/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.org.api.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.SimpleOpenApiRpcService;
import com.els.modules.org.entity.PurchaseOrganizationInfo;
import com.els.modules.org.enumerate.PurchaseOrganizationStatus;
import com.els.modules.org.service.PurchaseOrganizationInfoService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class GetPurOrgByMdmServiceImpl
implements SimpleOpenApiRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetPurOrgByMdmServiceImpl.class);
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseOrganizationInfoService purchaseOrganizationInfoService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String CATALOGUE = "sys:dict:";
    private static final String COLON = ":";

    @SrmTransaction
    public JSONObject invoke(JSONObject param) {
        TenantContext.setTenant((String)"1664299");
        log.info("getPurOrgByMdmServiceImpl_start");
        JSONObject data = (JSONObject)Convert.convert(JSONObject.class, (Object)param);
        JSONArray purchaseOrganizationInfosArray = data.getJSONArray("purchaseOrganizationInfo");
        this.verifyData(purchaseOrganizationInfosArray);
        this.handleData(purchaseOrganizationInfosArray);
        log.info("getPurOrgByMdmServiceImpl_end");
        return JSONObject.parseObject((String)JSONObject.toJSONString((Object)Result.ok()));
    }

    private void handleData(JSONArray purchaseOrganizationInfosArray) {
        List purchaseOrganizationInfos = JSON.parseArray((String)purchaseOrganizationInfosArray.toJSONString(), PurchaseOrganizationInfo.class);
        List orgCodes = purchaseOrganizationInfos.stream().map(PurchaseOrganizationInfo::getOrgCode).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"org_code", orgCodes);
        List existingOrgs = this.purchaseOrganizationInfoService.list((Wrapper)queryWrapper);
        Set existingOrgCodes = existingOrgs.stream().map(PurchaseOrganizationInfo::getOrgCode).collect(Collectors.toSet());
        List existingOrgList = purchaseOrganizationInfos.stream().filter(info -> existingOrgCodes.contains(info.getOrgCode())).collect(Collectors.toList());
        List<PurchaseOrganizationInfo> nonExistingOrgList = purchaseOrganizationInfos.stream().filter(info -> !existingOrgCodes.contains(info.getOrgCode())).collect(Collectors.toList());
        log.info("Existing Orgs: {}", existingOrgList);
        log.info("Non-existing Orgs: {}", nonExistingOrgList);
        this.handleExistingOrgs(existingOrgs, purchaseOrganizationInfos);
        this.handleNonExistingOrgs(nonExistingOrgList);
        this.deleteRedis("purchase_organization_info");
    }

    private void handleExistingOrgs(List<PurchaseOrganizationInfo> existingOrgs, List<PurchaseOrganizationInfo> inputOrgs) {
        if (CollectionUtils.isEmpty(existingOrgs)) {
            return;
        }
        existingOrgs.forEach(org -> inputOrgs.stream().filter(inputOrg -> inputOrg.getOrgCode().equals(org.getOrgCode())).forEach(inputOrg -> {
            org.setOrgName(StringUtils.isNotBlank((CharSequence)inputOrg.getOrgName()) ? inputOrg.getOrgName() : org.getOrgName());
            org.setOrgAbbreviation(StringUtils.isNotBlank((CharSequence)inputOrg.getOrgAbbreviation()) ? inputOrg.getOrgAbbreviation() : org.getOrgAbbreviation());
            org.setOrgDesc(StringUtils.isNotBlank((CharSequence)inputOrg.getOrgDesc()) ? inputOrg.getOrgDesc() : org.getOrgDesc());
            org.setOrgCategoryCode(StringUtils.isNotBlank((CharSequence)inputOrg.getOrgCategoryCode()) ? inputOrg.getOrgCategoryCode() : org.getOrgCategoryCode());
            org.setOrgCategoryDesc(StringUtils.isNotBlank((CharSequence)inputOrg.getOrgCategoryDesc()) ? inputOrg.getOrgCategoryDesc() : org.getOrgCategoryDesc());
            org.setOrgNature(StringUtils.isNotBlank((CharSequence)inputOrg.getOrgNature()) ? inputOrg.getOrgNature() : org.getOrgNature());
            org.setTaxNumber(StringUtils.isNotBlank((CharSequence)inputOrg.getTaxNumber()) ? inputOrg.getTaxNumber() : org.getTaxNumber());
            org.setCreditCode(StringUtils.isNotBlank((CharSequence)inputOrg.getCreditCode()) ? inputOrg.getCreditCode() : org.getCreditCode());
            org.setStatus(StringUtils.isNotBlank((CharSequence)inputOrg.getStatus()) ? inputOrg.getStatus() : org.getStatus());
            org.setDataSource(StringUtils.isNotBlank((CharSequence)inputOrg.getDataSource()) ? inputOrg.getDataSource() : org.getDataSource());
            org.setEnableTime(inputOrg.getEnableTime() != null ? inputOrg.getEnableTime() : org.getEnableTime());
            org.setFreezeTime(inputOrg.getFreezeTime() != null ? inputOrg.getFreezeTime() : org.getFreezeTime());
            org.setCreateBy(StringUtils.isNotBlank((CharSequence)inputOrg.getCreateBy()) ? inputOrg.getCreateBy() : org.getCreateBy());
            org.setCreateTime(inputOrg.getCreateTime() != null ? inputOrg.getCreateTime() : org.getCreateTime());
            org.setUpdateBy(StringUtils.isNotBlank((CharSequence)inputOrg.getUpdateBy()) ? inputOrg.getUpdateBy() : org.getUpdateBy());
            org.setUpdateTime(inputOrg.getUpdateTime() != null ? inputOrg.getUpdateTime() : org.getUpdateTime());
            org.setBusinessRegion(StringUtils.isNotBlank((CharSequence)inputOrg.getBusinessRegion()) ? inputOrg.getBusinessRegion() : org.getBusinessRegion());
            org.setBusinessPerson(StringUtils.isNotBlank((CharSequence)inputOrg.getBusinessPerson()) ? inputOrg.getBusinessPerson() : org.getBusinessPerson());
            org.setSuperBusinessId(StringUtils.isNotBlank((CharSequence)inputOrg.getSuperBusinessId()) ? inputOrg.getSuperBusinessId() : org.getSuperBusinessId());
            this.handleSuperBusinessData((PurchaseOrganizationInfo)((Object)org));
            org.setRelateBusinessId(StringUtils.isNotBlank((CharSequence)inputOrg.getRelateBusinessId()) ? inputOrg.getRelateBusinessId() : org.getRelateBusinessId());
            org.setBusinessLevel(StringUtils.isNotBlank((CharSequence)inputOrg.getBusinessLevel()) ? inputOrg.getBusinessLevel() : org.getBusinessLevel());
            org.setBusinessOrder(StringUtils.isNotBlank((CharSequence)inputOrg.getBusinessOrder()) ? inputOrg.getBusinessOrder() : org.getBusinessOrder());
        }));
        this.purchaseOrganizationInfoService.saveOrUpdateBatch(existingOrgs);
    }

    private void handleNonExistingOrgs(List<PurchaseOrganizationInfo> nonExistingOrgList) {
        nonExistingOrgList.forEach(org -> {
            log.info("Non-existing org: {}", (Object)org);
            this.handleNonExistingOrgData((PurchaseOrganizationInfo)((Object)org));
            this.purchaseOrganizationInfoService.checkOrgData((PurchaseOrganizationInfo)((Object)org));
            if ("companyCode".equals(org.getOrgCategoryCode()) && StringUtils.isBlank((CharSequence)org.getChargeCurrency())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VRAcLRCKWtevLlxOLV_b07102b1", (String)"\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u516c\u53f8\u65f6\uff0c\u8bb0\u8d26\u672c\u4f4d\u5e01\u4e0d\u80fd\u4e3a\u7a7a"));
            }
        });
        this.purchaseOrganizationInfoService.saveBatch(nonExistingOrgList, 2000);
    }

    private void handleNonExistingOrgData(PurchaseOrganizationInfo org) {
        org.setStatus(StringUtils.isBlank((CharSequence)org.getStatus()) ? PurchaseOrganizationStatus.NORMAL.getValue() : org.getStatus());
        org.setDataSource(StringUtils.isBlank((CharSequence)org.getDataSource()) ? "1" : org.getStatus());
        org.setCreateById(org.getCreateBy());
        org.setUpdateById(org.getUpdateBy());
        this.handleSuperBusinessData(org);
        TemplateHeadDTO template = this.getTemplate();
        if (!Objects.isNull(template)) {
            org.setTemplateName(template.getTemplateName());
            org.setTemplateNumber(template.getTemplateNumber());
            org.setTemplateVersion(template.getTemplateVersion());
            org.setTemplateAccount(template.getElsAccount());
        }
    }

    private void handleSuperBusinessData(PurchaseOrganizationInfo org) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"org_code", new Object[]{org.getSuperBusinessId()});
        List existingOrgs = this.purchaseOrganizationInfoService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)existingOrgs)) {
            return;
        }
        org.setSuperBusinessId(((PurchaseOrganizationInfo)((Object)existingOrgs.get(0))).getId());
    }

    private void verifyData(JSONArray purchaseOrganizationInfosArray) {
        if (purchaseOrganizationInfosArray.size() > 500) {
            throw new IllegalArgumentException("\u7ec4\u7ec7 \u6570\u91cf\u4e0d\u80fd\u5927\u4e8e 500");
        }
        for (int i = 0; i < purchaseOrganizationInfosArray.size(); ++i) {
            JSONObject purchaseOrganizationInfo = purchaseOrganizationInfosArray.getJSONObject(i);
            this.checkField(purchaseOrganizationInfo, "orgCode");
            this.checkField(purchaseOrganizationInfo, "orgName");
            this.checkField(purchaseOrganizationInfo, "orgAbbreviation");
            this.checkField(purchaseOrganizationInfo, "orgCategoryCode");
            this.checkField(purchaseOrganizationInfo, "status");
            this.checkField(purchaseOrganizationInfo, "dataSource");
            this.checkField(purchaseOrganizationInfo, "createBy");
            this.checkField(purchaseOrganizationInfo, "createTime");
            this.checkField(purchaseOrganizationInfo, "updateBy");
            this.checkField(purchaseOrganizationInfo, "updateTime");
            this.checkField(purchaseOrganizationInfo, "superBusinessId");
        }
    }

    private void checkField(JSONObject jsonObject, String key) {
        if (!jsonObject.containsKey((Object)key) || jsonObject.getString(key).isEmpty()) {
            throw new IllegalArgumentException("\u5b57\u6bb5 " + key + " \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private TemplateHeadDTO getTemplate() {
        List templateList = this.invokeBaseRpcService.getTemplateByType("org");
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u914d\u7f6e\u7269\u6599\u4e3b\u6570\u636e\u4e1a\u52a1\u6a21\u677f!"));
        Map<String, List<TemplateHeadDTO>> templateMap = templateList.stream().filter(a -> a.getElsAccount() != null).collect(Collectors.groupingBy(o -> o.getElsAccount()));
        TemplateHeadDTO template = CollectionUtil.isNotEmpty((Collection)templateMap.get(TenantContext.getTenant())) ? templateMap.get(TenantContext.getTenant()).get(0) : templateMap.get("100000").get(0);
        return template;
    }

    private void deleteRedis(String table) {
        StringBuffer redisKey = new StringBuffer(CATALOGUE);
        redisKey.append(TenantContext.getTenant()).append(COLON).append(table);
        this.redisUtil.deleteByPrex(redisKey.toString());
    }
}

