/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.price.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.api.dto.PriceRecordsDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseOpenServiceImpl;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.ListColumnQueryBuilder;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.contract.dto.PurchaseContractItemDTO;
import com.els.modules.material.api.enumerate.MaterialSourceStatusEnum;
import com.els.modules.material.entity.PurchaseMaterialSource;
import com.els.modules.material.enumerate.MaterialSourceTypeEnum;
import com.els.modules.material.service.PurchaseMaterialSourceService;
import com.els.modules.price.api.enumerate.PriceRecordTypeEnum;
import com.els.modules.price.entity.PurchaseInformationRecords;
import com.els.modules.price.enumerate.MaterialCreateSourceTypeEnum;
import com.els.modules.price.enumerate.PriceSourceTypeEnum;
import com.els.modules.price.enumerate.PriceStatusEnum;
import com.els.modules.price.enumerate.PurchaseInformationPriceTypeEnum;
import com.els.modules.price.mapper.PurchaseInformationRecordsMapper;
import com.els.modules.price.rpc.service.PriceInvokeInquiryRpcService;
import com.els.modules.price.rpc.service.PriceInvokeWorkFlowRpcService;
import com.els.modules.price.service.PurchaseInformationRecordsService;
import com.els.modules.price.vo.HisQuotePriceTrendVO;
import com.els.modules.price.vo.QueryPriceVO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseInformationRecordsServiceImpl
extends BaseOpenServiceImpl<PurchaseInformationRecordsMapper, PurchaseInformationRecords, PurchaseInformationRecords>
implements PurchaseInformationRecordsService {
    @Autowired
    private InvokeBaseRpcService baseRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseMaterialSourceService purchaseMaterialSourceService;
    @Autowired
    private PriceInvokeInquiryRpcService priceInvokeInquiryRpcService;
    @Autowired
    private InterfaceUtil interfaceUtil;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private PriceInvokeWorkFlowRpcService priceInvokeWorkFlowRpcService;
    private static String PRICE_COVER_KEY = "record_price_cover:";

    @Override
    @SrmTransaction
    public void savePurchaseInformationRecords(PurchaseInformationRecords records, List<PurchaseAttachmentDTO> attachmentDTOList) {
        if (null != records.getExpiryDate() && null != records.getEffectiveDate() && records.getExpiryDate().before(records.getEffectiveDate())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umtHjXyRBAxOQUumtHjXAKBA_95550107", (String)"\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u8d77\u59cb\u65e5\u671f"));
        }
        if (StringUtils.isBlank((CharSequence)records.getInfoRecordNumber())) {
            records.setInfoRecordNumber(this.baseRpcService.getNextCode("srmPriceNumber", (Object)records));
        }
        records.setSourceType(PriceSourceTypeEnum.SRM.getValue());
        if (StrUtil.isEmpty((CharSequence)records.getAuditStatus())) {
            records.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        records.setRecordStatus(PriceStatusEnum.NEW.getValue());
        records.setQuoteDate(records.getQuoteDate() == null ? new Date() : records.getQuoteDate());
        if (AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(records.getAuditStatus())) {
            this.cutOffPriceDate(records, false);
            records.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
            this.checkStatus(records);
        }
        this.calculatePrice(records);
        ((PurchaseInformationRecordsMapper)this.baseMapper).insert((Object)records);
        this.insertAttachmentData(records, attachmentDTOList);
    }

    @Override
    public void calculatePrice(PurchaseInformationRecords records) {
        BigDecimal taxRate = StrUtil.isBlank((CharSequence)records.getTaxRate()) ? BigDecimal.ZERO : new BigDecimal(records.getTaxRate()).divide(BigDecimal.valueOf(100L));
        BigDecimal price = records.getPrice() == null ? BigDecimal.ZERO : records.getPrice();
        BigDecimal freight = records.getFreight() == null ? BigDecimal.ZERO : records.getFreight();
        BigDecimal discount = records.getDiscount() == null ? BigDecimal.ZERO : records.getDiscount();
        BigDecimal netPrice = price.divide(BigDecimal.ONE.add(taxRate), 6, 4);
        BigDecimal theNetPrice = price.add(freight).subtract(discount);
        records.setNetPrice(netPrice);
        records.setTheNetPrice(theNetPrice);
    }

    @Override
    public String createMaterialSource(List<PurchaseInformationRecords> recordsList) {
        System.out.println(recordsList.toString());
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(recordsList), (String)I18nUtil.translate((String)"i18n_alert_ViFTPsSjumdWFc_6498c6ee", (String)"\u8bf7\u9009\u62e9\u9700\u8981\u8f6c\u6362\u7684\u4ef7\u683c\u4e3b\u6570\u636e\u884c"));
        ArrayList<PurchaseMaterialSource> sourceList = new ArrayList<PurchaseMaterialSource>();
        for (int index = 0; index < recordsList.size(); ++index) {
            PurchaseInformationRecords records = recordsList.get(index);
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{PurchaseMaterialSource::getSourceId});
            ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getMaterialNumber, (Object)records.getMaterialNumber());
            ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getFactory, (Object)records.getFactory());
            ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getCompany, (Object)records.getCompany());
            ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getPurchaseOrg, (Object)records.getPurchaseOrg());
            ListColumnQueryBuilder.lambdaWrapperEqOrNullBuilder((LambdaQueryWrapper)wrapper, PurchaseMaterialSource::getToElsAccount, (Object)records.getToElsAccount());
            wrapper.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.or(a -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.le(PurchaseMaterialSource::getEffectiveDate, (Object)records.getEffectiveDate())).ge(PurchaseMaterialSource::getExpiryDate, (Object)records.getExpiryDate());
                })).or(b -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)b.ge(PurchaseMaterialSource::getEffectiveDate, (Object)records.getEffectiveDate())).le(PurchaseMaterialSource::getExpiryDate, (Object)records.getExpiryDate());
                })).or(b -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)b.le(PurchaseMaterialSource::getEffectiveDate, (Object)records.getEffectiveDate())).le(PurchaseMaterialSource::getExpiryDate, (Object)records.getExpiryDate())).ge(PurchaseMaterialSource::getExpiryDate, (Object)records.getEffectiveDate());
                })).or(b -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)b.ge(PurchaseMaterialSource::getEffectiveDate, (Object)records.getEffectiveDate())).ge(PurchaseMaterialSource::getExpiryDate, (Object)records.getExpiryDate())).le(PurchaseMaterialSource::getEffectiveDate, (Object)records.getExpiryDate());
                });
            });
            wrapper.in(PurchaseMaterialSource::getStatus, (Collection)Lists.newArrayList((Object[])new String[]{MaterialSourceStatusEnum.NORMAL.getValue(), MaterialSourceStatusEnum.FROZEN.getValue(), MaterialSourceStatusEnum.EFFECTIVE.getValue()}));
            List list = this.purchaseMaterialSourceService.list((Wrapper)wrapper);
            if (list.size() <= 0) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_dicumtHyWWWWWWWIsSjVtWWWWWW_cdd6e7c8", (String)"\u6240\u9009\u884c\u4ef7\u683c\u8bb0\u5f55\u53f7: ${0} \u5df2\u8f6c\u8d27\u6e90\u6e05\u5355: ${1}", (String[])new String[]{records.getInfoRecordNumber(), ((PurchaseMaterialSource)((Object)list.get(0))).getSourceId()}));
        }
        for (PurchaseInformationRecords records : recordsList) {
            PurchaseMaterialSource source = new PurchaseMaterialSource();
            BeanUtils.copyProperties((Object)((Object)records), (Object)((Object)source));
            source.setToElsDesc(records.getSupplierName());
            source.setSourceId(this.invokeBaseRpcService.getNextCode("materialSourceNumber", (Object)source));
            source.setId(null);
            source.setMaterialSourceType(MaterialSourceTypeEnum.MATERIAL.getValue());
            source.setCreateTime(new Date());
            source.setUpdateTime(new Date());
            source.setCreateBy(null);
            source.setUpdateBy(null);
            source.setUpdateById(null);
            source.setCreateById(null);
            source.setFlowId(null);
            source.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
            DateTime date = DateUtil.date();
            DateTime toDay = DateUtil.parseDate((CharSequence)DateUtil.today());
            if (null != source.getEffectiveDate() && source.getEffectiveDate().before((Date)date)) {
                source.setStatus(MaterialSourceStatusEnum.EFFECTIVE.getValue());
            } else if (null != source.getExpiryDate() && source.getExpiryDate().before((Date)toDay)) {
                source.setStatus(MaterialSourceStatusEnum.INVALID.getValue());
            } else {
                source.setStatus(MaterialSourceStatusEnum.NORMAL.getValue());
            }
            source.setSourceType(MaterialCreateSourceTypeEnum.PRICE.getValue());
            source.setEffectiveDate(records.getEffectiveDate());
            source.setExpiryDate(records.getExpiryDate());
            sourceList.add(source);
        }
        this.purchaseMaterialSourceService.addBatch(sourceList);
        return sourceList.stream().map(PurchaseMaterialSource::getSourceId).collect(Collectors.toList()).toString();
    }

    @Override
    public void addBatch(List<PurchaseInformationRecords> recordsList) {
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType("price");
        if (CollectionUtil.isNotEmpty(recordsList) && CollectionUtil.isNotEmpty((Collection)templateList)) {
            PurchaseInformationRecords entity = recordsList.get(0);
            long size = recordsList.stream().filter(x -> StrUtil.isBlank((CharSequence)x.getInfoRecordNumber())).count();
            List nextCodes = this.baseRpcService.getNextCodes("srmPriceNumber", (Object)entity, (int)size);
            int codeIndex = 0;
            for (PurchaseInformationRecords records : recordsList) {
                SysUtil.setNullCreate((BaseEntity)records);
                records.setUpdateBy(null);
                records.setUpdateTime(null);
                records.setId(null);
                if (StringUtils.isBlank((CharSequence)records.getInfoRecordNumber())) {
                    records.setInfoRecordNumber((String)nextCodes.get(codeIndex++));
                }
                records.setRecordType(CharSequenceUtil.emptyToDefault((CharSequence)records.getRecordType(), (String)PriceRecordTypeEnum.STANDARD.getValue()));
                records.setTemplateNumber(((TemplateHeadDTO)templateList.get(0)).getTemplateNumber());
                records.setTemplateName(((TemplateHeadDTO)templateList.get(0)).getTemplateName());
                records.setTemplateVersion(((TemplateHeadDTO)templateList.get(0)).getTemplateVersion());
                records.setTemplateAccount(((TemplateHeadDTO)templateList.get(0)).getElsAccount());
                records.setQuoteDate(records.getQuoteDate() == null ? new Date() : records.getQuoteDate());
                this.cutOffPriceDate(records, false);
                records.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
                this.checkStatus(records);
            }
            this.saveBatch(recordsList);
        }
    }

    private void insertAttachmentData(PurchaseInformationRecords head, List<PurchaseAttachmentDTO> attachmentList) {
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            for (PurchaseAttachmentDTO entity : attachmentList) {
                entity.setId(null);
                entity.setHeadId(head.getId());
                entity.setElsAccount(head.getElsAccount());
                entity.setCreateBy(head.getCreateBy());
                entity.setCreateTime(head.getCreateTime());
                entity.setUpdateBy(head.getUpdateBy());
                entity.setUpdateTime(head.getUpdateTime());
                entity.setDeleted(CommonConstant.DEL_FLAG_0);
            }
        }
        if (CollectionUtil.isNotEmpty(attachmentList)) {
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(attachmentList);
        }
    }

    @Override
    @SrmTransaction
    public void updatePurchaseInformationRecords(PurchaseInformationRecords purchaseInformationRecords, List<PurchaseAttachmentDTO> attachmentList) {
        if (null != purchaseInformationRecords.getPrice() && purchaseInformationRecords.getPrice().compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalArgumentException(I18nUtil.translate((String)"i18n_alert_xfuxOXU0_feacb714", (String)"\u542b\u7a0e\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0\uff01"));
        }
        if (null != purchaseInformationRecords.getExpiryDate() && null != purchaseInformationRecords.getEffectiveDate() && purchaseInformationRecords.getExpiryDate().before(purchaseInformationRecords.getEffectiveDate())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umtHjXyRBAxOQUumtHjXAKBA_95550107", (String)"\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u8d77\u59cb\u65e5\u671f"));
        }
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseInformationRecords.getPriceType()), (String)I18nUtil.translate((String)"i18n_alert_umAclS_b641dd5b", (String)"\u4ef7\u683c\u7c7b\u578b\u5fc5\u586b"));
        if ("1".equals(purchaseInformationRecords.getRecordType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseInformationRecords.getMaterialNumber()), (String)I18nUtil.translate((String)"i18n_alert_umAcLSLKWSLAylS_a87995e2", (String)"\u4ef7\u683c\u7c7b\u578b\u4e3a\u7269\u6599\u65f6\uff0c\u7269\u6599\u7f16\u53f7\u5fc5\u586b"));
        } else if ("2".equals(purchaseInformationRecords.getRecordType())) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseInformationRecords.getMaterialGroup()), (String)I18nUtil.translate((String)"i18n_alert_umAcLSLVKWSLVlS_dce240f5", (String)"\u4ef7\u683c\u7c7b\u578b\u4e3a\u7269\u6599\u7ec4\u65f6\uff0c\u7269\u6599\u7ec4\u5fc5\u586b"));
        }
        purchaseInformationRecords.setSourceType(PriceSourceTypeEnum.SRM.getValue());
        if (AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(purchaseInformationRecords.getAuditStatus())) {
            this.cutOffPriceDate(purchaseInformationRecords, false);
            this.checkStatus(purchaseInformationRecords);
        }
        this.calculatePrice(purchaseInformationRecords);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseInformationRecords.getId());
        int count = ((PurchaseInformationRecordsMapper)this.baseMapper).updateById((Object)purchaseInformationRecords);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        this.insertAttachmentData(purchaseInformationRecords, attachmentList);
    }

    @Override
    public void cutOffPriceDate(PurchaseInformationRecords newRecords, boolean onlyCheck) {
        boolean row;
        if (CharSequenceUtil.isEmpty((CharSequence)newRecords.getFactory()) && CharSequenceUtil.isEmpty((CharSequence)newRecords.getPurchaseOrg())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RHnnRVRlTSMIm_f3c63546", (String)"\u5de5\u5382\u548c\u91c7\u8d2d\u7ec4\u7ec7\u5fc5\u987b\u586b\u5199\u4e00\u4e2a") + ":" + newRecords.getInfoRecordNumber());
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(PurchaseInformationRecords::getToElsAccount, (Object)newRecords.getToElsAccount())).eq(PurchaseInformationRecords::getPriceType, (Object)newRecords.getPriceType());
        if (PurchaseInformationPriceTypeEnum.MATERIAL.getValue().equals(newRecords.getPriceType())) {
            queryWrapper.eq(PurchaseInformationRecords::getMaterialNumber, (Object)newRecords.getMaterialNumber());
        } else if (PurchaseInformationPriceTypeEnum.MATERIAL_GROUP.getValue().equals(newRecords.getPriceType())) {
            queryWrapper.eq(PurchaseInformationRecords::getMaterialGroup, (Object)newRecords.getMaterialGroup());
        } else {
            String msg = CharSequenceUtil.isEmpty((CharSequence)newRecords.getId()) ? "" : "[ " + newRecords.getId() + " ]";
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umdWFWWWWWWWWumAcLV_910b114f", (String)"\u4ef7\u683c\u4e3b\u6570\u636e${0}\u4ef7\u683c\u7c7b\u578b\u4e3a\u7a7a", (String[])new String[]{msg}));
        }
        if (onlyCheck) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)newRecords.getFactory())) {
            queryWrapper.eq(PurchaseInformationRecords::getFactory, (Object)newRecords.getFactory());
        } else {
            queryWrapper.eq(PurchaseInformationRecords::getPurchaseOrg, (Object)newRecords.getPurchaseOrg());
        }
        if (StringUtils.isNotBlank((CharSequence)newRecords.getRecordType())) {
            queryWrapper.eq(PurchaseInformationRecords::getRecordType, (Object)newRecords.getRecordType());
        }
        ArrayList recordStatusList = Lists.newArrayList((Object[])new String[]{PriceStatusEnum.NORMAL.getValue(), PriceStatusEnum.FROZEN.getValue(), PriceStatusEnum.EFFECTIVE.getValue()});
        ArrayList auditStatusList = Lists.newArrayList((Object[])new String[]{AuditStatusEnum.NO_AUDIT_REQUIRED.getValue(), AuditStatusEnum.AUDIT_FINISH.getValue()});
        ((LambdaQueryWrapper)queryWrapper.in(PurchaseInformationRecords::getAuditStatus, (Collection)auditStatusList)).in(PurchaseInformationRecords::getRecordStatus, (Collection)recordStatusList);
        queryWrapper.and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.or(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.le(PurchaseInformationRecords::getEffectiveDate, (Object)newRecords.getEffectiveDate())).ge(PurchaseInformationRecords::getExpiryDate, (Object)newRecords.getExpiryDate());
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)b.ge(PurchaseInformationRecords::getEffectiveDate, (Object)newRecords.getEffectiveDate())).le(PurchaseInformationRecords::getExpiryDate, (Object)newRecords.getExpiryDate());
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)b.le(PurchaseInformationRecords::getEffectiveDate, (Object)newRecords.getEffectiveDate())).le(PurchaseInformationRecords::getExpiryDate, (Object)newRecords.getExpiryDate())).ge(PurchaseInformationRecords::getExpiryDate, (Object)newRecords.getEffectiveDate());
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)b.ge(PurchaseInformationRecords::getEffectiveDate, (Object)newRecords.getEffectiveDate())).ge(PurchaseInformationRecords::getExpiryDate, (Object)newRecords.getExpiryDate())).le(PurchaseInformationRecords::getEffectiveDate, (Object)newRecords.getExpiryDate());
            });
        });
        List disRecords = ((PurchaseInformationRecordsMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (disRecords.isEmpty()) {
            return;
        }
        ArrayList updateOldRecords = Lists.newArrayList();
        Calendar cal = Calendar.getInstance();
        Date xStartDate = newRecords.getEffectiveDate();
        Date xEndDate = newRecords.getExpiryDate();
        for (PurchaseInformationRecords y : disRecords) {
            Date yStartDate = y.getEffectiveDate();
            Date yEndDate = y.getExpiryDate();
            if (xStartDate.compareTo(yStartDate) > 0 && xEndDate.compareTo(yEndDate) <= 0) {
                PurchaseInformationRecords records = new PurchaseInformationRecords();
                BeanUtils.copyProperties((Object)((Object)y), (Object)((Object)records));
                this.rebuildPriceStatus(y, cal, xStartDate, -1);
                y.setExpiryDate(cal.getTime());
                this.checkStatus(y);
                updateOldRecords.add(y);
                if (xEndDate.compareTo(yEndDate) == 0) continue;
                this.rebuildPriceStatus(records, cal, xEndDate, 1);
                records.setEffectiveDate(cal.getTime());
                this.checkStatus(records);
                records.setId(null);
                updateOldRecords.add(records);
                continue;
            }
            if (xStartDate.compareTo(yStartDate) == 0 && xEndDate.compareTo(yEndDate) < 0 || xStartDate.compareTo(yStartDate) < 0 && xEndDate.compareTo(yEndDate) < 0 && xEndDate.compareTo(yStartDate) >= 0) {
                this.rebuildPriceStatus(y, cal, xEndDate, 1);
                y.setEffectiveDate(cal.getTime());
                this.checkStatus(y);
                updateOldRecords.add(y);
                continue;
            }
            if (xStartDate.compareTo(yStartDate) <= 0 && xEndDate.compareTo(yEndDate) >= 0) {
                if ("1".equals(y.getAllowDuplicatePrice())) continue;
                y.setRecordStatus(PriceStatusEnum.CANCEL.getValue());
                updateOldRecords.add(y);
                continue;
            }
            if (xStartDate.compareTo(yStartDate) <= 0 || xEndDate.compareTo(yEndDate) <= 0 || xStartDate.compareTo(yEndDate) > 0) continue;
            this.rebuildPriceStatus(y, cal, xStartDate, -1);
            y.setExpiryDate(cal.getTime());
            this.checkStatus(y);
            updateOldRecords.add(y);
        }
        if (!updateOldRecords.isEmpty() && !(row = this.saveOrUpdateBatch(updateOldRecords))) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    private void filterList(List<PurchaseInformationRecords> filterList, Predicate<PurchaseInformationRecords> predicate) {
        filterList = filterList.stream().filter(predicate).collect(Collectors.toList());
    }

    @Override
    public void cutOffPriceDate(PurchaseInformationRecords newRecords, List<PurchaseInformationRecords> unSubmitList, boolean onlyCheck) {
        if (CharSequenceUtil.isEmpty((CharSequence)newRecords.getFactory()) && CharSequenceUtil.isEmpty((CharSequence)newRecords.getPurchaseOrg())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RHnnRVRlTSMIm_f3c63546", (String)"\u5de5\u5382\u548c\u91c7\u8d2d\u7ec4\u7ec7\u5fc5\u987b\u586b\u5199\u4e00\u4e2a") + ":" + newRecords.getInfoRecordNumber());
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(PurchaseInformationRecords::getToElsAccount, (Object)newRecords.getToElsAccount())).eq(PurchaseInformationRecords::getPriceType, (Object)newRecords.getPriceType());
        List filterList = unSubmitList.stream().filter(x -> newRecords.getToElsAccount().equals(x.getToElsAccount()) && x.getPriceType().equals(newRecords.getPriceType())).collect(Collectors.toList());
        if (PurchaseInformationPriceTypeEnum.MATERIAL.getValue().equals(newRecords.getPriceType())) {
            queryWrapper.eq(PurchaseInformationRecords::getMaterialNumber, (Object)newRecords.getMaterialNumber());
            filterList = filterList.stream().filter(x -> newRecords.getMaterialNumber().equals(x.getMaterialNumber())).collect(Collectors.toList());
        } else if (PurchaseInformationPriceTypeEnum.MATERIAL_GROUP.getValue().equals(newRecords.getPriceType())) {
            queryWrapper.eq(PurchaseInformationRecords::getMaterialGroup, (Object)newRecords.getMaterialGroup());
            filterList = filterList.stream().filter(x -> newRecords.getMaterialGroup().equals(x.getMaterialGroup())).collect(Collectors.toList());
        } else {
            String msg = CharSequenceUtil.isEmpty((CharSequence)newRecords.getId()) ? "" : "[ " + newRecords.getId() + " ]";
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_umdWFWWWWWWWWumAcLV_910b114f", (String)"\u4ef7\u683c\u4e3b\u6570\u636e${0}\u4ef7\u683c\u7c7b\u578b\u4e3a\u7a7a", (String[])new String[]{msg}));
        }
        if (onlyCheck) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)newRecords.getFactory())) {
            queryWrapper.eq(PurchaseInformationRecords::getFactory, (Object)newRecords.getFactory());
            filterList = filterList.stream().filter(x -> newRecords.getFactory().equals(x.getFactory())).collect(Collectors.toList());
        } else {
            queryWrapper.eq(PurchaseInformationRecords::getPurchaseOrg, (Object)newRecords.getPurchaseOrg());
            filterList = filterList.stream().filter(x -> newRecords.getPurchaseOrg().equals(x.getPurchaseOrg())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)newRecords.getRecordType())) {
            queryWrapper.eq(PurchaseInformationRecords::getRecordType, (Object)newRecords.getRecordType());
            filterList = filterList.stream().filter(x -> newRecords.getRecordType().equals(x.getRecordType())).collect(Collectors.toList());
        }
        ArrayList recordStatusList = Lists.newArrayList((Object[])new String[]{PriceStatusEnum.NORMAL.getValue(), PriceStatusEnum.FROZEN.getValue(), PriceStatusEnum.EFFECTIVE.getValue()});
        ArrayList auditStatusList = Lists.newArrayList((Object[])new String[]{AuditStatusEnum.NO_AUDIT_REQUIRED.getValue(), AuditStatusEnum.AUDIT_FINISH.getValue()});
        ((LambdaQueryWrapper)queryWrapper.in(PurchaseInformationRecords::getAuditStatus, (Collection)auditStatusList)).in(PurchaseInformationRecords::getRecordStatus, (Collection)recordStatusList);
        queryWrapper.and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.or(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.le(PurchaseInformationRecords::getEffectiveDate, (Object)newRecords.getEffectiveDate())).ge(PurchaseInformationRecords::getExpiryDate, (Object)newRecords.getExpiryDate());
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)b.ge(PurchaseInformationRecords::getEffectiveDate, (Object)newRecords.getEffectiveDate())).le(PurchaseInformationRecords::getExpiryDate, (Object)newRecords.getExpiryDate());
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)b.le(PurchaseInformationRecords::getEffectiveDate, (Object)newRecords.getEffectiveDate())).le(PurchaseInformationRecords::getExpiryDate, (Object)newRecords.getExpiryDate())).ge(PurchaseInformationRecords::getExpiryDate, (Object)newRecords.getEffectiveDate());
            })).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)b.ge(PurchaseInformationRecords::getEffectiveDate, (Object)newRecords.getEffectiveDate())).ge(PurchaseInformationRecords::getExpiryDate, (Object)newRecords.getExpiryDate())).le(PurchaseInformationRecords::getEffectiveDate, (Object)newRecords.getExpiryDate());
            });
        });
        List disRecords = ((PurchaseInformationRecordsMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)disRecords) & CollectionUtil.isNotEmpty(filterList)) {
            List temIdList = filterList.stream().map(BaseEntity::getId).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList());
            disRecords = disRecords.stream().filter(x -> !temIdList.contains(x.getId())).collect(Collectors.toList());
        }
        if (CollectionUtil.isNotEmpty(filterList)) {
            filterList = filterList.stream().filter(x -> recordStatusList.contains(x.getRecordStatus()) && auditStatusList.contains(x.getAuditStatus())).collect(Collectors.toList());
            Predicate<PurchaseInformationRecords> predicate = d -> d.getEffectiveDate().compareTo(newRecords.getEffectiveDate()) <= 0 && d.getExpiryDate().compareTo(newRecords.getExpiryDate()) >= 0 || d.getEffectiveDate().compareTo(newRecords.getEffectiveDate()) >= 0 && d.getExpiryDate().compareTo(newRecords.getExpiryDate()) <= 0 || d.getEffectiveDate().compareTo(newRecords.getEffectiveDate()) <= 0 && d.getExpiryDate().compareTo(newRecords.getExpiryDate()) <= 0 && d.getExpiryDate().compareTo(newRecords.getEffectiveDate()) >= 0 || d.getEffectiveDate().compareTo(newRecords.getEffectiveDate()) >= 0 && d.getExpiryDate().compareTo(newRecords.getExpiryDate()) >= 0 && d.getEffectiveDate().compareTo(newRecords.getExpiryDate()) <= 0;
            if (CollectionUtil.isNotEmpty(filterList = filterList.stream().filter(predicate).collect(Collectors.toList()))) {
                disRecords.addAll(filterList);
            }
        }
        if (disRecords.isEmpty()) {
            return;
        }
        List<Object> updateOldRecords = Lists.newArrayList();
        Calendar cal = Calendar.getInstance();
        Date xStartDate = newRecords.getEffectiveDate();
        Date xEndDate = newRecords.getExpiryDate();
        for (PurchaseInformationRecords y : disRecords) {
            Date yStartDate = y.getEffectiveDate();
            Date yEndDate = y.getExpiryDate();
            if (xStartDate.compareTo(yStartDate) > 0 && xEndDate.compareTo(yEndDate) <= 0) {
                PurchaseInformationRecords records = new PurchaseInformationRecords();
                BeanUtils.copyProperties((Object)((Object)y), (Object)((Object)records));
                this.rebuildPriceStatus(y, cal, xStartDate, -1);
                y.setExpiryDate(cal.getTime());
                this.checkStatus(y);
                updateOldRecords.add((Object)y);
                if (xEndDate.compareTo(yEndDate) == 0) continue;
                this.rebuildPriceStatus(records, cal, xEndDate, 1);
                records.setEffectiveDate(cal.getTime());
                this.checkStatus(records);
                records.setId(IdWorker.getIdStr());
                records.setInsertData(true);
                updateOldRecords.add((Object)records);
                continue;
            }
            if (xStartDate.compareTo(yStartDate) == 0 && xEndDate.compareTo(yEndDate) < 0 || xStartDate.compareTo(yStartDate) < 0 && xEndDate.compareTo(yEndDate) < 0 && xEndDate.compareTo(yStartDate) >= 0) {
                this.rebuildPriceStatus(y, cal, xEndDate, 1);
                y.setEffectiveDate(cal.getTime());
                this.checkStatus(y);
                updateOldRecords.add((Object)y);
                continue;
            }
            if (xStartDate.compareTo(yStartDate) <= 0 && xEndDate.compareTo(yEndDate) >= 0) {
                if ("1".equals(y.getAllowDuplicatePrice())) continue;
                y.setRecordStatus(PriceStatusEnum.CANCEL.getValue());
                updateOldRecords.add((Object)y);
                continue;
            }
            if (xStartDate.compareTo(yStartDate) <= 0 || xEndDate.compareTo(yEndDate) <= 0 || xStartDate.compareTo(yEndDate) > 0) continue;
            this.rebuildPriceStatus(y, cal, xStartDate, -1);
            y.setExpiryDate(cal.getTime());
            this.checkStatus(y);
            updateOldRecords.add((Object)y);
        }
        if (!updateOldRecords.isEmpty()) {
            List unSaveIds = filterList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            if (CollectionUtil.isEmpty((Collection)(updateOldRecords = updateOldRecords.stream().filter(x -> !unSaveIds.contains(x.getId())).collect(Collectors.toList())))) {
                return;
            }
            unSubmitList.addAll((Collection<PurchaseInformationRecords>)updateOldRecords);
        }
    }

    private void rebuildPriceStatus(PurchaseInformationRecords y, Calendar cal, Date calTime, int dateOfSet) {
        cal.setTime(calTime);
        cal.add(5, dateOfSet);
        y.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
    }

    @Override
    public void frozenPurchaseInformationRecords(String id) {
        PurchaseInformationRecords record = (PurchaseInformationRecords)((Object)((PurchaseInformationRecordsMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        record.setRecordStatus(PriceStatusEnum.FROZEN.getValue());
        int count = ((PurchaseInformationRecordsMapper)this.baseMapper).updateById((Object)record);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void checkStatus(PurchaseInformationRecords record) {
        DateTime date = DateUtil.date();
        if (null != record.getEffectiveDate() && record.getEffectiveDate().before((Date)date)) {
            record.setRecordStatus(PriceStatusEnum.EFFECTIVE.getValue());
        }
        DateTime toDay = DateUtil.parseDate((CharSequence)DateUtil.today());
        if (null != record.getExpiryDate() && record.getExpiryDate().before((Date)toDay)) {
            record.setRecordStatus(PriceStatusEnum.INVALID.getValue());
        }
    }

    @Override
    public void thawPurchaseInformationRecords(String id) {
        PurchaseInformationRecords record = (PurchaseInformationRecords)((Object)((PurchaseInformationRecordsMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        record.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
        this.checkStatus(record);
        int count = ((PurchaseInformationRecordsMapper)this.baseMapper).updateById((Object)record);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void cancelPurchaseInformationRecords(String id) {
        PurchaseInformationRecords record = (PurchaseInformationRecords)((Object)((PurchaseInformationRecordsMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        record.setRecordStatus(PriceStatusEnum.CANCEL.getValue());
        int count = ((PurchaseInformationRecordsMapper)this.baseMapper).updateById((Object)record);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void cancelBySourceNumber(String sourceType, String sourceNumber, List<String> itemNumberList) {
        String elsAccount = TenantContext.getTenant();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(PurchaseInformationRecords::getSourceNumber, (Object)sourceNumber)).eq(PurchaseInformationRecords::getSourceType, (Object)sourceType)).in(PurchaseInformationRecords::getSourceItemNumber, itemNumberList);
        PurchaseInformationRecords records = new PurchaseInformationRecords();
        records.setRecordStatus(PriceStatusEnum.CANCEL.getValue());
        ((PurchaseInformationRecordsMapper)this.baseMapper).update((Object)records, (Wrapper)updateWrapper);
    }

    @Override
    @SrmTransaction
    public void delPurchaseInformationRecords(String id) {
        ((PurchaseInformationRecordsMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
    }

    @Override
    @SrmTransaction
    public void delBatchPurchaseInformationRecords(List<String> idList) {
        ((PurchaseInformationRecordsMapper)this.baseMapper).deleteBatchIds(idList);
        this.invokeBaseRpcService.deletePurchaseAttachmentByBatchId(idList);
    }

    @Override
    public HisQuotePriceTrendVO findTrendByMaterial(QueryPriceVO queryPriceVO) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PurchaseInformationRecords::getMaterialNumber, (Object)queryPriceVO.getMaterialNumber());
        wrapper.in(PurchaseInformationRecords::getToElsAccount, queryPriceVO.getToElsAccountList());
        wrapper.orderByAsc(PurchaseInformationRecords::getQuoteDate);
        List itemList = ((PurchaseInformationRecordsMapper)this.baseMapper).selectList((Wrapper)wrapper);
        HisQuotePriceTrendVO trendVO = new HisQuotePriceTrendVO();
        LinkedHashMap itemMap = itemList.stream().filter(item -> item.getQuoteDate() != null).collect(Collectors.groupingBy(item -> DateUtil.format((Date)item.getQuoteDate(), (String)"yyyy-MM-dd"), LinkedHashMap::new, Collectors.toList()));
        ArrayList<String> xAxisData = new ArrayList<String>(itemMap.keySet());
        trendVO.setXAxisData(xAxisData);
        List<String> legendData = itemList.stream().map(PurchaseInformationRecords::getSupplierName).distinct().collect(Collectors.toList());
        trendVO.setLegendData(legendData);
        JSONArray series = new JSONArray();
        for (String supplierName : legendData) {
            JSONObject object = new JSONObject();
            object.put("name", (Object)supplierName);
            object.put("type", (Object)"line");
            ArrayList<BigDecimal> dataList = new ArrayList<BigDecimal>();
            for (String quoteDate : xAxisData) {
                List masterList = ((List)itemMap.get(quoteDate)).stream().filter(record -> supplierName.equals(record.getSupplierName())).collect(Collectors.toList());
                if (!masterList.isEmpty()) {
                    BigDecimal minPrice = masterList.stream().filter(x -> x.getPrice() != null).map(PurchaseInformationRecords::getPrice).min(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
                    dataList.add(minPrice);
                    continue;
                }
                dataList.add(BigDecimal.ZERO);
            }
            object.put("data", dataList);
            series.add((Object)object);
        }
        trendVO.setSeries(series);
        return trendVO;
    }

    @Override
    public PurchaseInformationRecords getEffectiveRecord(String materialNumber, String materialGroup, String factory, String purchaseOrg, String toElsAccount) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String priceType = StringUtils.isNotBlank((CharSequence)materialNumber) ? "1" : "2";
        ((LambdaQueryWrapper)queryWrapper.eq(PurchaseInformationRecords::getToElsAccount, (Object)toElsAccount)).eq(PurchaseInformationRecords::getPriceType, (Object)priceType);
        if (StringUtils.isNotBlank((CharSequence)materialNumber)) {
            queryWrapper.eq(PurchaseInformationRecords::getMaterialNumber, (Object)materialNumber);
        } else {
            queryWrapper.eq(PurchaseInformationRecords::getMaterialGroup, (Object)materialGroup);
        }
        if (StringUtils.isNotBlank((CharSequence)factory)) {
            queryWrapper.eq(PurchaseInformationRecords::getFactory, (Object)factory);
        } else {
            queryWrapper.eq(PurchaseInformationRecords::getPurchaseOrg, (Object)purchaseOrg);
        }
        ((LambdaQueryWrapper)queryWrapper.and(a -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.lt(PurchaseInformationRecords::getEffectiveDate, (Object)new Date())).gt(PurchaseInformationRecords::getExpiryDate, (Object)new Date());
        })).last(" limit 1");
        PurchaseInformationRecords record = (PurchaseInformationRecords)((Object)((PurchaseInformationRecordsMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        return record;
    }

    @Override
    public List<PurchaseInformationRecords> getEffectiveRecordList(String materialNumber, String materialGroup, String factory, String purchaseOrg, String toElsAccount) {
        if (StringUtils.isBlank((CharSequence)materialNumber) && StringUtils.isBlank((CharSequence)materialGroup)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SLSSLVRRTPjIm_f8fc5a66", (String)"\u7269\u6599\u6216\u7269\u6599\u7ec4\u81f3\u5c11\u9700\u8981\u6709\u4e00\u4e2a"));
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String priceType = StringUtils.isNotBlank((CharSequence)materialNumber) ? "1" : "2";
        queryWrapper.eq(PurchaseInformationRecords::getPriceType, (Object)priceType);
        if (StringUtils.isNotBlank((CharSequence)toElsAccount)) {
            queryWrapper.eq(PurchaseInformationRecords::getToElsAccount, (Object)toElsAccount);
        }
        if (StringUtils.isNotBlank((CharSequence)materialNumber)) {
            queryWrapper.eq(PurchaseInformationRecords::getMaterialNumber, (Object)materialNumber);
        } else {
            queryWrapper.eq(PurchaseInformationRecords::getMaterialGroup, (Object)materialGroup);
        }
        if (StringUtils.isNotBlank((CharSequence)factory)) {
            queryWrapper.eq(PurchaseInformationRecords::getFactory, (Object)factory);
        } else if (StringUtils.isNotBlank((CharSequence)purchaseOrg)) {
            queryWrapper.eq(PurchaseInformationRecords::getPurchaseOrg, (Object)purchaseOrg);
        }
        queryWrapper.and(a -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.lt(PurchaseInformationRecords::getEffectiveDate, (Object)new Date())).gt(PurchaseInformationRecords::getExpiryDate, (Object)new Date());
        });
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void insertInfomationRecordsBatch(ArrayList<PurchaseInformationRecords> copyProperties) {
        this.saveBatch(copyProperties);
    }

    @Override
    public boolean checkPriceIfCreateByType(PurchaseInformationRecords records) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(PurchaseInformationRecords::getSourceNumber, (Object)records.getSourceNumber())).eq(PurchaseInformationRecords::getSourceItemNumber, (Object)records.getSourceItemNumber())).eq(PurchaseInformationRecords::getAuditStatus, (Object)records.getAuditStatus())).eq(PurchaseInformationRecords::getPriceType, (Object)records.getPriceType())).eq(PurchaseInformationRecords::getSourceType, (Object)records.getSourceType());
        return ((PurchaseInformationRecordsMapper)this.baseMapper).selectCount((Wrapper)wrapper) > 0;
    }

    @Override
    public List<String> checkPriceForSome(List<String> stringList) {
        List<PurchaseInformationRecords> purchaseInformationRecords = ((PurchaseInformationRecordsMapper)this.baseMapper).checkPriceForSome(stringList);
        return purchaseInformationRecords.stream().map(o -> o.getMaterialNumber() + "_" + o.getFactory() + "_" + o.getPurchaseOrg()).distinct().collect(Collectors.toList());
    }

    @Override
    public void changePriceStatusForJob() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        DateTime date = DateUtil.date();
        param.put("nowDate", date);
        List<PurchaseInformationRecords> records = ((PurchaseInformationRecordsMapper)this.baseMapper).selectWithoutElsAccountToChangeStatus(param);
        ArrayList<PurchaseInformationRecords> updateRecords = new ArrayList<PurchaseInformationRecords>(records.size() / 2);
        for (PurchaseInformationRecords item : records) {
            if (null != item.getEffectiveDate() && item.getEffectiveDate().before((Date)date)) {
                item.setRecordStatus(PriceStatusEnum.EFFECTIVE.getValue());
            }
            if (null != item.getExpiryDate() && item.getExpiryDate().before((Date)date)) {
                item.setRecordStatus(PriceStatusEnum.INVALID.getValue());
            }
            updateRecords.add(item);
        }
        if (CollectionUtil.isEmpty(updateRecords)) {
            return;
        }
        this.updateBatchById(updateRecords);
        List dtoList = Convert.toList(PriceRecordsDTO.class, updateRecords);
        try {
            this.priceInvokeInquiryRpcService.refreshRequestItemToWaitOrder(dtoList);
        }
        catch (Exception e) {
            log.error("refreshRequestItemToWaitOrder error", (Throwable)e);
        }
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getPriceMainData", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List recordsList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseInformationRecords records : recordsList) {
            this.pushDataToErp(records);
        }
    }

    @Override
    public void auditPreCheck(List<PurchaseInformationRecords> recordsList) {
        for (int index = 0; index < recordsList.size(); ++index) {
            PurchaseInformationRecords records = recordsList.get(index);
            String indexMsg = records.getInfoRecordNumber();
            if (null != records.getPrice() && records.getPrice().compareTo(BigDecimal.ZERO) < 0) {
                throw new ELSBootException(indexMsg + I18nUtil.translate((String)"i18n_alert_xfuxOXU0_feacb714", (String)"\u542b\u7a0e\u4ef7\u4e0d\u80fd\u5c0f\u4e8e0\uff01"));
            }
            if (null != records.getExpiryDate() && null != records.getEffectiveDate() && records.getExpiryDate().before(records.getEffectiveDate())) {
                throw new ELSBootException(indexMsg + I18nUtil.translate((String)"i18n_alert_umtHjXyRBAxOQUumtHjXAKBA_95550107", (String)"\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u8bb0\u5f55\u6709\u6548\u8d77\u59cb\u65e5\u671f"));
            }
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)records.getPriceType()), (String)(indexMsg + I18nUtil.translate((String)"i18n_alert_umAclS_b641dd5b", (String)"\u4ef7\u683c\u7c7b\u578b\u5fc5\u586b")));
            if ("1".equals(records.getRecordType())) {
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)records.getMaterialNumber()), (String)(indexMsg + I18nUtil.translate((String)"i18n_alert_umAcLSLKWSLAylS_a87995e2", (String)"\u4ef7\u683c\u7c7b\u578b\u4e3a\u7269\u6599\u65f6\uff0c\u7269\u6599\u7f16\u53f7\u5fc5\u586b")));
            } else if ("2".equals(records.getRecordType())) {
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)records.getMaterialGroup()), (String)(indexMsg + I18nUtil.translate((String)"i18n_alert_umAcLSLVKWSLVlS_dce240f5", (String)"\u4ef7\u683c\u7c7b\u578b\u4e3a\u7269\u6599\u7ec4\u65f6\uff0c\u7269\u6599\u7ec4\u5fc5\u586b")));
            }
            Assert.isTrue((StringUtils.isNotBlank((CharSequence)records.getFactory()) || StringUtils.isNotBlank((CharSequence)records.getPurchaseOrg()) ? 1 : 0) != 0, (String)(indexMsg + I18nUtil.translate((String)"i18n_alert_RHnnRVRlTSMIm_f3c63546", (String)"\u5de5\u5382\u548c\u91c7\u8d2d\u7ec4\u7ec7\u5fc5\u987b\u586b\u5199\u4e00\u4e2a")));
            this.cutOffPriceDate(records, true);
        }
    }

    @Override
    public List<PurchaseInformationRecords> listRecordsByNumber(List<String> numberList) {
        if (CollectionUtil.isEmpty(numberList)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.in(PurchaseInformationRecords::getRecordStatus, (Collection)Lists.newArrayList((Object[])new String[]{PriceStatusEnum.EFFECTIVE.getValue(), PriceStatusEnum.NORMAL.getValue()}))).in(PurchaseInformationRecords::getAuditStatus, (Collection)Lists.newArrayList((Object[])new String[]{AuditStatusEnum.NO_AUDIT_REQUIRED.getValue(), AuditStatusEnum.AUDIT_FINISH.getValue()}))).in(PurchaseInformationRecords::getInfoRecordNumber, numberList);
        return ((PurchaseInformationRecordsMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    private void pushDataToErp(PurchaseInformationRecords records) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushPriceMainData", (Object)records);
    }

    private void auditCheckFromRedis() {
    }

    @Override
    public List<JSONObject> priceAnalyseByMaterial(PurchaseInformationRecords head) {
        List list;
        String materialNumber = head.getMaterialNumber();
        Date effectiveDate = head.getEffectiveDate();
        Date expiryDate = head.getExpiryDate();
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)materialNumber), (String)I18nUtil.translate((String)"i18n_alert_VSMSLAo_a0c7ce40", (String)"\u8bf7\u586b\u5199\u7269\u6599\u7f16\u7801"));
        Assert.isTrue((effectiveDate != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_vKKIxOLV_f095ba59", (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((expiryDate != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_yWKIxOLV_19b945ba", (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a"));
        final String factory = head.getFactory();
        final String purchaseOrg = head.getPurchaseOrg();
        QueryWrapper purchaseInformationRecordsQueryWrapper = new QueryWrapper();
        purchaseInformationRecordsQueryWrapper.lambda().eq(PurchaseInformationRecords::getMaterialNumber, (Object)head.getMaterialNumber());
        purchaseInformationRecordsQueryWrapper.lambda().ge(PurchaseInformationRecords::getEffectiveDate, (Object)effectiveDate);
        purchaseInformationRecordsQueryWrapper.lambda().le(PurchaseInformationRecords::getExpiryDate, (Object)expiryDate);
        if (StringUtils.isNotBlank((CharSequence)factory)) {
            purchaseInformationRecordsQueryWrapper.lambda().eq(PurchaseInformationRecords::getFactory, (Object)factory);
        }
        if (StringUtils.isNotBlank((CharSequence)purchaseOrg)) {
            purchaseInformationRecordsQueryWrapper.lambda().eq(PurchaseInformationRecords::getPurchaseOrg, (Object)purchaseOrg);
        }
        if (CollectionUtil.isEmpty((Collection)(list = this.list((Wrapper)purchaseInformationRecordsQueryWrapper)))) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6839\u636e\u6761\u4ef6\u672a\u5339\u914d\u5230\u6709\u6548\u7684\u4ef7\u683c\u6570\u636e"));
        }
        List mouthByTime = DateUtils.getMouthByTime((Date)effectiveDate, (Date)expiryDate);
        Map<String, List> collect = list.stream().collect(Collectors.toMap(new Function<PurchaseInformationRecords, String>(){

            @Override
            public String apply(PurchaseInformationRecords p) {
                String key = p.getToElsAccount() + "_" + p.getSupplierName();
                if (StringUtils.isNotBlank((CharSequence)purchaseOrg)) {
                    key = key + "_" + p.getPurchaseOrg();
                }
                if (StringUtils.isNotBlank((CharSequence)factory)) {
                    key = key + "_" + p.getFactory();
                }
                return key;
            }
        }, p -> {
            ArrayList<PurchaseInformationRecords> getNameList = new ArrayList<PurchaseInformationRecords>();
            getNameList.add((PurchaseInformationRecords)((Object)p));
            return getNameList;
        }, (value1, value2) -> {
            value1.addAll(value2);
            return value1;
        }));
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        HashMap<String, BigDecimal> stringBigDecimalHashMap = new HashMap<String, BigDecimal>();
        for (String s : mouthByTime) {
            for (String next : collect.keySet()) {
                List purchaseInformationRecords = collect.get(next);
                for (PurchaseInformationRecords purchaseInformationRecord : purchaseInformationRecords) {
                    Date effectiveDate1 = purchaseInformationRecord.getEffectiveDate();
                    Date expiryDate1 = purchaseInformationRecord.getExpiryDate();
                    List mouthByTime1 = DateUtils.getMouthByTime((Date)effectiveDate1, (Date)expiryDate1);
                    BigDecimal price = purchaseInformationRecord.getPrice() != null ? purchaseInformationRecord.getPrice() : BigDecimal.ZERO;
                    String key = next + "#" + s;
                    if (mouthByTime1.contains(s)) {
                        if (stringBigDecimalHashMap.containsKey(key)) {
                            BigDecimal bigDecimal = (BigDecimal)stringBigDecimalHashMap.get(key);
                            if (bigDecimal.compareTo(price) > 0) continue;
                            stringBigDecimalHashMap.put(key, price);
                            continue;
                        }
                        stringBigDecimalHashMap.put(key, price);
                        continue;
                    }
                    stringBigDecimalHashMap.put(key, BigDecimal.ZERO);
                }
            }
        }
        for (String next : stringBigDecimalHashMap.keySet()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", (Object)next.split("#")[0]);
            jsonObject.put("name", (Object)next.split("#")[1]);
            jsonObject.put("value", stringBigDecimalHashMap.get(next));
            jsonObjects.add(jsonObject);
        }
        return jsonObjects;
    }

    @Override
    public List<PurchaseInformationRecords> generatePrice(TemplateHeadDTO templateHeadDTO, PurchaseContractHeadDTO head, List<PurchaseContractItemDTO> contractItems) {
        ArrayList<PurchaseInformationRecords> informationRecords = new ArrayList<PurchaseInformationRecords>();
        if (CollectionUtil.isNotEmpty(contractItems)) {
            for (PurchaseContractItemDTO contractItem : contractItems) {
                PurchaseInformationRecords records = new PurchaseInformationRecords();
                records.setTemplateAccount(templateHeadDTO.getElsAccount());
                records.setTemplateName(templateHeadDTO.getTemplateName());
                records.setTemplateNumber(templateHeadDTO.getTemplateNumber());
                records.setTemplateVersion((int)templateHeadDTO.getTemplateVersion());
                records.setElsAccount(head.getElsAccount());
                records.setEffectiveDate(head.getEffectiveDate());
                records.setExpiryDate(head.getExpiryDate());
                records.setMaterialNumber(contractItem.getMaterialNumber());
                records.setMaterialId(contractItem.getMaterialId());
                records.setMaterialDesc(contractItem.getMaterialDesc());
                records.setToElsAccount(head.getToElsAccount());
                records.setSupplierCode(head.getSupplierCode());
                records.setSupplierName(head.getSupplierName());
                records.setTaxCode(contractItem.getTaxCode());
                records.setTaxRate(contractItem.getTaxRate());
                records.setPrice(contractItem.getPrice());
                records.setPurchaseUnit(contractItem.getPurchaseUnit());
                records.setPurchaseOrg(head.getPurchaseOrg());
                records.setCompany(head.getCompany());
                records.setPurchaseGroup(head.getPurchaseGroup());
                records.setDeleted(0);
                records.setCreateBy(SysUtil.getLoginUser().getSubAccount());
                records.setUpdateBy(SysUtil.getLoginUser().getSubAccount());
                records.setCreateTime(new Date());
                records.setUpdateTime(new Date());
                if (StringUtils.isBlank((CharSequence)records.getInfoRecordNumber())) {
                    records.setInfoRecordNumber(this.baseRpcService.getNextCode("srmPriceNumber", (Object)records));
                }
                records.setSourceType(PriceSourceTypeEnum.CONTRACT.getValue());
                if (StrUtil.isEmpty((CharSequence)records.getAuditStatus())) {
                    records.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
                }
                records.setRecordStatus(PriceStatusEnum.NEW.getValue());
                records.setQuoteDate(records.getQuoteDate() == null ? new Date() : records.getQuoteDate());
                if (AuditStatusEnum.NO_AUDIT_REQUIRED.getValue().equals(records.getAuditStatus())) {
                    this.cutOffPriceDate(records, false);
                    records.setRecordStatus(PriceStatusEnum.NORMAL.getValue());
                    this.checkStatus(records);
                }
                this.calculatePrice(records);
                informationRecords.add(records);
            }
            ((PurchaseInformationRecordsMapper)this.baseMapper).insertBatchSomeColumn(informationRecords);
        }
        return informationRecords;
    }

    public int insertBatchSomeColumn(List<PurchaseInformationRecords> entityList) {
        return ((PurchaseInformationRecordsMapper)this.baseMapper).insertBatchSomeColumn(entityList);
    }

    @Override
    public void batchSubmit(List<PurchaseInformationRecords> purchaseInformationRecords) {
        this.verifySubmitdata(purchaseInformationRecords);
        this.doBatchSubmit(purchaseInformationRecords);
    }

    private void verifySubmitdata(List<PurchaseInformationRecords> purchaseInformationRecords) {
        for (PurchaseInformationRecords record : purchaseInformationRecords) {
            if ("1".equals(record.getRecordStatus()) && "0".equals(record.getAuditStatus())) continue;
            throw new ELSBootException("\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25\uff0c\u72b6\u6001\u5fc5\u987b\u4e3a\u65b0\u5efa\uff0c\u5ba1\u6279\u72b6\u6001\u5fc5\u987b\u4e3a\u672a\u5ba1\u6279");
        }
    }

    private void doBatchSubmit(List<PurchaseInformationRecords> purchaseInformationRecords) {
        for (PurchaseInformationRecords purchaseInformationRecord : purchaseInformationRecords) {
            AuditInputParamDTO dto = new AuditInputParamDTO();
            dto.setBusinessId(purchaseInformationRecord.getId());
            dto.setBusinessType("price");
            dto.setAuditSubject("\u4ef7\u683c\u4e3b\u6570\u636e\u5355\u53f7:" + purchaseInformationRecord.getInfoRecordNumber());
            dto.setParams(JSONObject.toJSONString((Object)((Object)purchaseInformationRecord)));
            this.priceInvokeWorkFlowRpcService.submit(dto);
        }
    }
}

