/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.utils;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SpringContextUtils;
import com.els.modules.material.entity.PurchaseMaterialHead;
import com.els.modules.material.entity.PurchaseMaterialItem;
import com.els.modules.material.entity.PurchaseMaterialUnit;
import com.els.modules.material.service.PurchaseMaterialHeadService;
import com.els.modules.material.vo.PurchaseMaterialHeadVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class InterfaceDatasUtils {
    private static PurchaseMaterialHeadService purchaseMaterialHeadService = (PurchaseMaterialHeadService)SpringContextUtils.getBean(PurchaseMaterialHeadService.class);

    public static List<PurchaseMaterialHead> checkData(JSONArray materialListArray) {
        ArrayList<String> codes = new ArrayList<String>();
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty((Collection)materialListArray), (String)"materialListArray\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!");
        Assert.isTrue((materialListArray.size() <= 500 ? 1 : 0) != 0, (String)("\u6bcf\u6b21\u4f20\u9001\u6570\u636e\u4e0d\u80fd\u8d85\u8fc7500\u6761,\u5f53\u524d\u6570\u636e" + materialListArray.size() + "\u6761,\u8bf7\u68c0\u67e5!"));
        List purchaseMaterialHeadVOS = JSON.parseArray((String)materialListArray.toJSONString(), PurchaseMaterialHeadVO.class);
        for (PurchaseMaterialHeadVO purchaseMaterialHeadVO : purchaseMaterialHeadVOS) {
            InterfaceDatasUtils.checkMaterialHead(purchaseMaterialHeadVO);
            InterfaceDatasUtils.checkItems(purchaseMaterialHeadVO);
            codes.add(purchaseMaterialHeadVO.getMaterialNumber());
        }
        List duplicate = InterfaceDatasUtils.findDuplicate(codes);
        Assert.isTrue((boolean)CollectionUtil.isEmpty(duplicate), (String)("\u7269\u6599\u4e3b\u6570\u636e\u4e2d" + duplicate.toString() + "\u5b58\u5728\u91cd\u590d\u6570\u636e,\u8bf7\u68c0\u67e5\uff01"));
        QueryWrapper purchaseMaterialHeadQueryWrapper = new QueryWrapper();
        purchaseMaterialHeadQueryWrapper.lambda().eq(BaseEntity::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
        purchaseMaterialHeadQueryWrapper.lambda().in(PurchaseMaterialHead::getMaterialNumber, codes);
        List existDatas = purchaseMaterialHeadService.list((Wrapper)purchaseMaterialHeadQueryWrapper);
        return existDatas;
    }

    public static void checkMaterialHead(PurchaseMaterialHeadVO purchaseMaterialHeadVO) {
        List<String> strings = Arrays.asList("0", "1");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialHeadVO.getMaterialNumber()), (String)"materialNumber\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialHeadVO.getBaseUnit()), (String)"baseUnit\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
    }

    public static void checkItems(PurchaseMaterialHeadVO purchaseMaterialHeadVO) {
        if (CollectionUtil.isNotEmpty(purchaseMaterialHeadVO.getPurchaseMaterialItemList())) {
            for (PurchaseMaterialItem materialItem : purchaseMaterialHeadVO.getPurchaseMaterialItemList()) {
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)materialItem.getFactory()), (String)"\u7269\u6599\u884cfactory\u3010\u5de5\u5382\u3011\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
    }

    public static void checkUnits(PurchaseMaterialHeadVO purchaseMaterialHeadVO) {
        List<String> strings = Arrays.asList("0", "1");
        if (CollectionUtil.isNotEmpty(purchaseMaterialHeadVO.getPurchaseMaterialMeterUnitList())) {
            ArrayList<String> alltype = new ArrayList<String>();
            for (PurchaseMaterialUnit purchaseMaterialUnit : purchaseMaterialHeadVO.getPurchaseMaterialMeterUnitList()) {
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialUnit.getType()), (String)"\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u4e2d\u3010type\u3011\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
                Assert.isTrue((boolean)strings.contains(purchaseMaterialUnit.getType()), (String)"\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u4e2d\u3010type\u3011\u5b57\u6bb5\u53ea\u80fd\u586b0\uff08\u91c7\u8d2d\u5355\u4f4d)1(\u5e93\u5b58\u5355\u4f4d)");
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialUnit.getBasicUnit()), (String)"\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u4e2dt\u3010basicUnit\u3011\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
                Assert.isTrue((purchaseMaterialUnit.getBasicAmount() != null ? 1 : 0) != 0, (String)"\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u4e2d\u3010basicAmount\u6570\u91cfX\u3011\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)purchaseMaterialUnit.getObjectUnit()), (String)"\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u4e2d\u3010objectUnit\u8ba1\u91cf\u5355\u4f4d\u3011\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
                Assert.isTrue((purchaseMaterialUnit.getObjectAmount() != null ? 1 : 0) != 0, (String)"\u8ba1\u91cf\u5355\u4f4d\u4fe1\u606f\u4e2d\u3010objectAmount\u3011\u6570\u91cfY\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
                alltype.add(purchaseMaterialUnit.getType());
            }
            Assert.isTrue((boolean)alltype.containsAll(strings), (String)"\u8ba1\u91cf\u5355\u4f4d\u4e2d\u6700\u5c11\u8981\u6709\u4e00\u884c\u5e93\u5b58\u5355\u4f4d\u548c\u91c7\u8d2d\u5355\u4f4d");
        }
    }

    public static <T> List<T> findDuplicate(List<T> list) {
        HashSet<T> set = new HashSet<T>();
        ArrayList<T> duplicatesList = new ArrayList<T>();
        for (T t : list) {
            if (set.add(t)) continue;
            duplicatesList.add(t);
        }
        return duplicatesList;
    }
}

