/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.member.controller;

import com.els.common.api.vo.Result;
import com.els.common.system.base.controller.BaseController;
import com.els.modules.member.entity.Member;
import com.els.modules.member.service.MemberService;
import com.els.modules.member.vo.CheckModelVo;
import com.els.modules.member.vo.CurrentOptVo;
import com.els.modules.member.vo.LoginModelExtent;
import io.swagger.annotations.Api;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"mcn\u4f1a\u5458"})
@RestController
@RequestMapping(value={"/member"})
public class MemberController
extends BaseController<Member, MemberService> {
    private static final Logger log = LoggerFactory.getLogger(MemberController.class);
    @Resource
    private MemberService memberService;

    @RequestMapping(value={"/checkEnterprise"}, method={RequestMethod.POST})
    public Result<?> checkEnterprise(@RequestBody LoginModelExtent loginModel) {
        CheckModelVo checkModelVo = this.memberService.checkEnterprise(loginModel);
        return Result.ok((Object)checkModelVo);
    }

    @RequestMapping(value={"/createElsAccount"}, method={RequestMethod.POST})
    public Result<?> createElsAccount(@RequestBody LoginModelExtent loginModel) {
        return this.memberService.createElsAccount(loginModel);
    }

    @RequestMapping(value={"/noToken/appointDemo"}, method={RequestMethod.POST})
    public Result<?> appointDemo(@RequestBody LoginModelExtent loginModel) {
        return this.memberService.appointDemo(loginModel);
    }

    @RequestMapping(value={"/getLimit"}, method={RequestMethod.GET})
    public Result<?> getLimit(@RequestParam(value="configCode") String configCode) {
        CurrentOptVo vo = this.memberService.getLimit(configCode);
        return Result.ok((Object)vo);
    }
}

