/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.util.PermissionDataQueryUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.system.vo.TodoTypeEnum;
import com.els.modules.todo.vo.TodoCountInfoVO;
import com.els.modules.todo.vo.TodoStatusVO;
import com.els.modules.touch.entity.TopManMsgRecord;
import com.els.modules.touch.service.TopManMsgRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9996\u9875\u5f85\u529e\u4e8b\u9879"})
@RestController
@RequestMapping(value={"/base/todoExtend"})
public class TodoExtendListController {
    private static final Logger log = LoggerFactory.getLogger(TodoExtendListController.class);
    @Autowired
    private TopManMsgRecordService topManMsgRecordService;
    @Autowired
    private PermissionDataQueryUtil permissionDataQueryUtil;
    @Resource
    private AccountRpcService accountRpcService;

    @ApiOperation(value="\u83b7\u53d6\u9996\u9875\u5f85\u529e\u4e8b\u9879\u7edf\u8ba1", notes="\u83b7\u53d6\u9996\u9875\u5f85\u529e\u4e8b\u9879\u7edf\u8ba1")
    @PostMapping(value={"/getTodoCountList"})
    public Result<?> getTodoCountList() {
        List<PermissionDTO> filterPermissionDTOList = this.processPermissionTodoList();
        if (filterPermissionDTOList == null || filterPermissionDTOList.size() == 0) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        filterPermissionDTOList.forEach(permissionDTO -> {
            TodoCountInfoVO todoCountInfoVO = this.processTodoInfo((PermissionDTO)permissionDTO, 11);
            this.processCount(todoCountInfoVO);
            list.add(todoCountInfoVO);
        });
        return Result.ok((Object)list);
    }

    private String getAccountBusinessType(String businessType) {
        String accountBusinessType = null;
        if (StringUtils.isNotBlank((CharSequence)businessType)) {
            accountBusinessType = TenantContext.getTenant() + "_" + SysUtil.getLoginUser().getSubAccount() + "-" + businessType;
        }
        return accountBusinessType;
    }

    private void processCount(TodoCountInfoVO todoCountInfoVO) {
        switch (todoCountInfoVO.getModuleName()) {
            case "\u8fbe\u4eba\u89e6\u8fbe": {
                this.handleTouch(todoCountInfoVO);
                break;
            }
            case "\u8fbe\u4eba\u5408\u4f5c": {
                break;
            }
            case "\u4f01\u4e1a\u8d44\u6e90": {
                break;
            }
            case "\u4f01\u4e1a\u5e97\u94fa": {
                break;
            }
            case "\u9009\u54c1\u5e7f\u573a": {
                break;
            }
        }
    }

    private void handleTouch(TodoCountInfoVO todoCountInfoVO) {
        this.permissionDataQueryUtil.initPermissionData(this.getAccountBusinessType("talentMsg"));
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)new TopManMsgRecord(), new HashMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"is_deleted", (Object)0);
        TodoStatusVO all = new TodoStatusVO();
        int count = this.topManMsgRecordService.count((Wrapper)queryWrapper);
        all.setName("\u5168\u90e8\u8fbe\u4eba");
        all.setValue(count + "");
        TodoStatusVO my = new TodoStatusVO();
        int mc = this.topManMsgRecordService.count((Wrapper)queryWrapper);
        my.setName("\u6211\u7684\u8fbe\u4eba");
        my.setValue(mc + "");
        todoCountInfoVO.setStatusList(Arrays.asList(all, my));
    }

    private TodoCountInfoVO processTodoInfo(PermissionDTO permissionDTO, Integer count) {
        TodoCountInfoVO vo = new TodoCountInfoVO();
        TodoTypeEnum todoTypeEnum = TodoTypeEnum.getByUrl(permissionDTO.getUrl());
        vo.setModuleName(todoTypeEnum.getModuleName());
        vo.setCountNumber(count);
        vo.setIcon(permissionDTO.getIcon());
        vo.setPageRoute(permissionDTO.getUrl());
        return vo;
    }

    private List<PermissionDTO> processPermissionTodoList() {
        String account = TenantContext.getTenant() + "_" + SysUtil.getLoginUser().getSubAccount();
        List permissionDTOList = this.accountRpcService.selectAccountPermission(account);
        if (permissionDTOList == null || permissionDTOList.size() == 0) {
            return null;
        }
        ArrayList<PermissionDTO> filterPermissionDTOList = new ArrayList();
        List<String> allTodoTypeList = TodoTypeEnum.getAllTodoTypeList();
        for (String todoType : allTodoTypeList) {
            for (PermissionDTO permissionDTO : permissionDTOList) {
                if (!todoType.equals(permissionDTO.getUrl())) continue;
                filterPermissionDTOList.add(permissionDTO);
            }
        }
        filterPermissionDTOList = filterPermissionDTOList.parallelStream().sorted(Comparator.comparing(PermissionDTO::getUrl)).collect(Collectors.toList());
        return filterPermissionDTOList;
    }
}

