/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.ApiLimitErrorEnum;
import com.els.common.enumerate.TenantControlModeEnum;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.common.utils.ApiAssertI18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.ApiCallCountRpcService;
import com.els.modules.apirecord.entity.ApiCallRecord;
import com.els.modules.apirecord.enumerate.ApiTypeEnum;
import com.els.modules.apirecord.service.ApiCallRecordService;
import com.els.modules.common.utils.RedissonUtil;
import com.els.modules.system.entity.McnTenantParamConfig;
import com.els.modules.system.service.McnTenantParamConfigService;
import java.util.Date;
import org.redisson.api.RLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ApiCallRecordRpcServiceImpl
implements ApiCallCountRpcService {
    @Autowired
    @Lazy
    private ApiCallRecordService apiCallRecordService;
    @Autowired
    @Lazy
    private McnTenantParamConfigService tenantParamConfigService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private RedissonUtil redissonUtil;

    public void removeRedisCache(String apiCode, String elsAccount, String subAccount) {
        String key = "api:count:" + elsAccount + ":" + apiCode;
        String keyStr = "api:count:str:" + elsAccount + ":" + apiCode;
        String subKey = "api:count:str:" + elsAccount + ":" + subAccount + ":" + apiCode;
        String subkeyStr = "api:count:str:" + elsAccount + ":" + subAccount + ":" + apiCode;
        this.redisUtil.del(new String[]{key, keyStr, subKey, subkeyStr});
    }

    public void saveApiCallRecord(String apiCode, String id, String elsAccount, String subAccount) {
        ApiCallRecord record = new ApiCallRecord();
        ApiTypeEnum apiTypeEnum = ApiTypeEnum.getApiTypeEnumByCode(apiCode);
        if (apiTypeEnum == null) {
            return;
        }
        String configCode = apiTypeEnum.getConfigCode();
        if (StrUtil.isBlank((CharSequence)configCode)) {
            return;
        }
        String num = this.tenantParamConfigService.getOneConfig(elsAccount, configCode);
        if ("Y".equals(num)) {
            return;
        }
        record.setElsAccount(elsAccount);
        record.setApiCode(apiCode);
        record.setRelatedId(id);
        record.setCreateTime(new Date());
        record.setSubAccount(subAccount);
        record.setCreateBy(subAccount);
        record.setApiName(apiTypeEnum.getDesc());
        record.setApiCode(apiTypeEnum.getCode());
        record.setApiType(apiTypeEnum.getType());
        this.apiCallRecordService.save((Object)record);
        if (StrUtil.isBlank((CharSequence)apiTypeEnum.getConfigCode())) {
            return;
        }
        this.saveCount(record, elsAccount, subAccount, configCode);
    }

    public void checkApiLimit(String apiCode) {
        String elsAccount = TenantContext.getTenant();
        ApiTypeEnum apiTypeEnum = ApiTypeEnum.getApiTypeEnumByCode(apiCode);
        if (apiTypeEnum == null) {
            return;
        }
        String configCode = apiTypeEnum.getConfigCode();
        String num = this.tenantParamConfigService.getOneConfig(elsAccount, configCode);
        if (!"Y".equals(num)) {
            Long limitNum = Long.valueOf(num);
            Long countNum = null;
            McnTenantParamConfig config = this.tenantParamConfigService.getOneConfigDb(elsAccount, configCode);
            if (ObjectUtil.isEmpty((Object)((Object)config))) {
                return;
            }
            String redisKey = "api:count:str:" + elsAccount + ":" + apiCode;
            if (TenantControlModeEnum.SUB_ACCOUNT.value.equals(config.getControlMode())) {
                redisKey = "api:count:str:" + elsAccount + ":" + SysUtil.getLoginUser().getSubAccount() + ":" + apiCode;
            }
            if (!this.redisUtil.hasKey(redisKey)) {
                return;
            }
            String numStr = (String)this.redisUtil.get(redisKey);
            countNum = Long.valueOf(numStr);
            ApiAssertI18nUtil.isTrue((countNum >= limitNum ? 1 : 0) != 0, (Enum)ApiLimitErrorEnum.NUM_LIMIT_MESSAGE, (String)(ApiTypeEnum.isListLimit(apiTypeEnum) ? "100002" : "100001"));
        }
    }

    @SrmTransaction(rollbackFor={Exception.class})
    public void deductionCount(String configCode, String relatedId) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        RLock lock = this.redissonUtil.lock("deduction_count_" + configCode + elsAccount, Long.valueOf(120L));
        Assert.notNull((Object)lock, (String)"\u6b63\u5728\u6263\u9664\u6b21\u6570\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c", (Object[])new Object[0]);
        try {
            McnTenantParamConfig config = this.tenantParamConfigService.getOneConfigDb(elsAccount, configCode);
            Assert.notNull((Object)((Object)config), (String)"\u672a\u914d\u7f6e\u6b21\u6570", (Object[])new Object[0]);
            Assert.notBlank((CharSequence)config.getDefaultValue(), (String)"\u672a\u914d\u7f6e\u6b21\u6570", (Object[])new Object[0]);
            int count = Integer.valueOf(config.getDefaultValue());
            Assert.isTrue((count > 0 ? 1 : 0) != 0, (String)"\u6b21\u6570\u5df2\u8017\u5c3d", (Object[])new Object[0]);
            config.setDefaultValue(--count + "");
            this.tenantParamConfigService.updateById((Object)config);
            this.saveDedRecord(loginUser, configCode, relatedId);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.redissonUtil.unLock(lock);
        }
    }

    private void saveDedRecord(LoginUser loginUser, String configCode, String relatedId) {
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        ApiCallRecord record = new ApiCallRecord();
        ApiTypeEnum apiTypeEnum = ApiTypeEnum.getApiTypeEnumByConfigCode(configCode);
        if (apiTypeEnum == null) {
            return;
        }
        record.setElsAccount(elsAccount);
        record.setApiCode(record.getApiCode());
        record.setRelatedId(relatedId);
        record.setCreateTime(new Date());
        record.setSubAccount(subAccount);
        record.setCreateBy(subAccount);
        record.setApiName(apiTypeEnum.getDesc());
        record.setApiCode(apiTypeEnum.getCode());
        record.setApiType(apiTypeEnum.getType());
        this.apiCallRecordService.save((Object)record);
    }

    private void saveCount(ApiCallRecord record, String elsAccount, String subAccount, String configCode) {
        McnTenantParamConfig config = this.tenantParamConfigService.getOneConfigDb(elsAccount, configCode);
        String key = "api:count:" + elsAccount + ":" + record.getApiCode();
        String keyStr = "api:count:str:" + elsAccount + ":" + record.getApiCode();
        if (TenantControlModeEnum.SUB_ACCOUNT.value.equals(config.getControlMode())) {
            key = "api:count:" + elsAccount + ":" + subAccount + ":" + record.getApiCode();
            keyStr = "api:count:str:" + elsAccount + ":" + subAccount + ":" + record.getApiCode();
        }
        Long count = this.redisUtil.incr(key, 1L);
        this.redisUtil.set(keyStr, (Object)count.toString(), 86400L);
    }
}

