/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.context.TokenContext;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.ImgCreatorUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.PasswordUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.CompanyPermissionDTO;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.ElsTenantDTO;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.account.api.dto.PersonalSettingDTO;
import com.els.modules.account.api.dto.RoleDTO;
import com.els.modules.account.api.dto.RolePermissionDTO;
import com.els.modules.amateur.api.dto.PurchaseAmateurHeadDTO;
import com.els.modules.amateur.api.enumerate.AmateurStatusEnum;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.organ.api.dto.PurchaserOrganHeadDTO;
import com.els.modules.supplier.entity.SupplierInvitationCode;
import com.els.modules.supplier.entity.SupplierMasterData;
import com.els.modules.supplier.enumerate.SourceTypeEnum;
import com.els.modules.supplier.enumerate.SupplierFrozenStatusEnum;
import com.els.modules.supplier.enumerate.SupplierInvitationCodeStatusEnum;
import com.els.modules.supplier.enumerate.SupplierRegisterTypeExtendEnum;
import com.els.modules.supplier.enumerate.SupplierStatusEnum;
import com.els.modules.supplier.mapper.SupplierMasterDataMapper;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountExtendRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeMainDataExtendRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeTopManExtendRpcService;
import com.els.modules.supplier.service.SupplierInvitationCodeService;
import com.els.modules.supplier.service.SupplierMasterDataExtendService;
import com.els.modules.supplier.vo.RegisterExtendVO;
import com.els.modules.supplier.vo.RegisterMqDataVo;
import com.els.modules.supplier.vo.RegisterVO;
import com.els.rpc.service.ImGroupInvokeRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SupplierMasterDataExtendServiceImpl
extends BaseServiceImpl<SupplierMasterDataMapper, SupplierMasterData>
implements SupplierMasterDataExtendService {
    private static final Logger log = LoggerFactory.getLogger(SupplierMasterDataExtendServiceImpl.class);
    @Autowired
    private SupplierMasterDataMapper supplierMasterDataMapper;
    @Autowired
    private SupplierInvitationCodeService supplierInvitationCodeService;
    @Autowired
    private SupplierInvokeBaseRpcService supplierinvokeBaseRpcService;
    @Autowired
    private SupplierInvokeEnterpriseRpcService supplierinvokeEnterpriseRpcService;
    @Lazy
    @Resource
    private SupplierInvokeAccountExtendRpcService supplierInvokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired(required=false)
    private ImGroupInvokeRpcService baseImGroupService;
    @Resource(name="srmPoolExecutor")
    public ThreadPoolExecutor srmPoolExecutor;
    @Autowired
    private SupplierInvokeMainDataExtendRpcService supplierInvokeMainDataRpcService;
    @Autowired
    private SupplierInvokeTopManExtendRpcService supplierInvokeTopManRpcService;
    @Resource
    private InvokeBaseRpcService baseRpcService;
    @Value(value="${els.path.upload}")
    private String uploadpath;
    private static final String STR_FORMAT = "yyyyMMdd";

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> register(RegisterExtendVO registerVO) {
        List enterpriseInfos = this.supplierinvokeEnterpriseRpcService.selectList(registerVO.getCompanyName());
        if (enterpriseInfos != null && enterpriseInfos.size() > 0) {
            return Result.error((String)("\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728,SRM\u4f01\u4e1a\u8d26\u53f7\u4e3a\uff1a" + ((ElsEnterpriseInfoDTO)enterpriseInfos.get(0)).getElsAccount()));
        }
        return this.getAndSaveEnterpriseYouhua(registerVO);
    }

    private String getFilePath() {
        String bizPath = "files";
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
        String nowDay = dtf.format(time);
        String elsAccount = TenantContext.getTenant();
        return File.separator + bizPath + File.separator + elsAccount + File.separator + nowDay;
    }

    private Result<?> getAndSaveEnterpriseYouhua(RegisterExtendVO registerExtendVO) {
        JSONObject result;
        String els_account = null;
        SupplierInvitationCode invitationCode = null;
        if (SourceTypeEnum.INVITE_REGISTER.getValue().equals(registerExtendVO.getSourceType())) {
            invitationCode = this.supplierInvitationCodeService.getByCode(registerExtendVO.getInvitationCode());
            if (invitationCode == null) {
                return Result.error((String)"\u9080\u8bf7\u7801\u65e0\u6548");
            }
            if (SupplierInvitationCodeStatusEnum.REGISTERED.getValue().equals(invitationCode.getStatus())) {
                return Result.error((String)"\u9080\u8bf7\u7801\u5df2\u88ab\u6ce8\u518c");
            }
            if (SupplierInvitationCodeStatusEnum.LOSE_EFFICACY.getValue().equals(invitationCode.getStatus())) {
                return Result.error((String)"\u9080\u8bf7\u7801\u5df2\u5931\u6548");
            }
            SimpleDateFormat dateStr = new SimpleDateFormat("yyyy-MM-dd");
            String currentTime = dateStr.format(new Date());
            try {
                Date date = dateStr.parse(currentTime);
                if (date.getTime() > invitationCode.getEffectiveDate().getTime()) {
                    invitationCode.setStatus(SupplierInvitationCodeStatusEnum.LOSE_EFFICACY.getValue());
                    this.supplierInvitationCodeService.updateSupplierInvitationCode(invitationCode);
                    return Result.error((String)"\u8be5\u9080\u8bf7\u7801\u5df2\u8fc7\u6709\u6548\u671f\uff01");
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            els_account = invitationCode.getElsAccount();
            TenantContext.setTenant((String)els_account);
            if ("1".equals(invitationCode.getAppointType())) {
                registerExtendVO.setTemplateAccount(invitationCode.getTemplateAccount());
                registerExtendVO.setTemplateName(invitationCode.getTemplateName());
                registerExtendVO.setTemplateNumbe(invitationCode.getTemplateNumber());
                registerExtendVO.setTemplateVersion(invitationCode.getTemplateVersion());
            }
        }
        if (SourceTypeEnum.OPEN_REGISTER.getValue().equals(registerExtendVO.getSourceType()) || SourceTypeEnum.BUSINESS_PROMOTION.getValue().equals(registerExtendVO.getSourceType())) {
            els_account = "100000";
            TenantContext.setTenant((String)"100000");
        }
        if (SourceTypeEnum.GENERATION_REGISTER.getValue().equals(registerExtendVO.getSourceType())) {
            els_account = TenantContext.getTenant();
        }
        if ((result = this.supplierinvokeBaseRpcService.callIPaasInterface(this.getIpaaSData(registerExtendVO.getCompanyName(), registerExtendVO.getSourceType(), els_account), "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("get-enterprise-info"))).getBoolean("success").booleanValue()) {
            ElsEnterpriseInfoDTO ElsEnterpriseInfoDTO2 = (ElsEnterpriseInfoDTO)JSONObject.parseObject((String)result.getJSONObject("data").toJSONString(), ElsEnterpriseInfoDTO.class);
            ElsEnterpriseInfoDTO enterpriseInfo = this.supplierinvokeEnterpriseRpcService.getByElsAccount(ElsEnterpriseInfoDTO2.getElsAccount());
            if (enterpriseInfo != null) {
                return Result.error((String)("\u8be5\u4f01\u4e1a\u5df2\u5b58\u5728,SRM\u4f01\u4e1a\u8d26\u53f7\u4e3a\uff1a" + enterpriseInfo.getElsAccount()));
            }
            String supplierMasterDataId = "";
            String templateNumber = "";
            String templateVersion = "";
            if (!SourceTypeEnum.OPEN_REGISTER.getValue().equals(registerExtendVO.getSourceType())) {
                SupplierMasterData data = new SupplierMasterData();
                this.saveSupplierMasterData(ElsEnterpriseInfoDTO2, registerExtendVO, data, els_account);
                supplierMasterDataId = data.getId();
                templateNumber = data.getTemplateNumber();
                templateVersion = data.getTemplateVersion();
            }
            ElsSubAccountDTO account = new ElsSubAccountDTO();
            account.setElsAccount(ElsEnterpriseInfoDTO2.getElsAccount());
            account.setSubAccount(StringUtils.isNotBlank((CharSequence)registerExtendVO.getSubAccount()) ? registerExtendVO.getSubAccount() : "1001");
            account.setRealname(registerExtendVO.getContactsName());
            account.setPhone(registerExtendVO.getPhoneNumber());
            account.setStatus(Integer.valueOf(1));
            account.setEmail(registerExtendVO.getEmail());
            String salt = ConvertUtils.randomGen((int)8);
            account.setSalt(salt);
            String password = registerExtendVO.getPassword();
            String passwordEncode = PasswordUtil.encrypt((String)(ElsEnterpriseInfoDTO2.getElsAccount() + "_" + account.getSubAccount()), (String)password, (String)salt);
            account.setPassword(passwordEncode);
            account.setDeleted(Integer.valueOf(0));
            byte[] bytes = ImgCreatorUtil.generateImg((String)account.getRealname());
            if (null != bytes) {
                String fileName = System.currentTimeMillis() + ".jpg";
                String filePath = this.getFilePath() + File.separator + System.currentTimeMillis() + fileName;
                if (filePath.contains("\\")) {
                    filePath = filePath.replace("\\", "/");
                }
                String avatar = this.supplierinvokeBaseRpcService.uploadFile(bytes, this.uploadpath + filePath, fileName);
                account.setAvatar("/opt/upFiles" + avatar.replace(this.uploadpath, ""));
            }
            RoleDTO role = new RoleDTO();
            role.setElsAccount(ElsEnterpriseInfoDTO2.getElsAccount());
            role.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
            role.setRoleCode("companyAdmin");
            role = this.supplierInvokeAccountRpcService.saveRole(role);
            account = this.supplierInvokeAccountRpcService.addUserWithRole(account, role.getId());
            RegisterVO registerVO = new RegisterVO();
            RegisterMqDataVo registerMqDataVo = new RegisterMqDataVo(ElsEnterpriseInfoDTO2, registerVO, invitationCode, els_account, account, role, TenantContext.getTenant(), SysUtil.getLoginUser(), SpringContextUtils.getHttpServletRequest().getHeader("X-Access-Token"));
            String infoJson = JSON.toJSONString((Object)registerMqDataVo);
            this.registerMqdataDeal(registerMqDataVo, registerExtendVO);
            if (SourceTypeEnum.GENERATION_REGISTER.getValue().equals(registerExtendVO.getSourceType())) {
                Result r = new Result();
                r.setSuccess(true);
                r.setCode(CommonConstant.SC_OK_200);
                r.setMessage("\u6ce8\u518c\u6210\u529f\uff01 \u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\uff1a" + ElsEnterpriseInfoDTO2.getElsAccount() + " \u5b50\u8d26\u53f7\uff1a1001\u521d\u59cb\u767b\u5165\u5bc6\u7801\u4e3a\uff1a" + registerExtendVO.getPassword());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", supplierMasterDataId);
                map.put("elsAccount", els_account);
                map.put("templateNumber", templateNumber);
                map.put("templateVersion", templateVersion);
                r.setResult(map);
                return r;
            }
            return Result.ok((String)("\u6ce8\u518c\u6210\u529f\uff01 \u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\uff1a" + ElsEnterpriseInfoDTO2.getElsAccount() + " \u5b50\u8d26\u53f7\uff1a1001\u521d\u59cb\u767b\u5165\u5bc6\u7801\u4e3a\uff1a" + registerExtendVO.getPassword()));
        }
        return Result.error((String)("\u6ce8\u518c\u5931\u8d25\uff1a" + result.getString("message")));
    }

    public void registerMqdataDeal(RegisterMqDataVo dataVo, RegisterExtendVO registerVO) {
        TenantContext.setTenant((String)dataVo.getTenant());
        LoginUserContext.setUser((LoginUser)dataVo.getLoginUser());
        TokenContext.setToken((String)dataVo.getToken());
        ElsEnterpriseInfoDTO ElsEnterpriseInfoDTO2 = dataVo.getElsEnterpriseInfoDTO();
        SupplierInvitationCode invitationCode = dataVo.getInvitationCode();
        String els_account = dataVo.getElsAccount();
        ElsSubAccountDTO account = dataVo.getAccount();
        RoleDTO role = dataVo.getRole();
        ElsEnterpriseInfoDTO2.setDeleted(Integer.valueOf(0));
        if (!SourceTypeEnum.OPEN_REGISTER.getValue().equals(registerVO.getSourceType())) {
            if (invitationCode != null) {
                invitationCode.setToElsAccount(ElsEnterpriseInfoDTO2.getElsAccount());
                invitationCode.setSubAccount("1001");
                invitationCode.setStatus(SupplierInvitationCodeStatusEnum.REGISTERED.getValue());
                this.supplierInvitationCodeService.updateSupplierInvitationCode(invitationCode);
                this.supplierinvokeBaseRpcService.callIPaasInterface(this.getIpaaSRelationData(invitationCode.getElsAccount(), ElsEnterpriseInfoDTO2.getElsAccount()), "enterpriseRelationship", null);
            } else {
                this.supplierinvokeBaseRpcService.callIPaasInterface(this.getIpaaSRelationData(TenantContext.getTenant(), ElsEnterpriseInfoDTO2.getElsAccount()), "enterpriseRelationship", null);
            }
        }
        ElsEnterpriseInfoDTO2.setCreateBy(account.getCreateBy());
        ElsEnterpriseInfoDTO2.setUpdateBy(account.getUpdateBy());
        this.supplierinvokeEnterpriseRpcService.insert(ElsEnterpriseInfoDTO2);
        registerVO.setCompanyName(ElsEnterpriseInfoDTO2.getName());
        this.saveSubAccountInfoYouhua(registerVO, ElsEnterpriseInfoDTO2.getElsAccount(), account, role);
        this.doEventByRegistType(ElsEnterpriseInfoDTO2, registerVO);
        String id = account.getId();
        this.srmPoolExecutor.execute(() -> {
            try {
                LoginUserContext.setUser((LoginUser)dataVo.getLoginUser());
                TenantContext.setTenant((String)dataVo.getTenant());
                TokenContext.setToken((String)dataVo.getToken());
                this.baseImGroupService.initGroup(id);
            }
            catch (Exception e) {
                log.error(":::\u6dfb\u52a0\u597d\u53cb\u5206\u7ec4\u5f02\u5e38:{}", (Object)e.getMessage());
            }
            finally {
                TenantContext.clear();
                LoginUserContext.clear();
                TokenContext.clear();
            }
        });
    }

    private void doEventByRegistType(ElsEnterpriseInfoDTO elsEnterpriseInfoDTO, RegisterExtendVO registerVO) {
        if (SupplierRegisterTypeExtendEnum.MCN_ORGANIZATION.getValue().equals(registerVO.getSupplierRegisterType()) || SupplierRegisterTypeExtendEnum.BUSINESS_TEAMER.getValue().equals(registerVO.getSupplierRegisterType())) {
            PurchaserOrganHeadDTO purchaserOrganHeadDTO = this.supplierInvokeMainDataRpcService.selectPurchaseOrganHeadByName(registerVO.getCompanyName());
            if (purchaserOrganHeadDTO != null) {
                purchaserOrganHeadDTO.setOrgElsAccount(elsEnterpriseInfoDTO.getElsAccount());
                this.supplierInvokeMainDataRpcService.updatePurchaseOrganHeadById(purchaserOrganHeadDTO);
            }
        } else if (SupplierRegisterTypeExtendEnum.PROMOTION_TALENTS.getValue().equals(registerVO.getSupplierRegisterType())) {
            List defaultTemplateByType = this.baseRpcService.getDefaultTemplateByType("srmAmateurAccountManage");
            PurchaseAmateurHeadDTO purchaseAmateurHeadDTO = new PurchaseAmateurHeadDTO();
            if (!CollUtil.isNotEmpty((Collection)defaultTemplateByType)) {
                throw new ELSBootException("\u7cfb\u7edf\u67e5\u8be2\u4e0d\u5230\u7d20\u4ebaELS\u8d26\u53f7\u7ba1\u7406\u6a21\u677f");
            }
            purchaseAmateurHeadDTO.setTemplateNumber(((TemplateHeadDTO)defaultTemplateByType.get(0)).getTemplateNumber());
            purchaseAmateurHeadDTO.setTemplateName(((TemplateHeadDTO)defaultTemplateByType.get(0)).getTemplateName());
            purchaseAmateurHeadDTO.setTemplateAccount(((TemplateHeadDTO)defaultTemplateByType.get(0)).getElsAccount());
            purchaseAmateurHeadDTO.setTemplateVersion(((TemplateHeadDTO)defaultTemplateByType.get(0)).getTemplateVersion() + "");
            purchaseAmateurHeadDTO.setDocumentStatus(AmateurStatusEnum.UN_BOUND.getValue());
            purchaseAmateurHeadDTO.setToElsAccount(elsEnterpriseInfoDTO.getElsAccount());
            purchaseAmateurHeadDTO.setEnterpriseName(elsEnterpriseInfoDTO.getName());
            purchaseAmateurHeadDTO.setEstablishTime(elsEnterpriseInfoDTO.getEstablishTime());
            purchaseAmateurHeadDTO.setCompanyOrgType(elsEnterpriseInfoDTO.getCompanyOrgType());
            this.supplierInvokeTopManRpcService.insertPurchaseTopMan(purchaseAmateurHeadDTO);
        }
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveSubAccountInfoYouhua(RegisterExtendVO registerVO, String elsAccount, ElsSubAccountDTO account, RoleDTO role) {
        this.savePersonalSetting(elsAccount, account.getSubAccount());
        ElsTenantDTO systemEls = this.supplierInvokeAccountRpcService.getElsTenantDTO("1000000");
        ElsTenantDTO elsTenant = new ElsTenantDTO();
        elsTenant.setAccountStatus("1");
        elsTenant.setElsAccount(elsAccount);
        elsTenant.setCompanyName(registerVO.getCompanyName());
        elsTenant.setSourceType(registerVO.getSourceType());
        elsTenant.setLoginLayout(systemEls.getLoginLayout());
        elsTenant.setCompanyBackground(systemEls.getCompanyBackground());
        elsTenant.setUpdateBy(role.getUpdateBy());
        elsTenant.setCreateBy(role.getCreateBy());
        try {
            elsTenant.setExpiryDate(new SimpleDateFormat("yyyy-MM-dd").parse("2029-12-31"));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.supplierInvokeAccountRpcService.saveTenant(elsTenant);
        List<PermissionDTO> list = null;
        list = SupplierRegisterTypeExtendEnum.BUSINESS_TEAMER.getValue().equals(registerVO.getSupplierRegisterType()) ? this.supplierInvokeAccountRpcService.selectPermissionByRoleCode(TenantContext.getTenant(), SupplierRegisterTypeExtendEnum.getRoleCode(SupplierRegisterTypeExtendEnum.BUSINESS_TEAMER.getValue())) : (SupplierRegisterTypeExtendEnum.MCN_ORGANIZATION.getValue().equals(registerVO.getSupplierRegisterType()) ? this.supplierInvokeAccountRpcService.selectPermissionByRoleCode(TenantContext.getTenant(), SupplierRegisterTypeExtendEnum.getRoleCode(SupplierRegisterTypeExtendEnum.MCN_ORGANIZATION.getValue())) : (SupplierRegisterTypeExtendEnum.PROMOTION_TALENTS.getValue().equals(registerVO.getSupplierRegisterType()) ? this.supplierInvokeAccountRpcService.selectPermissionByRoleCode(TenantContext.getTenant(), SupplierRegisterTypeExtendEnum.getRoleCode(SupplierRegisterTypeExtendEnum.PROMOTION_TALENTS.getValue())) : (SupplierRegisterTypeExtendEnum.MATERIAL_SUPPLIER.getValue().equals(registerVO.getSupplierRegisterType()) ? this.supplierInvokeAccountRpcService.selectPermissionByRoleCode(TenantContext.getTenant(), SupplierRegisterTypeExtendEnum.getRoleCode(SupplierRegisterTypeExtendEnum.MATERIAL_SUPPLIER.getValue())) : this.supplierInvokeAccountRpcService.selectPermissionByRoleCode(TenantContext.getTenant(), SupplierRegisterTypeExtendEnum.getRoleCode(SupplierRegisterTypeExtendEnum.MATERIAL_SUPPLIER.getValue())))));
        if (list != null) {
            List<CompanyPermissionDTO> companyPermissions = new ArrayList<CompanyPermissionDTO>();
            CompanyPermissionDTO companyPermissionDTO = new CompanyPermissionDTO();
            for (PermissionDTO permission : list) {
                companyPermissionDTO = new CompanyPermissionDTO();
                companyPermissionDTO.setId(IdWorker.getIdStr());
                companyPermissionDTO.setElsAccount(elsAccount);
                companyPermissionDTO.setPermissionId(permission.getId());
                companyPermissionDTO.setName(permission.getName());
                companyPermissionDTO.setSortNo(permission.getSortNo());
                companyPermissionDTO.setIcon(permission.getIcon());
                companyPermissionDTO.setIconColor(permission.getIconColor());
                companyPermissionDTO.setRuleFlag(permission.getRuleFlag());
                companyPermissionDTO.setStatus(permission.getStatus());
                companyPermissionDTO.setDeleted(CommonConstant.DEL_FLAG_0);
                companyPermissionDTO.setUpdateTime(new Date());
                companyPermissionDTO.setCreateBy(role.getCreateBy());
                companyPermissionDTO.setUpdateBy(role.getUpdateBy());
                companyPermissions.add(companyPermissionDTO);
            }
            if (!companyPermissions.isEmpty()) {
                companyPermissions = this.supplierInvokeAccountRpcService.insertCompanyMenuBatch(companyPermissions);
                ArrayList companyPermissionList = Lists.newArrayList();
                for (CompanyPermissionDTO companyPermission : companyPermissions) {
                    RolePermissionDTO rolePermission = new RolePermissionDTO();
                    rolePermission.setElsAccount(elsAccount);
                    rolePermission.setRoleId(role.getId());
                    rolePermission.setPermissionId(companyPermission.getPermissionId());
                    companyPermissionList.add(rolePermission);
                }
                if (CollUtil.isNotEmpty((Collection)companyPermissionList)) {
                    this.supplierInvokeAccountRpcService.batchSaveRolePermission(companyPermissionList);
                }
            }
        }
    }

    private JSONObject getIpaaSData(String companyName, String sourceType, String elsAccount) {
        JSONObject data = new JSONObject();
        JSONObject base = new JSONObject();
        base.put("keyword", (Object)companyName);
        JSONObject body = new JSONObject();
        body.put("channel", (Object)sourceType);
        String auth = SourceTypeEnum.BUSINESS_PROMOTION.getValue().equals(sourceType) || SourceTypeEnum.OPEN_REGISTER.getValue().equals(sourceType) ? "1" : "0";
        body.put("auth", (Object)auth);
        data.put("base", (Object)base);
        data.put("body", (Object)body);
        data.put("currentAccount", (Object)elsAccount);
        return data;
    }

    private JSONObject getIpaaSRelationData(String purchaserElsAccount, String providerElsAccount) {
        JSONObject data = new JSONObject();
        data.put("purchaserElsAccount", (Object)purchaserElsAccount);
        data.put("providerElsAccount", (Object)providerElsAccount);
        return data;
    }

    public void savePersonalSetting(String elsAccount, String subaccount) {
        List<String> list = Arrays.asList("EMAIL", "NEWS", "VOICE", "MSG", "WECHAT", "DINGTALK");
        ArrayList<PersonalSettingDTO> personalSettings = new ArrayList<PersonalSettingDTO>();
        for (String str : list) {
            PersonalSettingDTO personalSetting = new PersonalSettingDTO();
            personalSetting.setId(UUID.randomUUID().toString().replace("-", ""));
            personalSetting.setElsAccount(elsAccount);
            personalSetting.setSubAccount(subaccount);
            personalSetting.setCreateBy("1001");
            personalSetting.setCreateTime(new Date());
            personalSetting.setUpdateBy("1001");
            personalSetting.setUpdateTime(new Date());
            personalSetting.setReceiveType(str);
            personalSetting.setIsReceive(Integer.valueOf(0));
            personalSettings.add(personalSetting);
        }
        this.supplierInvokeAccountRpcService.savePersonalSetting(personalSettings);
    }

    public void saveSupplierMasterData(ElsEnterpriseInfoDTO ElsEnterpriseInfoDTO2, RegisterExtendVO registerVO, SupplierMasterData data, String elsAccount) {
        List headList;
        data.setElsAccount(elsAccount);
        data.setToElsAccount(ElsEnterpriseInfoDTO2.getElsAccount());
        data.setSupplierName(ElsEnterpriseInfoDTO2.getName());
        data.setSourceType(registerVO.getSourceType());
        data.setStatus(SupplierFrozenStatusEnum.NORMAL.getValue());
        data.setTemplateName(registerVO.getTemplateName());
        data.setTemplateNumber(registerVO.getTemplateNumbe());
        data.setTemplateVersion(registerVO.getTemplateVersion());
        data.setTemplateAccount(registerVO.getTemplateAccount());
        data.setNeedCoordination("1");
        data.setNeedAudit("1");
        data.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        if (SourceTypeEnum.GENERATION_REGISTER.getValue().equals(registerVO.getSourceType())) {
            if (SupplierStatusEnum.QUALIFIED_SUPPLIER.getValue().equals(registerVO.getAddAs())) {
                data.setSupplierStatus(SupplierStatusEnum.QUALIFIED_SUPPLIER.getValue());
            } else {
                data.setSupplierStatus(SupplierStatusEnum.POTENTIAL_SUPPLIER.getValue());
            }
        } else if (SourceTypeEnum.INVITE_REGISTER.getValue().equals(registerVO.getSourceType())) {
            data.setSupplierStatus(SupplierStatusEnum.POTENTIAL_SUPPLIER.getValue());
        }
        if (SourceTypeEnum.BUSINESS_PROMOTION.getValue().equals(registerVO.getSourceType()) && (headList = this.supplierinvokeBaseRpcService.getAllByAccountAndType("100000", "supplierMasterData")) != null) {
            data.setTemplateName(((TemplateHeadDTO)headList.get(0)).getTemplateName());
            data.setTemplateVersion(((TemplateHeadDTO)headList.get(0)).getTemplateVersion() + "");
            data.setTemplateNumber(((TemplateHeadDTO)headList.get(0)).getTemplateNumber());
            data.setTemplateAccount("100000");
        }
        this.supplierMasterDataMapper.insert((Object)data);
    }
}

