/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.account.entity.PermissionRecord;
import com.els.modules.account.mapper.PermissionRecordMapper;
import com.els.modules.account.service.PermissionRecordService;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.service.PermissionService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PermissionRecordServiceImpl
extends BaseServiceImpl<PermissionRecordMapper, PermissionRecord>
implements PermissionRecordService {
    @Autowired
    private PermissionService permissionService;

    @Override
    public void add(PermissionRecord permissionRecord) {
        LoginUser loginUser = SysUtil.getLoginUser();
        PermissionRecord db = (PermissionRecord)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PermissionRecord::getPermissionId, (Object)permissionRecord.getPermissionId())).eq(PermissionRecord::getSubAccount, (Object)loginUser.getSubAccount())).eq(BaseEntity::getElsAccount, (Object)loginUser.getElsAccount())).eq(BaseEntity::getDeleted, (Object)"0")));
        if (ObjectUtil.isNotEmpty((Object)((Object)db))) {
            db.setClickCount(db.getClickCount() + 1);
            this.updateById((Object)db);
        } else {
            permissionRecord.setSubAccount(loginUser.getSubAccount());
            permissionRecord.setElsAccount(loginUser.getElsAccount());
            permissionRecord.setClickCount(0);
            this.save((Object)permissionRecord);
        }
    }

    @Override
    public void edit(PermissionRecord permissionRecord) {
        int count = ((PermissionRecordMapper)this.baseMapper).updateById((Object)permissionRecord);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PermissionRecordMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PermissionRecordMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<Permission> history() {
        LoginUser loginUser = SysUtil.getLoginUser();
        List list = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)loginUser.getElsAccount())).eq(PermissionRecord::getSubAccount, (Object)loginUser.getSubAccount())).eq(BaseEntity::getDeleted, (Object)"0")).orderByDesc(BaseEntity::getUpdateTime));
        ArrayList permissions = Lists.newArrayList();
        if (CollUtil.isNotEmpty((Collection)list)) {
            List ids = list.stream().map(x -> x.getPermissionId()).distinct().collect(Collectors.toList());
            List db = this.permissionService.listByIds(ids);
            Map<String, Permission> permissionMap = db.stream().collect(Collectors.toMap(x -> x.getId(), y -> y));
            list.forEach(x -> permissions.add((Permission)permissionMap.get(x.getPermissionId())));
        }
        return permissions;
    }
}

