/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.alliance.entity.MyGoodsHead;
import com.els.modules.alliance.service.MyGoodsHeadService;
import com.els.modules.companystore.entity.CompanyStoreHead;
import com.els.modules.companystore.service.CompanyStoreHeadService;
import com.els.modules.enterpriseorgan.controller.ElsTopManEnterpriseOrganHeadController;
import com.els.modules.enterpriseorgan.entity.ElsTopManEnterpriseOrganHeadQueryVo;
import com.els.modules.enterpriseresource.controller.EnterpriseBilibiliTopManController;
import com.els.modules.enterpriseresource.controller.EnterpriseBlogTopManController;
import com.els.modules.enterpriseresource.controller.EnterpriseDyTopManController;
import com.els.modules.enterpriseresource.controller.EnterpriseKsTopManController;
import com.els.modules.enterpriseresource.controller.EnterpriseRedBookTopManController;
import com.els.modules.enterpriseresource.controller.EnterpriseZhiHuTopManController;
import com.els.modules.enterpriseresource.dto.BilibiliTopManDTO;
import com.els.modules.enterpriseresource.dto.BlogTopManDTO;
import com.els.modules.enterpriseresource.dto.RedBookTopManDTO;
import com.els.modules.enterpriseresource.dto.ZhiHuTopManDTO;
import com.els.modules.enterpriseresource.vo.EnterpriseKsTopManVO;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.RequestOptionVO;
import com.els.modules.purchasercooperation.entity.PurchaserTalentManageHead;
import com.els.modules.purchasercooperation.service.PurchaserTalentManageHeadService;
import com.els.modules.suppliercooperation.entity.SupplierTalentManageHead;
import com.els.modules.suppliercooperation.service.SupplierTalentManageHeadService;
import com.els.modules.system.util.PermissionDataExtendUtil;
import com.els.modules.system.vo.TodoCountInfoVO;
import com.els.modules.system.vo.TodoTypeEnum;
import com.els.modules.todo.vo.TodoStatusVO;
import com.els.modules.topman.controller.VideoNumTopmanController;
import com.els.modules.topman.vo.VideoNumRequestParamVO;
import com.els.modules.touch.entity.TopManMsgRecord;
import com.els.modules.touch.service.TopManMsgRecordService;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9996\u9875\u5f85\u529e\u4e8b\u9879"})
@RestController
@RequestMapping(value={"/base/todoExtend"})
public class TodoExtendListController {
    private static final Logger log = LoggerFactory.getLogger(TodoExtendListController.class);
    @Autowired
    private TopManMsgRecordService topManMsgRecordService;
    @Autowired
    private PermissionDataExtendUtil permissionDataQueryUtil;
    @Resource
    private AccountRpcService accountRpcService;
    @Autowired
    private PurchaserTalentManageHeadService manageHeadService;
    @Autowired
    private EnterpriseDyTopManController enterpriseDyTopManController;
    @Autowired
    private EnterpriseKsTopManController enterpriseKsTopManController;
    @Autowired
    private VideoNumTopmanController videoNumTopmanController;
    @Autowired
    private EnterpriseRedBookTopManController enterpriseRedBookTopManController;
    @Autowired
    private EnterpriseBilibiliTopManController enterpriseBilibiliTopManController;
    @Autowired
    private EnterpriseBlogTopManController enterpriseBlogTopManController;
    @Autowired
    private EnterpriseZhiHuTopManController enterpriseZhiHuTopManController;
    @Autowired
    private ElsTopManEnterpriseOrganHeadController elsTopManEnterpriseOrganHeadController;
    @Autowired
    private CompanyStoreHeadService companyStoreHeadService;
    @Autowired
    private MyGoodsHeadService myGoodsHeadService;
    @Autowired
    private SupplierTalentManageHeadService supplierTalentManageHeadService;

    @ApiOperation(value="\u83b7\u53d6\u9996\u9875\u5f85\u529e\u4e8b\u9879\u7edf\u8ba1", notes="\u83b7\u53d6\u9996\u9875\u5f85\u529e\u4e8b\u9879\u7edf\u8ba1")
    @PostMapping(value={"/getTodoCountList"})
    public Result<?> getTodoCountList(HttpServletRequest req) {
        List<PermissionDTO> filterPermissionDTOList = this.processPermissionTodoList();
        if (filterPermissionDTOList == null || filterPermissionDTOList.size() == 0) {
            return null;
        }
        List<Object> list = Lists.newArrayList();
        for (PermissionDTO permissionDTO : filterPermissionDTOList) {
            TodoCountInfoVO todoCountInfoVO = this.processTodoInfo(permissionDTO);
            list.add(todoCountInfoVO);
        }
        list = list.stream().sorted(Comparator.comparing(TodoCountInfoVO::getCountNumber)).collect(Collectors.toList());
        return Result.ok((Object)list);
    }

    @ApiOperation(value="\u83b7\u53d6\u9996\u9875\u5f85\u529e\u4e8b\u9879\u7edf\u8ba1", notes="\u83b7\u53d6\u9996\u9875\u5f85\u529e\u4e8b\u9879\u7edf\u8ba1")
    @GetMapping(value={"/getTodoCount"})
    public Result<?> getTodoCount(HttpServletRequest req, @RequestParam(value="statusCode") String statusCode) {
        int num = 0;
        switch (statusCode) {
            case "TOUCH_ALL": {
                num = this.getTouchAll();
                break;
            }
            case "TOUCH_MY": {
                num = this.getTouchMy();
                break;
            }
            case "COOL_NEW": {
                num = this.getCoolNew();
                break;
            }
            case "COOL_ING": {
                num = this.getCoolIng();
                break;
            }
            case "ORG_TOPMAN": {
                num = (int)this.getOrgTopMan();
                break;
            }
            case "ORG_ORG": {
                num = (int)this.getOrgNum(req);
                break;
            }
            case "SHOP_AUTH": {
                num = this.getShopAuth();
                break;
            }
            case "SHOP_ADMIN": {
                num = this.getShopAdmin();
                break;
            }
            case "SQUARE_PUT": {
                num = this.getShopSquarePut();
                break;
            }
            case "SQUARE_RELATION": {
                num = this.getShopSquareRelation();
                break;
            }
            case "COOL_MANAGER_ING": {
                num = this.getCoolManagerIng();
                break;
            }
            case "COOL_MANAGER_COMPLETE": {
                num = this.getCoolManagerComplete();
            }
        }
        return Result.ok((Object)num);
    }

    private int getCoolManagerComplete() {
        String elsAccount = TenantContext.getTenant();
        this.permissionDataQueryUtil.initPermissionData(this.getAccountBusinessType("cooperativeExtension"));
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)new SupplierTalentManageHead(), new HashMap());
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"cooperate_bill_status", (Object)"2");
        queryWrapper.eq((Object)"is_deleted", (Object)0);
        return this.supplierTalentManageHeadService.count((Wrapper)queryWrapper);
    }

    private int getCoolManagerIng() {
        String elsAccount = TenantContext.getTenant();
        this.permissionDataQueryUtil.initPermissionData(this.getAccountBusinessType("cooperativeExtension"));
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)new SupplierTalentManageHead(), new HashMap());
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"cooperate_bill_status", (Object)"1");
        queryWrapper.eq((Object)"is_deleted", (Object)0);
        return this.supplierTalentManageHeadService.count((Wrapper)queryWrapper);
    }

    private int getShopSquareRelation() {
        String elsAccount = TenantContext.getTenant();
        this.permissionDataQueryUtil.initPermissionData(this.getAccountBusinessType("promotionAlliance"));
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)new MyGoodsHead(), new HashMap());
        queryWrapper.select(new String[]{"topman_num"});
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"goods_status", (Object)"1");
        queryWrapper.eq((Object)"is_deleted", (Object)0);
        List c1 = this.myGoodsHeadService.list((Wrapper)queryWrapper);
        int topmanNum = 0;
        if (CollUtil.isNotEmpty((Collection)c1)) {
            topmanNum = c1.stream().filter(x -> x != null && StrUtil.isNotBlank((CharSequence)x.getTopmanNum())).mapToInt(x -> this.changeInt(x.getTopmanNum())).sum();
        }
        return topmanNum;
    }

    private int getShopSquarePut() {
        String elsAccount = TenantContext.getTenant();
        this.permissionDataQueryUtil.initPermissionData(this.getAccountBusinessType("promotionAlliance"));
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)new MyGoodsHead(), new HashMap());
        queryWrapper.select(new String[]{"topman_num"});
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"goods_status", (Object)"1");
        queryWrapper.eq((Object)"is_deleted", (Object)0);
        List c1 = this.myGoodsHeadService.list((Wrapper)queryWrapper);
        return c1.size();
    }

    private int getShopAdmin() {
        String elsAccount = TenantContext.getTenant();
        this.permissionDataQueryUtil.initPermissionData(this.getAccountBusinessType("companyStore"));
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)new CompanyStoreHead(), new HashMap());
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"data_type", (Object)"2");
        queryWrapper.eq((Object)"is_deleted", (Object)0);
        return this.companyStoreHeadService.count((Wrapper)queryWrapper);
    }

    private int getShopAuth() {
        String elsAccount = TenantContext.getTenant();
        this.permissionDataQueryUtil.initPermissionData(this.getAccountBusinessType("companyStore"));
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)new CompanyStoreHead(), new HashMap());
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        queryWrapper.eq((Object)"data_type", (Object)"1");
        queryWrapper.eq((Object)"is_deleted", (Object)0);
        return this.companyStoreHeadService.count((Wrapper)queryWrapper);
    }

    private long getOrgNum(HttpServletRequest req) {
        String elsAccount = TenantContext.getTenant();
        ElsTopManEnterpriseOrganHeadQueryVo elsTopManEnterpriseOrganHeadQueryVo = new ElsTopManEnterpriseOrganHeadQueryVo();
        elsTopManEnterpriseOrganHeadQueryVo.setPlatform("1");
        elsTopManEnterpriseOrganHeadQueryVo.setElsAccount(elsAccount);
        Page dp = (Page)this.elsTopManEnterpriseOrganHeadController.attractPagelist(elsTopManEnterpriseOrganHeadQueryVo, Integer.valueOf(1), Integer.valueOf(1), req).getResult();
        long m = dp.getTotal();
        TodoStatusVO org = new TodoStatusVO();
        org.setName("\u673a\u6784");
        ElsTopManEnterpriseOrganHeadQueryVo rbqo = new ElsTopManEnterpriseOrganHeadQueryVo();
        rbqo.setPlatform("3");
        rbqo.setElsAccount(elsAccount);
        Page rp = (Page)this.elsTopManEnterpriseOrganHeadController.queryPageList(rbqo, Integer.valueOf(1), Integer.valueOf(1), req).getResult();
        return m += rp.getTotal();
    }

    private long getOrgTopMan() {
        SimplePostRequestParam topManDto = new SimplePostRequestParam();
        RequestOptionVO requestOptionVO = new RequestOptionVO();
        requestOptionVO.setPlatformType("1");
        requestOptionVO.setScreenItem((Map)Maps.newHashMap());
        topManDto.setFilterInfo((Object)requestOptionVO);
        Result dy = this.enterpriseDyTopManController.listDyAll(topManDto);
        IPage iPage = (IPage)dy.getResult();
        long all = iPage.getTotal();
        log.info("\u6296\u97f3\u8fbe\u4eba\u6570\u91cf:{}", (Object)all);
        SimplePostRequestParam ks = new SimplePostRequestParam();
        EnterpriseKsTopManVO ksTopManVO = new EnterpriseKsTopManVO();
        ksTopManVO.setPlatformType("2");
        ksTopManVO.setScreenItem(new EnterpriseKsTopManVO.ScreenItem());
        ks.setFilterInfo((Object)ksTopManVO);
        IPage iPageks = (IPage)this.enterpriseKsTopManController.listKsAll(ks).getResult();
        all += iPageks.getTotal();
        log.info("\u5feb\u624b\u8fbe\u4eba\u6570\u91cf:{}", (Object)iPageks.getTotal());
        SimplePostRequestParam s = new SimplePostRequestParam();
        VideoNumRequestParamVO videoNumRequestParamVO = new VideoNumRequestParamVO();
        videoNumRequestParamVO.setPlatformType("7");
        videoNumRequestParamVO.setTaskType("enterpriseTopMan");
        s.setFilterInfo((Object)videoNumRequestParamVO);
        try {
            IPage vp = (IPage)this.videoNumTopmanController.listAll(s).getResult();
            all += vp.getTotal();
            log.info("\u89c6\u9891\u53f7\u8fbe\u4eba\u6570\u91cf:{}", (Object)vp.getTotal());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SimplePostRequestParam rbq = new SimplePostRequestParam();
        RedBookTopManDTO redBookTopManDTO = new RedBookTopManDTO();
        redBookTopManDTO.setPlatformType("3");
        redBookTopManDTO.setTaskType("allTopMan");
        redBookTopManDTO.setScreenItem(new RedBookTopManDTO.ScreenItem());
        rbq.setFilterInfo((Object)redBookTopManDTO);
        IPage rb = (IPage)this.enterpriseRedBookTopManController.listRbAll(rbq).getResult();
        all += rb.getTotal();
        log.info("\u5c0f\u7ea2\u4e66\u8fbe\u4eba\u6570\u91cf:{}", (Object)rb.getTotal());
        SimplePostRequestParam bi = new SimplePostRequestParam();
        BilibiliTopManDTO bilibiliTopManDTO = new BilibiliTopManDTO();
        bilibiliTopManDTO.setPlatformType("4");
        bilibiliTopManDTO.setTaskType("allTopMan");
        bilibiliTopManDTO.setScreenItem(new BilibiliTopManDTO.ScreenItem());
        bi.setFilterInfo((Object)bilibiliTopManDTO);
        IPage b = (IPage)this.enterpriseBilibiliTopManController.listBilibiliAll(bi).getResult();
        all += b.getTotal();
        log.info("B\u7ad9\u8fbe\u4eba\u6570\u91cf:{}", (Object)b.getTotal());
        SimplePostRequestParam blog = new SimplePostRequestParam();
        BlogTopManDTO blogTopManDTO = new BlogTopManDTO();
        blogTopManDTO.setPlatformType("5");
        blogTopManDTO.setTaskType("allTopMan");
        blogTopManDTO.setScreenItem(new BlogTopManDTO.ScreenItem());
        blog.setFilterInfo((Object)blogTopManDTO);
        IPage be = (IPage)this.enterpriseBlogTopManController.listBlogAll(blog).getResult();
        all += be.getTotal();
        log.info("\u5fae\u535a\u8fbe\u4eba\u6570\u91cf:{}", (Object)be.getTotal());
        SimplePostRequestParam zhihu = new SimplePostRequestParam();
        ZhiHuTopManDTO zhiHuTopManDTO = new ZhiHuTopManDTO();
        zhiHuTopManDTO.setPlatformType("6");
        zhiHuTopManDTO.setTaskType("allTopMan");
        zhiHuTopManDTO.setScreenItem(new ZhiHuTopManDTO.ScreenItem());
        zhihu.setFilterInfo((Object)zhiHuTopManDTO);
        IPage ze = (IPage)this.enterpriseZhiHuTopManController.listZhiHuTopManDTOAll(zhihu).getResult();
        log.info("\u77e5\u4e4e\u8fbe\u4eba\u6570\u91cf:{}", (Object)ze.getTotal());
        return all += ze.getTotal();
    }

    private int getCoolIng() {
        this.permissionDataQueryUtil.initPermissionData(this.getAccountBusinessType("talentMsg"));
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)new PurchaserTalentManageHead(), new HashMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"is_deleted", (Object)0);
        queryWrapper.eq((Object)"cooperate_bill_status", (Object)1);
        return this.manageHeadService.count((Wrapper)queryWrapper);
    }

    private int getCoolNew() {
        this.permissionDataQueryUtil.initPermissionData(this.getAccountBusinessType("talentMsg"));
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)new PurchaserTalentManageHead(), new HashMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"is_deleted", (Object)0);
        queryWrapper.eq((Object)"cooperate_bill_status", (Object)0);
        return this.manageHeadService.count((Wrapper)queryWrapper);
    }

    private int getTouchAll() {
        this.permissionDataQueryUtil.initPermissionData(this.getAccountBusinessType("talentMsg"));
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)new TopManMsgRecord(), new HashMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"is_deleted", (Object)0);
        return this.topManMsgRecordService.count((Wrapper)queryWrapper);
    }

    private int getTouchMy() {
        LoginUser user = SysUtil.getLoginUser();
        this.permissionDataQueryUtil.initPermissionData(this.getAccountBusinessType("talentMsg"));
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)new TopManMsgRecord(), new HashMap());
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"is_deleted", (Object)0);
        queryWrapper.eq((Object)"sub_account", (Object)user.getSubAccount());
        return this.topManMsgRecordService.count((Wrapper)queryWrapper);
    }

    private String getAccountBusinessType(String businessType) {
        String accountBusinessType = null;
        if (StringUtils.isNotBlank((CharSequence)businessType)) {
            accountBusinessType = String.valueOf(TenantContext.getTenant()) + "_" + SysUtil.getLoginUser().getSubAccount() + "-" + businessType;
        }
        return accountBusinessType;
    }

    private Integer changeInt(String topmanNum) {
        if (StrUtil.isBlank((CharSequence)topmanNum)) {
            return 0;
        }
        try {
            return Integer.valueOf(topmanNum);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private TodoCountInfoVO processTodoInfo(PermissionDTO permissionDTO) {
        TodoCountInfoVO vo = new TodoCountInfoVO();
        TodoTypeEnum todoTypeEnum = TodoTypeEnum.getByUrl(permissionDTO.getUrl());
        vo.setModuleName(todoTypeEnum.getModuleName());
        vo.setCountNumber(todoTypeEnum.getSort());
        vo.setIcon(permissionDTO.getIcon());
        vo.setCode(todoTypeEnum.getCode());
        vo.setPageRoute(permissionDTO.getUrl());
        vo.setStatusList(todoTypeEnum.getStatusList());
        return vo;
    }

    private List<PermissionDTO> processPermissionTodoList() {
        String account = String.valueOf(TenantContext.getTenant()) + "_" + SysUtil.getLoginUser().getSubAccount();
        List permissionDTOList = this.accountRpcService.selectAccountPermission(account);
        if (permissionDTOList == null || permissionDTOList.size() == 0) {
            return null;
        }
        ArrayList<PermissionDTO> filterPermissionDTOList = new ArrayList();
        List<String> allTodoTypeList = TodoTypeEnum.getAllTodoTypeList();
        for (String todoType : allTodoTypeList) {
            for (PermissionDTO permissionDTO : permissionDTOList) {
                if (!todoType.equals(permissionDTO.getUrl())) continue;
                filterPermissionDTOList.add(permissionDTO);
            }
        }
        filterPermissionDTOList = filterPermissionDTOList.parallelStream().sorted(Comparator.comparing(PermissionDTO::getUrl)).collect(Collectors.toList());
        return filterPermissionDTOList;
    }
}

