/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.supplier.service.MyScheduleExtendService;
import com.els.modules.supplier.vo.CustomScheduleVO;
import com.els.modules.supplier.vo.MySchedule;
import com.els.modules.supplier.vo.MyScheduleQueryVO;
import io.swagger.annotations.Api;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6211\u7684\u65e5\u7a0b"})
@RestController
@RequestMapping(value={"/mcn/supplier/mySchedule"})
public class MyScheduleExtendController
extends BaseController<MySchedule, MyScheduleExtendService> {
    @Autowired
    private MyScheduleExtendService myScheduleService;

    @GetMapping(value={"/list"})
    public Result<?> queryPageList(MySchedule mySchedule, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)mySchedule), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.myScheduleService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody MySchedule mySchedule) {
        this.myScheduleService.add(mySchedule);
        return Result.ok((Object)((Object)mySchedule));
    }

    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody MySchedule mySchedule) {
        this.myScheduleService.edit(mySchedule);
        return this.commonSuccessResult(3);
    }

    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.myScheduleService.delete(id);
        return this.commonSuccessResult(4);
    }

    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.myScheduleService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        MySchedule mySchedule = (MySchedule)((Object)this.myScheduleService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)mySchedule));
    }

    @PostMapping(value={"/queryMySchedule"})
    public Result<?> queryMySchedule(@RequestBody MyScheduleQueryVO queryVO) {
        Map<String, List> stringListMap = this.myScheduleService.queryMySchedule(queryVO);
        return Result.ok(stringListMap);
    }

    @PostMapping(value={"/addCustomSchedule"})
    @SrmValidated
    public Result<?> addCustomSchedule(@RequestBody CustomScheduleVO customScheduleVO) {
        this.myScheduleService.addCustomSchedule(customScheduleVO);
        return Result.ok();
    }

    @GetMapping(value={"/delCustomSchedule"})
    @SrmValidated
    public Result<?> delCustomSchedule(String currentDate) {
        this.myScheduleService.delCustomSchedule(currentDate);
        return Result.ok();
    }
}

