/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tourist.controller;

import cn.hutool.core.util.RandomUtil;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.sms.api.dto.SmsDto;
import com.els.modules.sms.api.dto.SmsResult;
import com.els.modules.sms.api.service.SmsRpcService;
import com.els.modules.system.model.LoginModel;
import com.els.modules.system.vo.ForgetPasswordVO;
import com.els.modules.tourist.entity.Tourist;
import com.els.modules.tourist.service.TouristService;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tourist"})
public class TouristController
extends BaseController<Tourist, TouristService> {
    private static final Logger log = LoggerFactory.getLogger(TouristController.class);
    @Autowired
    private TouristService touristService;
    @Autowired
    private SmsRpcService smsRpcService;
    @Autowired
    private RedisUtil redisUtil;

    @ApiOperation(value="\u6e38\u5ba2\u8bd5\u7528\u9a8c\u8bc1\u7801\u767b\u5f55")
    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public Result<?> login(@RequestBody LoginModel loginModel) {
        log.info(":::doLogin:{}", (Object)loginModel);
        Result<?> result = this.touristService.checkUser(loginModel);
        return result;
    }

    @AutoLog(value="\u53d1\u77ed\u4fe1\u77ed\u4fe1\u63a5\u53e3", logType=1)
    @PostMapping(value={"/sms"})
    public Result<?> sms(@RequestBody ForgetPasswordVO forgetPasswordVO) {
        if (null == forgetPasswordVO.getPhone()) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_ltyoxOLVWVVVWNW_263247f8", (String)"\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01"));
        }
        String captcha = RandomUtil.randomNumbers((int)6);
        SmsDto smsDto = new SmsDto();
        smsDto.setMobile(forgetPasswordVO.getPhone());
        smsDto.setSmsmode("0");
        smsDto.setSourceType("0");
        smsDto.setCaptcha(captcha);
        SmsResult smsResult = this.smsRpcService.sendSms(smsDto);
        if (!smsResult.isSuccess()) {
            throw new ELSBootException(smsResult.getMessage());
        }
        this.redisUtil.set(forgetPasswordVO.getPhone(), (Object)captcha, 600L);
        return Result.ok((Object)forgetPasswordVO);
    }
}

