/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tourist.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.TouristProperties;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ElsCompanySetDTO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.model.LoginModel;
import com.els.modules.system.rpc.service.InvokeBaseRpcService;
import com.els.modules.system.rpc.service.InvokeSmsRpcService;
import com.els.modules.system.service.ElsPasswordSecurityService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.service.ThirdAccountService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.vo.ElsSubAccountVO;
import com.els.modules.tourist.entity.Tourist;
import com.els.modules.tourist.mapper.TouristMapper;
import com.els.modules.tourist.service.TouristService;
import com.els.shiro.authc.JwtToken;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TouristServiceImpl
extends BaseServiceImpl<TouristMapper, Tourist>
implements TouristService {
    private static final Logger log = LoggerFactory.getLogger(TouristServiceImpl.class);
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ElsTenantService elsTenantService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private ThirdAccountService thirdAccountService;
    @Resource
    private InvokeBaseRpcService baseRpcService;
    @Resource
    private InvokeSmsRpcService invokeSmsRpcService;
    @Autowired
    private ElsPasswordSecurityService pwSecurityService;
    @Autowired
    private TouristProperties touristProperties;
    private String version = this.getClass().getPackage().getImplementationVersion();

    private void checkUserIsEffective(LoginModel loginModel) {
        String subAccount = loginModel.getSubAccount();
        Object obj = this.redisUtil.get(subAccount);
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)obj), (String)I18nUtil.translate((String)"i18n_alert_OioIKXWVVVSMW_feeecd17", (String)"\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01"), (Object[])new Object[0]);
        Assert.isTrue((boolean)obj.toString().equals(loginModel.getCaptcha()), (String)I18nUtil.translate((String)"i18n_alert_OioNSWVVVSMW_4d0356d2", (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01"), (Object[])new Object[0]);
    }

    private Tourist getBySubAccount(String subAccount) {
        return (Tourist)((Object)Optional.ofNullable(this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)this.touristProperties.getElsAccount())).eq(Tourist::getSubAccount, (Object)subAccount), false)).orElse((Object)new Tourist()));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public Result<?> checkUser(LoginModel loginModel) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)loginModel.getSubAccount()), (String)"\u8bf7\u8f93\u5165\u624b\u673a\u53f7!", (Object[])new Object[0]);
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)loginModel.getCaptcha()), (String)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801!", (Object[])new Object[0]);
        this.checkUserIsEffective(loginModel);
        String touristElsAccount = this.touristProperties.getElsAccount();
        Tourist tourist = this.getBySubAccount(loginModel.getSubAccount());
        String account = touristElsAccount + "_" + loginModel.getSubAccount();
        ElsSubAccount user = this.elsSubAccountService.getUserByAccount(account);
        if (ObjectUtil.isEmpty((Object)user)) {
            user = new ElsSubAccount();
            user.setSubAccount(loginModel.getSubAccount());
            user.setElsAccount(touristElsAccount);
            user.setPassword(this.touristProperties.getPsd());
            user.setSalt(this.touristProperties.getSalt());
            user.setStatus(CommonConstant.STATUS_YES);
            user.setSourceSystem("SRM");
            user.setRealname("\u6e38\u5ba2" + loginModel.getSubAccount());
            this.elsSubAccountService.save((Object)user);
        }
        if (StrUtil.isBlank((CharSequence)tourist.getId())) {
            tourist.setUserId(user.getId());
            tourist.setExpireTime((Date)DateUtil.offsetDay((Date)new Date(), (int)7));
            tourist.setAddAccount("1");
            tourist.setSubAccount(user.getSubAccount());
            tourist.setElsAccount(user.getElsAccount());
            this.save((Object)tourist);
        } else {
            Assert.isTrue((tourist.getExpireTime().getTime() > System.currentTimeMillis() ? 1 : 0) != 0, (String)"\u8bd5\u7528\u5929\u6570\u5df2\u7528\u5b8c\uff0c\u65e0\u6cd5\u767b\u5f55\uff0c\u5982\u9700\u5f00\u901a\u4f1a\u5458\u8bf7\u8054\u7cfb\u5ba2\u670d\u3002", (Object[])new Object[0]);
        }
        Result result = new Result();
        TenantContext.setTenant((String)user.getElsAccount());
        this.pwSecurityService.setRepeatLoginToken(user.getElsAccount(), user.getSubAccount());
        this.userInfo(user, (Result<JSONObject>)result, tourist);
        MqUtil.sendLogMsg((String)user.getElsAccount(), (String)("\u8d26\u53f7: " + user.getElsAccount() + "_" + user.getSubAccount() + ",\u767b\u5f55\u6210\u529f\uff01\u65f6\u95f4\uff1a" + DateUtil.formatDateTime((Date)new Date())), (Integer)1, null);
        this.redisUtil.del(new String[]{"shiro:cache:com.els.modules.shiro.authc.ShiroRealm.authorizationCache:" + SysUtil.getLoginUser().getId()});
        return result;
    }

    private Result<JSONObject> userInfo(ElsSubAccount sysUser, Result<JSONObject> result, Tourist tourist) {
        String syspassword = sysUser.getPassword();
        String elsAccount = sysUser.getElsAccount();
        String subAccount = sysUser.getSubAccount();
        String token = JwtUtil.sign((String)(elsAccount + "_" + subAccount), (String)syspassword);
        this.redisUtil.set("sys:token:" + token, (Object)token);
        this.redisUtil.expire("sys:token:" + token, 3600L);
        this.redisUtil.set("sys:token:" + elsAccount + "_" + subAccount, (Object)token);
        this.redisUtil.expire("sys:token:" + elsAccount + "_" + subAccount, 3600L);
        String adminFlag = this.userRoleService.getAdminFlag(elsAccount, subAccount);
        this.redisUtil.set("sys:token:role:" + token, (Object)adminFlag, 172800L);
        List list = this.baseRpcService.getCompanySetList(elsAccount);
        this.setLogo(list, elsAccount);
        JSONObject companySetObj = this.getObjBySet(list);
        ElsSubAccountVO elsSubAccountVO = new ElsSubAccountVO();
        BeanUtils.copyProperties((Object)sysUser, (Object)elsSubAccountVO);
        Map config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
        elsSubAccountVO.setSerivceUrl((String)config.get("service.address"));
        elsSubAccountVO.setPassword(null);
        elsSubAccountVO.setSalt(null);
        JSONObject obj = new JSONObject();
        obj.put("token", (Object)token);
        obj.put("userInfo", (Object)elsSubAccountVO);
        obj.put("companySet", (Object)companySetObj);
        obj.put("srmVersion", (Object)this.version);
        result.setResult((Object)obj);
        result.success("\u767b\u5f55\u6210\u529f");
        JwtToken jwtToken = new JwtToken(token);
        SecurityUtils.getSubject().login((AuthenticationToken)jwtToken);
        if (!"1".equals(tourist.getAddRole())) {
            ElsSubAccount defaultAccount = this.elsSubAccountService.getUserByAccount(this.touristProperties.getElsAccount() + "_" + this.touristProperties.getDefaultRoleAccount());
            List userRoles = this.userRoleService.list((Wrapper)Wrappers.lambdaQuery().eq(UserRole::getUserId, (Object)defaultAccount.getId()));
            if (CollUtil.isNotEmpty((Collection)userRoles)) {
                this.userRoleService.saveBatch((Collection)userRoles.stream().map(userRole -> {
                    userRole.setId(IdWorker.getIdStr());
                    userRole.setUserId(tourist.getUserId());
                    return userRole;
                }).collect(Collectors.toList()));
            }
            tourist.setAddRole("1");
            this.updateById((Object)tourist);
        }
        this.redisUtil.del(new String[]{"shiro:cache:com.els.modules.shiro.authc.ShiroRealm.authorizationCache:" + sysUser.getId()});
        return result;
    }

    private JSONObject getObjBySet(List<ElsCompanySetDTO> list) {
        JSONObject result = new JSONObject();
        if (list != null) {
            for (ElsCompanySetDTO set : list) {
                result.put(set.getItemCode(), (Object)set.getDefaultValue());
            }
        }
        return result;
    }

    private void setLogo(List<ElsCompanySetDTO> list, String elsAccount) {
        if ("cloud".equals(SysUtil.getDeployWay())) {
            ElsTenant byElsAccount = this.elsTenantService.findByElsAccount(elsAccount);
            if (byElsAccount != null && StrUtil.isNotBlank((CharSequence)byElsAccount.getCompanyLogo())) {
                this.buildCompanySet(list, byElsAccount.getCompanyLogo(), byElsAccount.getCompanyName(), byElsAccount.getCompanyShortName());
            } else {
                byElsAccount = this.elsTenantService.findByElsAccount("100000");
                if (byElsAccount != null) {
                    this.buildCompanySet(list, byElsAccount.getCompanyLogo(), byElsAccount.getCompanyName(), byElsAccount.getCompanyShortName());
                } else {
                    this.buildCompanySet(list, null, null);
                }
            }
        } else {
            Map map = this.elsSubAccountService.getLogoSetByElsAccount(SysUtil.getPurchaseAccount());
            if (map != null) {
                this.buildCompanySet(list, (String)map.get("enterprise_logo"), (String)map.get("alias"));
            } else {
                this.buildCompanySet(list, null, null);
            }
        }
    }

    private void buildCompanySet(List<ElsCompanySetDTO> list, String logo, String name) {
        ElsCompanySetDTO elsCompanySetDTO1 = new ElsCompanySetDTO();
        elsCompanySetDTO1.setItemCode("companyShortName");
        elsCompanySetDTO1.setDefaultValue(name != null ? name : "");
        list.add(elsCompanySetDTO1);
        ElsCompanySetDTO elsCompanySetDTO2 = new ElsCompanySetDTO();
        elsCompanySetDTO2.setItemCode("companyLogo");
        elsCompanySetDTO2.setDefaultValue(logo != null ? logo : "");
        list.add(elsCompanySetDTO2);
    }

    private void buildCompanySet(List<ElsCompanySetDTO> list, String logo, String fullName, String shortName) {
        ElsCompanySetDTO elsCompanySetDTO1 = new ElsCompanySetDTO();
        elsCompanySetDTO1.setItemCode("companyShortName");
        elsCompanySetDTO1.setDefaultValue(shortName != null ? shortName : "");
        list.add(elsCompanySetDTO1);
        ElsCompanySetDTO elsCompanySetDTO2 = new ElsCompanySetDTO();
        elsCompanySetDTO2.setItemCode("companyLogo");
        elsCompanySetDTO2.setDefaultValue(logo != null ? logo : "");
        list.add(elsCompanySetDTO2);
        ElsCompanySetDTO elsCompanySetDTO3 = new ElsCompanySetDTO();
        elsCompanySetDTO3.setItemCode("companyName");
        elsCompanySetDTO3.setDefaultValue(fullName != null ? fullName : "");
        list.add(elsCompanySetDTO3);
    }
}

