/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.supplier.rpc.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.els.modules.account.api.dto.CompanyPermissionDTO;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.ElsTenantDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.account.api.dto.PermissionDataDTO;
import com.els.modules.account.api.dto.PersonalSettingDTO;
import com.els.modules.account.api.dto.RoleDTO;
import com.els.modules.account.api.dto.RolePermissionDTO;
import com.els.modules.account.api.dto.ThirdAccountDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.account.api.service.ElsTenantRpcService;
import com.els.modules.account.api.service.PermissionRpcService;
import com.els.modules.account.api.service.RolePermissionRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountExtendRpcService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SupplierInvokeAccountBeanExtendServiceImpl
implements SupplierInvokeAccountExtendRpcService {
    @Resource
    private AccountRpcService accountRpcService;
    @Resource
    private ElsTenantRpcService elsTenantRpcService;
    @Resource
    @Lazy
    private RolePermissionRpcService rolePermissionRpcService;
    @Resource
    @Lazy
    private PermissionRpcService permissionRpcService;

    @Override
    public List<ThirdAccountDTO> getThirdAccount(String accountId, String thirdType) {
        return this.accountRpcService.getThirdAccount(accountId, thirdType);
    }

    @Override
    public List<PersonalSettingDTO> getPersonalSetting(String elsAccount, String subAccount) {
        return this.accountRpcService.getPersonalSetting(elsAccount, subAccount);
    }

    @Override
    public ElsSubAccountDTO getAccount(String elsAccount, String subAccount) {
        return this.accountRpcService.getAccount(elsAccount, subAccount);
    }

    @Override
    public List<ElsSubAccountDTO> getAccountList(String elsAccount, List<String> subAccounts) {
        return this.accountRpcService.getAccountList(elsAccount, subAccounts);
    }

    @Override
    public List<ElsSubAccountDTO> getAccountListByElsSubAccountWithoutUser(List<String> elsSubAccountList) {
        return this.accountRpcService.getAccountListByElsSubAccountWithoutUser(elsSubAccountList);
    }

    @Override
    public ElsSubAccountDTO getAccountById(String id) {
        return this.accountRpcService.getAccountById(id);
    }

    @Override
    public LoginUserDTO getLoginUser(String account) {
        return this.accountRpcService.getLoginUser(account);
    }

    @Override
    public Set<String> getUserRolesSet(String elsAccount, String subAccount) {
        return this.accountRpcService.getUserRolesSet(elsAccount, subAccount);
    }

    @Override
    public Set<String> getUserPermissionsSet(String elsAccount, String subAccount) {
        return this.accountRpcService.getUserPermissionsSet(elsAccount, subAccount);
    }

    @Override
    public Set<String> getAllOptPermission() {
        return this.accountRpcService.getAllOptPermission();
    }

    @Override
    public List<PermissionDataDTO> getPermissionDataList(String elsAccount, String subAccount, String businessType) {
        return this.accountRpcService.getPermissionDataList(elsAccount, subAccount, businessType);
    }

    @Override
    public List<ElsSubAccountDTO> getAllByAccount(String account) {
        return this.accountRpcService.getAllByAccount(account);
    }

    @Override
    public void saveTenant(ElsTenantDTO elsTenantDTO) {
        this.elsTenantRpcService.saveTenant(elsTenantDTO);
    }

    @Override
    public ElsSubAccountDTO addUserWithRole(ElsSubAccountDTO user, String roles) {
        return this.accountRpcService.addUserWithRole(user, roles);
    }

    @Override
    public ElsSubAccountDTO save(ElsSubAccountDTO accountDTO) {
        return this.accountRpcService.save(accountDTO);
    }

    @Override
    public RoleDTO saveRole(RoleDTO roleDTO) {
        return this.accountRpcService.saveRole(roleDTO);
    }

    @Override
    public List<PermissionDTO> selectDefault() {
        return this.accountRpcService.selectDefault();
    }

    @Override
    public List<PermissionDTO> selectDefaultWithPurchase(String account) {
        return this.accountRpcService.selectDefaultWithPurchase(account);
    }

    @Override
    public List<CompanyPermissionDTO> insertCompanyMenuBatch(List<CompanyPermissionDTO> companyPermissionDTOs) {
        return this.accountRpcService.insertCompanyMenuBatch(companyPermissionDTOs);
    }

    @Override
    public RolePermissionDTO saveRolePermission(RolePermissionDTO permissionDTO) {
        return this.accountRpcService.saveRolePermission(permissionDTO);
    }

    @Override
    public List<PersonalSettingDTO> savePersonalSetting(List<PersonalSettingDTO> personalSettings) {
        return this.accountRpcService.savePersonalSetting(personalSettings);
    }

    @Override
    public List<ElsSubAccountDTO> queryByElsAccountList(List<String> accountList) {
        if (CollUtil.isEmpty(accountList)) {
            return Lists.newArrayList();
        }
        return this.accountRpcService.queryByElsAccountList(accountList);
    }

    @Override
    public List<RoleDTO> getAllRole() {
        return this.accountRpcService.getAllRole();
    }

    @Override
    public void batchSaveRolePermission(List<RolePermissionDTO> companyPermissionList) {
        this.accountRpcService.batchSaveRolePermission(companyPermissionList);
    }

    @Override
    public ElsSubAccountDTO initSupplierAccountInfo(String elsAccount, ElsSubAccountDTO account, String companyName, String sourceType) {
        return this.accountRpcService.initSupplierAccountInfo(elsAccount, account, companyName, sourceType);
    }

    @Override
    public List<RoleDTO> selectWithoutElsAccountOfAllRole(List<String> accountList) {
        if (CollUtil.isEmpty(accountList)) {
            return Lists.newArrayList();
        }
        return this.accountRpcService.selectWithoutElsAccountOfAllRole(accountList);
    }

    @Override
    public List<PermissionDTO> selectPermissionByRoleCode(String tenant, String roleCode) {
        List rolePermissionByRoleCodeList = this.rolePermissionRpcService.getRolePermissionByRoleCode(tenant, roleCode);
        ArrayList<PermissionDTO> permissionDtoList = new ArrayList<PermissionDTO>();
        HashMap<String, PermissionDTO> permissionDTOMap = new HashMap<String, PermissionDTO>();
        if (CollectionUtil.isNotEmpty((Collection)rolePermissionByRoleCodeList)) {
            List permissionIds = rolePermissionByRoleCodeList.stream().map(RolePermissionDTO::getPermissionId).filter(CharSequenceUtil::isNotEmpty).distinct().collect(Collectors.toList());
            List subPermissionList = this.permissionRpcService.getPermissionByIds(tenant, permissionIds);
            if (CollUtil.isNotEmpty((Collection)subPermissionList)) {
                for (PermissionDTO permissionDTO : subPermissionList) {
                    permissionDTOMap.put(permissionDTO.getId(), permissionDTO);
                }
                boolean flag = true;
                while (flag) {
                    List parentPermissionIds = subPermissionList.stream().map(PermissionDTO::getParentId).filter(CharSequenceUtil::isNotEmpty).distinct().collect(Collectors.toList());
                    if (CollUtil.isNotEmpty(parentPermissionIds)) {
                        subPermissionList = this.permissionRpcService.getPermissionByIds(tenant, parentPermissionIds);
                        for (PermissionDTO permissionDTO : subPermissionList) {
                            if (permissionDTOMap.containsKey(permissionDTO.getId())) continue;
                            permissionDTOMap.put(permissionDTO.getId(), permissionDTO);
                        }
                        continue;
                    }
                    flag = false;
                }
            }
            if (!permissionDTOMap.isEmpty()) {
                Set keys = permissionDTOMap.keySet();
                for (String key : keys) {
                    PermissionDTO permissionDTO = (PermissionDTO)permissionDTOMap.get(key);
                    permissionDtoList.add(permissionDTO);
                }
            }
            return permissionDtoList;
        }
        return null;
    }
}

