/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.member.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.SimpleOpenApiRpcService;
import com.els.modules.ipaas.entity.PayEnum;
import com.els.modules.ipaas.entity.PaymentCallBackEntity;
import com.els.modules.member.entity.Member;
import com.els.modules.member.entity.MemberMeal;
import com.els.modules.member.entity.MemberOrder;
import com.els.modules.member.enumerate.MealTypeEnum;
import com.els.modules.member.enumerate.OrderStatusEnum;
import com.els.modules.member.enumerate.PayStatusEnum;
import com.els.modules.member.service.MemberMealService;
import com.els.modules.member.service.MemberOrderService;
import com.els.modules.member.service.MemberService;
import com.els.modules.system.entity.McnTenantParamConfig;
import com.els.modules.system.entity.Role;
import com.els.modules.system.service.McnTenantParamConfigService;
import com.els.modules.system.service.RoleService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mcnIPaaSCallbackServiceImpl")
public class McnIPaaSCallbackServiceImpl
implements SimpleOpenApiRpcService {
    private static final Logger log = LoggerFactory.getLogger(McnIPaaSCallbackServiceImpl.class);
    @Autowired
    private MemberOrderService memberOrderService;
    @Autowired
    private MemberMealService memberMealService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private McnTenantParamConfigService mcnTenantParamConfigService;

    private boolean checkOrderSuccess(PaymentCallBackEntity callBackEntity) {
        PayEnum payEnum = Arrays.stream(PayEnum.values()).filter(x -> x.getValue().equals(callBackEntity.getPayType())).findFirst().get();
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)payEnum), (String)I18nUtil.translate((String)"i18n_alert_WWWRBMTKmWSMxuRBAc_d975e0b7", (String)"SRM\u652f\u4ed8\u56de\u8c03\u5931\u8d25\uff0c\u83b7\u53d6\u4e0d\u5230\u652f\u4ed8\u7c7b\u578b"), (Object[])new Object[0]);
        boolean flag = false;
        switch (payEnum) {
            case ALIPAY: {
                if (!callBackEntity.isSignVerify() || !"TRADE_SUCCESS".equals(callBackEntity.getRespCode())) break;
                flag = true;
                break;
            }
            case WXPAY: {
                if (!callBackEntity.isSignVerify() || !"SUCCESS".equals(callBackEntity.getRespCode())) break;
                flag = true;
                break;
            }
            case FUIOUPAY: {
                if (!callBackEntity.isSignVerify() || !"0000".equals(callBackEntity.getRespCode()) || !"11".equals(callBackEntity.getOrderSt())) break;
                flag = true;
            }
        }
        Assert.isTrue((boolean)flag, (String)(I18nUtil.translate((String)"i18n_alert_WWWRBMTWBjRBddLKmWItWW_acb12ab", (String)"SRM\u652f\u4ed8\u56de\u8c03\uff0c\u5bcc\u53cb\u652f\u4ed8\u54cd\u5e94\u4e3a\u5931\u8d25,\u8ba2\u5355ID\u3010") + callBackEntity.getOrderId() + "\u3011"), (Object[])new Object[0]);
        return flag;
    }

    @SrmTransaction(rollbackFor={Exception.class})
    public JSONObject invoke(JSONObject param) {
        PaymentCallBackEntity callBackEntity = new PaymentCallBackEntity();
        callBackEntity.setOrderId("1584458434045341697");
        MemberOrder memberOrder = (MemberOrder)((Object)this.memberOrderService.getById((Serializable)((Object)callBackEntity.getOrderId())));
        memberOrder.setOrderStatus(OrderStatusEnum.COMPLETED.getCode());
        memberOrder.setPayStatus(OrderStatusEnum.COMPLETED.getCode());
        memberOrder.setPayTime(new Date());
        memberOrder.setPayStatus(PayStatusEnum.PAID.getCode());
        this.memberOrderService.updateById((Object)memberOrder);
        TenantContext.setTenant((String)memberOrder.getToElsAccount());
        this.handleMemberPermission(memberOrder);
        return null;
    }

    private void handleMemberPermission(MemberOrder memberOrder) {
        String elsAccount;
        Member member;
        if (!MealTypeEnum.MEMBER_UPGRADE_RENEWAL.getCode().equals(memberOrder.getMealType())) {
            return;
        }
        String mealId = memberOrder.getMealId();
        if (!mealId.equals((member = this.memberService.getByElsAccount(elsAccount = memberOrder.getToElsAccount())).getMemberMealId())) {
            MemberMeal meal = (MemberMeal)((Object)this.memberMealService.getById((Serializable)((Object)memberOrder.getMealId())));
            Role role = (Role)this.roleService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Role::getElsAccount, (Object)elsAccount)).eq(Role::getRoleCode, (Object)"companyAdmin"));
            if (ObjectUtil.isNotEmpty((Object)role) && StrUtil.isNotBlank((CharSequence)role.getId())) {
                TenantContext.setTenant((String)elsAccount);
                this.memberService.deleteMemberPermission(elsAccount, role.getId());
                this.memberService.autoSetPermission(elsAccount, meal.getRuleCode(), memberOrder.getCreateBy(), memberOrder.getUpdateBy(), role.getId());
            }
            this.mcnTenantParamConfigService.remove((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount));
            List<McnTenantParamConfig> tenantParamConfigs = this.mcnTenantParamConfigService.getControlConfig(elsAccount, meal.getMemberLev());
            if (CollUtil.isNotEmpty(tenantParamConfigs)) {
                this.mcnTenantParamConfigService.saveBatch(tenantParamConfigs);
            }
        }
    }
}

