/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.MD5Util;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.model.TreeModel;
import com.els.modules.system.service.PermissionExtendService;
import com.els.modules.system.vo.PermissionVO;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/account/permissionExtend"})
@Api(tags={"\u83dc\u5355\u7ba1\u7406"})
public class PermissionExtendController {
    private static final Logger log = LoggerFactory.getLogger(PermissionExtendController.class);
    @Autowired
    private PermissionExtendService permissionService;

    @RequestMapping(value={"/queryCompanyPermission"}, method={RequestMethod.GET})
    public Result<List<String>> queryCompanyPermission(@RequestParam(name="elsAccount") String elsAccount) {
        Result result = new Result();
        try {
            List<PermissionVO> permissionList = this.permissionService.getCompanyMenuList(elsAccount);
            result.setResult(permissionList.stream().map(vo -> String.valueOf(vo.getId())).collect(Collectors.toList()));
            result.setSuccess(true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/getUserPermissionByToken"}, method={RequestMethod.GET})
    public Result<?> getUserPermissionByToken(@RequestParam(name="token") String token) {
        Result result = new Result();
        try {
            if (ConvertUtils.isEmpty((Object)token)) {
                return Result.error((String)"TOKEN\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
            }
            log.info(" ------ \u901a\u8fc7\u4ee4\u724c\u83b7\u53d6\u7528\u6237\u62e5\u6709\u7684\u8bbf\u95ee\u83dc\u5355 ---- TOKEN ------ " + token);
            String account = JwtUtil.getAccount((String)token);
            List<PermissionVO> metaList = this.permissionService.queryByAccount(account.split("_")[0], account.split("_")[1], 0);
            JSONObject json = new JSONObject();
            JSONArray menujsonArray = new JSONArray();
            this.getPermissionJsonArray(menujsonArray, metaList, null);
            JSONArray authjsonArray = new JSONArray();
            this.getAuthJsonArray(authjsonArray, metaList);
            JSONArray docArray = new JSONArray();
            this.getDocArray(docArray, metaList);
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(Permission::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
            query.eq(Permission::getMenuType, (Object)CommonConstant.MENU_TYPE_2);
            List allAuthList = this.permissionService.list((Wrapper)query);
            JSONArray allauthjsonArray = new JSONArray();
            this.getAllAuthJsonArray(allauthjsonArray, allAuthList);
            json.put("menu", (Object)menujsonArray);
            json.put("auth", (Object)authjsonArray);
            json.put("allAuth", (Object)allauthjsonArray);
            json.put("doc", (Object)docArray);
            result.setResult((Object)json);
            result.success("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            result.error500("\u67e5\u8be2\u5931\u8d25:" + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    JSONArray getDocArray(JSONArray docArray, List<PermissionVO> metaList) {
        for (PermissionVO vo : metaList) {
            if (StrUtil.isBlank((CharSequence)vo.getUrl())) continue;
            JSONObject object = new JSONObject();
            object.put("path", (Object)vo.getUrl());
            if (StrUtil.isBlank((CharSequence)vo.getHelpDesc())) {
                object.put("hasDoc", (Object)"0");
            } else {
                object.put("hasDoc", (Object)"1");
            }
            docArray.add((Object)object);
        }
        return docArray;
    }

    private void getTreeModelList(List<TreeModel> treeList, List<Permission> metaList, TreeModel temp) {
        for (Permission permission : metaList) {
            String tempPid = permission.getParentId();
            TreeModel tree = new TreeModel(permission);
            if (temp == null && ConvertUtils.isEmpty((Object)tempPid)) {
                treeList.add(tree);
                if (tree.getIsLeaf()) continue;
                this.getTreeModelList(treeList, metaList, tree);
                continue;
            }
            if (temp == null || tempPid == null || !tempPid.equals(temp.getKey())) continue;
            temp.getChildren().add(tree);
            if (tree.getIsLeaf()) continue;
            this.getTreeModelList(treeList, metaList, tree);
        }
    }

    private void getAllAuthJsonArray(JSONArray jsonArray, List<Permission> allList) {
        for (Permission permission : allList) {
            JSONObject json = new JSONObject();
            json.put("action", (Object)permission.getPerms());
            json.put("status", (Object)permission.getStatus());
            json.put("type", (Object)permission.getPermsType());
            json.put("describe", (Object)permission.getName());
            jsonArray.add((Object)json);
        }
    }

    private void getAuthJsonArray(JSONArray jsonArray, List<PermissionVO> metaList) {
        for (Permission permission : metaList) {
            if (permission.getMenuType() == null || !permission.getMenuType().equals(CommonConstant.MENU_TYPE_2) || !"1".equals(permission.getStatus())) continue;
            JSONObject json = new JSONObject();
            json.put("action", (Object)permission.getPerms());
            json.put("type", (Object)permission.getPermsType());
            json.put("describe", (Object)permission.getName());
            jsonArray.add((Object)json);
        }
    }

    private void getPermissionJsonArray(JSONArray jsonArray, List<PermissionVO> metaList, JSONObject parentJson) {
        for (Permission permission : metaList) {
            if (permission.getMenuType() == null) continue;
            String tempPid = permission.getParentId();
            permission.setName(I18nUtil.translate((String)permission.getNameI18nKey(), (String)permission.getName()));
            JSONObject json = this.getPermissionJsonObject(permission);
            if (json == null) continue;
            if (parentJson == null && ConvertUtils.isEmpty((Object)tempPid)) {
                jsonArray.add((Object)json);
                if (permission.isLeaf()) continue;
                this.getPermissionJsonArray(jsonArray, metaList, json);
                continue;
            }
            if (parentJson == null || !ConvertUtils.isNotEmpty((Object)tempPid) || !tempPid.equals(parentJson.getString("id"))) continue;
            if (permission.getMenuType().equals(CommonConstant.MENU_TYPE_2)) {
                JSONObject metaJson = parentJson.getJSONObject("meta");
                if (metaJson.containsKey((Object)"permissionList")) {
                    metaJson.getJSONArray("permissionList").add((Object)json);
                    continue;
                }
                JSONArray permissionList = new JSONArray();
                permissionList.add((Object)json);
                metaJson.put("permissionList", (Object)permissionList);
                continue;
            }
            if (!permission.getMenuType().equals(CommonConstant.MENU_TYPE_1) && !permission.getMenuType().equals(CommonConstant.MENU_TYPE_0)) continue;
            if (parentJson.containsKey((Object)"children")) {
                parentJson.getJSONArray("children").add((Object)json);
            } else {
                JSONArray children = new JSONArray();
                children.add((Object)json);
                parentJson.put("children", (Object)children);
            }
            if (permission.isLeaf()) continue;
            this.getPermissionJsonArray(jsonArray, metaList, json);
        }
    }

    private JSONObject getPermissionJsonObject(Permission permission) {
        JSONObject json = new JSONObject();
        if (permission.getMenuType().equals(CommonConstant.MENU_TYPE_2)) {
            return null;
        }
        if (permission.getMenuType().equals(CommonConstant.MENU_TYPE_0) || permission.getMenuType().equals(CommonConstant.MENU_TYPE_1)) {
            json.put("id", (Object)permission.getId());
            if (permission.isRoute()) {
                json.put("route", (Object)"1");
            } else {
                json.put("route", (Object)"0");
            }
            if (this.isWWWHttpUrl(permission.getUrl())) {
                json.put("path", (Object)MD5Util.md5Encode((String)permission.getUrl(), (String)"utf-8"));
            } else {
                json.put("path", (Object)permission.getUrl());
            }
            json.put("mobile", (Object)permission.isMobile());
            if (ConvertUtils.isNotEmpty((Object)permission.getComponentName())) {
                json.put("name", (Object)permission.getComponentName());
            } else {
                json.put("name", (Object)this.urlToRouteName(permission.getUrl()));
            }
            if (permission.isHidden()) {
                json.put("hidden", (Object)true);
            }
            if (permission.isAlwaysShow()) {
                json.put("alwaysShow", (Object)true);
            }
            json.put("component", (Object)permission.getComponent());
            JSONObject meta = new JSONObject();
            if (permission.isKeepAlive()) {
                meta.put("keepAlive", (Object)true);
            } else {
                meta.put("keepAlive", (Object)false);
            }
            if (permission.isInternalOrExternal()) {
                meta.put("internalOrExternal", (Object)true);
            } else {
                meta.put("internalOrExternal", (Object)false);
            }
            meta.put("title", (Object)permission.getName());
            if (ConvertUtils.isEmpty((Object)permission.getParentId())) {
                json.put("redirect", (Object)permission.getRedirect());
                if (ConvertUtils.isNotEmpty((Object)permission.getIcon())) {
                    meta.put("icon", (Object)permission.getIcon());
                }
                if (ConvertUtils.isNotEmpty((Object)permission.getIconColor())) {
                    meta.put("iconColor", (Object)permission.getIconColor());
                }
            } else {
                if (ConvertUtils.isNotEmpty((Object)permission.getIcon())) {
                    meta.put("icon", (Object)permission.getIcon());
                }
                if (ConvertUtils.isNotEmpty((Object)permission.getIconColor())) {
                    meta.put("iconColor", (Object)permission.getIconColor());
                }
            }
            if (this.isWWWHttpUrl(permission.getUrl())) {
                meta.put("url", (Object)permission.getUrl());
            }
            if (StrUtil.isNotBlank((CharSequence)permission.getHelpDocUrl())) {
                meta.put("helpDocUrl", (Object)permission.getHelpDocUrl());
            }
            json.put("meta", (Object)meta);
        }
        return json;
    }

    private boolean isWWWHttpUrl(String url) {
        return url != null && (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("{{"));
    }

    private String urlToRouteName(String url) {
        if (ConvertUtils.isNotEmpty((Object)url)) {
            if (url.startsWith("/")) {
                url = url.substring(1);
            }
            url = url.replace("/", "-");
            url = url.replace(":", "@");
            return url;
        }
        return null;
    }
}

