/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.member.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.member.entity.MemberMeal;
import com.els.modules.member.entity.MemberMealDetail;
import com.els.modules.member.entity.MemberMealGroup;
import com.els.modules.member.entity.MemberOrder;
import com.els.modules.member.enumerate.MealTypeEnum;
import com.els.modules.member.mapper.MemberMealMapper;
import com.els.modules.member.service.MemberMealDetailService;
import com.els.modules.member.service.MemberMealGroupService;
import com.els.modules.member.service.MemberMealService;
import com.els.modules.member.service.MemberOrderService;
import com.els.modules.member.vo.MemberMealVo;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class MemberMealServiceImpl
extends BaseServiceImpl<MemberMealMapper, MemberMeal>
implements MemberMealService {
    @Autowired
    private MemberMealGroupService memberMealGroupService;
    @Autowired
    private MemberMealDetailService memberMealDetailService;
    @Autowired
    private MemberOrderService memberOrderService;

    @Override
    public void add(MemberMeal memberMeal) {
        ((MemberMealMapper)this.baseMapper).insert((Object)memberMeal);
    }

    @Override
    public void edit(MemberMeal memberMeal) {
        int count = ((MemberMealMapper)this.baseMapper).updateById((Object)memberMeal);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((MemberMealMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((MemberMealMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public MemberMealVo getMeal(String type) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)type), (String)"\u53c2\u6570\u5f02\u5e38");
        MealTypeEnum mealType = MealTypeEnum.getByCode(type);
        List dbs = this.list((Wrapper)Wrappers.lambdaQuery().eq(MemberMeal::getPayShow, (Object)"1"));
        MemberMealVo vo = new MemberMealVo();
        String elsAccount = TenantContext.getTenant();
        List orders = this.memberOrderService.getOrderByElsAccount(elsAccount).stream().filter(o -> o.getMealType().equals(type)).collect(Collectors.toList());
        DateTime validityTime = DateUtil.offsetMonth((Date)new Date(), (int)12);
        switch (mealType) {
            case MEMBER_UPGRADE_RENEWAL: {
                if (CollUtil.isNotEmpty(orders)) {
                    orders = orders.stream().filter(o -> ObjectUtil.isEmpty((Object)o.getIsDed()) || !"1".equals(o.getIsDed())).collect(Collectors.toList());
                    List mealIds = orders.stream().map(o -> o.getMealId()).distinct().collect(Collectors.toList());
                    List oldMeals = dbs.stream().filter(x -> mealIds.contains(x.getId())).collect(Collectors.toList());
                    if (!ObjectUtil.isNotEmpty(oldMeals)) break;
                    Assert.isTrue((oldMeals.size() == 1 ? 1 : 0) != 0, (String)"\u5957\u9910\u5f02\u5e38");
                    MemberMeal nowMeal = (MemberMeal)((Object)oldMeals.get(0));
                    orders = orders.stream().filter(o -> o.getMealId().equals(nowMeal.getId())).collect(Collectors.toList());
                    MemberOrder nowOrder = orders.stream().filter(o -> o.getMealId().equals(nowMeal.getId())).sorted(Comparator.comparing(MemberOrder::getMealExpireTime).reversed()).findFirst().get();
                    BigDecimal dedAmt = BigDecimal.ZERO;
                    if (ObjectUtil.isNotEmpty((Object)nowOrder.getMealExpireTime())) {
                        long day = DateUtil.between((Date)nowOrder.getMealExpireTime(), (Date)new Date(), (DateUnit)DateUnit.DAY);
                        double oldSumAmt = orders.stream().mapToDouble(x -> x.getPayAmt().doubleValue()).sum();
                        dedAmt = new BigDecimal(oldSumAmt).divide(new BigDecimal(365), 2, RoundingMode.DOWN).multiply(new BigDecimal(day));
                        dedAmt = dedAmt.setScale(2);
                    }
                    MemberOrder order = orders.stream().sorted(Comparator.comparing(MemberOrder::getMealExpireTime).reversed()).findFirst().get();
                    for (MemberMeal dbMeals : dbs) {
                        if (dbMeals.getMemberLev() < nowMeal.getMemberLev()) {
                            dbMeals.setCanChoice(false);
                        } else {
                            dbMeals.setCanChoice(true);
                        }
                        dbMeals.setDedAmt(dedAmt);
                        if (dbMeals.getId().equals(nowMeal.getId())) {
                            if (ObjectUtil.isNotEmpty((Object)((Object)order))) {
                                DateTime orderExpireTime = DateUtil.offsetMonth((Date)order.getMealExpireTime(), (int)12);
                                if (ObjectUtil.isNotEmpty((Object)order.getMealExpireTime()) && orderExpireTime.getTime() > validityTime.getTime()) {
                                    dbMeals.setValidityTime((Date)orderExpireTime);
                                }
                            }
                        } else {
                            dbMeals.setValidityTime((Date)validityTime);
                        }
                        dbMeals.setPayAmt(dbMeals.getProductAmt().subtract(dedAmt));
                        if (!ObjectUtil.isNotEmpty((Object)dbMeals.getDiscount())) continue;
                        String s = "0." + dbMeals.getDiscount();
                        double ds = Double.valueOf(s);
                        dbMeals.setPayAmt(dbMeals.getProductAmt().multiply(BigDecimal.valueOf(ds)).subtract(dedAmt).setScale(0, 4));
                    }
                } else {
                    for (MemberMeal dbMeals : dbs) {
                        dbMeals.setValidityTime((Date)validityTime);
                        dbMeals.setCanChoice(true);
                        dbMeals.setPayAmt(dbMeals.getProductAmt());
                        if (!ObjectUtil.isNotEmpty((Object)dbMeals.getDiscount())) continue;
                        String s = "0." + dbMeals.getDiscount();
                        double ds = Double.valueOf(s);
                        dbMeals.setPayAmt(dbMeals.getProductAmt().multiply(BigDecimal.valueOf(ds)).setScale(0, 4));
                    }
                }
                break;
            }
            case ADD_SHOPS: {
                break;
            }
        }
        this.handleMeasAmt(dbs);
        vo.setMeals(dbs);
        return vo;
    }

    private void handleMeasAmt(List<MemberMeal> list) {
        list.forEach(x -> {
            if (ObjectUtil.isNotEmpty((Object)x.getProductAmt())) {
                x.setProductAmt(x.getProductAmt().setScale(2).stripTrailingZeros());
            }
            if (ObjectUtil.isNotEmpty((Object)x.getDayAmt())) {
                x.setDayAmt(x.getDayAmt().setScale(2).stripTrailingZeros());
            }
            if (ObjectUtil.isNotEmpty((Object)x.getAddShopAmt())) {
                x.setAddShopAmt(x.getAddShopAmt().setScale(2).stripTrailingZeros());
            }
            if (ObjectUtil.isNotEmpty((Object)x.getAddAccountAmt())) {
                x.setAddAccountAmt(x.getAddAccountAmt().setScale(2).stripTrailingZeros());
            }
            if (ObjectUtil.isNotEmpty((Object)x.getAddShopAmt())) {
                x.setAddShopAmt(x.getAddShopAmt().setScale(2).stripTrailingZeros());
            }
            if (ObjectUtil.isNotEmpty((Object)x.getPayAmt())) {
                x.setPayAmt(x.getPayAmt().setScale(2).stripTrailingZeros());
            }
        });
    }

    @Override
    public MemberMealVo getMealDetail() {
        List meals = this.list((Wrapper)Wrappers.lambdaQuery().orderByDesc(MemberMeal::getMemberLev));
        MemberMealVo vo = new MemberMealVo();
        vo.setMeals(meals);
        List memberMealGroups = this.memberMealGroupService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().isNull(MemberMealGroup::getPid)).orderByAsc(MemberMealGroup::getSort));
        ArrayList tables = Lists.newArrayList();
        memberMealGroups.forEach(g -> {
            HashMap m = Maps.newHashMap();
            m.put("id", g.getId());
            m.put("title", g.getGroupName());
            List lv2 = this.memberMealGroupService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MemberMealGroup::getPid, (Object)g.getId())).orderByAsc(MemberMealGroup::getSort));
            ArrayList tables2 = Lists.newArrayList();
            lv2.forEach(v2 -> {
                HashMap mv2 = Maps.newHashMap();
                mv2.put("id", v2.getId());
                mv2.put("title", v2.getGroupName());
                List memberMealDetails = this.memberMealDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MemberMealDetail::getGroupId, (Object)v2.getId())).orderByAsc(MemberMealDetail::getSort));
                ArrayList tables3 = Lists.newArrayList();
                memberMealDetails.forEach(m3 -> {
                    HashMap mv3 = Maps.newHashMap();
                    mv3.put("id", m3.getId());
                    mv3.put("title", m3.getSubFun());
                    mv3.put("lv0Val", m3.getLv0Val());
                    mv3.put("lv1Val", m3.getLv1Val());
                    mv3.put("lv2Val", m3.getLv2Val());
                    mv3.put("lv3Val", m3.getLv3Val());
                    tables3.add(mv3);
                });
                mv2.put("children", tables3);
                tables2.add(mv2);
            });
            m.put("children", tables2);
            tables.add(m);
        });
        vo.setMealDetails(tables);
        return vo;
    }

    @Override
    public MemberMeal getTrialMeal() {
        return (MemberMeal)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(MemberMeal::getPayShow, (Object)false)));
    }
}

