/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.member.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.context.TokenContext;
import com.els.common.enumerate.TenantControlModeEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.DictModel;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.EmailBuilder;
import com.els.common.util.I18nUtil;
import com.els.common.util.ImgCreatorUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.CompanyPermissionDTO;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.ElsTenantDTO;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.account.api.dto.PersonalSettingDTO;
import com.els.modules.account.api.dto.RoleDTO;
import com.els.modules.account.api.dto.RolePermissionDTO;
import com.els.modules.apirecord.enumerate.ApiTypeEnum;
import com.els.modules.base.api.dto.ElsEmailConfigDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.member.entity.AppointDemo;
import com.els.modules.member.entity.Member;
import com.els.modules.member.entity.MemberMeal;
import com.els.modules.member.mapper.MemberMapper;
import com.els.modules.member.service.AppointDemoService;
import com.els.modules.member.service.MemberMealService;
import com.els.modules.member.service.MemberService;
import com.els.modules.member.vo.CheckModelVo;
import com.els.modules.member.vo.CurrentMemberVo;
import com.els.modules.member.vo.CurrentOptVo;
import com.els.modules.member.vo.LoginModelExtent;
import com.els.modules.supplier.entity.SupplierInvitationCode;
import com.els.modules.supplier.enumerate.SourceTypeEnum;
import com.els.modules.supplier.enumerate.SupplierRegisterTypeExtendEnum;
import com.els.modules.supplier.rpc.service.SupplierInvokeAccountExtendRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeBaseRpcService;
import com.els.modules.supplier.rpc.service.SupplierInvokeEnterpriseRpcService;
import com.els.modules.supplier.vo.RegisterMqDataVo;
import com.els.modules.supplier.vo.RegisterVO;
import com.els.modules.system.entity.McnTenantParamConfig;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.McnTenantParamConfigService;
import com.els.rpc.service.ImGroupInvokeRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
public class MemberServiceImpl
extends BaseServiceImpl<MemberMapper, Member>
implements MemberService {
    private static final Logger log = LoggerFactory.getLogger(MemberServiceImpl.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SupplierInvokeEnterpriseRpcService supplierinvokeEnterpriseRpcService;
    @Autowired
    private SupplierInvokeBaseRpcService supplierinvokeBaseRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private MemberMealService memberMealService;
    @Lazy
    @Resource
    private SupplierInvokeAccountExtendRpcService supplierInvokeAccountRpcService;
    @Value(value="${els.path.upload}")
    private String uploadpath;
    @Resource(name="srmPoolExecutor")
    public ThreadPoolExecutor srmPoolExecutor;
    @Autowired(required=false)
    private ImGroupInvokeRpcService baseImGroupService;
    @Autowired
    private McnTenantParamConfigService mcnTenantParamConfigService;
    @Autowired
    private DictService dictService;
    @Autowired
    private AppointDemoService appointDemoService;

    private void checkUserIsEffective(LoginModelExtent loginModel) {
        Object obj = this.redisUtil.get(loginModel.getSubAccount());
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)obj), (String)I18nUtil.translate((String)"i18n_alert_OioIKXWVVVSMW_feeecd17", (String)"\u9a8c\u8bc1\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01"), (Object[])new Object[0]);
        Assert.isTrue((boolean)obj.toString().equals(loginModel.getCaptcha()), (String)I18nUtil.translate((String)"i18n_alert_OioNSWVVVSMW_4d0356d2", (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\uff01"), (Object[])new Object[0]);
    }

    @Override
    public CheckModelVo checkEnterprise(LoginModelExtent loginModel) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)loginModel.getSubAccount()), (String)"\u8bf7\u8f93\u5165\u624b\u673a\u53f7!", (Object[])new Object[0]);
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)loginModel.getCaptcha()), (String)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801!", (Object[])new Object[0]);
        this.checkUserIsEffective(loginModel);
        CheckModelVo checkModelVo = new CheckModelVo();
        Member member = (Member)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(Member::getSubAccount, (Object)loginModel.getSubAccount())));
        if (ObjectUtil.isEmpty((Object)((Object)member)) || StrUtil.isBlank((CharSequence)member.getElsAccount())) {
            checkModelVo.setHasElsAccount(false);
        } else {
            checkModelVo.setHasElsAccount(true);
        }
        return checkModelVo;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public Result<?> createElsAccount(LoginModelExtent loginModel) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)loginModel.getCompanyName()), (String)"\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)loginModel.getPassword()), (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)loginModel.getConfirmPassword()), (String)"\u786e\u8ba4\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isTrue((boolean)loginModel.getConfirmPassword().equals(loginModel.getPassword()), (String)"\u4e24\u6b21\u5bc6\u7801\u4e0d\u4e00\u81f4", (Object[])new Object[0]);
        SupplierInvitationCode invitationCode = null;
        String els_account = "100000";
        TenantContext.setTenant((String)"100000");
        JSONObject result = this.supplierinvokeBaseRpcService.callIPaasInterface(this.getIpaaSData(loginModel.getCompanyName(), SourceTypeEnum.OPEN_REGISTER.getValue(), els_account), "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("get-enterprise-info"));
        Assert.isTrue((boolean)result.getBoolean("success"), (String)"\u4f01\u4e1a\u540d\u79f0\u9519\u8bef\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u586b\u5199\uff01", (Object[])new Object[0]);
        ElsEnterpriseInfoDTO elsEnterpriseInfoDTO = (ElsEnterpriseInfoDTO)JSONObject.parseObject((String)result.getJSONObject("data").toJSONString(), ElsEnterpriseInfoDTO.class);
        ElsEnterpriseInfoDTO enterpriseInfo = this.supplierinvokeEnterpriseRpcService.getByElsAccount(elsEnterpriseInfoDTO.getElsAccount());
        Assert.isTrue((boolean)ObjectUtil.isEmpty((Object)enterpriseInfo), (String)"\u8be5\u4f01\u4e1a\u5df2\u88ab\u6ce8\u518c\uff01", (Object[])new Object[0]);
        ElsSubAccountDTO account = new ElsSubAccountDTO();
        account.setElsAccount(elsEnterpriseInfoDTO.getElsAccount());
        account.setSubAccount(loginModel.getSubAccount());
        account.setRealname(loginModel.getSubAccount());
        account.setPhone(loginModel.getSubAccount());
        account.setStatus(CommonConstant.STATUS_YES);
        String salt = ConvertUtils.randomGen((int)8);
        account.setSalt(salt);
        String password = loginModel.getPassword();
        String passwordEncode = PasswordUtil.encrypt((String)(account.getElsAccount() + "_" + account.getSubAccount()), (String)password, (String)salt);
        account.setPassword(passwordEncode);
        account.setDeleted(CommonConstant.STATUS_NO);
        byte[] bytes = ImgCreatorUtil.generateImg((String)account.getRealname());
        if (null != bytes) {
            String fileName = System.currentTimeMillis() + ".jpg";
            String filePath = this.getFilePath() + File.separator + System.currentTimeMillis() + fileName;
            if (filePath.contains("\\")) {
                filePath = filePath.replace("\\", "/");
            }
            String avatar = this.supplierinvokeBaseRpcService.uploadFile(bytes, this.uploadpath + filePath, fileName);
            account.setAvatar("/opt/upFiles" + avatar.replace(this.uploadpath, ""));
        }
        RoleDTO role = new RoleDTO();
        role.setElsAccount(account.getElsAccount());
        role.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
        role.setRoleCode("companyAdmin");
        role = this.supplierInvokeAccountRpcService.saveRole(role);
        account = this.supplierInvokeAccountRpcService.addUserWithRole(account, role.getId());
        RegisterVO registerVO = new RegisterVO();
        BeanUtil.copyProperties((Object)((Object)loginModel), (Object)registerVO, (String[])new String[0]);
        RegisterMqDataVo registerMqDataVo = new RegisterMqDataVo(elsEnterpriseInfoDTO, registerVO, invitationCode, els_account, account, role, TenantContext.getTenant(), SysUtil.getLoginUser(), SpringContextUtils.getHttpServletRequest().getHeader("X-Access-Token"));
        this.registerMqdataDeal(registerMqDataVo);
        this.handleMember(account.getElsAccount(), account.getSubAccount(), account.getId());
        HashMap res = Maps.newHashMap();
        HashMap login = Maps.newHashMap();
        res.put("msg", "\u6ce8\u518c\u6210\u529f\uff01 \u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\uff1a" + elsEnterpriseInfoDTO.getElsAccount() + " \u5b50\u8d26\u53f7\uff1a" + loginModel.getSubAccount() + "\u521d\u59cb\u767b\u5165\u5bc6\u7801\u4e3a\uff1a" + loginModel.getPassword());
        login.put("elsAccount", elsEnterpriseInfoDTO.getElsAccount());
        login.put("subAccount", loginModel.getSubAccount());
        login.put("password", loginModel.getPassword());
        res.put("login", login);
        return Result.ok((Object)res);
    }

    @Override
    public CurrentMemberVo checkMember(String subAccount, String elsAccount) {
        Member member = (Member)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(Member::getSubAccount, (Object)subAccount)));
        if (ObjectUtil.isEmpty((Object)((Object)member))) {
            return null;
        }
        Assert.isTrue((member.getExpireTime().getTime() > System.currentTimeMillis() ? 1 : 0) != 0, (String)"\u8bd5\u7528\u5929\u6570\u5df2\u7528\u5b8c\uff0c\u65e0\u6cd5\u767b\u5f55\uff0c\u5982\u9700\u5f00\u901a\u4f1a\u5458\u8bf7\u8054\u7cfb\u5ba2\u670d\u3002", (Object[])new Object[0]);
        CurrentMemberVo vo = new CurrentMemberVo();
        vo.setMemberLv(member.getMemberLv());
        vo.setMemberMealId(member.getMemberMealId());
        long day = DateUtil.between((Date)member.getExpireTime(), (Date)new Date(), (DateUnit)DateUnit.DAY);
        vo.setDay(day);
        if (member.getMemberLv() == 0) {
            vo.setNeedTips(true);
            vo.setTips("\u60a8\u7684\u8bd5\u7528\u5929\u6570\u5269\u4f59" + day + "\u5929\uff0c\u5efa\u8bae\u60a8\u5347\u7ea7\u4f1a\u5458\uff0c\u4f53\u9a8c\u5b8c\u6574\u529f\u80fd\u3002");
        }
        return vo;
    }

    @Override
    public boolean isTrial(String elsAccount, String subAccount) {
        Member member = (Member)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(Member::getSubAccount, (Object)subAccount)));
        return ObjectUtil.isNotEmpty((Object)((Object)member)) && member.getMemberLv().equals(0);
    }

    @Override
    public CurrentOptVo getLimit(String configCode) {
        String selectCode;
        ApiTypeEnum config = ApiTypeEnum.getApiTypeEnumByConfigCode(configCode);
        CurrentOptVo vo = new CurrentOptVo();
        vo.setCanContinue(true);
        vo.setLimit(5);
        if (ObjectUtil.isEmpty((Object)((Object)config))) {
            return vo;
        }
        String elsAccount = TenantContext.getTenant();
        String num = this.mcnTenantParamConfigService.getOneConfig(elsAccount, selectCode = configCode);
        if (!"Y".equals(num)) {
            Long limitNum = Long.valueOf(num);
            Long countNum = null;
            McnTenantParamConfig configDb = this.mcnTenantParamConfigService.getOneConfigDb(elsAccount, configCode);
            String redisKey = "api:count:str:" + elsAccount + ":" + config.getCode();
            if (TenantControlModeEnum.SUB_ACCOUNT.value.equals(configDb.getControlMode())) {
                redisKey = "api:count:str:" + elsAccount + ":" + SysUtil.getLoginUser().getSubAccount() + ":" + config.getCode();
            }
            if (this.redisUtil.hasKey(redisKey)) {
                String numStr = (String)this.redisUtil.get(redisKey);
                countNum = Long.valueOf(numStr);
                Long limit = limitNum - countNum;
                vo.setLimit(limit.intValue());
                if (limit <= 0L) {
                    vo.setCanContinue(false);
                }
            }
        }
        return vo;
    }

    private void handleMember(String elsAccount, String subAccount, String userId) {
        Member member = new Member();
        member.setElsAccount(elsAccount);
        member.setSubAccount(subAccount);
        MemberMeal meal = this.memberMealService.getTrialMeal();
        member.setUserId(userId);
        member.setMemberLv(meal.getMemberLev());
        member.setMemberMealId(meal.getId());
        member.setExpireTime((Date)DateUtil.offsetDay((Date)new Date(), (int)7));
        this.save((Object)member);
        this.mcnTenantParamConfigService.remove((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount));
        List<McnTenantParamConfig> tenantParamConfigs = this.mcnTenantParamConfigService.getControlConfig(elsAccount, 0);
        if (CollUtil.isNotEmpty(tenantParamConfigs)) {
            this.mcnTenantParamConfigService.saveBatch(tenantParamConfigs);
        }
    }

    public void registerMqdataDeal(RegisterMqDataVo dataVo) {
        TenantContext.setTenant((String)dataVo.getTenant());
        LoginUserContext.setUser((LoginUser)dataVo.getLoginUser());
        TokenContext.setToken((String)dataVo.getToken());
        ElsEnterpriseInfoDTO ElsEnterpriseInfoDTO2 = dataVo.getElsEnterpriseInfoDTO();
        RegisterVO registerVO = dataVo.getRegisterVO();
        ElsSubAccountDTO account = dataVo.getAccount();
        RoleDTO role = dataVo.getRole();
        ElsEnterpriseInfoDTO2.setDeleted(Integer.valueOf(0));
        ElsEnterpriseInfoDTO2.setCreateBy(account.getCreateBy());
        ElsEnterpriseInfoDTO2.setUpdateBy(account.getUpdateBy());
        this.supplierinvokeEnterpriseRpcService.insert(ElsEnterpriseInfoDTO2);
        registerVO.setCompanyName(ElsEnterpriseInfoDTO2.getName());
        this.saveSubAccountInfoYouhua(registerVO, ElsEnterpriseInfoDTO2.getElsAccount(), account, role);
        String id = account.getId();
        this.srmPoolExecutor.execute(() -> {
            try {
                LoginUserContext.setUser((LoginUser)dataVo.getLoginUser());
                TenantContext.setTenant((String)dataVo.getTenant());
                TokenContext.setToken((String)dataVo.getToken());
                this.baseImGroupService.initGroup(id);
            }
            catch (Exception e) {
                log.error(":::\u6dfb\u52a0\u597d\u53cb\u5206\u7ec4\u5f02\u5e38:{}", (Throwable)e);
            }
            finally {
                TenantContext.clear();
                LoginUserContext.clear();
                TokenContext.clear();
            }
        });
    }

    public void savePersonalSetting(String elsAccount, String subaccount) {
        List<String> list = Arrays.asList("EMAIL", "NEWS", "VOICE", "MSG", "WECHAT", "DINGTALK");
        ArrayList<PersonalSettingDTO> personalSettings = new ArrayList<PersonalSettingDTO>();
        for (String str : list) {
            PersonalSettingDTO personalSetting = new PersonalSettingDTO();
            personalSetting.setId(UUID.randomUUID().toString().replace("-", ""));
            personalSetting.setElsAccount(elsAccount);
            personalSetting.setSubAccount(subaccount);
            personalSetting.setCreateBy("1001");
            personalSetting.setCreateTime(new Date());
            personalSetting.setUpdateBy("1001");
            personalSetting.setUpdateTime(new Date());
            personalSetting.setReceiveType(str);
            personalSetting.setIsReceive(Integer.valueOf(0));
            personalSettings.add(personalSetting);
        }
        this.supplierInvokeAccountRpcService.savePersonalSetting(personalSettings);
    }

    public void saveSubAccountInfoYouhua(RegisterVO registerVO, String elsAccount, ElsSubAccountDTO account, RoleDTO role) {
        this.savePersonalSetting(elsAccount, account.getSubAccount());
        ElsTenantDTO elsTenant = new ElsTenantDTO();
        elsTenant.setAccountStatus("1");
        elsTenant.setElsAccount(elsAccount);
        elsTenant.setCompanyName(registerVO.getCompanyName());
        elsTenant.setSourceType("8");
        elsTenant.setUpdateBy(role.getUpdateBy());
        elsTenant.setCreateBy(role.getCreateBy());
        elsTenant.setExpiryDate((Date)DateUtil.offsetDay((Date)new Date(), (int)7));
        this.autoSetPermission(elsAccount, SupplierRegisterTypeExtendEnum.MEMBER_TRIAL.getRoleCode(), role.getCreateBy(), role.getUpdateBy(), role.getId());
        this.supplierInvokeAccountRpcService.saveTenant(elsTenant);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void autoSetPermission(String elsAccount, String roleCode, String createBy, String updateBy, String roleId) {
        List<PermissionDTO> list = this.supplierInvokeAccountRpcService.selectPermissionByRoleCode("100000", roleCode);
        if (list != null) {
            List<CompanyPermissionDTO> companyPermissions = new ArrayList<CompanyPermissionDTO>();
            CompanyPermissionDTO companyPermissionDTO = new CompanyPermissionDTO();
            for (PermissionDTO permission : list) {
                companyPermissionDTO = new CompanyPermissionDTO();
                companyPermissionDTO.setId(IdWorker.getIdStr());
                companyPermissionDTO.setElsAccount(elsAccount);
                companyPermissionDTO.setPermissionId(permission.getId());
                companyPermissionDTO.setName(permission.getName());
                companyPermissionDTO.setSortNo(permission.getSortNo());
                companyPermissionDTO.setIcon(permission.getIcon());
                companyPermissionDTO.setIconColor(permission.getIconColor());
                companyPermissionDTO.setRuleFlag(permission.getRuleFlag());
                companyPermissionDTO.setStatus(permission.getStatus());
                companyPermissionDTO.setDeleted(CommonConstant.DEL_FLAG_0);
                companyPermissionDTO.setUpdateTime(new Date());
                companyPermissionDTO.setCreateBy(createBy);
                companyPermissionDTO.setUpdateBy(updateBy);
                companyPermissions.add(companyPermissionDTO);
            }
            if (!companyPermissions.isEmpty()) {
                companyPermissions = this.supplierInvokeAccountRpcService.insertCompanyMenuBatch(companyPermissions);
                ArrayList companyPermissionList = Lists.newArrayList();
                for (CompanyPermissionDTO companyPermission : companyPermissions) {
                    RolePermissionDTO rolePermission = new RolePermissionDTO();
                    rolePermission.setElsAccount(elsAccount);
                    rolePermission.setRoleId(roleId);
                    rolePermission.setPermissionId(companyPermission.getPermissionId());
                    companyPermissionList.add(rolePermission);
                }
                if (CollUtil.isNotEmpty((Collection)companyPermissionList)) {
                    this.supplierInvokeAccountRpcService.batchSaveRolePermission(companyPermissionList);
                }
            }
        }
    }

    @Override
    public Member getByElsAccount(String elsAccount) {
        return (Member)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)elsAccount), false));
    }

    @Override
    public void deleteMemberPermission(String elsAccount, String roleId) {
        ((MemberMapper)this.baseMapper).deleteMemberPermission(elsAccount, roleId);
    }

    @Override
    public Result<?> appointDemo(LoginModelExtent loginModel) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)loginModel.getSubAccount()), (String)"\u8bf7\u5b8c\u5584\u7533\u8bf7\u4fe1\u606f", (Object[])new Object[0]);
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)loginModel.getCompanyName()), (String)"\u8bf7\u5b8c\u5584\u7533\u8bf7\u4fe1\u606f", (Object[])new Object[0]);
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)loginModel.getContactsName()), (String)"\u8bf7\u5b8c\u5584\u7533\u8bf7\u4fe1\u606f", (Object[])new Object[0]);
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)loginModel.getCaptcha()), (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkUserIsEffective(loginModel);
        String companyRedisKey = "mcn:demo_appoint:" + loginModel.getCompanyName();
        String subAccountRedisKey = "mcn:demo_appoint:" + loginModel.getSubAccount();
        Assert.isTrue((boolean)ObjectUtil.isEmpty((Object)this.redisUtil.get(companyRedisKey)), (String)"\u5f53\u5929\u8bf7\u52ff\u91cd\u590d\u9884\u7ea6", (Object[])new Object[0]);
        Assert.isTrue((boolean)ObjectUtil.isEmpty((Object)this.redisUtil.get(subAccountRedisKey)), (String)"\u5f53\u5929\u8bf7\u52ff\u91cd\u590d\u9884\u7ea6", (Object[])new Object[0]);
        ElsEmailConfigDTO config = this.invokeBaseRpcService.getEmailConfig(TenantContext.getTenant());
        List dictModels = this.dictService.queryDictItemsByCode("mcnMemberAccountNotice", "100000");
        DictModel dictModel = dictModels.stream().filter(x -> "EmailAccount".equals(x.getText())).findFirst().get();
        String smsTemplate = "\u4f01\u4e1a\u540d\u79f0\uff1a#{[companyName]}<br>\u59d3\u540d\uff1a#{[applyName]}<br>\u8054\u7cfb\u624b\u673a\uff1a#{[mobile]}<br>\u63d0\u4ea4\u65f6\u95f4\uff1a#{[applyTime]}<br>\u7559\u8a00\uff1a#{[content]}";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("companyName", loginModel.getCompanyName());
        params.put("applyName", loginModel.getContactsName());
        params.put("mobile", loginModel.getSubAccount());
        params.put("applyTime", DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        params.put("content", loginModel.getContent());
        SpelExpressionParser parser = new SpelExpressionParser();
        TemplateParserContext parserContext = new TemplateParserContext();
        String content = (String)parser.parseExpression(smsTemplate, (ParserContext)parserContext).getValue(params, String.class);
        AppointDemo appointDemo = new AppointDemo();
        BeanUtil.copyProperties((Object)((Object)loginModel), (Object)((Object)appointDemo), (String[])new String[0]);
        appointDemo.setElsAccount("100000");
        this.appointDemoService.save((Object)appointDemo);
        MemberServiceImpl.sendEmail(config, dictModel.getValue().split(","), "\u8fbe\u4eba\u901a\u9884\u7ea6\u6f14\u793a\u7533\u8bf7", content, null, false);
        Calendar curDate = Calendar.getInstance();
        GregorianCalendar tomorrowDate = new GregorianCalendar(curDate.get(1), curDate.get(2), curDate.get(5) + 1, 0, 0, 0);
        int second = (int)(tomorrowDate.getTimeInMillis() - curDate.getTimeInMillis()) / 1000;
        this.redisUtil.set(companyRedisKey, (Object)"1", (long)second);
        this.redisUtil.set(subAccountRedisKey, (Object)"1", (long)second);
        return Result.ok((String)"\u5df2\u6210\u529f\u9884\u7ea6");
    }

    public static boolean sendEmail(ElsEmailConfigDTO config, String[] to, String subject, String content, String cc, boolean needCc) {
        JavaMailSender mailSender = EmailBuilder.buildJavaMailSender((ElsEmailConfigDTO)config);
        MimeMessage message = mailSender.createMimeMessage();
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(content, true);
            helper.setFrom(config.getEmailUsername());
            if (needCc) {
                helper.setCc(cc.split(","));
            }
        }
        catch (Exception var11) {
            log.error("EmailBuilder==>sendEmail:", (Throwable)var11);
        }
        try {
            mailSender.send(message);
            return true;
        }
        catch (Exception var10) {
            return false;
        }
    }

    private String getFilePath() {
        String bizPath = "files";
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
        String nowDay = dtf.format(time);
        String elsAccount = TenantContext.getTenant();
        return File.separator + bizPath + File.separator + elsAccount + File.separator + nowDay;
    }

    private JSONObject getIpaaSData(String companyName, String sourceType, String elsAccount) {
        JSONObject data = new JSONObject();
        JSONObject base = new JSONObject();
        base.put("keyword", (Object)companyName);
        JSONObject body = new JSONObject();
        body.put("channel", (Object)sourceType);
        String auth = SourceTypeEnum.BUSINESS_PROMOTION.getValue().equals(sourceType) || SourceTypeEnum.OPEN_REGISTER.getValue().equals(sourceType) ? "1" : "0";
        body.put("auth", (Object)auth);
        body.put("failIsCreateAccount", (Object)"0");
        data.put("base", (Object)base);
        data.put("body", (Object)body);
        data.put("currentAccount", (Object)elsAccount);
        return data;
    }
}

