/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.rpc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SpringContextUtils;
import com.els.modules.demand.api.dto.PurchaseRequestItemDTO;
import com.els.modules.sample.entity.PurchaseSampleHead;
import com.els.modules.sample.entity.PurchaseSampleItem;
import com.els.modules.sample.entity.SaleSampleHead;
import com.els.modules.sample.enumerate.PurchaseSampleStatusEnum;
import com.els.modules.sample.enumerate.PurchaseSampleStatusItemEnum;
import com.els.modules.sample.rpc.service.PurchaseSampleItemRpcService;
import com.els.modules.sample.service.PurchaseSampleHeadService;
import com.els.modules.sample.service.PurchaseSampleItemService;
import com.els.modules.sample.service.SaleSampleHeadService;
import com.els.modules.sample.service.impl.SaleSampleHeadServiceImpl;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="purchaseSampleItemRpcService")
public class PurchaseSampleItemRpcBeanServiceImpl
implements PurchaseSampleItemRpcService {
    @Resource
    private PurchaseSampleItemService purchaseSampleItemService;
    @Resource
    private PurchaseSampleHeadService purchaseSampleHeadService;

    public Boolean returnItem(String sampleItemId) {
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseSampleItemService.lambdaUpdate().eq(BaseEntity::getId, (Object)sampleItemId)).set(PurchaseSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.DEMAND_RETURN.getValue())).update();
    }

    public Boolean deliverySampleItem(String sampleHeadId, String sampleItemId) {
        if (StringUtils.isBlank((CharSequence)sampleHeadId) && StringUtils.isBlank((CharSequence)sampleItemId)) {
            return false;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseSampleItemService.lambdaUpdate().eq(BaseEntity::getId, (Object)sampleItemId)).set(PurchaseSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.SAMPLE_DELIVERY.getValue())).update();
        List purchaseSampleItems1 = this.purchaseSampleItemService.selectByMainId(sampleHeadId);
        if (purchaseSampleItems1.size() == purchaseSampleItems1.parallelStream().filter(vo -> PurchaseSampleStatusItemEnum.CLOSE.getValue().equals(vo.getItemStatus())).collect(Collectors.toList()).size() + purchaseSampleItems1.parallelStream().filter(vo -> PurchaseSampleStatusItemEnum.SAMPLE_DELIVERY.getValue().equals(vo.getItemStatus())).collect(Collectors.toList()).size()) {
            UpdateWrapper updateHeadWrapper = new UpdateWrapper();
            updateHeadWrapper.lambda().eq(BaseEntity::getId, (Object)sampleHeadId);
            updateHeadWrapper.lambda().set(PurchaseSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.SAMPLE_DELIVERY.getValue());
            this.purchaseSampleHeadService.update((Wrapper)updateHeadWrapper);
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.lambda().eq(SaleSampleHead::getRelationId, (Object)sampleHeadId);
            updateWrapper.lambda().set(SaleSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.SAMPLE_DELIVERY.getValue());
            SaleSampleHeadService saleSampleheadService = (SaleSampleHeadService)SpringContextUtils.getBean(SaleSampleHeadServiceImpl.class);
            saleSampleheadService.update((Wrapper)updateWrapper);
        }
        return true;
    }

    public void updateDeliveryToSample(List<JSONObject> dtoList) {
        List itemDTOList = JSONArray.parseArray((String)JSONArray.toJSONString(dtoList), PurchaseRequestItemDTO.class);
        Map<String, List<PurchaseRequestItemDTO>> groupList = itemDTOList.stream().collect(Collectors.groupingBy(PurchaseRequestItemDTO::getSourceId));
        for (Map.Entry<String, List<PurchaseRequestItemDTO>> entry : groupList.entrySet()) {
            List sampleItemList = entry.getValue().parallelStream().map(PurchaseRequestItemDTO::getSourceItemId).collect(Collectors.toList());
            this.purchaseSampleHeadService.deliveryByOrder(sampleItemList, entry.getKey());
        }
    }
}

