/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.report.job;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.BaseDTO;
import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.delivery.api.dto.PurchaseDeliveryHeadDTO;
import com.els.modules.delivery.api.dto.PurchaseDeliveryItemDTO;
import com.els.modules.delivery.api.dto.PurchaseDeliveryNoticeDTO;
import com.els.modules.delivery.api.dto.PurchaseOrderDeliveryPlanDTO;
import com.els.modules.delivery.api.dto.PurchaseVoucherItemDTO;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.report.entity.ElsQuantityToleranceSetting;
import com.els.modules.report.entity.ElsTimeToleranceSetting;
import com.els.modules.report.entity.ElsTimeWindowSetting;
import com.els.modules.report.entity.PurchasePerformanceDetailReport;
import com.els.modules.report.entity.SalePerformanceDetailReport;
import com.els.modules.report.enumerate.AppealStatusEnum;
import com.els.modules.report.enumerate.PerformanceDeduceResultEnum;
import com.els.modules.report.enumerate.QuantityDeduceResultEnum;
import com.els.modules.report.enumerate.TimeDeduceResultEnum;
import com.els.modules.report.enumerate.TimeWindowTypeEnum;
import com.els.modules.report.mapper.ElsQuantityToleranceSettingMapper;
import com.els.modules.report.mapper.ElsTimeToleranceSettingMapper;
import com.els.modules.report.mapper.ElsTimeWindowSettingMapper;
import com.els.modules.report.mapper.PurchasePerformanceDetailReportMapper;
import com.els.modules.report.mapper.SalePerformanceDetailReportMapper;
import com.els.modules.report.rpc.service.InvokeOrderRpcService;
import com.els.modules.report.rpc.service.ReportInvokeSupplierRpcService;
import com.els.modules.report.service.PurchasePerformanceDetailReportService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service(value="PerformanceDetailScheduleJob")
public class PerformanceDetailScheduleJob
implements JobRpcService {
    private final Integer pageSize = 100;
    private static final Logger logger = LoggerFactory.getLogger(PerformanceDetailScheduleJob.class);
    @Autowired
    private PurchasePerformanceDetailReportMapper purchasePerformanceDetailReportMapper;
    @Autowired
    private PlatformTransactionManager txManager;
    @Autowired
    private RedisUtil redisUtil;
    private final String LOCK_PREFIX = "performanceDetail_schedule_";
    private final long EXPIRE_TIME = 50000L;
    @Autowired
    private InvokeOrderRpcService invokeOrderRpcService;
    @Autowired
    @Qualifier(value="reportInvokerSupplierRpcServiceImplReport")
    private ReportInvokeSupplierRpcService reportInvokeSupplierRpcService;

    @Async
    public void execute(String parameter) {
        TransactionStatus status;
        block13: {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(0);
            status = this.txManager.getTransaction((TransactionDefinition)def);
            JSONObject paramObj = JSONObject.parseObject((String)parameter);
            String tenantId = paramObj.getString("tenantId");
            if (StrUtil.isBlank((CharSequence)tenantId)) {
                tenantId = "100000";
            }
            String lockKey = "performanceDetail_schedule_" + paramObj.getString("tenantId");
            String requestId = UUID.randomUUID().toString();
            try {
                if (this.redisUtil.tryGetDistributedLock(lockKey, requestId, 50000L)) {
                    int i;
                    int totalPageNum;
                    logger.info(" \u7ee9\u6548\u62a5\u8868\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1 PerformanceDetailScheduleJob \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
                    TenantContext.setTenant((String)tenantId);
                    LambdaQueryWrapper purchasePerformanceDetailReportLambdaQueryWrapper = new LambdaQueryWrapper();
                    purchasePerformanceDetailReportLambdaQueryWrapper.eq(PurchasePerformanceDetailReport::getIsPerformance, (Object)"0");
                    purchasePerformanceDetailReportLambdaQueryWrapper.eq(PurchasePerformanceDetailReport::getQuantityDeduce, (Object)QuantityDeduceResultEnum.UN_ACCEPTABLE.getValue());
                    Integer deliveryPlanTotalRecord = this.invokeOrderRpcService.selectOrderDeliveryPlanConfirmCount();
                    Integer deliveryNoticeTotalRecord = this.invokeOrderRpcService.selectDeliveryNoticeConfirmCount();
                    Integer performanceDetailRecord = this.purchasePerformanceDetailReportMapper.selectCount((Wrapper)purchasePerformanceDetailReportLambdaQueryWrapper);
                    if (deliveryPlanTotalRecord > 0) {
                        totalPageNum = (deliveryPlanTotalRecord + this.pageSize - 1) / this.pageSize;
                        for (i = 0; i < totalPageNum; ++i) {
                            List purchaseOrderDeliveryPlanList = this.invokeOrderRpcService.selectPurchaseOrderDeliveryPlanByPage("limit " + i * this.pageSize + "," + this.pageSize);
                            this.doPurchaseOrderDeliveryPlanDTO(purchaseOrderDeliveryPlanList);
                        }
                    }
                    if (deliveryNoticeTotalRecord > 0) {
                        totalPageNum = (deliveryNoticeTotalRecord + this.pageSize - 1) / this.pageSize;
                        for (i = 0; i < totalPageNum; ++i) {
                            List purchaseDeliveryNoticeList = this.invokeOrderRpcService.selectPurchaseDeliveryNoticeByPage("limit " + i * this.pageSize + "," + this.pageSize);
                            this.doDeliveryNoticePlan(purchaseDeliveryNoticeList);
                        }
                    }
                    if (performanceDetailRecord > 0) {
                        totalPageNum = (performanceDetailRecord + this.pageSize - 1) / this.pageSize;
                        for (i = 0; i < totalPageNum; ++i) {
                            purchasePerformanceDetailReportLambdaQueryWrapper.last("limit " + i * this.pageSize + "," + this.pageSize);
                            List purchasePerformanceDetailReportList = ((PurchasePerformanceDetailReportMapper)SpringContextUtils.getBean(PurchasePerformanceDetailReportMapper.class)).selectList((Wrapper)purchasePerformanceDetailReportLambdaQueryWrapper);
                            this.doUpdatePerformanceReportData(purchasePerformanceDetailReportList);
                        }
                    }
                    logger.info(" \u7ee9\u6548\u62a5\u8868\u660e\u7ec6\u5b9a\u65f6\u4efb\u52a1 PerformanceDetailScheduleJob \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
                    break block13;
                }
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_tXRHiKRcsWVxPVBRc_ec23d2d0", (String)"\u7ee9\u6548\u660e\u7ec6\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
            }
            catch (Exception e) {
                this.txManager.rollback(status);
                logger.info(Thread.currentThread().getName() + "\u5904\u7406\u4ea4\u8d27\u8ba1\u5212\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
                throw e;
            }
            finally {
                this.redisUtil.releaseDistributedLock(lockKey, requestId);
            }
        }
        this.txManager.commit(status);
    }

    private void doUpdatePerformanceReportData(List<PurchasePerformanceDetailReport> purchasePerformanceDetailReportList) {
        PurchasePerformanceDetailReport dbPurchasePerformancDetailReport;
        if (CollectionUtil.isEmpty(purchasePerformanceDetailReportList)) {
            return;
        }
        List<PurchasePerformanceDetailReport> performanceDetailReportByDeliveryPlanList = purchasePerformanceDetailReportList.stream().filter(item -> "deliveryPlan".equals(item.getSourceType())).collect(Collectors.toList());
        List<PurchasePerformanceDetailReport> performanceDetailReportByDeliveryNoticeList = purchasePerformanceDetailReportList.stream().filter(item -> "deliveryNotice".equals(item.getSourceType())).collect(Collectors.toList());
        List orderDeliveryPlanIds = null;
        List deliveryNoticeIds = null;
        if (CollectionUtil.isNotEmpty(performanceDetailReportByDeliveryPlanList)) {
            orderDeliveryPlanIds = performanceDetailReportByDeliveryPlanList.stream().map(PurchasePerformanceDetailReport::getSourceId).collect(Collectors.toList());
        }
        if (CollectionUtil.isNotEmpty(performanceDetailReportByDeliveryNoticeList)) {
            deliveryNoticeIds = performanceDetailReportByDeliveryNoticeList.stream().map(PurchasePerformanceDetailReport::getSourceId).collect(Collectors.toList());
        }
        List purchaseOrderDeliveryPlanList = null;
        List deliveryNoticeList = null;
        if (CollectionUtil.isNotEmpty(orderDeliveryPlanIds)) {
            purchaseOrderDeliveryPlanList = this.invokeOrderRpcService.selectPurchaseOrderDeliveryPlanByIds(orderDeliveryPlanIds);
        }
        if (CollectionUtil.isNotEmpty(deliveryNoticeIds)) {
            deliveryNoticeList = this.invokeOrderRpcService.selectPurchaseDeliveryNoticeByIds(deliveryNoticeIds);
        }
        List<PurchasePerformanceDetailReport> updataPerformanceDetailReportByDeliveryPlanList = this.packagePerformanceDetaiListData(purchaseOrderDeliveryPlanList);
        List<PurchasePerformanceDetailReport> updataPerformanceDetailReportByDeliveryNoticeList = this.packagePerformanceDetaiListData2DeliveryNotice(deliveryNoticeList);
        Map<String, PurchasePerformanceDetailReport> performanceDetailReportByDeliveryPlanMap = this.getPerformanceDetailReportMap(performanceDetailReportByDeliveryPlanList);
        Map<String, PurchasePerformanceDetailReport> performanceDetailReportByDeliveryNoticeMap = this.getPerformanceDetailReportMap(performanceDetailReportByDeliveryNoticeList);
        ArrayList<PurchasePerformanceDetailReport> purchasePerformanceDetailReports = new ArrayList<PurchasePerformanceDetailReport>();
        for (PurchasePerformanceDetailReport purchasePerformanceDetailReport : updataPerformanceDetailReportByDeliveryPlanList) {
            if (performanceDetailReportByDeliveryPlanMap == null || (dbPurchasePerformancDetailReport = performanceDetailReportByDeliveryPlanMap.get(purchasePerformanceDetailReport.getSourceId())) == null) continue;
            purchasePerformanceDetailReport.setId(dbPurchasePerformancDetailReport.getId());
            purchasePerformanceDetailReport.setCreateTime(null);
            purchasePerformanceDetailReports.add(purchasePerformanceDetailReport);
        }
        for (PurchasePerformanceDetailReport purchasePerformanceDetailReport : updataPerformanceDetailReportByDeliveryNoticeList) {
            if (performanceDetailReportByDeliveryNoticeMap == null || (dbPurchasePerformancDetailReport = performanceDetailReportByDeliveryNoticeMap.get(purchasePerformanceDetailReport.getSourceId())) == null) continue;
            purchasePerformanceDetailReport.setId(dbPurchasePerformancDetailReport.getId());
            purchasePerformanceDetailReport.setCreateTime(null);
            purchasePerformanceDetailReports.add(purchasePerformanceDetailReport);
        }
        ((PurchasePerformanceDetailReportService)SpringContextUtils.getBean(PurchasePerformanceDetailReportService.class)).updateBatchById(purchasePerformanceDetailReports);
    }

    private Map<String, PurchasePerformanceDetailReport> getPerformanceDetailReportMap(List<PurchasePerformanceDetailReport> updataPerformanceDetailReportByDeliveryPlanList) {
        if (CollectionUtil.isEmpty(updataPerformanceDetailReportByDeliveryPlanList)) {
            return null;
        }
        return updataPerformanceDetailReportByDeliveryPlanList.stream().collect(Collectors.toMap(PurchasePerformanceDetailReport::getSourceId, Function.identity()));
    }

    private void doPurchaseOrderDeliveryPlanDTO(List<PurchaseOrderDeliveryPlanDTO> purchaseOrderDeliveryPlanList) {
        if (CollectionUtil.isEmpty(purchaseOrderDeliveryPlanList)) {
            return;
        }
        try {
            List<PurchasePerformanceDetailReport> purchasePerformanceDetailReportList = this.packagePerformanceDetaiListData(purchaseOrderDeliveryPlanList);
            ArrayList<PurchaseOrderDeliveryPlanDTO> purchaseOrderDeliveryPlanList1 = new ArrayList<PurchaseOrderDeliveryPlanDTO>();
            if (CollectionUtil.isNotEmpty(purchasePerformanceDetailReportList)) {
                ArrayList<SalePerformanceDetailReport> salePerformanceDetailReportList = new ArrayList<SalePerformanceDetailReport>();
                for (PurchasePerformanceDetailReport performanceDetailReport : purchasePerformanceDetailReportList) {
                    performanceDetailReport.setRelationId(IdWorker.getIdStr());
                    SalePerformanceDetailReport salePerformanceDetailReport = new SalePerformanceDetailReport();
                    BeanUtils.copyProperties((Object)performanceDetailReport, (Object)salePerformanceDetailReport);
                    salePerformanceDetailReport.setId(performanceDetailReport.getRelationId());
                    salePerformanceDetailReport.setRelationId(performanceDetailReport.getId());
                    salePerformanceDetailReport.setElsAccount(performanceDetailReport.getToElsAccount());
                    salePerformanceDetailReport.setToElsAccount(performanceDetailReport.getElsAccount());
                    salePerformanceDetailReportList.add(salePerformanceDetailReport);
                }
                ((PurchasePerformanceDetailReportMapper)SpringContextUtils.getBean(PurchasePerformanceDetailReportMapper.class)).insertBatchSomeColumn(purchasePerformanceDetailReportList);
                ((SalePerformanceDetailReportMapper)SpringContextUtils.getBean(SalePerformanceDetailReportMapper.class)).insertBatchSomeColumn(salePerformanceDetailReportList);
                for (PurchasePerformanceDetailReport performanceDetailReport : purchasePerformanceDetailReportList) {
                    PurchaseOrderDeliveryPlanDTO tempDeliveryPlan = new PurchaseOrderDeliveryPlanDTO();
                    tempDeliveryPlan.setId(performanceDetailReport.getSourceId());
                    tempDeliveryPlan.setIsPerformance("1");
                    purchaseOrderDeliveryPlanList1.add(tempDeliveryPlan);
                }
                this.invokeOrderRpcService.updatePurchaseOrderDeliveryPlanByIds(purchaseOrderDeliveryPlanList1);
            }
        }
        catch (Exception e) {
            logger.info(Thread.currentThread().getName() + "\u5904\u7406\u4ea4\u8d27\u8ba1\u5212\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
    }

    private void doDeliveryNoticePlan(List<PurchaseDeliveryNoticeDTO> purchaseDeliveryNoticeList) {
        if (CollectionUtil.isEmpty(purchaseDeliveryNoticeList)) {
            return;
        }
        try {
            List<PurchasePerformanceDetailReport> purchasePerformanceDetailReportList = this.packagePerformanceDetaiListData2DeliveryNotice(purchaseDeliveryNoticeList);
            ArrayList<PurchaseDeliveryNoticeDTO> purchaseDeliveryNotices = new ArrayList<PurchaseDeliveryNoticeDTO>();
            if (CollectionUtil.isNotEmpty(purchasePerformanceDetailReportList)) {
                ArrayList<SalePerformanceDetailReport> salePerformanceDetailReportList = new ArrayList<SalePerformanceDetailReport>();
                for (PurchasePerformanceDetailReport performanceDetailReport : purchasePerformanceDetailReportList) {
                    performanceDetailReport.setRelationId(IdWorker.getIdStr());
                    SalePerformanceDetailReport salePerformanceDetailReport = new SalePerformanceDetailReport();
                    BeanUtils.copyProperties((Object)performanceDetailReport, (Object)salePerformanceDetailReport);
                    salePerformanceDetailReport.setId(performanceDetailReport.getRelationId());
                    salePerformanceDetailReport.setRelationId(performanceDetailReport.getId());
                    salePerformanceDetailReport.setElsAccount(performanceDetailReport.getToElsAccount());
                    salePerformanceDetailReport.setToElsAccount(performanceDetailReport.getElsAccount());
                    salePerformanceDetailReportList.add(salePerformanceDetailReport);
                }
                ((PurchasePerformanceDetailReportMapper)SpringContextUtils.getBean(PurchasePerformanceDetailReportMapper.class)).insertBatchSomeColumn(purchasePerformanceDetailReportList);
                ((SalePerformanceDetailReportMapper)SpringContextUtils.getBean(SalePerformanceDetailReportMapper.class)).insertBatchSomeColumn(salePerformanceDetailReportList);
                for (PurchasePerformanceDetailReport performanceDetailReport : purchasePerformanceDetailReportList) {
                    PurchaseDeliveryNoticeDTO tempDeliveryNotice = new PurchaseDeliveryNoticeDTO();
                    tempDeliveryNotice.setId(performanceDetailReport.getSourceId());
                    tempDeliveryNotice.setIsPerformance("1");
                    purchaseDeliveryNotices.add(tempDeliveryNotice);
                }
                this.invokeOrderRpcService.updatePurchaseDeliveryNotivceByIds(purchaseDeliveryNotices);
            }
        }
        catch (Exception e) {
            logger.info(Thread.currentThread().getName() + "\u5904\u7406\u9001\u8d27\u901a\u77e5\u5355\u8ba1\u5212\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
    }

    private List<PurchasePerformanceDetailReport> packagePerformanceDetaiListData2DeliveryNotice(List<PurchaseDeliveryNoticeDTO> purchaseDeliveryNoticeList) {
        List<String> toElsAccounts = purchaseDeliveryNoticeList.stream().map(PurchaseDeliveryNoticeDTO::getToElsAccount).distinct().collect(Collectors.toList());
        Map<String, SupplierMasterDataDTO> supplierMasterDataMap = this.getSupplierMasterDataDTO(toElsAccounts);
        Map<String, ElsQuantityToleranceSetting> elsQuantityToleranceMap = this.getElsQuantityToleranceMap(toElsAccounts, supplierMasterDataMap);
        Map<String, ElsTimeToleranceSetting> elsTimeToleranceMap = this.getElsTimeToleranceMap(toElsAccounts, supplierMasterDataMap);
        Map<String, ElsTimeWindowSetting> elsTimeWindowSettingPerformanceAppealMap = this.getElsTimeWindowByTypeMap(toElsAccounts, TimeWindowTypeEnum.PERFORMANCE_APPEAL.getValue(), supplierMasterDataMap);
        Map<String, ElsTimeWindowSetting> elsTimeWindowSettingPerformanceReplyMap = this.getElsTimeWindowByTypeMap(toElsAccounts, TimeWindowTypeEnum.PERFORMANCE_REPLY.getValue(), supplierMasterDataMap);
        ArrayList<PurchasePerformanceDetailReport> purchasePerformanceDetailReportList = new ArrayList<PurchasePerformanceDetailReport>();
        List ids = purchaseDeliveryNoticeList.stream().map(BaseDTO::getId).distinct().collect(Collectors.toList());
        List purchaseDeliveryItemList = this.invokeOrderRpcService.selectDeliveryItemList(ids);
        Map<String, List<PurchaseDeliveryItemDTO>> deliveryItemListMap = null;
        Map<String, PurchaseDeliveryHeadDTO> deliveryHeadMap = null;
        if (CollectionUtil.isNotEmpty((Collection)purchaseDeliveryItemList)) {
            List headIds = purchaseDeliveryItemList.stream().map(PurchaseDeliveryItemDTO::getHeadId).collect(Collectors.toList());
            List purchaseDeliveryHeads = this.invokeOrderRpcService.selectPurcherDeliveryHeadByBatchIds(headIds);
            deliveryItemListMap = purchaseDeliveryItemList.stream().collect(Collectors.groupingBy(PurchaseDeliveryItemDTO::getSourceId));
            deliveryHeadMap = purchaseDeliveryHeads.stream().collect(Collectors.toMap(BaseDTO::getId, Function.identity()));
        }
        List purchaseVoucherItems = this.invokeOrderRpcService.selectVoucherItemListByDeliverySourceIds(ids);
        List orderHeadIds = purchaseVoucherItems.stream().map(PurchaseVoucherItemDTO::getOrderId).collect(Collectors.toList());
        List purchaseOrderHeadList = this.invokeOrderRpcService.selectPurchaseOrderHeadByIds(orderHeadIds);
        Map purchaseVoucherItemMap = purchaseVoucherItems.stream().collect(Collectors.groupingBy(voucherItem -> voucherItem.getDeliverySourceId(), Collectors.toList()));
        Map<String, PurchaseOrderHeadDTO> purchaseOrderHeadMap = purchaseOrderHeadList.stream().collect(Collectors.toMap(BaseDTO::getId, Function.identity()));
        for (PurchaseDeliveryNoticeDTO purchaseDeliveryNotice : purchaseDeliveryNoticeList) {
            Long difDate;
            List<PurchaseDeliveryHeadDTO> dbPurchaseDeliveryHeadDTOList = null;
            List<PurchaseDeliveryItemDTO> dbPurchaseDeliveryItemDTOList = null;
            if (deliveryItemListMap != null) {
                dbPurchaseDeliveryItemDTOList = deliveryItemListMap.get(purchaseDeliveryNotice.getId());
            }
            if (deliveryHeadMap != null) {
                dbPurchaseDeliveryHeadDTOList = this.getDelivryHeadList(dbPurchaseDeliveryItemDTOList, deliveryHeadMap);
            }
            SupplierMasterDataDTO supplierMasterData = null;
            if (supplierMasterDataMap != null) {
                supplierMasterData = supplierMasterDataMap.get(purchaseDeliveryNotice.getToElsAccount());
            }
            List<PurchaseVoucherItemDTO> purchaseVoucherItemList = purchaseVoucherItemMap.get(purchaseDeliveryNotice.getId());
            List<PurchaseOrderHeadDTO> purchaseOrderHeads = this.getPurchaseOrderHeadDTOByVoucherItem(purchaseVoucherItemList, purchaseOrderHeadMap);
            PurchaseVoucherItemDTO postDateMaxVoucherItem = this.getPostDateMaxVoucherItem(purchaseVoucherItemList);
            PurchasePerformanceDetailReport purchasePerformanceDetailReport = new PurchasePerformanceDetailReport();
            purchasePerformanceDetailReport.setElsAccount(TenantContext.getTenant());
            purchasePerformanceDetailReport.setNoticeNumber(purchaseDeliveryNotice.getNoticeNumber());
            purchasePerformanceDetailReport.setPerformanceBaseDate(purchaseDeliveryNotice.getPerformanceBaseDate());
            PurchaseDeliveryHeadDTO arriveDateMaxFromDeliveryHead = this.getArriveDateMaxFromDeliveryHead(dbPurchaseDeliveryHeadDTOList);
            if (arriveDateMaxFromDeliveryHead != null) {
                purchasePerformanceDetailReport.setArriveDate(arriveDateMaxFromDeliveryHead.getArriveDate());
            }
            purchasePerformanceDetailReport.setVoucherNumber(this.parseListToStr2(purchaseVoucherItemList));
            if (postDateMaxVoucherItem != null) {
                purchasePerformanceDetailReport.setPostDate(postDateMaxVoucherItem.getPostDate());
            }
            if ((difDate = this.getDifDate(purchasePerformanceDetailReport)) != null) {
                purchasePerformanceDetailReport.setDifDate(Integer.valueOf(difDate.intValue()));
            }
            purchasePerformanceDetailReport.setTimeDeduce(this.timeDeduce(difDate, elsTimeToleranceMap.get(purchaseDeliveryNotice.getToElsAccount())));
            purchasePerformanceDetailReport.setQuantity(purchaseDeliveryNotice.getRequireQuantity());
            purchasePerformanceDetailReport.setReceiceQuantity(purchaseDeliveryNotice.getReceiveQuantity());
            purchasePerformanceDetailReport.setQuantityDeduce(this.quantityDeduce(purchasePerformanceDetailReport, elsQuantityToleranceMap.get(purchaseDeliveryNotice.getToElsAccount())));
            purchasePerformanceDetailReport.setPerformanceDeduce(this.performanceDeduce(purchasePerformanceDetailReport));
            purchasePerformanceDetailReport.setOrderNumber(this.parseOrderNumberToStr(purchaseVoucherItemList));
            purchasePerformanceDetailReport.setOrderItemNumber(this.parseOrderItemNumberToStr(purchaseVoucherItemList));
            purchasePerformanceDetailReport.setPurchasePrincipal(this.parsePurchasePricipayByOrderToStr(purchaseOrderHeads));
            if (CollectionUtil.isNotEmpty(dbPurchaseDeliveryItemDTOList)) {
                purchasePerformanceDetailReport.setMaterialNumber(dbPurchaseDeliveryItemDTOList.get(0).getMaterialNumber());
                purchasePerformanceDetailReport.setMaterialDesc(dbPurchaseDeliveryItemDTOList.get(0).getMaterialDesc());
                purchasePerformanceDetailReport.setFactory(dbPurchaseDeliveryItemDTOList.get(0).getFactory());
                purchasePerformanceDetailReport.setStorageLocation(dbPurchaseDeliveryItemDTOList.get(0).getStorageLocation());
                purchasePerformanceDetailReport.setPurchaseUnit(dbPurchaseDeliveryItemDTOList.get(0).getPurchaseUnit());
            }
            purchasePerformanceDetailReport.setJit("1");
            purchasePerformanceDetailReport.setSupplierCode(purchaseDeliveryNotice.getSupplierCode());
            purchasePerformanceDetailReport.setSupplierName(purchaseDeliveryNotice.getSupplierName());
            purchasePerformanceDetailReport.setMobileType("101");
            purchasePerformanceDetailReport.setLoanDirection("+");
            purchasePerformanceDetailReport.setId(IdWorker.getIdStr());
            purchasePerformanceDetailReport.setSourceType("deliveryNotice");
            purchasePerformanceDetailReport.setSourceId(purchaseDeliveryNotice.getId());
            purchasePerformanceDetailReport.setRefVoucherNumber(this.parseRefVoucherToStr(purchaseVoucherItemList));
            purchasePerformanceDetailReport.setCreateTime(new Date());
            purchasePerformanceDetailReport.setUpdateTime(new Date());
            purchasePerformanceDetailReport.setToElsAccount(purchaseDeliveryNotice.getToElsAccount());
            purchasePerformanceDetailReport.setDeleted(Integer.valueOf(Integer.parseInt("0")));
            purchasePerformanceDetailReport.setIsPerformance("0");
            if (supplierMasterData != null) {
                purchasePerformanceDetailReport.setAccountGroup(supplierMasterData.getAccountGroup());
            }
            purchasePerformanceDetailReport.setAppealStatus(AppealStatusEnum.NEW.getValue());
            ElsTimeWindowSetting elsTimeWindowPerformanceAppealSetting = elsTimeWindowSettingPerformanceAppealMap.get(purchaseDeliveryNotice.getToElsAccount());
            ElsTimeWindowSetting elsTimeWindoPerformanceReplySetting = elsTimeWindowSettingPerformanceReplyMap.get(purchaseDeliveryNotice.getToElsAccount());
            if (elsTimeWindowPerformanceAppealSetting != null) {
                purchasePerformanceDetailReport.setAppealWindow(elsTimeWindowPerformanceAppealSetting.getTimeWindow().intValue() + "");
                purchasePerformanceDetailReport.setAppealDeadTime((Date)DateUtil.offsetDay((Date)new Date(), (int)elsTimeWindowPerformanceAppealSetting.getTimeWindow().intValue()));
            } else {
                purchasePerformanceDetailReport.setAppealWindow("0");
                purchasePerformanceDetailReport.setAppealDeadTime(new Date());
            }
            if (elsTimeWindoPerformanceReplySetting != null) {
                purchasePerformanceDetailReport.setReplyWindow(elsTimeWindoPerformanceReplySetting.getTimeWindow().intValue() + "");
            } else {
                purchasePerformanceDetailReport.setReplyWindow("0");
            }
            purchasePerformanceDetailReportList.add(purchasePerformanceDetailReport);
        }
        return purchasePerformanceDetailReportList;
    }

    private List<PurchaseOrderHeadDTO> getPurchaseOrderHeadDTOByVoucherItem(List<PurchaseVoucherItemDTO> purchaseVoucherItemList, Map<String, PurchaseOrderHeadDTO> purchaseOrderHeadMap) {
        ArrayList<PurchaseOrderHeadDTO> purchaseOrderHeadList = new ArrayList<PurchaseOrderHeadDTO>();
        if (CollectionUtil.isNotEmpty(purchaseVoucherItemList)) {
            for (PurchaseVoucherItemDTO voucherItem : purchaseVoucherItemList) {
                PurchaseOrderHeadDTO purchaseOrderHead = purchaseOrderHeadMap.get(voucherItem.getOrderId());
                if (purchaseOrderHead == null || purchaseOrderHeadList.contains(purchaseOrderHead)) continue;
                purchaseOrderHeadList.add(purchaseOrderHead);
            }
        }
        return purchaseOrderHeadList;
    }

    private List<PurchasePerformanceDetailReport> packagePerformanceDetaiListData(List<PurchaseOrderDeliveryPlanDTO> purchaseOrderDeliveryPlanList) {
        List<String> toElsAccounts = purchaseOrderDeliveryPlanList.stream().map(PurchaseOrderDeliveryPlanDTO::getToElsAccount).distinct().collect(Collectors.toList());
        Map<String, SupplierMasterDataDTO> supplierMasterDataMap = this.getSupplierMasterDataDTO(toElsAccounts);
        Map<String, ElsQuantityToleranceSetting> elsQuantityToleranceMap = this.getElsQuantityToleranceMap(toElsAccounts, supplierMasterDataMap);
        Map<String, ElsTimeToleranceSetting> elsTimeToleranceMap = this.getElsTimeToleranceMap(toElsAccounts, supplierMasterDataMap);
        Map<String, ElsTimeWindowSetting> elsTimeWindowSettingPerformanceAppealMap = this.getElsTimeWindowByTypeMap(toElsAccounts, TimeWindowTypeEnum.PERFORMANCE_APPEAL.getValue(), supplierMasterDataMap);
        Map<String, ElsTimeWindowSetting> elsTimeWindowSettingPerformanceReplyMap = this.getElsTimeWindowByTypeMap(toElsAccounts, TimeWindowTypeEnum.PERFORMANCE_REPLY.getValue(), supplierMasterDataMap);
        ArrayList<PurchasePerformanceDetailReport> purchasePerformanceDetailReportList = new ArrayList<PurchasePerformanceDetailReport>();
        List ids = purchaseOrderDeliveryPlanList.stream().map(BaseDTO::getId).distinct().collect(Collectors.toList());
        List orderHeadIds = purchaseOrderDeliveryPlanList.stream().map(PurchaseOrderDeliveryPlanDTO::getHeadId).distinct().collect(Collectors.toList());
        List purchaseDeliveryItemList = this.invokeOrderRpcService.selectDeliveryItemList(ids);
        Map<String, List<PurchaseDeliveryItemDTO>> deliveryItemListMap = null;
        Map<String, PurchaseDeliveryHeadDTO> deliveryHeadMap = null;
        if (CollectionUtil.isNotEmpty((Collection)purchaseDeliveryItemList)) {
            List headIds = purchaseDeliveryItemList.stream().map(PurchaseDeliveryItemDTO::getHeadId).collect(Collectors.toList());
            List purchaseDeliveryHeads = this.invokeOrderRpcService.selectPurcherDeliveryHeadByBatchIds(headIds);
            deliveryItemListMap = purchaseDeliveryItemList.stream().collect(Collectors.groupingBy(PurchaseDeliveryItemDTO::getSourceItemId));
            deliveryHeadMap = purchaseDeliveryHeads.stream().collect(Collectors.toMap(BaseDTO::getId, Function.identity()));
        }
        List purchaseOrderHeadList = this.invokeOrderRpcService.selectPurchaseOrderHeadByIds(orderHeadIds);
        List purchaseVoucherItems = this.invokeOrderRpcService.selectVoucherItemListByDeliverySourceIds(ids);
        Map purchaseVoucherItemMap = purchaseVoucherItems.stream().collect(Collectors.groupingBy(voucherItem -> voucherItem.getDeliverySourceId(), Collectors.toList()));
        Map purchaseOrderHeadMap = purchaseOrderHeadList.stream().collect(Collectors.toMap(BaseDTO::getId, Function.identity()));
        for (PurchaseOrderDeliveryPlanDTO purchaseOrderDeliveryPlan : purchaseOrderDeliveryPlanList) {
            Long difDate;
            List<PurchaseDeliveryItemDTO> dbPurchaseDeliveryItemDTOList = null;
            List<PurchaseDeliveryHeadDTO> dbPurchaseDeliveryHeadDTOList = null;
            if (deliveryItemListMap != null) {
                dbPurchaseDeliveryItemDTOList = deliveryItemListMap.get(purchaseOrderDeliveryPlan.getId());
                dbPurchaseDeliveryHeadDTOList = this.getDelivryHeadList(dbPurchaseDeliveryItemDTOList, deliveryHeadMap);
            }
            PurchaseOrderHeadDTO purchaseOrderHead = (PurchaseOrderHeadDTO)purchaseOrderHeadMap.get(purchaseOrderDeliveryPlan.getHeadId());
            SupplierMasterDataDTO supplierMasterData = null;
            if (supplierMasterDataMap != null) {
                supplierMasterData = supplierMasterDataMap.get(purchaseOrderDeliveryPlan.getToElsAccount());
            }
            if (purchaseOrderHead == null) continue;
            List<PurchaseVoucherItemDTO> purchaseVoucherItemList = purchaseVoucherItemMap.get(purchaseOrderDeliveryPlan.getId());
            PurchaseVoucherItemDTO postDateMaxVoucherItem = this.getPostDateMaxVoucherItem(purchaseVoucherItemList);
            PurchasePerformanceDetailReport purchasePerformanceDetailReport = new PurchasePerformanceDetailReport();
            purchasePerformanceDetailReport.setElsAccount(TenantContext.getTenant());
            purchasePerformanceDetailReport.setNoticeNumber(purchaseOrderDeliveryPlan.getId());
            purchasePerformanceDetailReport.setPerformanceBaseDate(purchaseOrderDeliveryPlan.getPerformanceBaseDate());
            PurchaseDeliveryHeadDTO purchaseDeliveryHead = this.getArriveDateMaxFromDeliveryHead(dbPurchaseDeliveryHeadDTOList);
            if (purchaseDeliveryHead != null) {
                purchasePerformanceDetailReport.setArriveDate(this.getArriveDateMaxFromDeliveryHead(dbPurchaseDeliveryHeadDTOList).getArriveDate());
            }
            purchasePerformanceDetailReport.setVoucherNumber(this.parseListToStr2(purchaseVoucherItemList));
            if (postDateMaxVoucherItem != null) {
                purchasePerformanceDetailReport.setPostDate(postDateMaxVoucherItem.getPostDate());
            }
            if ((difDate = this.getDifDate(purchasePerformanceDetailReport)) != null) {
                purchasePerformanceDetailReport.setDifDate(Integer.valueOf(difDate.intValue()));
            }
            purchasePerformanceDetailReport.setTimeDeduce(this.timeDeduce(difDate, elsTimeToleranceMap.get(purchaseOrderDeliveryPlan.getToElsAccount())));
            purchasePerformanceDetailReport.setQuantity(purchaseOrderDeliveryPlan.getPlanDeliveryQuantity());
            purchasePerformanceDetailReport.setReceiceQuantity(purchaseOrderDeliveryPlan.getReceiveQuantity());
            purchasePerformanceDetailReport.setQuantityDeduce(this.quantityDeduce(purchasePerformanceDetailReport, elsQuantityToleranceMap.get(purchaseOrderDeliveryPlan.getToElsAccount())));
            purchasePerformanceDetailReport.setPerformanceDeduce(this.performanceDeduce(purchasePerformanceDetailReport));
            purchasePerformanceDetailReport.setOrderNumber(purchaseOrderDeliveryPlan.getOrderNumber());
            purchasePerformanceDetailReport.setOrderItemNumber(purchaseOrderDeliveryPlan.getOrderItemNumber());
            purchasePerformanceDetailReport.setPurchasePrincipal(purchaseOrderHead.getPurchasePrincipal());
            if (CollectionUtil.isNotEmpty(dbPurchaseDeliveryItemDTOList)) {
                purchasePerformanceDetailReport.setMaterialNumber(dbPurchaseDeliveryItemDTOList.get(0).getMaterialNumber());
                purchasePerformanceDetailReport.setMaterialDesc(dbPurchaseDeliveryItemDTOList.get(0).getMaterialDesc());
                purchasePerformanceDetailReport.setStorageLocation(dbPurchaseDeliveryItemDTOList.get(0).getStorageLocation());
                purchasePerformanceDetailReport.setPurchaseUnit(dbPurchaseDeliveryItemDTOList.get(0).getPurchaseUnit());
                purchasePerformanceDetailReport.setFactory(dbPurchaseDeliveryItemDTOList.get(0).getFactory());
            }
            purchasePerformanceDetailReport.setJit("0");
            purchasePerformanceDetailReport.setSupplierCode(null);
            purchasePerformanceDetailReport.setSupplierName(purchaseOrderHead.getSupplierName());
            purchasePerformanceDetailReport.setMobileType("101");
            purchasePerformanceDetailReport.setLoanDirection("+");
            purchasePerformanceDetailReport.setId(IdWorker.getIdStr());
            purchasePerformanceDetailReport.setSourceType("deliveryPlan");
            purchasePerformanceDetailReport.setSourceId(purchaseOrderDeliveryPlan.getId());
            purchasePerformanceDetailReport.setRefVoucherNumber(this.parseRefVoucherToStr(purchaseVoucherItemList));
            purchasePerformanceDetailReport.setCreateTime(new Date());
            purchasePerformanceDetailReport.setUpdateTime(new Date());
            purchasePerformanceDetailReport.setToElsAccount(purchaseOrderHead.getToElsAccount());
            purchasePerformanceDetailReport.setSupplierCode(purchaseOrderHead.getSupplierCode());
            purchasePerformanceDetailReport.setDeleted(Integer.valueOf(Integer.parseInt("0")));
            purchasePerformanceDetailReport.setIsPerformance("0");
            if (supplierMasterData != null) {
                purchasePerformanceDetailReport.setAccountGroup(supplierMasterData.getAccountGroup());
            }
            purchasePerformanceDetailReport.setAppealStatus(AppealStatusEnum.NEW.getValue());
            ElsTimeWindowSetting elsTimeWindowPerformanceAppealSetting = elsTimeWindowSettingPerformanceAppealMap.get(purchaseOrderHead.getToElsAccount());
            ElsTimeWindowSetting elsTimeWindowPerformanceReplySetting = elsTimeWindowSettingPerformanceReplyMap.get(purchaseOrderHead.getToElsAccount());
            if (elsTimeWindowPerformanceAppealSetting != null) {
                purchasePerformanceDetailReport.setAppealWindow(elsTimeWindowPerformanceAppealSetting.getTimeWindow().intValue() + "");
                purchasePerformanceDetailReport.setAppealDeadTime((Date)DateUtil.offsetDay((Date)new Date(), (int)elsTimeWindowPerformanceAppealSetting.getTimeWindow().intValue()));
            } else {
                purchasePerformanceDetailReport.setAppealWindow("0");
                purchasePerformanceDetailReport.setAppealDeadTime(new Date());
            }
            if (elsTimeWindowPerformanceReplySetting != null) {
                purchasePerformanceDetailReport.setReplyWindow(elsTimeWindowPerformanceReplySetting.getTimeWindow().intValue() + "");
            } else {
                purchasePerformanceDetailReport.setReplyWindow("0");
            }
            purchasePerformanceDetailReportList.add(purchasePerformanceDetailReport);
        }
        return purchasePerformanceDetailReportList;
    }

    private Map<String, SupplierMasterDataDTO> getSupplierMasterDataDTO(List<String> toElsAccounts) {
        List supplierMasterDataList = this.reportInvokeSupplierRpcService.selectSupplerList(TenantContext.getTenant(), toElsAccounts);
        Map<String, Object> supplierMasterDataMap = new HashMap<String, SupplierMasterDataDTO>();
        if (CollectionUtil.isNotEmpty((Collection)supplierMasterDataList)) {
            supplierMasterDataMap = supplierMasterDataList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity()));
        }
        return supplierMasterDataMap;
    }

    private String performanceDeduce(PurchasePerformanceDetailReport purchasePerformanceDetailReport) {
        String quantityDeduce = purchasePerformanceDetailReport.getQuantityDeduce();
        String timeDeduce = purchasePerformanceDetailReport.getTimeDeduce();
        if (TimeDeduceResultEnum.ACCEPTABLE.getValue().equals(timeDeduce) && QuantityDeduceResultEnum.ACCEPTABLE.getValue().equals(quantityDeduce)) {
            return PerformanceDeduceResultEnum.ACCEPTABLE.getValue();
        }
        return PerformanceDeduceResultEnum.UN_ACCEPTABLE.getValue();
    }

    private String quantityDeduce(PurchasePerformanceDetailReport purchasePerformanceDetailReport, ElsQuantityToleranceSetting elsQuantityToleranceSetting) {
        BigDecimal quantity = purchasePerformanceDetailReport.getQuantity();
        BigDecimal receiveQuantity = purchasePerformanceDetailReport.getReceiceQuantity();
        if (quantity == null || receiveQuantity == null) {
            return QuantityDeduceResultEnum.UN_ACCEPTABLE.getValue();
        }
        if (receiveQuantity.compareTo(quantity) >= 0) {
            return QuantityDeduceResultEnum.ACCEPTABLE.getValue();
        }
        return QuantityDeduceResultEnum.UN_ACCEPTABLE.getValue();
    }

    private Long getDifDate(PurchasePerformanceDetailReport purchasePerformanceDetailReport) {
        Date arriveDate = purchasePerformanceDetailReport.getArriveDate();
        Date postDate = purchasePerformanceDetailReport.getPostDate();
        Date performanceBaseDate = purchasePerformanceDetailReport.getPerformanceBaseDate();
        if (performanceBaseDate == null) {
            return null;
        }
        if (arriveDate != null) {
            long between = DateUtil.between((Date)arriveDate, (Date)performanceBaseDate, (DateUnit)DateUnit.DAY, (boolean)false);
            return between;
        }
        if (postDate != null) {
            long between = DateUtil.between((Date)postDate, (Date)performanceBaseDate, (DateUnit)DateUnit.DAY, (boolean)false);
            return between;
        }
        return null;
    }

    private Map<String, ElsTimeWindowSetting> getElsTimeWindowByTypeMap(List<String> toElsAccounts, String type, Map<String, SupplierMasterDataDTO> supplierMasterDataMap) {
        HashMap<String, ElsTimeWindowSetting> elsTimeWindowMap = new HashMap<String, ElsTimeWindowSetting>();
        if (CollectionUtil.isNotEmpty(toElsAccounts)) {
            for (String toElsAccount : toElsAccounts) {
                if (elsTimeWindowMap.containsKey(toElsAccount)) continue;
                LambdaQueryWrapper elsTimeWindowSettingLambdaQueryWrapper = new LambdaQueryWrapper();
                elsTimeWindowSettingLambdaQueryWrapper.eq(BaseEntity::getDeleted, (Object)"0");
                elsTimeWindowSettingLambdaQueryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
                elsTimeWindowSettingLambdaQueryWrapper.eq(ElsTimeWindowSetting::getToElsAccount, (Object)toElsAccount);
                elsTimeWindowSettingLambdaQueryWrapper.eq(ElsTimeWindowSetting::getWindowType, (Object)type);
                ElsTimeWindowSetting elsTimeWindowSetting = (ElsTimeWindowSetting)((ElsTimeWindowSettingMapper)SpringContextUtils.getBean(ElsTimeWindowSettingMapper.class)).selectOne((Wrapper)elsTimeWindowSettingLambdaQueryWrapper);
                if (elsTimeWindowSetting != null) {
                    elsTimeWindowMap.put(toElsAccount, elsTimeWindowSetting);
                    continue;
                }
                SupplierMasterDataDTO supplierMasterData = supplierMasterDataMap.get(toElsAccount);
                if (supplierMasterData == null || !StringUtils.isNotBlank((CharSequence)supplierMasterData.getAccountGroup())) continue;
                LambdaQueryWrapper elsTimeWindowSettingLambdaQueryWrapper1 = new LambdaQueryWrapper();
                elsTimeWindowSettingLambdaQueryWrapper1.eq(BaseEntity::getDeleted, (Object)"0");
                elsTimeWindowSettingLambdaQueryWrapper1.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
                elsTimeWindowSettingLambdaQueryWrapper1.eq(ElsTimeWindowSetting::getAccountGroup, (Object)supplierMasterData.getAccountGroup());
                elsTimeWindowSettingLambdaQueryWrapper.eq(ElsTimeWindowSetting::getWindowType, (Object)type);
                elsTimeWindowSettingLambdaQueryWrapper1.last("AND (to_els_account is null OR to_els_account = '')");
                ElsTimeWindowSetting elsTimeWindowSetting1 = (ElsTimeWindowSetting)((ElsTimeWindowSettingMapper)SpringContextUtils.getBean(ElsTimeWindowSettingMapper.class)).selectOne((Wrapper)elsTimeWindowSettingLambdaQueryWrapper1);
                elsTimeWindowMap.put(toElsAccount, elsTimeWindowSetting1);
            }
        }
        return elsTimeWindowMap;
    }

    private Map<String, ElsTimeToleranceSetting> getElsTimeToleranceMap(List<String> toElsAccounts, Map<String, SupplierMasterDataDTO> supplierMasterDataMap) {
        HashMap<String, ElsTimeToleranceSetting> elsTimeToleranceSettingMap = new HashMap<String, ElsTimeToleranceSetting>();
        if (CollectionUtil.isNotEmpty(toElsAccounts)) {
            for (String toElsAccount : toElsAccounts) {
                if (elsTimeToleranceSettingMap.containsKey(toElsAccount)) continue;
                LambdaQueryWrapper elsTimeToleranceSettingLambdaQueryWrapper = new LambdaQueryWrapper();
                elsTimeToleranceSettingLambdaQueryWrapper.eq(BaseEntity::getDeleted, (Object)"0");
                elsTimeToleranceSettingLambdaQueryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
                elsTimeToleranceSettingLambdaQueryWrapper.eq(ElsTimeToleranceSetting::getToElsAccount, (Object)toElsAccount);
                elsTimeToleranceSettingLambdaQueryWrapper.ge(ElsTimeToleranceSetting::getFbk1, (Object)new Date());
                elsTimeToleranceSettingLambdaQueryWrapper.le(ElsTimeToleranceSetting::getFbk2, (Object)new Date());
                ElsTimeToleranceSetting elsTimeToleranceSetting = (ElsTimeToleranceSetting)((ElsTimeToleranceSettingMapper)SpringContextUtils.getBean(ElsTimeToleranceSettingMapper.class)).selectOne((Wrapper)elsTimeToleranceSettingLambdaQueryWrapper);
                if (elsTimeToleranceSetting != null) {
                    elsTimeToleranceSettingMap.put(toElsAccount, elsTimeToleranceSetting);
                    continue;
                }
                SupplierMasterDataDTO supplierMasterData = supplierMasterDataMap.get(toElsAccount);
                if (supplierMasterData == null || !StringUtils.isNotBlank((CharSequence)supplierMasterData.getAccountGroup())) continue;
                LambdaQueryWrapper elsTimeToleranceSettingLambdaQueryWrapper1 = new LambdaQueryWrapper();
                elsTimeToleranceSettingLambdaQueryWrapper1.eq(BaseEntity::getDeleted, (Object)"0");
                elsTimeToleranceSettingLambdaQueryWrapper1.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
                elsTimeToleranceSettingLambdaQueryWrapper1.ge(ElsTimeToleranceSetting::getFbk1, (Object)new Date());
                elsTimeToleranceSettingLambdaQueryWrapper1.le(ElsTimeToleranceSetting::getFbk2, (Object)new Date());
                elsTimeToleranceSettingLambdaQueryWrapper1.eq(ElsTimeToleranceSetting::getAccountGroup, (Object)supplierMasterData.getAccountGroup());
                elsTimeToleranceSettingLambdaQueryWrapper1.last("AND (to_els_account is null OR to_els_account = '' )");
                ElsTimeToleranceSetting elsTimeToleranceSetting1 = (ElsTimeToleranceSetting)((ElsTimeToleranceSettingMapper)SpringContextUtils.getBean(ElsTimeToleranceSettingMapper.class)).selectOne((Wrapper)elsTimeToleranceSettingLambdaQueryWrapper1);
                elsTimeToleranceSettingMap.put(toElsAccount, elsTimeToleranceSetting1);
            }
        }
        return elsTimeToleranceSettingMap;
    }

    private Map<String, ElsQuantityToleranceSetting> getElsQuantityToleranceMap(List<String> toElsAccounts, Map<String, SupplierMasterDataDTO> supplierMasterDataMap) {
        HashMap<String, ElsQuantityToleranceSetting> elsQuantityToleranceSettingMap = new HashMap<String, ElsQuantityToleranceSetting>();
        if (CollectionUtil.isNotEmpty(toElsAccounts)) {
            for (String toElsAccount : toElsAccounts) {
                if (elsQuantityToleranceSettingMap.containsKey(toElsAccount)) continue;
                LambdaQueryWrapper elsQuantityToleranceSettingLambdaQueryWrapper = new LambdaQueryWrapper();
                elsQuantityToleranceSettingLambdaQueryWrapper.eq(BaseEntity::getDeleted, (Object)"0");
                elsQuantityToleranceSettingLambdaQueryWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
                elsQuantityToleranceSettingLambdaQueryWrapper.eq(ElsQuantityToleranceSetting::getToElsAccount, (Object)toElsAccount);
                ElsQuantityToleranceSetting elsQuantityToleranceSetting = (ElsQuantityToleranceSetting)((ElsQuantityToleranceSettingMapper)SpringContextUtils.getBean(ElsQuantityToleranceSettingMapper.class)).selectOne((Wrapper)elsQuantityToleranceSettingLambdaQueryWrapper);
                if (elsQuantityToleranceSetting != null) {
                    elsQuantityToleranceSettingMap.put(toElsAccount, elsQuantityToleranceSetting);
                    continue;
                }
                SupplierMasterDataDTO supplierMasterData = supplierMasterDataMap.get(toElsAccount);
                if (supplierMasterData == null || !StringUtils.isNotBlank((CharSequence)supplierMasterData.getAccountGroup())) continue;
                LambdaQueryWrapper elsQuantityToleranceSettingLambdaQueryAccountWrapper = new LambdaQueryWrapper();
                elsQuantityToleranceSettingLambdaQueryAccountWrapper.eq(BaseEntity::getDeleted, (Object)"0");
                elsQuantityToleranceSettingLambdaQueryAccountWrapper.eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
                elsQuantityToleranceSettingLambdaQueryAccountWrapper.eq(ElsQuantityToleranceSetting::getAccountGroup, (Object)supplierMasterData.getAccountGroup());
                elsQuantityToleranceSettingLambdaQueryAccountWrapper.last("AND (to_els_account is null OR to_els_account = '' )");
                ElsQuantityToleranceSetting elsQuantityToleranceSetting1 = (ElsQuantityToleranceSetting)((ElsQuantityToleranceSettingMapper)SpringContextUtils.getBean(ElsQuantityToleranceSettingMapper.class)).selectOne((Wrapper)elsQuantityToleranceSettingLambdaQueryAccountWrapper);
                elsQuantityToleranceSettingMap.put(toElsAccount, elsQuantityToleranceSetting1);
            }
        }
        return elsQuantityToleranceSettingMap;
    }

    private String splitShowItemStatus(List<PurchaseDeliveryItemDTO> dbPurchaseDeliveryItemDTOList) {
        if (CollectionUtil.isEmpty(dbPurchaseDeliveryItemDTOList)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        dbPurchaseDeliveryItemDTOList.stream().forEach(deliveryItem -> sb.append(deliveryItem.getItemStatus()).append(","));
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private List<PurchaseDeliveryHeadDTO> getDelivryHeadList(List<PurchaseDeliveryItemDTO> dbPurchaseDeliveryItemDTOList, Map<String, PurchaseDeliveryHeadDTO> deliveryHeadMap) {
        if (CollectionUtil.isEmpty(dbPurchaseDeliveryItemDTOList)) {
            return null;
        }
        if (deliveryHeadMap == null) {
            return null;
        }
        ArrayList<PurchaseDeliveryHeadDTO> purchaseDeliveryHeadList = new ArrayList<PurchaseDeliveryHeadDTO>();
        for (PurchaseDeliveryItemDTO purchaseDeliveryItem : dbPurchaseDeliveryItemDTOList) {
            PurchaseDeliveryHeadDTO purchaseDeliveryHead = deliveryHeadMap.get(purchaseDeliveryItem.getHeadId());
            if (purchaseDeliveryHead == null || purchaseDeliveryHeadList.contains(purchaseDeliveryHead)) continue;
            purchaseDeliveryHeadList.add(purchaseDeliveryHead);
        }
        return purchaseDeliveryHeadList;
    }

    public String parseRefVoucherToStr(List<PurchaseVoucherItemDTO> list) {
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        list.stream().forEach(voucherItem -> {
            if (StringUtils.isNotBlank((CharSequence)voucherItem.getRefVoucherNumber())) {
                sb.append(voucherItem.getRefVoucherNumber()).append(",");
            }
        });
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String parseOrderNumberToStr(List<PurchaseVoucherItemDTO> list) {
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        list.stream().forEach(voucherItem -> {
            if (StringUtils.isNotBlank((CharSequence)voucherItem.getOrderNumber())) {
                sb.append(voucherItem.getOrderNumber()).append(",");
            }
        });
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private String parsePurchasePricipayByOrderToStr(List<PurchaseOrderHeadDTO> list) {
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        list.stream().forEach(orderHead -> {
            if (StringUtils.isNotBlank((CharSequence)orderHead.getPurchasePrincipal())) {
                sb.append(orderHead.getPurchasePrincipal()).append(",");
            }
        });
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private String parseOrderItemNumberToStr(List<PurchaseVoucherItemDTO> list) {
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        list.stream().forEach(voucherItem -> {
            if (StringUtils.isNotBlank((CharSequence)voucherItem.getOrderNumber())) {
                sb.append(voucherItem.getOrderItemNumber()).append(",");
            }
        });
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String parseListToStr2(List<PurchaseVoucherItemDTO> list) {
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        list.stream().forEach(voucherItem -> sb.append(voucherItem.getVoucherNumber()).append(","));
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public PurchaseVoucherItemDTO getPostDateMaxVoucherItem(List<PurchaseVoucherItemDTO> list) {
        PurchaseVoucherItemDTO voucherMaxItem = null;
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        for (PurchaseVoucherItemDTO item : list) {
            if (item.getPostDate() == null) continue;
            if (voucherMaxItem == null) {
                voucherMaxItem = item;
                continue;
            }
            if (item.getPostDate().compareTo(voucherMaxItem.getPostDate()) <= 0) continue;
            voucherMaxItem = item;
        }
        return voucherMaxItem;
    }

    public PurchaseDeliveryHeadDTO getArriveDateMaxFromDeliveryHead(List<PurchaseDeliveryHeadDTO> list) {
        PurchaseDeliveryHeadDTO deliveryHeadMAX = null;
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        for (PurchaseDeliveryHeadDTO head : list) {
            if (head.getArriveDate() == null) continue;
            if (deliveryHeadMAX == null && head.getArriveDate() != null) {
                deliveryHeadMAX = head;
                continue;
            }
            if (head.getArriveDate() == null || deliveryHeadMAX == null || deliveryHeadMAX.getArriveDate() == null || head.getArriveDate().compareTo(deliveryHeadMAX.getArriveDate()) <= 0) continue;
            deliveryHeadMAX = head;
        }
        if (deliveryHeadMAX == null) {
            return list.get(0);
        }
        return deliveryHeadMAX;
    }

    public String timeDeduce(Long difDate, ElsTimeToleranceSetting elsTimeToleranceSetting) {
        if (difDate == null) {
            return TimeDeduceResultEnum.DELAY.getValue();
        }
        if (elsTimeToleranceSetting != null) {
            int hour = difDate.intValue() * 24;
            String timeUnit = elsTimeToleranceSetting.getTimeUnit();
            int preTimeTolerance = elsTimeToleranceSetting.getPreTimeTolerance().intValue();
            int afterTimeTolerance = elsTimeToleranceSetting.getAfterTimeTolerance().intValue();
            if ("day".equals(timeUnit)) {
                preTimeTolerance *= 24;
                afterTimeTolerance *= 24;
            }
            if (hour < 0) {
                if ((hour += afterTimeTolerance) >= 0) {
                    return TimeDeduceResultEnum.ACCEPTABLE.getValue();
                }
                return TimeDeduceResultEnum.DELAY.getValue();
            }
            if (hour > 0) {
                if ((hour -= preTimeTolerance) <= 0) {
                    return TimeDeduceResultEnum.ACCEPTABLE.getValue();
                }
                return TimeDeduceResultEnum.PREP.getValue();
            }
            if (hour == 0) {
                return TimeDeduceResultEnum.ACCEPTABLE.getValue();
            }
        } else {
            if (difDate > 0L) {
                return TimeDeduceResultEnum.PREP.getValue();
            }
            if (difDate < 0L) {
                return TimeDeduceResultEnum.DELAY.getValue();
            }
            if (difDate == 0L) {
                return TimeDeduceResultEnum.ACCEPTABLE.getValue();
            }
        }
        return null;
    }
}

