/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.report.job;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.delivery.api.dto.PurchaseVoucherItemDTO;
import com.els.modules.delivery.enumerate.CheckStatusEnum;
import com.els.modules.quality.entity.PurchaseQualityCheckHead;
import com.els.modules.quality.entity.PurchaseQualityCheckItem;
import com.els.modules.quality.mapper.PurchaseQualityCheckHeadMapper;
import com.els.modules.quality.mapper.PurchaseQualityCheckItemMapper;
import com.els.modules.report.entity.PurchaseQualityDetailReport;
import com.els.modules.report.mapper.PurchaseQualityDetailReportMapper;
import com.els.modules.report.rpc.service.InvokeOrderRpcService;
import com.els.modules.report.rpc.service.InvokeOtherRpcService;
import com.els.modules.report.service.PurchaseQualityDetailReportService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service(value="PurchaseQualityDetailReportJob")
public class PurchaseQualityDetailReportJob
implements JobRpcService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PurchaseQualityDetailReportJob.class);
    private final Integer pageSize = 100;
    @Autowired
    private PurchaseQualityDetailReportMapper purchaseQualityDetailReportMapper;
    @Autowired
    private PurchaseQualityCheckHeadMapper purchaseQualityCheckHeadMapper;
    @Autowired
    private PurchaseQualityCheckItemMapper purchaseQualityCheckItemMapper;
    @Autowired
    private PlatformTransactionManager txManager;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private InvokeOrderRpcService invokeOrderRpcService;
    private InvokeOtherRpcService invokeOtherRpcService;
    private final String LOCK_PREFIX = "performanceDetail_schedule_";
    private final long EXPIRE_TIME = 50000L;

    @Async
    public void execute(String parameter) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(0);
        TransactionStatus status = this.txManager.getTransaction((TransactionDefinition)def);
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String tenantId = paramObj.getString("tenantId");
        if (StrUtil.isBlank((CharSequence)tenantId)) {
            tenantId = "100000";
        }
        TenantContext.setTenant((String)tenantId);
        String lockKey = "performanceDetail_schedule_" + paramObj.getString("tenantId");
        String requestId = paramObj.getString("tenantId");
        if (!this.redisUtil.tryGetDistributedLock(lockKey, requestId, 50000L)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_zmRIRHiKRcsWVxPVBRc_415451cf", (String)"\u6279\u6b21\u8d28\u68c0\u660e\u7ec6\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
        }
        try {
            int i;
            int totalPageNum;
            Date currentDate = new Date();
            DateTime preDate = DateUtil.offsetDay((Date)currentDate, (int)-1);
            LOGGER.info("\u6279\u6b21\u8d28\u68c0\u660e\u7ec6 PurchaseQualityDetailReportJob \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
            LOGGER.info("\u6279\u6b21\u8d28\u68c0\u660e\u7ec6 PurchaseQualityDetailReportJob \u5f53\u524d\u7edf\u8ba1\u7684\u65f6\u95f4\u4e3a:" + DateUtils.formatDate((Date)preDate, (String)"yyyy-MM-dd"));
            Integer voucherItemCount = this.invokeOrderRpcService.selectVoucherItemReceiveCount(tenantId);
            QueryWrapper purchaseQualityDetailReportQueryWrapper = new QueryWrapper();
            purchaseQualityDetailReportQueryWrapper.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"check_status", (Object)CheckStatusEnum.NEW.getValue())).or()).eq((Object)"check_status", (Object)CheckStatusEnum.CHECK_ING.getValue());
            });
            Integer qualityDetailCount = this.purchaseQualityDetailReportMapper.selectCount((Wrapper)purchaseQualityDetailReportQueryWrapper);
            if (voucherItemCount > 0) {
                totalPageNum = (voucherItemCount + this.pageSize - 1) / this.pageSize;
                for (i = 0; i < totalPageNum; ++i) {
                    List purchaseVoucherItemsList = this.invokeOrderRpcService.selectVoucherItemReceiveList(tenantId, "limit " + i * this.pageSize + "," + this.pageSize);
                    this.doVoucherItemData(purchaseVoucherItemsList);
                }
            }
            if (qualityDetailCount > 0) {
                totalPageNum = (qualityDetailCount + this.pageSize - 1) / this.pageSize;
                for (i = 0; i < totalPageNum; ++i) {
                    purchaseQualityDetailReportQueryWrapper.last("limit " + i * this.pageSize + "," + this.pageSize);
                    List purchaseQualityDetailReportList = this.purchaseQualityDetailReportMapper.selectList((Wrapper)purchaseQualityDetailReportQueryWrapper);
                    this.doQualityDetailReport(purchaseQualityDetailReportList);
                }
            }
        }
        catch (Exception e) {
            this.txManager.rollback(status);
            LOGGER.info(Thread.currentThread().getName() + "\u5904\u7406\u6279\u6b21\u8d28\u68c0\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
        finally {
            this.redisUtil.releaseDistributedLock(lockKey, requestId);
        }
        this.txManager.commit(status);
        LOGGER.info(String.format("\u6279\u6b21\u8d28\u68c0\u660e\u7ec6 PurchaseQualityDetailReportJob \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp(), new Object[0]) + parameter);
    }

    private void doQualityDetailReport(List<PurchaseQualityDetailReport> purchaseQualityDetailReportList) {
        List sourceIds;
        List voucherItems;
        if (CollectionUtil.isNotEmpty(purchaseQualityDetailReportList) && CollectionUtil.isNotEmpty((Collection)(voucherItems = this.invokeOrderRpcService.selectVoucherItemListByDeliverySourceIds(sourceIds = purchaseQualityDetailReportList.stream().map(PurchaseQualityDetailReport::getSourceId).collect(Collectors.toList()))))) {
            List qualityHeadIds = voucherItems.stream().map(PurchaseVoucherItemDTO::getQualityNumberId).collect(Collectors.toList());
            List qualityItemIds = voucherItems.stream().map(PurchaseVoucherItemDTO::getQualityItemId).collect(Collectors.toList());
            List purchaseQualityCheckHeadList = this.purchaseQualityCheckHeadMapper.selectBatchIds(qualityHeadIds);
            List purchaseQualityCheckItemList = this.purchaseQualityCheckItemMapper.selectBatchIds(qualityItemIds);
            Map dbQualityCheckHeadMap = purchaseQualityCheckHeadList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            Map dbQualityCheckItemMap = purchaseQualityCheckItemList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            Map purchaseQualityDetailReportMap = purchaseQualityDetailReportList.stream().collect(Collectors.toMap(PurchaseQualityDetailReport::getSourceId, Function.identity()));
            ArrayList<PurchaseQualityDetailReport> updatePurchaseQuantityDetailReportList = new ArrayList<PurchaseQualityDetailReport>();
            for (PurchaseVoucherItemDTO purchaseVoucherItem : voucherItems) {
                PurchaseQualityCheckHead purchaseQualityCheckHead = (PurchaseQualityCheckHead)dbQualityCheckHeadMap.get(purchaseVoucherItem.getQualityNumberId());
                PurchaseQualityCheckItem purchaseQualityCheckItem = (PurchaseQualityCheckItem)dbQualityCheckItemMap.get(purchaseVoucherItem.getQualityItemId());
                PurchaseQualityDetailReport detailReport = (PurchaseQualityDetailReport)purchaseQualityDetailReportMap.get(purchaseVoucherItem.getId());
                if (purchaseQualityCheckHead != null) {
                    detailReport.setCheckStatus(purchaseQualityCheckHead.getCheckStatus());
                    detailReport.setSourceId(purchaseVoucherItem.getId());
                }
                if (purchaseQualityCheckItem != null) {
                    detailReport.setCheckNumber(purchaseQualityCheckItem.getCheckNumber());
                    detailReport.setCheckItemNumber(purchaseQualityCheckItem.getItemNumber());
                    detailReport.setTestResult(purchaseQualityCheckItem.getTestResult());
                    detailReport.setNumberDefectiveProducts(purchaseQualityCheckItem.getNumberDefectiveProducts());
                }
                detailReport.setVoucherStatus(purchaseVoucherItem.getVoucherStatus());
                detailReport.setUpdateTime(new Date());
                updatePurchaseQuantityDetailReportList.add(detailReport);
            }
            ((PurchaseQualityDetailReportService)SpringContextUtils.getBean(PurchaseQualityDetailReportService.class)).updateBatchById(updatePurchaseQuantityDetailReportList);
        }
    }

    private void doVoucherItemData(List<PurchaseVoucherItemDTO> purchaseVoucherItemsList) {
        if (CollectionUtil.isNotEmpty(purchaseVoucherItemsList)) {
            Date currentDate = new Date();
            List voucherItemQuantityYes = purchaseVoucherItemsList.stream().filter(item -> "1".equals(item.getCheckQuality())).collect(Collectors.toList());
            List voucherItemQuantityNo = purchaseVoucherItemsList.stream().filter(item -> "0".equals(item.getCheckQuality()) || StringUtils.isBlank((CharSequence)item.getCheckQuality())).collect(Collectors.toList());
            ArrayList<PurchaseQualityDetailReport> purchaseQualityDetailReportList = new ArrayList<PurchaseQualityDetailReport>();
            if (CollectionUtil.isNotEmpty(voucherItemQuantityYes)) {
                List qualityHeadIds = voucherItemQuantityYes.stream().map(PurchaseVoucherItemDTO::getQualityNumberId).collect(Collectors.toList());
                List qualityItemIds = voucherItemQuantityYes.stream().map(PurchaseVoucherItemDTO::getQualityItemId).collect(Collectors.toList());
                List purchaseQualityCheckHeadList = this.purchaseQualityCheckHeadMapper.selectBatchIds(qualityHeadIds);
                List purchaseQualityCheckItemList = this.purchaseQualityCheckItemMapper.selectBatchIds(qualityItemIds);
                Map dbQualityCheckHeadMap = purchaseQualityCheckHeadList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
                Map dbQualityCheckItemMap = purchaseQualityCheckItemList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
                for (PurchaseVoucherItemDTO purchaseVoucherItem : voucherItemQuantityYes) {
                    PurchaseQualityCheckHead purchaseQualityCheckHead = (PurchaseQualityCheckHead)dbQualityCheckHeadMap.get(purchaseVoucherItem.getQualityNumberId());
                    PurchaseQualityCheckItem purchaseQualityCheckItem = (PurchaseQualityCheckItem)dbQualityCheckItemMap.get(purchaseVoucherItem.getQualityItemId());
                    PurchaseQualityDetailReport purchaseQualityDetailReport = this.packageQualityDetailReportData(purchaseVoucherItem, purchaseQualityCheckHead, purchaseQualityCheckItem, currentDate);
                    purchaseQualityDetailReportList.add(purchaseQualityDetailReport);
                }
            }
            if (CollectionUtil.isNotEmpty(voucherItemQuantityNo)) {
                for (PurchaseVoucherItemDTO purchaseVoucherItem : voucherItemQuantityNo) {
                    PurchaseQualityDetailReport purchaseQualityDetailReport = this.packageQualityDetailReportData(purchaseVoucherItem, null, null, currentDate);
                    purchaseQualityDetailReportList.add(purchaseQualityDetailReport);
                }
            }
            if (CollectionUtil.isNotEmpty(purchaseQualityDetailReportList)) {
                this.purchaseQualityDetailReportMapper.insertBatchSomeColumn(purchaseQualityDetailReportList);
            }
            if (CollectionUtil.isNotEmpty(purchaseVoucherItemsList)) {
                for (PurchaseVoucherItemDTO purchaseVoucherItem : purchaseVoucherItemsList) {
                    purchaseVoucherItem.setFbk1("1");
                }
                this.invokeOrderRpcService.updatePurchaseVoucherItemListById(purchaseVoucherItemsList);
            }
        }
    }

    private PurchaseQualityDetailReport packageQualityDetailReportData(PurchaseVoucherItemDTO purchaseVoucherItem, PurchaseQualityCheckHead purchaseQualityCheckHead, PurchaseQualityCheckItem purchaseQualityCheckItem, Date currentDate) {
        PurchaseQualityDetailReport purchaseQualityDetailReport = new PurchaseQualityDetailReport();
        if (purchaseVoucherItem != null) {
            purchaseQualityDetailReport.setToElsAccount(purchaseVoucherItem.getToElsAccount());
            purchaseQualityDetailReport.setRelationId(purchaseVoucherItem.getId());
            purchaseQualityDetailReport.setMoveType(purchaseVoucherItem.getMoveType());
            purchaseQualityDetailReport.setVoucherNumber(purchaseVoucherItem.getVoucherNumber());
            purchaseQualityDetailReport.setVoucherItemNumber(purchaseVoucherItem.getItemNumber());
            purchaseQualityDetailReport.setVoucherStatus(purchaseVoucherItem.getVoucherStatus());
            purchaseQualityDetailReport.setVoucherQuantity(purchaseVoucherItem.getVoucherQuantity());
            purchaseQualityDetailReport.setVoucherDate(purchaseVoucherItem.getVoucherDate());
            purchaseQualityDetailReport.setSupplierCode(purchaseVoucherItem.getSupplierCode());
            purchaseQualityDetailReport.setSupplierName(purchaseVoucherItem.getSupplierName());
            purchaseQualityDetailReport.setFactory(purchaseVoucherItem.getFactory());
            purchaseQualityDetailReport.setPurchaseOrg(purchaseVoucherItem.getPurchaseOrg());
            purchaseQualityDetailReport.setPurchaseOrgName(purchaseVoucherItem.getPurchaseOrgName());
            purchaseQualityDetailReport.setOrderNumber(purchaseVoucherItem.getOrderNumber());
            purchaseQualityDetailReport.setOrderItemNumber(purchaseVoucherItem.getOrderItemNumber());
            purchaseQualityDetailReport.setPurchaseGroup(purchaseVoucherItem.getPurchaseGroup());
            purchaseQualityDetailReport.setPurchaseGroupName(purchaseVoucherItem.getPurchaseGroupName());
            purchaseQualityDetailReport.setCompany(purchaseVoucherItem.getCompany());
            purchaseQualityDetailReport.setCompanyName(purchaseVoucherItem.getCompanyName());
            purchaseQualityDetailReport.setMaterialNumber(purchaseVoucherItem.getMaterialNumber());
            purchaseQualityDetailReport.setMaterialDesc(purchaseVoucherItem.getMaterialDesc());
            purchaseQualityDetailReport.setPrice(purchaseVoucherItem.getPrice());
            purchaseQualityDetailReport.setNetPrice(purchaseVoucherItem.getNetPrice());
            purchaseQualityDetailReport.setRefVoucherNumber(purchaseVoucherItem.getRefVoucherNumber());
            purchaseQualityDetailReport.setRefVoucherItemNumber(purchaseVoucherItem.getRefVoucherItemNumber());
            purchaseQualityDetailReport.setCheckType(purchaseVoucherItem.getCheckQuality());
        }
        if (purchaseQualityCheckHead != null) {
            purchaseQualityDetailReport.setCheckStatus(purchaseQualityCheckHead.getCheckStatus());
            if (purchaseVoucherItem != null) {
                purchaseQualityDetailReport.setSourceId(purchaseVoucherItem.getId());
            }
        }
        if (purchaseQualityCheckItem != null) {
            purchaseQualityDetailReport.setCheckNumber(purchaseQualityCheckItem.getCheckNumber());
            purchaseQualityDetailReport.setCheckItemNumber(purchaseQualityCheckItem.getItemNumber());
            purchaseQualityDetailReport.setTestResult(purchaseQualityCheckItem.getTestResult());
            purchaseQualityDetailReport.setNumberDefectiveProducts(purchaseQualityCheckItem.getNumberDefectiveProducts());
        }
        purchaseQualityDetailReport.setElsAccount(TenantContext.getTenant());
        purchaseQualityDetailReport.setDeleted(Integer.valueOf(Integer.parseInt("0")));
        purchaseQualityDetailReport.setCreateTime(currentDate);
        purchaseQualityDetailReport.setUpdateTime(currentDate);
        return purchaseQualityDetailReport;
    }
}

