/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.sample.entity.PurchaseSampleHead;
import com.els.modules.sample.entity.PurchaseSampleItem;
import com.els.modules.sample.entity.SaleSampleHead;
import com.els.modules.sample.entity.SaleSampleItem;
import com.els.modules.sample.entity.SaleSampleTrackingItem;
import com.els.modules.sample.entity.SampleSupplierList;
import com.els.modules.sample.enumerate.PurchaseSampleStatusEnum;
import com.els.modules.sample.enumerate.PurchaseSampleStatusItemEnum;
import com.els.modules.sample.enumerate.SampleDeliveryModeEnum;
import com.els.modules.sample.mapper.PurchaseSampleHeadMapper;
import com.els.modules.sample.mapper.PurchaseSampleItemMapper;
import com.els.modules.sample.mapper.SaleSampleHeadMapper;
import com.els.modules.sample.mapper.SaleSampleItemMapper;
import com.els.modules.sample.mapper.SaleSampleTrackingItemMapper;
import com.els.modules.sample.service.PurchaseSampleItemService;
import com.els.modules.sample.service.SaleSampleHeadService;
import com.els.modules.sample.service.SaleSampleItemService;
import com.els.modules.sample.service.impl.PurchaseSampleItemServiceImpl;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleSampleHeadServiceImpl
extends BaseServiceImpl<SaleSampleHeadMapper, SaleSampleHead>
implements SaleSampleHeadService {
    @Resource
    private SaleSampleHeadMapper saleSampleHeadMapper;
    @Resource
    private SaleSampleItemMapper saleSampleItemMapper;
    @Resource
    private PurchaseSampleItemMapper purchaseSampleItemMapper;
    @Resource
    private SaleSampleItemService saleSampleItemService;
    @Resource
    private SaleSampleTrackingItemMapper saleSampleTrackingItemMapper;
    @Resource
    private PurchaseSampleHeadMapper purchaseSampleHeadMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SaleSampleHead saleSampleHead, List<SaleSampleItem> saleSampleItemList, List<SaleSampleTrackingItem> saleSampleTrackingItemList) {
        this.saleSampleHeadMapper.insert((Object)saleSampleHead);
        this.insertData(saleSampleHead, saleSampleItemList, saleSampleTrackingItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SaleSampleHead saleSampleHead, List<SaleSampleItem> saleSampleItemList, List<SaleSampleTrackingItem> saleSampleTrackingItemList) {
        this.saleSampleHeadMapper.updateById((Object)saleSampleHead);
        this.saleSampleItemMapper.deleteByMainId(saleSampleHead.getId());
        this.saleSampleTrackingItemMapper.deleteByMainId(saleSampleHead.getId());
        this.insertData(saleSampleHead, saleSampleItemList, saleSampleTrackingItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void comfirm(SaleSampleHead saleSampleHead, List<SaleSampleItem> saleSampleItemList, List<SaleSampleTrackingItem> saleSampleTrackingItemList) {
        SaleSampleHeadServiceImpl.checkComfirm(saleSampleItemList);
        for (SaleSampleItem saleSampleItem : saleSampleItemList) {
            if (SampleDeliveryModeEnum.DIRECT_SAMPLE_DELIVERY.getValue().equals(saleSampleItem.getSampleDeliveryMode())) {
                saleSampleItem.setItemStatus(PurchaseSampleStatusItemEnum.SENDING_SAMPLES.getValue());
            } else if (SampleDeliveryModeEnum.SAMPLE_DELIVERY_BY_FREE_ORDER.getValue().equals(saleSampleItem.getSampleDeliveryMode()) || SampleDeliveryModeEnum.SAMPLE_DELIVERY_OF_CHARGE_ORDER.getValue().equals(saleSampleItem.getSampleDeliveryMode())) {
                saleSampleItem.setItemStatus(PurchaseSampleStatusItemEnum.QUOTED.getValue());
            } else {
                saleSampleItem.setItemStatus(PurchaseSampleStatusItemEnum.NO_SAMPLES.getValue());
            }
            this.saleSampleItemMapper.alwaysUpdateSomeColumnById((Object)saleSampleItem);
            PurchaseSampleItem purchaseSampleItem = new PurchaseSampleItem();
            BeanUtils.copyProperties((Object)((Object)saleSampleItem), (Object)((Object)purchaseSampleItem));
            purchaseSampleItem.setRelationId(null);
            purchaseSampleItem.setId(saleSampleItem.getRelationId());
            purchaseSampleItem.setHeadId(null);
            purchaseSampleItem.setRelationId(null);
            purchaseSampleItem.setElsAccount(null);
            purchaseSampleItem.setToElsAccount(null);
            purchaseSampleItem.setCreateBy(null);
            purchaseSampleItem.setCreateTime(null);
            purchaseSampleItem.setUpdateBy(null);
            purchaseSampleItem.setUpdateTime(DateUtils.getDate());
            this.purchaseSampleItemMapper.updateById((Object)purchaseSampleItem);
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(SaleSampleHead::getSampleStatus, (Object)PurchaseSampleStatusEnum.WAIT_PURCHASE_CONFIRM.getValue())).eq(BaseEntity::getId, (Object)saleSampleItemList.get(0).getHeadId())).update();
        AttachmentSendDTO sendVO = new AttachmentSendDTO();
        sendVO.setElsAccount(saleSampleHead.getElsAccount());
        sendVO.setHeadId(saleSampleHead.getId());
        HashMap<String, String> toSend = new HashMap<String, String>();
        toSend.put(saleSampleHead.getRelationId(), saleSampleHead.getToElsAccount());
        sendVO.setToSend(toSend);
        this.invokeBaseRpcService.sendSaleFile(sendVO);
        List<SaleSampleItem> allSaleList = this.saleSampleItemService.selectByMainId(saleSampleHead.getRelationId());
        if (allSaleList != null && allSaleList.size() == allSaleList.parallelStream().filter(vo -> PurchaseSampleStatusItemEnum.NO_SAMPLES.getValue().equals(vo.getItemStatus())).collect(Collectors.toList()).size() + allSaleList.parallelStream().filter(vo -> PurchaseSampleStatusItemEnum.QUOTED.getValue().equals(vo.getItemStatus())).collect(Collectors.toList()).size() + allSaleList.parallelStream().filter(vo -> PurchaseSampleStatusItemEnum.SENDING_SAMPLES.getValue().equals(vo.getItemStatus())).collect(Collectors.toList()).size()) {
            PurchaseSampleHead sampleHead = new PurchaseSampleHead();
            sampleHead.setId(saleSampleHead.getRelationId());
            sampleHead.setSampleStatus(PurchaseSampleStatusEnum.WAIT_PURCHASE_CONFIRM.getValue());
            this.purchaseSampleHeadMapper.updateById((Object)sampleHead);
        }
    }

    private static void checkComfirm(List<SaleSampleItem> saleSampleItemList) {
        saleSampleItemList.forEach(item -> {
            Assert.hasText((String)item.getSampleDeliveryMode(), (String)I18nUtil.translate((String)"", (String)"\u9009\u62e9\u9001\u6837\u6a21\u5f0f"));
            if (SampleDeliveryModeEnum.SAMPLE_DELIVERY_BY_FREE_ORDER.equals(item.getSampleDeliveryMode()) || SampleDeliveryModeEnum.SAMPLE_DELIVERY_OF_CHARGE_ORDER.equals(item.getSampleDeliveryMode())) {
                Assert.notNull((Object)item.getPrice(), (String)I18nUtil.translate((String)"i18n_alert_empty_notPrice", (String)"\u542b\u7a0e\u4ef7\u4e0d\u80fd\u4e3a\u7a7a"));
            }
        });
    }

    private void insertData(SaleSampleHead saleSampleHead, List<SaleSampleItem> saleSampleItemList, List<SaleSampleTrackingItem> saleSampleTrackingItemList) {
        for (SaleSampleItem saleSampleItem : saleSampleItemList) {
            saleSampleItem.setHeadId(saleSampleHead.getId());
            SysUtil.setSysParam((BaseEntity)saleSampleItem, (BaseEntity)saleSampleHead);
        }
        if (!saleSampleItemList.isEmpty()) {
            this.saleSampleItemMapper.insertBatchSomeColumn(saleSampleItemList);
        }
        for (SaleSampleTrackingItem saleSampleTrackingItem : saleSampleTrackingItemList) {
            saleSampleTrackingItem.setHeadId(saleSampleHead.getId());
            SysUtil.setSysParam((BaseEntity)saleSampleTrackingItem, (BaseEntity)saleSampleHead);
        }
        if (!saleSampleTrackingItemList.isEmpty()) {
            this.saleSampleTrackingItemMapper.insertBatchSomeColumn(saleSampleTrackingItemList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.saleSampleItemMapper.deleteByMainId(id);
        this.saleSampleTrackingItemMapper.deleteByMainId(id);
        this.saleSampleHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.saleSampleItemMapper.deleteByMainId(serializable.toString());
            this.saleSampleTrackingItemMapper.deleteByMainId(serializable.toString());
            this.saleSampleHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public Map<String, SaleSampleHead> add(PurchaseSampleHead head, List<PurchaseSampleItem> itemList, List<SampleSupplierList> supplierList) {
        ArrayList<Object> saleHeadList = new ArrayList<Object>();
        LoginUser user = SysUtil.getLoginUser();
        for (SampleSupplierList supplier : supplierList) {
            SaleSampleHead saleHead = new SaleSampleHead();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)saleHead));
            SysUtil.setSysParam((BaseEntity)saleHead, (BaseEntity)head);
            saleHead.setId(null);
            saleHead.setRelationId(head.getId());
            saleHead.setElsAccount(supplier.getToElsAccount());
            saleHead.setToElsAccount(supplier.getElsAccount());
            saleHead.setPurchaseName(user.getEnterpriseName());
            saleHead.setSupplierName(supplier.getSupplierName());
            saleHead.setSupplierListId(supplier.getId());
            saleHead.setSampleStatus(PurchaseSampleStatusEnum.WAIT_SUPPLIER_OPT.getValue());
            saleHeadList.add((Object)saleHead);
        }
        ((SaleSampleHeadMapper)this.baseMapper).insertBatchSomeColumn(saleHeadList);
        Map<String, SaleSampleHead> supplierMap = saleHeadList.parallelStream().collect(Collectors.toMap(BaseEntity::getElsAccount, Function.identity()));
        ArrayList<SaleSampleItem> saleItemList = new ArrayList<SaleSampleItem>();
        for (PurchaseSampleItem item2 : itemList) {
            SaleSampleItem saleItem = new SaleSampleItem();
            BeanUtils.copyProperties((Object)((Object)item2), (Object)((Object)saleItem));
            saleItem.setId(IdWorker.getIdStr());
            item2.setRelationId(saleItem.getId());
            saleItem.setElsAccount(item2.getToElsAccount());
            saleItem.setRelationId(item2.getId());
            saleItem.setHeadId(supplierMap.get(item2.getToElsAccount()).getId());
            saleItem.setToElsAccount(item2.getElsAccount());
            saleItemList.add(saleItem);
        }
        this.saleSampleItemMapper.insertBatchSomeColumn(saleItemList);
        PurchaseSampleItemService bean = (PurchaseSampleItemService)SpringContextUtils.getBean(PurchaseSampleItemServiceImpl.class);
        if (bean != null) {
            itemList.forEach(item -> ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)bean.lambdaUpdate().eq(BaseEntity::getId, (Object)item.getId())).set(PurchaseSampleItem::getRelationId, (Object)item.getRelationId())).update());
        }
        return supplierMap;
    }
}

