/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.siteInspection.adapter;

import com.els.common.enumerate.AuditStatusEnum;
import com.els.modules.siteInspection.entity.ElsInspectionStandardHead;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardHeadMapper;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="inspectionStandardAdapter")
public class ElsInspectionStandardAdapter
implements AuditOptCallBackService {
    @Resource
    private ElsInspectionStandardHeadMapper headMapper;

    private void updateAudiStatus(String businessId, String auditStatus, String processRootId) {
        ElsInspectionStandardHead head = (ElsInspectionStandardHead)((Object)this.headMapper.selectById((Serializable)((Object)businessId)));
        head.setResultAuditStatus(auditStatus).setResultFlowId(processRootId);
        if (Objects.equals(AuditStatusEnum.AUDIT_FINISH.getValue(), auditStatus)) {
            head.setStatus("1");
        }
        this.headMapper.updateById((Object)head);
    }

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId());
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId());
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId());
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId());
    }
}

