/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.siteInspection.adapter;

import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.enumerate.i18n.I18nBaseEnum;
import com.els.common.util.AssertI18nUtil;
import com.els.modules.siteInspection.entity.PurchaseInspectionHead;
import com.els.modules.siteInspection.entity.SaleInspectionHead;
import com.els.modules.siteInspection.enums.I18nSiteInspectEnum;
import com.els.modules.siteInspection.mapper.PurchaseInspectionHeadMapper;
import com.els.modules.siteInspection.mapper.SaleInspectionHeadMapper;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="siteInspectionAdapter")
public class SiteInspectionAdapter
implements AuditOptCallBackService {
    @Resource
    private PurchaseInspectionHeadMapper purHeadMapper;
    @Resource
    private SaleInspectionHeadMapper saleHeadMapper;

    private void updateAudiStatus(String businessId, String auditStatus, String processRootId) {
        PurchaseInspectionHead head = (PurchaseInspectionHead)((Object)this.purHeadMapper.selectById((Serializable)((Object)businessId)));
        AssertI18nUtil.isTrue((head == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        AssertI18nUtil.isTrue((!"1".equals(head.getPubishAudit()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.NOT_AUDI_FAIL);
        AssertI18nUtil.isTrue((!"4".equals(head.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.NOT_SCORE_STATUS_FAIL);
        head.setResultAuditStatus(auditStatus).setResultFlowId(processRootId);
        if (Objects.equals(AuditStatusEnum.AUDIT_FINISH.getValue(), auditStatus)) {
            String status = "2".equals(head.getInspectionConclusion()) ? "5" : "6";
            head.setDocumentsStatus(status);
        } else if (Objects.equals(AuditStatusEnum.AUDIT_REJECT.getValue(), auditStatus)) {
            head.setDocumentsStatus("3");
        }
        this.purHeadMapper.updateById((Object)head);
        if (StringUtils.isBlank((CharSequence)head.getRelationId())) {
            return;
        }
        SaleInspectionHead saleInspectionHead = (SaleInspectionHead)((Object)this.saleHeadMapper.selectById((Serializable)((Object)head.getRelationId())));
        if (saleInspectionHead == null) {
            return;
        }
        saleInspectionHead.setResultAuditStatus(auditStatus).setResultFlowId(processRootId);
        saleInspectionHead.setDocumentsStatus(head.getDocumentsStatus());
        this.saleHeadMapper.updateById((Object)saleInspectionHead);
    }

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId());
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId());
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId());
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId());
    }
}

