/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.siteInspection.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.enumerate.i18n.I18nBaseEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AssertI18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.siteInspection.entity.ElsInspectionStandardHead;
import com.els.modules.siteInspection.entity.ElsInspectionStandardItem;
import com.els.modules.siteInspection.entity.ElsInspectionStandardItemDetail;
import com.els.modules.siteInspection.entity.ElsInspectionStandardItemWeight;
import com.els.modules.siteInspection.entity.ElsInspectionStandardScoreGrade;
import com.els.modules.siteInspection.enums.I18nSiteInspectEnum;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardHeadMapper;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardItemDetailMapper;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardItemMapper;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardItemWeightMapper;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardScoreGradeMapper;
import com.els.modules.siteInspection.rpc.SiteInspectBaseRpcService;
import com.els.modules.siteInspection.service.ElsInspectionStandardHeadService;
import com.els.modules.siteInspection.utils.BigDecimalUtil;
import com.els.modules.siteInspection.vo.ElsInspectionStandardHeadSaveVO;
import com.els.modules.siteInspection.vo.ElsInspectionStandardHeadSubmitVO;
import com.els.modules.siteInspection.vo.inspectionStandard.ElsInspectionStandardItemDetailVO;
import com.els.modules.siteInspection.vo.inspectionStandard.ElsInspectionStandardItemVO;
import com.els.modules.siteInspection.vo.inspectionStandard.ElsInspectionStandardItemWeightVO;
import com.els.modules.siteInspection.vo.inspectionStandard.ElsInspectionStandardScoreGradeVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ElsInspectionStandardHeadServiceImpl
extends BaseServiceImpl<ElsInspectionStandardHeadMapper, ElsInspectionStandardHead>
implements ElsInspectionStandardHeadService {
    @Autowired
    private ElsInspectionStandardHeadMapper headMapper;
    @Autowired
    private ElsInspectionStandardItemMapper itemMapper;
    @Autowired
    private ElsInspectionStandardItemWeightMapper itemWeightMapper;
    @Autowired
    private ElsInspectionStandardScoreGradeMapper scoreGradeMapper;
    @Autowired
    private ElsInspectionStandardItemDetailMapper itemDetailMapper;
    @Autowired
    private SiteInspectBaseRpcService baseRpcService;

    private String getSerialNumber(Object businessObj) {
        return this.baseRpcService.getNextCode("inspectionStandardNumber", businessObj);
    }

    private void delByHeadId(String headId) {
        if (StringUtils.isBlank((CharSequence)headId)) {
            return;
        }
        this.itemMapper.deleteByMainId(headId);
        this.itemDetailMapper.deleteByMainId(headId);
        this.itemWeightMapper.deleteByMainId(headId);
        this.scoreGradeMapper.deleteByMainId(headId);
    }

    private void setBaseEntity(BaseEntity baseEntity) {
        Date now = new Date();
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        baseEntity.setElsAccount(TenantContext.getTenant()).setCreateTime(now).setUpdateTime(now).setCreateBy(sysUser.getSubAccount()).setUpdateBy(sysUser.getSubAccount()).setDeleted(CommonConstant.DEL_FLAG_0);
    }

    private void saveItemDetail(String headId, String itemId, List<ElsInspectionStandardItemDetailVO> itemDetailVoList) {
        if (CollectionUtils.isEmpty(itemDetailVoList)) {
            return;
        }
        List itemDetailList = itemDetailVoList.stream().map(vo -> {
            ElsInspectionStandardItemDetail itemDetail = new ElsInspectionStandardItemDetail();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)itemDetail));
            itemDetail.setHeadId(headId).setItemId(itemId);
            this.setBaseEntity(itemDetail);
            return itemDetail;
        }).collect(Collectors.toList());
        this.itemDetailMapper.insertBatchSomeColumn(itemDetailList);
    }

    private void saveItem(String headId, List<ElsInspectionStandardItemVO> itemVoList) {
        if (CollectionUtils.isEmpty(itemVoList)) {
            return;
        }
        List itemList = itemVoList.stream().map(itemVo -> {
            ElsInspectionStandardItem elsInspectionStandardItem = new ElsInspectionStandardItem();
            BeanUtils.copyProperties((Object)itemVo, (Object)((Object)elsInspectionStandardItem));
            elsInspectionStandardItem.setHeadId(headId).setId(IdWorker.getIdStr());
            this.setBaseEntity(elsInspectionStandardItem);
            if (!"2".equals(itemVo.getScoringType())) {
                this.saveItemDetail(headId, elsInspectionStandardItem.getId(), itemVo.getItemDetailList());
            }
            return elsInspectionStandardItem;
        }).collect(Collectors.toList());
        this.itemMapper.insertBatchSomeColumn(itemList);
    }

    private void saveItemWeight(String headId, List<ElsInspectionStandardItemWeightVO> itemWeightVoList) {
        if (CollectionUtils.isEmpty(itemWeightVoList)) {
            return;
        }
        List itemWeightList = itemWeightVoList.stream().map(vo -> {
            ElsInspectionStandardItemWeight itemWeight = new ElsInspectionStandardItemWeight();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)itemWeight));
            itemWeight.setHeadId(headId);
            this.setBaseEntity(itemWeight);
            return itemWeight;
        }).collect(Collectors.toList());
        this.itemWeightMapper.insertBatchSomeColumn(itemWeightList);
    }

    private String getSaveQualifiedPoints(List<ElsInspectionStandardScoreGradeVO> scoreGradeVoList) {
        if (CollectionUtils.isEmpty(scoreGradeVoList)) {
            return null;
        }
        scoreGradeVoList.sort((a, b) -> BigDecimalUtil.compare(a.getScoreLowerLimit(), b.getScoreLowerLimit()));
        for (ElsInspectionStandardScoreGradeVO gradeVO : scoreGradeVoList) {
            if (!"0".equals(gradeVO.getInspectionConclusion())) continue;
            return gradeVO.getScoreLowerLimit();
        }
        return null;
    }

    private void saveScoreGrade(String headId, List<ElsInspectionStandardScoreGradeVO> scoreGradeVoList) {
        if (CollectionUtils.isEmpty(scoreGradeVoList)) {
            return;
        }
        List scoreGradeList = scoreGradeVoList.stream().map(vo -> {
            ElsInspectionStandardScoreGrade scoreGrade = new ElsInspectionStandardScoreGrade();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)scoreGrade));
            this.setBaseEntity(scoreGrade);
            scoreGrade.setHeadId(headId);
            return scoreGrade;
        }).collect(Collectors.toList());
        this.scoreGradeMapper.insertBatchSomeColumn(scoreGradeList);
    }

    private String sumSaveTotalScore(List<ElsInspectionStandardItemVO> itemVoList) {
        if (CollectionUtils.isEmpty(itemVoList)) {
            return null;
        }
        BigDecimal totalScore = BigDecimalUtil.getZero();
        for (ElsInspectionStandardItemVO itemVo : itemVoList) {
            if (StringUtils.isBlank((CharSequence)itemVo.getFullMark())) continue;
            totalScore = BigDecimalUtil.add(totalScore, itemVo.getFullMark());
        }
        return totalScore.toString();
    }

    private String sumSubmitTotalScore(List<ElsInspectionStandardItem> itemList) {
        BigDecimal totalScore = BigDecimalUtil.getZero();
        for (ElsInspectionStandardItem item : itemList) {
            totalScore = BigDecimalUtil.add(totalScore, item.getFullMark());
        }
        return totalScore.toString();
    }

    private void validItemWeight(List<ElsInspectionStandardItemWeight> itemWeightList) {
        BigDecimal totalWeight = BigDecimalUtil.getZero();
        for (ElsInspectionStandardItemWeight itemWeight : itemWeightList) {
            totalWeight = BigDecimalUtil.add(totalWeight, itemWeight.getClassifyWeight());
        }
        AssertI18nUtil.isTrue((!BigDecimalUtil.equalOneHundred(totalWeight) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.ITEM_WEIGHT_EQUAL_ONE_HUNDRED);
    }

    private void validScoreGrade(String standardFullMarks, List<ElsInspectionStandardScoreGrade> scoreGradeList) {
        boolean validBool;
        scoreGradeList.sort((a, b) -> BigDecimalUtil.compare(a.getScoreLowerLimit(), b.getScoreLowerLimit()));
        for (int i = 0; i < scoreGradeList.size(); ++i) {
            ElsInspectionStandardScoreGrade scoreGrade = scoreGradeList.get(i);
            validBool = BigDecimalUtil.bigThan(scoreGrade.getScoreLowerLimit(), scoreGrade.getScoreLimit());
            AssertI18nUtil.isTrue((boolean)validBool, (Enum)I18nSiteInspectEnum.ITEM_SCORE_MIN_MAX_ILLEGAL, (String[])new String[]{scoreGrade.getScoreGrade()});
            if (i == scoreGradeList.size() - 1) break;
            validBool = !BigDecimalUtil.equal(scoreGrade.getScoreLimit(), scoreGradeList.get(i + 1).getScoreLowerLimit());
            AssertI18nUtil.isTrue((boolean)validBool, (Enum)I18nSiteInspectEnum.ITEM_SCORE_COVER_ILLEGAL);
        }
        validBool = !BigDecimalUtil.equal(scoreGradeList.get(0).getScoreLowerLimit(), "0");
        AssertI18nUtil.isTrue((boolean)validBool, (Enum)I18nSiteInspectEnum.ITEM_SCORE_MIN_GRADE_ILLEGAL);
        validBool = !BigDecimalUtil.equal(scoreGradeList.get(scoreGradeList.size() - 1).getScoreLimit(), standardFullMarks);
        AssertI18nUtil.isTrue((boolean)validBool, (Enum)I18nSiteInspectEnum.ITEM_SCORE_MAX_GRADE_ILLEGAL);
    }

    private void submitItemDetail(String headId, String itemId, List<ElsInspectionStandardItemDetail> itemDetailList) {
        if (CollectionUtils.isEmpty(itemDetailList)) {
            return;
        }
        Map<String, Long> mapGroup = itemDetailList.stream().collect(Collectors.groupingBy(ElsInspectionStandardItemDetail::getOptionType, Collectors.counting()));
        for (Map.Entry<String, Long> map : mapGroup.entrySet()) {
            AssertI18nUtil.isTrue((map.getValue() > 1L ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.ITEM_DETAIL_OPTION_TYPE_REPEAT, (String[])new String[]{map.getKey()});
        }
        itemDetailList.forEach(itemDetail -> {
            itemDetail.setHeadId(headId).setItemId(itemId);
            this.setBaseEntity((BaseEntity)itemDetail);
        });
        this.itemDetailMapper.insertBatchSomeColumn(itemDetailList);
    }

    private void submitItem(String headId, List<ElsInspectionStandardItem> itemList) {
        itemList.forEach(item -> {
            item.setHeadId(headId).setId(IdWorker.getIdStr());
            this.setBaseEntity((BaseEntity)item);
            if (!"2".equals(item.getScoringType())) {
                this.submitItemDetail(headId, item.getId(), item.getItemDetailList());
            }
        });
        this.itemMapper.insertBatchSomeColumn(itemList);
    }

    private void submitItemWeight(String headId, List<ElsInspectionStandardItemWeight> itemWeightList) {
        itemWeightList.forEach(itemWeight -> {
            itemWeight.setHeadId(headId);
            this.setBaseEntity((BaseEntity)itemWeight);
        });
        this.itemWeightMapper.insertBatchSomeColumn(itemWeightList);
    }

    private String getSubmitQualifiedPoints(List<ElsInspectionStandardScoreGrade> scoreGradeVoList) {
        scoreGradeVoList.sort((a, b) -> BigDecimalUtil.compare(a.getScoreLowerLimit(), b.getScoreLowerLimit()));
        for (ElsInspectionStandardScoreGrade grade : scoreGradeVoList) {
            if (!"0".equals(grade.getInspectionConclusion())) continue;
            return grade.getScoreLowerLimit();
        }
        return null;
    }

    private void submitScoreGrade(String headId, List<ElsInspectionStandardScoreGrade> scoreGradeList) {
        scoreGradeList.forEach(scoreGrade -> {
            this.setBaseEntity((BaseEntity)scoreGrade);
            scoreGrade.setHeadId(headId);
        });
        this.scoreGradeMapper.insertBatchSomeColumn(scoreGradeList);
    }

    private void copyItem(String oldHeadId, String newHeadId) {
        List<ElsInspectionStandardItem> itemList = this.itemMapper.selectByMainId(oldHeadId);
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        itemList.forEach(item -> {
            List<ElsInspectionStandardItemDetail> detailList = this.itemDetailMapper.selectByItemId(item.getId());
            item.setHeadId(newHeadId).setId(IdWorker.getIdStr());
            if (!CollectionUtils.isEmpty(detailList)) {
                detailList.forEach(detail -> detail.setHeadId(newHeadId).setItemId(item.getId()).setId(IdWorker.getIdStr()));
                this.itemDetailMapper.insertBatchSomeColumn(detailList);
            }
        });
        this.itemMapper.insertBatchSomeColumn(itemList);
    }

    private void copyItemWeight(String oldHeadId, String newHeadId) {
        List<ElsInspectionStandardItemWeight> weightList = this.itemWeightMapper.selectByMainId(oldHeadId);
        if (CollectionUtils.isEmpty(weightList)) {
            return;
        }
        weightList.forEach(itemWeight -> itemWeight.setHeadId(newHeadId).setId(IdWorker.getIdStr()));
        this.itemWeightMapper.insertBatchSomeColumn(weightList);
    }

    private void copyScoreGrade(String oldHeadId, String newHeadId) {
        List<ElsInspectionStandardScoreGrade> list = this.scoreGradeMapper.selectByMainId(oldHeadId);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(scoreGrade -> scoreGrade.setHeadId(newHeadId).setId(IdWorker.getIdStr()));
        this.scoreGradeMapper.insertBatchSomeColumn(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createNewRecord(ElsInspectionStandardHeadSaveVO headSaveVo) {
        boolean bool = StringUtils.isNotBlank((CharSequence)headSaveVo.getInspectionStandardName()) && StringUtils.isNotBlank((CharSequence)headSaveVo.getVersionNumber()) && this.headMapper.onlyRecord(null, headSaveVo.getInspectionStandardName(), headSaveVo.getVersionNumber(), TenantContext.getTenant()) > 0;
        AssertI18nUtil.isTrue((boolean)bool, (Enum)I18nSiteInspectEnum.INSPECTION_STANDARD_RECORD_NOT_ONLY);
        ElsInspectionStandardHead elsInspectionStandardHead = new ElsInspectionStandardHead();
        BeanUtils.copyProperties((Object)headSaveVo, (Object)((Object)elsInspectionStandardHead));
        elsInspectionStandardHead.setInspectionStandardNumber(this.getSerialNumber(headSaveVo)).setStatus("0").setTotalScore(this.sumSaveTotalScore(headSaveVo.getItemList())).setQualifiedPoints(this.getSaveQualifiedPoints(headSaveVo.getScoreGradeList())).setId(IdWorker.getIdStr());
        this.headMapper.insert((Object)elsInspectionStandardHead);
        this.saveItem(elsInspectionStandardHead.getId(), headSaveVo.getItemList());
        this.saveItemWeight(elsInspectionStandardHead.getId(), headSaveVo.getItemWeightList());
        this.saveScoreGrade(elsInspectionStandardHead.getId(), headSaveVo.getScoreGradeList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateRecord(ElsInspectionStandardHeadSaveVO headSaveVo) {
        boolean bool = StringUtils.isNotBlank((CharSequence)headSaveVo.getInspectionStandardName()) && StringUtils.isNotBlank((CharSequence)headSaveVo.getVersionNumber()) && this.headMapper.onlyRecord(headSaveVo.getId(), headSaveVo.getInspectionStandardName(), headSaveVo.getVersionNumber(), TenantContext.getTenant()) > 0;
        AssertI18nUtil.isTrue((boolean)bool, (Enum)I18nSiteInspectEnum.INSPECTION_STANDARD_RECORD_NOT_ONLY);
        ElsInspectionStandardHead head = (ElsInspectionStandardHead)((Object)this.headMapper.selectById((Serializable)((Object)headSaveVo.getId())));
        AssertI18nUtil.isTrue((head == null || !"0".equals(head.getStatus()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.RECORD_NULL_NOT_NEW);
        AssertI18nUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)head.getResultAuditStatus()), (Enum)I18nSiteInspectEnum.RECORD_AUDI);
        this.delByHeadId(headSaveVo.getId());
        this.saveItem(headSaveVo.getId(), headSaveVo.getItemList());
        this.saveItemWeight(headSaveVo.getId(), headSaveVo.getItemWeightList());
        this.saveScoreGrade(headSaveVo.getId(), headSaveVo.getScoreGradeList());
        ElsInspectionStandardHead elsInspectionStandardHead = new ElsInspectionStandardHead();
        BeanUtils.copyProperties((Object)headSaveVo, (Object)((Object)elsInspectionStandardHead));
        elsInspectionStandardHead.setTotalScore(this.sumSaveTotalScore(headSaveVo.getItemList())).setQualifiedPoints(this.getSaveQualifiedPoints(headSaveVo.getScoreGradeList()));
        this.headMapper.updateById((Object)elsInspectionStandardHead);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitRecordNoId(ElsInspectionStandardHeadSubmitVO headSubmitVO) {
        boolean bool = this.headMapper.onlyRecord(null, headSubmitVO.getInspectionStandardName(), headSubmitVO.getVersionNumber(), TenantContext.getTenant()) > 0;
        AssertI18nUtil.isTrue((boolean)bool, (Enum)I18nSiteInspectEnum.INSPECTION_STANDARD_RECORD_NOT_ONLY);
        this.validItemWeight(headSubmitVO.getItemWeightList());
        this.validScoreGrade(headSubmitVO.getStandardFullMarks(), headSubmitVO.getScoreGradeList());
        headSubmitVO.setInspectionStandardNumber(this.getSerialNumber((Object)headSubmitVO)).setTotalScore(this.sumSubmitTotalScore(headSubmitVO.getItemList())).setQualifiedPoints(this.getSubmitQualifiedPoints(headSubmitVO.getScoreGradeList())).setStatus("0").setId(IdWorker.getIdStr());
        if (!"1".equals(headSubmitVO.getPubishAudit())) {
            headSubmitVO.setStatus("1");
        }
        this.headMapper.insert((Object)headSubmitVO);
        this.delByHeadId(headSubmitVO.getId());
        this.submitItem(headSubmitVO.getId(), headSubmitVO.getItemList());
        this.submitItemWeight(headSubmitVO.getId(), headSubmitVO.getItemWeightList());
        this.submitScoreGrade(headSubmitVO.getId(), headSubmitVO.getScoreGradeList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitRecordWithId(ElsInspectionStandardHeadSubmitVO headSubmitVO) {
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)headSubmitVO.getId()), (Enum)I18nBaseEnum.RECORD_ID_IS_NULL);
        boolean bool = this.headMapper.onlyRecord(headSubmitVO.getId(), headSubmitVO.getInspectionStandardName(), headSubmitVO.getVersionNumber(), TenantContext.getTenant()) > 0;
        AssertI18nUtil.isTrue((boolean)bool, (Enum)I18nSiteInspectEnum.INSPECTION_STANDARD_RECORD_NOT_ONLY);
        ElsInspectionStandardHead head = (ElsInspectionStandardHead)((Object)this.headMapper.selectById((Serializable)((Object)headSubmitVO.getId())));
        AssertI18nUtil.isTrue((head == null || !"0".equals(head.getStatus()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.RECORD_NULL_NOT_NEW);
        AssertI18nUtil.isTrue((StringUtils.isNotBlank((CharSequence)head.getResultAuditStatus()) && !AuditStatusEnum.AUDIT_REJECT.getValue().equals(head.getResultAuditStatus()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.RECORD_AUDI);
        this.validItemWeight(headSubmitVO.getItemWeightList());
        this.validScoreGrade(headSubmitVO.getStandardFullMarks(), headSubmitVO.getScoreGradeList());
        this.delByHeadId(headSubmitVO.getId());
        this.submitItem(headSubmitVO.getId(), headSubmitVO.getItemList());
        this.submitItemWeight(headSubmitVO.getId(), headSubmitVO.getItemWeightList());
        this.submitScoreGrade(headSubmitVO.getId(), headSubmitVO.getScoreGradeList());
        if (!"1".equals(headSubmitVO.getPubishAudit())) {
            headSubmitVO.setStatus("1");
        }
        headSubmitVO.setTotalScore(this.sumSubmitTotalScore(headSubmitVO.getItemList())).setQualifiedPoints(this.getSubmitQualifiedPoints(headSubmitVO.getScoreGradeList()));
        this.headMapper.updateById((Object)headSubmitVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delMain(String id) {
        int recordNum = this.headMapper.countByIdAndStatus(id, "0");
        AssertI18nUtil.isTrue((recordNum <= 0 ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.RECORD_NULL_NOT_NEW);
        this.headMapper.deleteById((Serializable)((Object)id));
        this.delByHeadId(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enable(String id) {
        ElsInspectionStandardHead head = (ElsInspectionStandardHead)((Object)this.headMapper.selectById((Serializable)((Object)id)));
        boolean bool = head == null || !"2".equals(head.getStatus());
        AssertI18nUtil.isTrue((boolean)bool, (Enum)I18nSiteInspectEnum.RECORD_NULL_NOT_DISABLE);
        head.setStatus("1");
        this.headMapper.updateById((Object)head);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disable(String id) {
        ElsInspectionStandardHead head = (ElsInspectionStandardHead)((Object)this.headMapper.selectById((Serializable)((Object)id)));
        boolean bool = head == null || !"1".equals(head.getStatus());
        AssertI18nUtil.isTrue((boolean)bool, (Enum)I18nSiteInspectEnum.RECORD_NULL_NOT_ENABLE);
        head.setStatus("2");
        this.headMapper.updateById((Object)head);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void copyInspectionStandard(String id) {
        ElsInspectionStandardHead head = (ElsInspectionStandardHead)((Object)this.headMapper.selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((head == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        String serialNumber = this.baseRpcService.getNextCode("inspectionStandardNumber", (Object)head);
        head.setStatus("0").setInspectionStandardName(null).setVersionNumber(null).setInspectionStandardNumber(serialNumber).setResultAuditStatus(null).setResultFlowId(null).setId(IdWorker.getIdStr());
        this.headMapper.insert((Object)head);
        this.copyItem(id, head.getId());
        this.copyItemWeight(id, head.getId());
        this.copyScoreGrade(id, head.getId());
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public ElsInspectionStandardHeadSubmitVO getById(String id) {
        ElsInspectionStandardHeadSubmitVO submitVO = new ElsInspectionStandardHeadSubmitVO();
        ElsInspectionStandardHead head = (ElsInspectionStandardHead)((Object)this.headMapper.selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((head == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)submitVO));
        List<ElsInspectionStandardItem> itemList = this.itemMapper.selectByMainId(id);
        if (!CollectionUtils.isEmpty(itemList)) {
            itemList.forEach(item -> item.setItemDetailList(this.itemDetailMapper.selectByItemId(item.getId())));
        }
        submitVO.setItemList(itemList);
        submitVO.setItemWeightList(this.itemWeightMapper.selectByMainId(id));
        submitVO.setScoreGradeList(this.scoreGradeMapper.selectByMainId(id));
        return submitVO;
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public List<ElsInspectionStandardItemDetail> selectWithoutElsAccountByItemId(String itemId) {
        return this.itemDetailMapper.selectWithoutElsAccountByItemId(itemId);
    }
}

