/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.spcn.adapter;

import com.alibaba.fastjson.JSONObject;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.ecn.rpc.service.EcnInvokeAccountRpcService;
import com.els.modules.ecn.rpc.service.EcnInvokeSupplierRpcService;
import com.els.modules.spcn.entity.PurchaseSpcn;
import com.els.modules.spcn.entity.SaleSpcn;
import com.els.modules.spcn.enumerate.PurchaseConfirmStatusEnum;
import com.els.modules.spcn.enumerate.SpcnStatusEnum;
import com.els.modules.spcn.service.PurchaseSpcnService;
import com.els.modules.spcn.service.SaleSpcnService;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpcnAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchaseSpcnService purchaseSpcnService;
    @Autowired
    private EcnInvokeAccountRpcService ecnInvokeAccountRpcService;
    @Autowired
    private SaleSpcnService saleSpcnService;
    @Resource
    private EcnInvokeSupplierRpcService ecnInvokeSupplierRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        this.sendMsg(inputParamVO, outputParamVO, "submitAudit");
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            this.sendMsg(inputParamVO, outputParamVO, "auditPass");
        } else {
            this.sendMsg(inputParamVO, outputParamVO, "submitAudit");
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        this.sendMsg(inputParamVO, outputParamVO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
    }

    private void updateAuditStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        SaleSpcn saleSpcn;
        PurchaseSpcn purchaseEcn = (PurchaseSpcn)((Object)this.purchaseSpcnService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        purchaseEcn.setAuditStatus(outputParamVO.getAuditStatus());
        purchaseEcn.setFlowId(outputParamVO.getProcessRootId());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            purchaseEcn.setSpcnStatus(SpcnStatusEnum.NORMAL.getValue());
            purchaseEcn.setPurchaseConfirmStatus(PurchaseConfirmStatusEnum.CONFIRMED.getValue());
            saleSpcn = (SaleSpcn)((Object)this.saleSpcnService.getById((Serializable)((Object)purchaseEcn.getRelationId())));
            saleSpcn.setSpcnStatus(SpcnStatusEnum.NORMAL.getValue());
            saleSpcn.setPurchaseConfirmStatus(PurchaseConfirmStatusEnum.CONFIRMED.getValue());
            this.saleSpcnService.updateById((Object)saleSpcn);
            this.sendMsg(purchaseEcn, "confirm");
        }
        if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            purchaseEcn.setSpcnStatus(SpcnStatusEnum.CANCELLATION.getValue());
            purchaseEcn.setPurchaseConfirmStatus(PurchaseConfirmStatusEnum.REFUSED.getValue());
            saleSpcn = (SaleSpcn)((Object)this.saleSpcnService.getById((Serializable)((Object)purchaseEcn.getRelationId())));
            saleSpcn.setSpcnStatus(SpcnStatusEnum.CANCELLATION.getValue());
            saleSpcn.setPurchaseConfirmStatus(PurchaseConfirmStatusEnum.REFUSED.getValue());
            this.saleSpcnService.updateById((Object)saleSpcn);
            this.sendMsg(purchaseEcn, "refund");
        }
        this.purchaseSpcnService.updateById((Object)purchaseEcn);
    }

    private void sendMsg(PurchaseSpcn spcn, String operation) {
        ArrayList<String> recevieAccount = new ArrayList<String>();
        recevieAccount.add(spcn.getToElsAccount());
        HashMap<String, List<ElsSubAccountDTO>> receiverMap = new HashMap<String, List<ElsSubAccountDTO>>();
        receiverMap.put(spcn.getToElsAccount(), this.ecnInvokeSupplierRpcService.getSubAccountListByJob(spcn.getToElsAccount()));
        MsgParamsVO paramsVO = new MsgParamsVO();
        paramsVO.setParams((Object)spcn);
        paramsVO.setReceiverMap(receiverMap);
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)"spcn", (String)operation, (MsgParamsVO)paramsVO);
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"ecn", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"ecn", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.ecnInvokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        Map<String, String> paramMap = inputParamVO.getVariables() == null ? new HashMap() : inputParamVO.getVariables();
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams(paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

