/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.siteInspection.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.i18n.I18nBaseEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AssertI18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.eightReport.entity.PurchaseEightDisciplinesZero;
import com.els.modules.eightReport.enumerate.EightReportStatusEnum;
import com.els.modules.eightReport.mapper.PurchaseEightDisciplinesZeroMapper;
import com.els.modules.eightReport.service.PurchaseEightDisciplinesZeroService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.siteInspection.entity.PurchaseInspectionHead;
import com.els.modules.siteInspection.entity.PurchaseInspectionItem;
import com.els.modules.siteInspection.entity.PurchaseInspectionPlan;
import com.els.modules.siteInspection.entity.PurchaseInspectionScoreGroup;
import com.els.modules.siteInspection.entity.SaleInspectionHead;
import com.els.modules.siteInspection.entity.SaleInspectionItem;
import com.els.modules.siteInspection.entity.SaleInspectionPlan;
import com.els.modules.siteInspection.entity.SaleInspectionScoreGroup;
import com.els.modules.siteInspection.enums.I18nSiteInspectEnum;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardItemDetailMapper;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardItemMapper;
import com.els.modules.siteInspection.mapper.ElsInspectionStandardScoreGradeMapper;
import com.els.modules.siteInspection.mapper.PurchaseInspectionHeadMapper;
import com.els.modules.siteInspection.mapper.PurchaseInspectionItemMapper;
import com.els.modules.siteInspection.mapper.PurchaseInspectionPlanMapper;
import com.els.modules.siteInspection.mapper.PurchaseInspectionScoreGroupMapper;
import com.els.modules.siteInspection.mapper.SaleInspectionHeadMapper;
import com.els.modules.siteInspection.mapper.SaleInspectionItemMapper;
import com.els.modules.siteInspection.mapper.SaleInspectionPlanMapper;
import com.els.modules.siteInspection.mapper.SaleInspectionScoreGroupMapper;
import com.els.modules.siteInspection.rpc.SiteInspectBaseRpcService;
import com.els.modules.siteInspection.service.PurchaseInspectionHeadService;
import com.els.modules.siteInspection.utils.BigDecimalUtil;
import com.els.modules.siteInspection.vo.EightReportVo;
import com.els.modules.siteInspection.vo.GetItemsReqVo;
import com.els.modules.siteInspection.vo.InspectionPlanReqSaveVo;
import com.els.modules.siteInspection.vo.InspectionPlanReqSubmitVo;
import com.els.modules.siteInspection.vo.InspectionScoreResVo;
import com.els.modules.siteInspection.vo.PurInspectionScoreReqVo;
import com.els.modules.siteInspection.vo.PurchaseInspectionHeadSaveVO;
import com.els.modules.siteInspection.vo.PurchaseInspectionHeadSubmitVO;
import com.els.modules.siteInspection.vo.ScoreGroupVo;
import com.els.modules.siteInspection.vo.ScoreItemVo;
import com.els.modules.siteInspection.vo.inspectionSheet.PurchaseInspectionItemVo;
import com.els.modules.siteInspection.vo.inspectionSheet.PurchaseInspectionPlanVo;
import com.els.modules.siteInspection.vo.inspectionSheet.PurchaseInspectionScoreGroupVo;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseInspectionHeadServiceImpl
extends BaseServiceImpl<PurchaseInspectionHeadMapper, PurchaseInspectionHead>
implements PurchaseInspectionHeadService {
    @Resource
    private PurchaseInspectionHeadMapper headMapper;
    @Resource
    private PurchaseInspectionItemMapper itemMapper;
    @Resource
    private PurchaseInspectionScoreGroupMapper scoreGroupMapper;
    @Resource
    private PurchaseInspectionPlanMapper planMapper;
    @Resource
    private SaleInspectionHeadMapper sHeadMapper;
    @Resource
    private SaleInspectionItemMapper sItemMapper;
    @Resource
    private SaleInspectionScoreGroupMapper sScoreGroupMapper;
    @Resource
    private SaleInspectionPlanMapper sPlanMapper;
    @Resource
    private PurchaseEightDisciplinesZeroMapper eightD0Mapper;
    @Resource
    private ElsInspectionStandardItemMapper standardItemMapper;
    @Resource
    private ElsInspectionStandardScoreGradeMapper scoreGradeMapper;
    @Autowired
    private ElsInspectionStandardItemDetailMapper itemDetailMapper;
    @Autowired
    private SiteInspectBaseRpcService baseRpcService;
    @Autowired
    private PurchaseEightDisciplinesZeroService eight0Service;

    private String getSerialNumber(Object businessObj) {
        return this.baseRpcService.getNextCode("siteInspectionNumber", businessObj);
    }

    private String getElsSubAccount() {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        return sysUser.getSubAccount();
    }

    private void delByHeadId(String headId) {
        if (StringUtils.isBlank((CharSequence)headId)) {
            return;
        }
        this.itemMapper.deleteByMainId(headId);
        this.scoreGroupMapper.deleteByMainId(headId);
        this.planMapper.deleteByMainId(headId);
    }

    private void setBaseEntity(BaseEntity baseEntity) {
        Date now = new Date();
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        baseEntity.setElsAccount(TenantContext.getTenant()).setCreateTime(now).setUpdateTime(now).setCreateBy(sysUser.getSubAccount()).setUpdateBy(sysUser.getSubAccount()).setDeleted(CommonConstant.DEL_FLAG_0);
    }

    private void saveInspectionItem(String headId, String standardName, String versionNumber, List<PurchaseInspectionItemVo> inspectionItemList) {
        if (CollectionUtils.isEmpty(inspectionItemList)) {
            return;
        }
        List<PurchaseInspectionItem> itemList = this.standardItemMapper.getItems(standardName, versionNumber, TenantContext.getTenant());
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        itemList.forEach(item -> inspectionItemList.forEach(itemVo -> {
            if (item.getInspectionStandardItemId().equals(itemVo.getInspectionStandardItemId())) {
                item.setRemark(itemVo.getRemark());
            }
            item.setHeadId(headId);
            this.setBaseEntity((BaseEntity)item);
        }));
        this.itemMapper.insertBatchSomeColumn(itemList);
    }

    private void saveScoreGroup(String headId, List<PurchaseInspectionScoreGroupVo> scoreGroupList) {
        if (CollectionUtils.isEmpty(scoreGroupList)) {
            return;
        }
        List inspectionScoreGroups = scoreGroupList.stream().map(vo -> {
            PurchaseInspectionScoreGroup inspectionScoreGroup = new PurchaseInspectionScoreGroup();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)inspectionScoreGroup));
            inspectionScoreGroup.setHeadId(headId);
            this.setBaseEntity(inspectionScoreGroup);
            return inspectionScoreGroup;
        }).collect(Collectors.toList());
        this.scoreGroupMapper.insertBatchSomeColumn(inspectionScoreGroups);
    }

    private void saveInspectionPlan(String headId, List<PurchaseInspectionPlanVo> inspectionPlanList) {
        if (CollectionUtils.isEmpty(inspectionPlanList)) {
            return;
        }
        List plans = inspectionPlanList.stream().map(vo -> {
            PurchaseInspectionPlan plan = new PurchaseInspectionPlan();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)plan));
            plan.setHeadId(headId);
            this.setBaseEntity(plan);
            return plan;
        }).collect(Collectors.toList());
        this.planMapper.insertBatchSomeColumn(plans);
    }

    private void pushToSaleHead(PurchaseInspectionHead pHead) {
        if (pHead.getInspectionStep().equals("2")) {
            return;
        }
        SaleInspectionHead saleInspectionHead = new SaleInspectionHead();
        BeanUtils.copyProperties((Object)((Object)pHead), (Object)((Object)saleInspectionHead));
        saleInspectionHead.setBusAccount(TenantContext.getTenant()).setDocumentsStatus("1").setRelationId(pHead.getId()).setElsAccount(pHead.getSaleElsAccount()).setId(IdWorker.getIdStr());
        this.sHeadMapper.insert((Object)saleInspectionHead);
        pHead.setDocumentsStatus("1").setRelationId(saleInspectionHead.getId());
    }

    private void validScoreAccountRepeat(List<PurchaseInspectionScoreGroup> scoreGroupList) {
        Map<String, Long> mapGroup = scoreGroupList.stream().collect(Collectors.groupingBy(PurchaseInspectionScoreGroup::getElsSubAccount, Collectors.counting()));
        for (Map.Entry<String, Long> map : mapGroup.entrySet()) {
            AssertI18nUtil.isTrue((map.getValue() > 1L ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.SCORE_GRADE_ACCOUNT_REPEAT, (String[])new String[]{map.getKey()});
        }
    }

    private void validScoreGroup(String name, String versionNumber, List<PurchaseInspectionScoreGroup> scoreGroupList) {
        List<String> itemClassifys = this.standardItemMapper.getClassifys(name, versionNumber, TenantContext.getTenant());
        if (CollectionUtils.isEmpty(itemClassifys)) {
            return;
        }
        List scoreClassifys = scoreGroupList.stream().map(PurchaseInspectionScoreGroup::getInspectionClassify).collect(Collectors.toList());
        for (String itemClassify : itemClassifys) {
            int count = 0;
            for (String inspectionClassify : scoreClassifys) {
                List<String> classifys = Arrays.asList(inspectionClassify.split(","));
                count += classifys.contains(itemClassify) ? 1 : 0;
                AssertI18nUtil.isTrue((!itemClassifys.containsAll(classifys) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.SCORE_GROUP_NO_CLASSIFY);
            }
            AssertI18nUtil.isTrue((count > 1 ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.CLASSIFY_MANY_SCORE_GROUP);
            AssertI18nUtil.isTrue((count <= 0 ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.CLASSIFY_NO_SCORE_GROUP);
        }
    }

    private void submitInspectionItem(String name, String versionNumber, String headId, String relationId, String saleAccount, List<PurchaseInspectionItemVo> pItemVoList) {
        List<PurchaseInspectionItem> itemList = this.standardItemMapper.getItems(name, versionNumber, TenantContext.getTenant());
        AssertI18nUtil.isTrue((boolean)CollectionUtils.isEmpty(itemList), (Enum)I18nSiteInspectEnum.INSPECT_ITEM_IS_EMPTY);
        ArrayList<SaleInspectionItem> sItemList = new ArrayList<SaleInspectionItem>();
        for (PurchaseInspectionItem pItem : itemList) {
            pItemVoList.forEach(itemVo -> {
                if (pItem.getInspectionStandardItemId().equals(itemVo.getInspectionStandardItemId())) {
                    pItem.setRemark(itemVo.getRemark());
                }
            });
            pItem.setHeadId(headId).setRelationId(relationId).setBusAccount(saleAccount).setId(IdWorker.getIdStr());
            this.setBaseEntity(pItem);
            if (StringUtils.isBlank((CharSequence)relationId)) continue;
            SaleInspectionItem sItem = new SaleInspectionItem();
            BeanUtils.copyProperties((Object)((Object)pItem), (Object)((Object)sItem));
            sItem.setHeadId(relationId).setRelationId(headId).setSourceId(pItem.getId()).setBusAccount(TenantContext.getTenant()).setElsAccount(saleAccount).setId(IdWorker.getIdStr());
            sItemList.add(sItem);
            pItem.setToSaleId(sItem.getId());
        }
        this.itemMapper.insertBatchSomeColumn(itemList);
        if (!CollectionUtils.isEmpty(sItemList)) {
            this.sItemMapper.insertBatchSomeColumn(sItemList);
        }
    }

    private void submitScoreGroup(String headId, String relationId, String saleAccount, List<PurchaseInspectionScoreGroup> pScoreGroupList) {
        ArrayList<SaleInspectionScoreGroup> sScoreGroupList = new ArrayList<SaleInspectionScoreGroup>();
        for (PurchaseInspectionScoreGroup pScoreGroup : pScoreGroupList) {
            pScoreGroup.setHeadId(headId).setRelationId(relationId).setBusAccount(saleAccount).setId(IdWorker.getIdStr());
            this.setBaseEntity(pScoreGroup);
            if (StringUtils.isBlank((CharSequence)relationId)) continue;
            SaleInspectionScoreGroup sScoreGroup = new SaleInspectionScoreGroup();
            BeanUtils.copyProperties((Object)((Object)pScoreGroup), (Object)((Object)sScoreGroup));
            sScoreGroup.setHeadId(relationId).setRelationId(headId).setSourceId(pScoreGroup.getId()).setBusAccount(TenantContext.getTenant()).setElsAccount(saleAccount).setId(IdWorker.getIdStr());
            pScoreGroup.setToSaleId(sScoreGroup.getId());
            sScoreGroupList.add(sScoreGroup);
        }
        this.scoreGroupMapper.insertBatchSomeColumn(pScoreGroupList);
        if (!CollectionUtils.isEmpty(sScoreGroupList)) {
            this.sScoreGroupMapper.insertBatchSomeColumn(sScoreGroupList);
        }
    }

    private void submitInspectionPlan(String headId, String relationId, String saleAccount, List<PurchaseInspectionPlan> pPlanList) {
        ArrayList<SaleInspectionPlan> sPlanList = new ArrayList<SaleInspectionPlan>();
        for (PurchaseInspectionPlan pPlan : pPlanList) {
            pPlan.setHeadId(headId).setRelationId(relationId).setBusAccount(saleAccount).setId(IdWorker.getIdStr());
            this.setBaseEntity(pPlan);
            if (StringUtils.isBlank((CharSequence)relationId)) continue;
            SaleInspectionPlan sPlan = new SaleInspectionPlan();
            BeanUtils.copyProperties((Object)((Object)pPlan), (Object)((Object)sPlan));
            sPlan.setHeadId(relationId).setRelationId(headId).setSourceId(pPlan.getId()).setBusAccount(TenantContext.getTenant()).setElsAccount(saleAccount).setId(IdWorker.getIdStr());
            pPlan.setToSaleId(sPlan.getId());
            sPlanList.add(sPlan);
        }
        this.planMapper.insertBatchSomeColumn(pPlanList);
        if (!CollectionUtils.isEmpty(sPlanList)) {
            this.sPlanMapper.insertBatchSomeColumn(sPlanList);
        }
    }

    private void sendFile(String purchaseHeadId, String saleHeadId, String elsAccount, String toElsAccount) {
        if (StringUtils.isBlank((CharSequence)saleHeadId)) {
            return;
        }
        AttachmentSendDTO attachmentSendVO = new AttachmentSendDTO();
        attachmentSendVO.setHeadId(purchaseHeadId);
        attachmentSendVO.setElsAccount(elsAccount);
        HashMap toSend = Maps.newHashMap();
        toSend.put(saleHeadId, toElsAccount);
        attachmentSendVO.setToSend((Map)toSend);
        this.baseRpcService.sendPurchaseFile(attachmentSendVO);
    }

    private void submitRow(PurchaseInspectionHeadSubmitVO submitVO) {
        this.submitInspectionItem(submitVO.getInspectionStandardName(), submitVO.getInspectionStandardVersion(), submitVO.getId(), submitVO.getRelationId(), submitVO.getSaleElsAccount(), submitVO.getInspectionItemList());
        this.submitScoreGroup(submitVO.getId(), submitVO.getRelationId(), submitVO.getSaleElsAccount(), submitVO.getScoreGroupList());
        this.submitInspectionPlan(submitVO.getId(), submitVO.getRelationId(), submitVO.getSaleElsAccount(), submitVO.getInspectionPlanList());
        this.sendFile(submitVO.getId(), submitVO.getRelationId(), TenantContext.getTenant(), submitVO.getSaleElsAccount());
    }

    private int getDecimalPlace(String fullMark) {
        return fullMark.contains(".") ? fullMark.split("\\.")[1].length() : 2;
    }

    private void saveScoreItem(String classify, PurInspectionScoreReqVo reqVo) {
        this.itemMapper.getSelfScoreItem(reqVo.getId(), classify).forEach(itemVo -> {
            reqVo.getInspectionItemList().forEach(reqItem -> {
                if (!itemVo.getId().equals(reqItem.getId())) {
                    return;
                }
                itemVo.setInspectScore(reqItem.getInspectScore()).setInspectResult(reqItem.getInspectResult());
            });
            this.itemMapper.updateById(itemVo);
        });
    }

    private void submitScoreItem(String classify, PurInspectionScoreReqVo reqVo) {
        this.itemMapper.getSelfScoreItem(reqVo.getId(), classify).forEach(itemVo -> {
            reqVo.getInspectionItemList().forEach(reqItem -> {
                if (!itemVo.getId().equals(reqItem.getId())) {
                    return;
                }
                AssertI18nUtil.isTrue((boolean)BigDecimalUtil.bigThan(reqItem.getInspectScore(), itemVo.getFullMark()), (Enum)I18nSiteInspectEnum.SCORE_BIG_FULL_MARK);
                itemVo.setInspectScore(reqItem.getInspectScore()).setInspectResult(reqItem.getInspectResult());
            });
            this.itemMapper.updateById(itemVo);
            if (StringUtils.isBlank((CharSequence)itemVo.getToSaleId())) {
                return;
            }
            SaleInspectionItem saleInspectionItem = new SaleInspectionItem();
            saleInspectionItem.setInspectScore(itemVo.getInspectScore()).setInspectResult(itemVo.getInspectResult()).setId(itemVo.getToSaleId());
            this.sItemMapper.updateById((Object)saleInspectionItem);
        });
    }

    private void updateScoreType(String classify, String id, String relationId) {
        String scoreType = this.itemMapper.countSelfNoScore(id, classify) > 0 ? "1" : "2";
        this.scoreGroupMapper.updateScoreType(id, this.getElsSubAccount(), scoreType);
        this.sScoreGroupMapper.updateScoreType(relationId, this.getElsSubAccount(), scoreType);
    }

    private void updatePartScore(PurchaseInspectionHead head) {
        if (this.itemMapper.countScoreItem(head.getId()) <= 0) {
            return;
        }
        head.setDocumentsStatus("3");
        this.headMapper.updateById((Object)head);
        SaleInspectionHead saleInspectionHead = new SaleInspectionHead();
        saleInspectionHead.setDocumentsStatus("3").setId(head.getRelationId());
        this.sHeadMapper.updateById((Object)saleInspectionHead);
    }

    private void updateScoreFinish(PurchaseInspectionHead head) {
        List<ScoreItemVo> scoreItemVos = this.itemMapper.getAllScoreItem(head.getId());
        int decimalPlace = this.getDecimalPlace(scoreItemVos.get(0).getFullMark());
        BigDecimal sumSocre = BigDecimalUtil.getZero();
        Map<String, BigDecimal> mapGroup = scoreItemVos.parallelStream().collect(Collectors.groupingBy(ScoreItemVo::getInspectionItemClassify, Collectors.collectingAndThen(Collectors.toList(), m -> {
            BigDecimal sumResult = m.parallelStream().map(i -> new BigDecimal(i.getFullMark())).reduce(BigDecimal.ZERO, BigDecimal::add);
            return m.parallelStream().map(i -> BigDecimalUtil.multiplyWeight(i.getScore(), i.getWeight())).reduce(BigDecimal.ZERO, BigDecimal::add).divide(sumResult, decimalPlace, 4).multiply(new BigDecimal(head.getStandardFullMarks()));
        })));
        for (Map.Entry<String, BigDecimal> entry : mapGroup.entrySet()) {
            sumSocre = sumSocre.add(entry.getValue());
        }
        ScoreGroupVo scoreGroupVo = this.scoreGradeMapper.getScoreGroupByScore(head.getInspectionStandardName(), head.getInspectionStandardVersion(), sumSocre, TenantContext.getTenant());
        String status = "1".equals(head.getPubishAudit()) ? "4" : ("2".equals(scoreGroupVo.getInspectionConclusion()) ? "5" : "6");
        head.setInspectScore(sumSocre.toString()).setScoreGrade(scoreGroupVo.getScoreGrade()).setInspectionConclusion(scoreGroupVo.getInspectionConclusion()).setDocumentsStatus(status);
        this.headMapper.updateById((Object)head);
        SaleInspectionHead saleInspectionHead = new SaleInspectionHead();
        saleInspectionHead.setInspectScore(sumSocre.toString()).setScoreGrade(scoreGroupVo.getScoreGrade()).setInspectionConclusion(scoreGroupVo.getInspectionConclusion()).setDocumentsStatus(status).setId(head.getRelationId());
        this.sHeadMapper.updateById((Object)saleInspectionHead);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createNewRecord(PurchaseInspectionHeadSaveVO headSaveVO) {
        PurchaseInspectionHead inspectionHead = new PurchaseInspectionHead();
        BeanUtils.copyProperties((Object)headSaveVO, (Object)((Object)inspectionHead));
        inspectionHead.setDocumentsSerialNumber(this.getSerialNumber(headSaveVO)).setDocumentsStatus("0").setId(IdWorker.getIdStr());
        headSaveVO.setId(inspectionHead.getId());
        this.headMapper.insert((Object)inspectionHead);
        this.saveInspectionItem(inspectionHead.getId(), headSaveVO.getInspectionStandardName(), headSaveVO.getInspectionStandardVersion(), headSaveVO.getInspectionItemList());
        this.saveScoreGroup(inspectionHead.getId(), headSaveVO.getScoreGroupList());
        this.saveInspectionPlan(inspectionHead.getId(), headSaveVO.getInspectionPlanList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateRecord(PurchaseInspectionHeadSaveVO headSaveVO) {
        int countNum = this.headMapper.countByIAndStatus(headSaveVO.getId(), "0");
        AssertI18nUtil.isTrue((countNum <= 0 ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.P_INSPECT_NULL_NOT_NEW);
        this.delByHeadId(headSaveVO.getId());
        this.saveInspectionItem(headSaveVO.getId(), headSaveVO.getInspectionStandardName(), headSaveVO.getInspectionStandardVersion(), headSaveVO.getInspectionItemList());
        this.saveScoreGroup(headSaveVO.getId(), headSaveVO.getScoreGroupList());
        this.saveInspectionPlan(headSaveVO.getId(), headSaveVO.getInspectionPlanList());
        PurchaseInspectionHead inspectionHead = new PurchaseInspectionHead();
        BeanUtils.copyProperties((Object)headSaveVO, (Object)((Object)inspectionHead));
        this.headMapper.updateById((Object)inspectionHead);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitRecordNoId(PurchaseInspectionHeadSubmitVO submitVO) {
        AssertI18nUtil.isTrue((!submitVO.getInspectionStep().equals("2") && StringUtils.isBlank((CharSequence)submitVO.getSaleElsAccount()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.SALE_ACCOUNT_IS_NULL);
        this.validScoreAccountRepeat(submitVO.getScoreGroupList());
        this.validScoreGroup(submitVO.getInspectionStandardName(), submitVO.getInspectionStandardVersion(), submitVO.getScoreGroupList());
        submitVO.setDocumentsSerialNumber(this.getSerialNumber((Object)submitVO)).setDocumentsStatus("2").setBusAccount(submitVO.getSaleElsAccount()).setSelfAssessmentScore(null).setInspectScore(null).setScoreGrade(null).setInspectionConclusion(null).setId(IdWorker.getIdStr());
        this.pushToSaleHead(submitVO);
        this.headMapper.insert((Object)submitVO);
        this.submitRow(submitVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitRecordWithId(PurchaseInspectionHeadSubmitVO submitVO) {
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)submitVO.getId()), (Enum)I18nBaseEnum.RECORD_ID_IS_NULL);
        int countNum = this.headMapper.countByIAndStatus(submitVO.getId(), "0");
        AssertI18nUtil.isTrue((countNum <= 0 ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.P_INSPECT_NULL_NOT_NEW);
        AssertI18nUtil.isTrue((!submitVO.getInspectionStep().equals("2") && StringUtils.isBlank((CharSequence)submitVO.getSaleElsAccount()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.SALE_ACCOUNT_IS_NULL);
        this.validScoreAccountRepeat(submitVO.getScoreGroupList());
        this.validScoreGroup(submitVO.getInspectionStandardName(), submitVO.getInspectionStandardVersion(), submitVO.getScoreGroupList());
        this.delByHeadId(submitVO.getId());
        submitVO.setDocumentsStatus("2").setSelfAssessmentScore(null).setInspectScore(null).setScoreGrade(null).setInspectionConclusion(null).setBusAccount(submitVO.getSaleElsAccount());
        this.pushToSaleHead(submitVO);
        this.headMapper.updateById((Object)submitVO);
        this.submitRow(submitVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveItemScore(PurInspectionScoreReqVo reqVo) {
        PurchaseInspectionHead head = (PurchaseInspectionHead)((Object)this.headMapper.selectById((Serializable)((Object)reqVo.getId())));
        AssertI18nUtil.isTrue((!"2".equals(head.getDocumentsStatus()) && !"3".equals(head.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.NOT_SCORE_IN_STATUS);
        String classify = this.scoreGroupMapper.getInspectionClassify(reqVo.getId(), this.getElsSubAccount());
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)classify), (Enum)I18nSiteInspectEnum.ACCOUNT_CAN_NOT_SCORE);
        this.saveScoreItem(classify, reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PurchaseInspectionHead submitItemScore(PurInspectionScoreReqVo reqVo) {
        PurchaseInspectionHead head = (PurchaseInspectionHead)((Object)this.headMapper.selectById((Serializable)((Object)reqVo.getId())));
        AssertI18nUtil.isTrue((!"2".equals(head.getDocumentsStatus()) && !"3".equals(head.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.NOT_SCORE_IN_STATUS);
        String classify = this.scoreGroupMapper.getInspectionClassify(reqVo.getId(), this.getElsSubAccount());
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)classify), (Enum)I18nSiteInspectEnum.ACCOUNT_CAN_NOT_SCORE);
        this.submitScoreItem(classify, reqVo);
        this.updateScoreType(classify, head.getId(), head.getRelationId());
        if (this.itemMapper.countNoScoreItem(head.getId()) > 0) {
            this.updatePartScore(head);
        } else {
            this.updateScoreFinish(head);
        }
        return head;
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public InspectionScoreResVo getById(String id) {
        InspectionScoreResVo resVo = new InspectionScoreResVo();
        PurchaseInspectionHead head = (PurchaseInspectionHead)((Object)this.headMapper.selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((head == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)resVo));
        List<PurchaseInspectionItem> itemList = this.itemMapper.selectByMainId(id);
        if (!CollectionUtils.isEmpty(itemList)) {
            itemList.forEach(item -> item.setItemDetailList(this.itemDetailMapper.selectWithoutElsAccountByItemId(item.getInspectionStandardItemId())));
        }
        resVo.setInspectionItemList(itemList);
        resVo.setScoreGroupList(this.scoreGroupMapper.selectByMainId(id));
        resVo.setInspectionPlanList(this.planMapper.selectByMainId(id));
        resVo.setAttachmentList(this.baseRpcService.purcahseSelectByMainId(id));
        return resVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delMain(String id) {
        int countNum = this.headMapper.countByIAndStatus(id, "0");
        AssertI18nUtil.isTrue((countNum <= 0 ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.P_INSPECT_NULL_NOT_NEW);
        this.headMapper.deleteById((Serializable)((Object)id));
        this.delByHeadId(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancellation(String id) {
        PurchaseInspectionHead purchaseInspectionHead = (PurchaseInspectionHead)((Object)this.headMapper.selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((purchaseInspectionHead == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        String status = purchaseInspectionHead.getDocumentsStatus();
        AssertI18nUtil.isTrue(("5".equals(status) || "6".equals(status) || "7".equals(status) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.STATUS_CANCELLATION_FAIL);
        purchaseInspectionHead.setDocumentsStatus("7");
        this.headMapper.updateById((Object)purchaseInspectionHead);
        if (StringUtils.isBlank((CharSequence)purchaseInspectionHead.getRelationId())) {
            return;
        }
        SaleInspectionHead saleInspectionHead = (SaleInspectionHead)((Object)this.sHeadMapper.selectById((Serializable)((Object)purchaseInspectionHead.getRelationId())));
        saleInspectionHead.setDocumentsStatus("7");
        this.sHeadMapper.updateById((Object)saleInspectionHead);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<PurchaseInspectionItem> getItems(GetItemsReqVo reqVo) {
        return this.standardItemMapper.getItems(reqVo.getName(), reqVo.getVersionNumber(), TenantContext.getTenant());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void savePlanTailAfter(InspectionPlanReqSaveVo reqVo) {
        PurchaseInspectionHead purchaseInspectionHead = (PurchaseInspectionHead)((Object)this.headMapper.selectById((Serializable)((Object)reqVo.getId())));
        AssertI18nUtil.isTrue((purchaseInspectionHead == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        reqVo.getInspectionPlanList().forEach(planVo -> {
            PurchaseInspectionPlan purPlan = (PurchaseInspectionPlan)((Object)((Object)this.planMapper.selectById((Serializable)((Object)planVo.getId()))));
            AssertI18nUtil.isTrue((purPlan == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
            purPlan.setPlanStage(planVo.getPlanStage()).setPlanFinishTime(planVo.getPlanFinishTime()).setActualFinishTime(planVo.getActualFinishTime()).setPlanTailAfter(planVo.getPlanTailAfter()).setRemark(planVo.getRemark());
            this.planMapper.updateById((Object)purPlan);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitPlanTailAfter(InspectionPlanReqSubmitVo reqVo) {
        PurchaseInspectionHead purHead = (PurchaseInspectionHead)((Object)this.headMapper.selectById((Serializable)((Object)reqVo.getId())));
        AssertI18nUtil.isTrue((purHead == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        reqVo.getInspectionPlanList().forEach(planVo -> {
            this.planMapper.updateById(planVo);
            if (StringUtils.isBlank((CharSequence)planVo.getToSaleId())) {
                return;
            }
            SaleInspectionPlan salePlan = (SaleInspectionPlan)((Object)((Object)this.sPlanMapper.selectById((Serializable)((Object)planVo.getToSaleId()))));
            AssertI18nUtil.isTrue((salePlan == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
            salePlan.setPlanStage(planVo.getPlanStage()).setPlanFinishTime(planVo.getPlanFinishTime()).setActualFinishTime(planVo.getActualFinishTime()).setPlanTailAfter(planVo.getPlanTailAfter()).setRemark(planVo.getRemark());
            this.sPlanMapper.updateById((Object)salePlan);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rectification(String id) {
        PurchaseInspectionHead purHead = (PurchaseInspectionHead)((Object)this.headMapper.selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((purHead == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        AssertI18nUtil.isTrue((!"5".equals(purHead.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.STATUS_CAN_NOT_RECTIFICATION);
        AssertI18nUtil.isTrue((!"2".equals(purHead.getInspectionConclusion()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.INSPECTION_CONCLUSION_CAN_NOT_RECTIFICATION);
        PurchaseEightDisciplinesZero eightD0 = new PurchaseEightDisciplinesZero();
        LoginUser sysUser = SysUtil.getLoginUser();
        eightD0.setEightDisciplinesNumber(this.baseRpcService.getNextCode("eightDisciplines", (Object)eightD0)).setEightDisciplinesStatus(EightReportStatusEnum.D0.getValue()).setEightDisciplinesType("gysgj").setQuestionSource("XCKC").setSourceNumber(purHead.getDocumentsSerialNumber()).setToElsAccount(purHead.getSaleElsAccount()).setSupplierCode(purHead.getSupplierErpCode()).setSupplierName(purHead.getSupplierName()).setPurchaseOrg(purHead.getPurchaseOrgCode()).setFactory(purHead.getFactoryCode()).setMaterialNumber(purHead.getMaterialType()).setRelationId(IdWorker.getIdStr()).setPublishUser(sysUser.getSubAccount() + "_" + sysUser.getRealname()).setBusAccount(TenantContext.getTenant());
        List<PurchaseOrganizationInfoDTO> deptOrgList = this.eight0Service.getDeptById(sysUser.getOrgCode());
        if (CollectionUtil.isNotEmpty(deptOrgList)) {
            eightD0.setCreateDepartment(this.eight0Service.getDeptName(deptOrgList));
            eightD0.setCreateDepartmentId(this.eight0Service.getDeptCode(deptOrgList));
        }
        this.eightD0Mapper.insert((Object)eightD0);
        purHead.setEightReportNumber(eightD0.getEightDisciplinesNumber()).setEightReportStatus(eightD0.getEightDisciplinesStatus());
        this.headMapper.updateById((Object)purHead);
        if (StringUtils.isBlank((CharSequence)purHead.getRelationId())) {
            return;
        }
        SaleInspectionHead saleHead = new SaleInspectionHead();
        saleHead.setEightReportNumber(eightD0.getEightDisciplinesNumber()).setEightReportStatus(eightD0.getEightDisciplinesStatus()).setId(purHead.getRelationId());
        this.sHeadMapper.updateById((Object)saleHead);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setEightReport(List<PurchaseInspectionHead> heads) {
        if (CollectionUtils.isEmpty(heads)) {
            return;
        }
        List<String> ltNums = heads.stream().filter(head -> StringUtils.isNotBlank((CharSequence)head.getEightReportNumber()) && !EightReportStatusEnum.D9.getValue().equals(head.getEightReportStatus())).map(PurchaseInspectionHead::getEightReportNumber).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ltNums)) {
            return;
        }
        List<EightReportVo> eightReportVos = this.headMapper.getEightReport(ltNums);
        if (CollectionUtils.isEmpty(eightReportVos)) {
            heads.forEach(purHead -> {
                if (StringUtils.isBlank((CharSequence)purHead.getEightReportNumber())) {
                    return;
                }
                purHead.setEightReportNumber(null).setEightReportStatus(null).setEightReportEvaluate(null);
                this.headMapper.clearEightReport(purHead.getId());
            });
            return;
        }
        Map<String, EightReportVo> mapEightReportVos = eightReportVos.stream().collect(Collectors.toMap(EightReportVo::getEightDisciplinesNumber, reportVo -> reportVo));
        for (PurchaseInspectionHead head2 : heads) {
            if (StringUtils.isBlank((CharSequence)head2.getEightReportNumber())) continue;
            EightReportVo reportVo2 = mapEightReportVos.get(head2.getEightReportNumber());
            if (reportVo2 == null || CommonConstant.DEL_FLAG_0.intValue() != reportVo2.getDeleted()) {
                head2.setEightReportNumber(null).setEightReportStatus(null).setEightReportEvaluate(null);
                this.headMapper.clearEightReport(head2.getId());
                continue;
            }
            head2.setEightReportStatus(reportVo2.getEightDisciplinesStatus()).setEightReportEvaluate(reportVo2.getClosedCondition());
            if (EightReportStatusEnum.D9.getValue().equals(reportVo2.getEightDisciplinesStatus())) {
                head2.setDocumentsStatus("6");
            }
            this.headMapper.updateEightReport(head2.getId(), head2.getEightReportStatus(), head2.getEightReportEvaluate(), head2.getDocumentsStatus());
        }
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public InspectionScoreResVo getSelfScoreItemDetail(String id) {
        InspectionScoreResVo resVo = new InspectionScoreResVo();
        PurchaseInspectionHead head = (PurchaseInspectionHead)((Object)this.headMapper.selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((head == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)resVo));
        String classify = this.scoreGroupMapper.getInspectionClassify(id, this.getElsSubAccount());
        List<PurchaseInspectionItem> itemList = this.itemMapper.getSelfScoreItem(id, classify);
        if (!CollectionUtils.isEmpty(itemList)) {
            itemList.forEach(item -> item.setItemDetailList(this.itemDetailMapper.selectWithoutElsAccountByItemId(item.getInspectionStandardItemId())));
        }
        resVo.setInspectionItemList(itemList);
        resVo.setScoreGroupList(this.scoreGroupMapper.selectByMainId(id));
        resVo.setInspectionPlanList(this.planMapper.selectByMainId(id));
        resVo.setAttachmentList(this.baseRpcService.purcahseSelectByMainId(id));
        return resVo;
    }
}

