/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.trial.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.trial.entity.PurchaseTrialProductionHead;
import com.els.modules.trial.enumerate.PurchaseTrialProductionHeadEnum;
import com.els.modules.trial.service.PurchaseTrialProductionHeadService;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PurchaseTrialProductionAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchaseTrialProductionHeadService purchaseTrialProductionHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String param = StringUtils.isEmpty((Object)inputParamVO.getParams()) ? "{}" : inputParamVO.getParams();
        PurchaseTrialProductionHead purchaseTrialProductionHead = (PurchaseTrialProductionHead)((Object)JSONObject.parseObject((String)param, PurchaseTrialProductionHead.class));
        purchaseTrialProductionHead.setAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue());
        purchaseTrialProductionHead.setFlowId(outputParamVO.getProcessRootId());
        this.purchaseTrialProductionHeadService.updateById((Object)purchaseTrialProductionHead);
        this.sendMsg(inputParamVO, outputParamVO, "submitAudit");
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseTrialProductionHead purchaseTrialProductionHead = (PurchaseTrialProductionHead)((Object)this.purchaseTrialProductionHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        purchaseTrialProductionHead.setId(inputParamVO.getBusinessId());
        purchaseTrialProductionHead.setAuditStatus(outputParamVO.getAuditStatus());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            purchaseTrialProductionHead.setTrialStatus(PurchaseTrialProductionHeadEnum.FINAL.getValue());
        }
        this.purchaseTrialProductionHeadService.updateById((Object)purchaseTrialProductionHead);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            this.sendMsg(inputParamVO, outputParamVO, "auditPass");
        } else {
            this.sendMsg(inputParamVO, outputParamVO, "submitAudit");
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseTrialProductionHead purchaseTrialProductionHead = (PurchaseTrialProductionHead)((Object)this.purchaseTrialProductionHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        purchaseTrialProductionHead.setId(inputParamVO.getBusinessId());
        purchaseTrialProductionHead.setAuditStatus(outputParamVO.getAuditStatus());
        this.purchaseTrialProductionHeadService.updateById((Object)purchaseTrialProductionHead);
        this.sendMsg(inputParamVO, outputParamVO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseTrialProductionHead purchaseTrialProductionHead = (PurchaseTrialProductionHead)((Object)this.purchaseTrialProductionHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        purchaseTrialProductionHead.setId(inputParamVO.getBusinessId());
        purchaseTrialProductionHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        this.purchaseTrialProductionHeadService.updateById((Object)purchaseTrialProductionHead);
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"enquiry", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamVO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"enquiry", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String businessType = inputParamVO.getBusinessType();
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        PurchaseTrialProductionHead purchaseTrialProductionHead = (PurchaseTrialProductionHead)((Object)this.purchaseTrialProductionHeadService.getById((Serializable)((Object)headId)));
        Result result = Result.ok((Object)((Object)purchaseTrialProductionHead));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

