/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mould.adapter;

import com.els.common.enumerate.AuditStatusEnum;
import com.els.modules.mould.entity.PurchaseMouldScrapped;
import com.els.modules.mould.service.PurchaseMouldScrappedService;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="mouldScrappedAuditServiceImpl")
public class MouldScrappedAuditServiceImpl
implements AuditOptCallBackService {
    @Autowired
    private PurchaseMouldScrappedService purchaseMouldScrappedService;

    public void startCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
    }

    public void completeCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
    }

    public void rejectCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateAuditStatus(inputParamDTO, outputParamDTO);
    }

    private void updateAuditStatus(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        PurchaseMouldScrapped scrapped = (PurchaseMouldScrapped)((Object)this.purchaseMouldScrappedService.getById((Serializable)((Object)inputParamDTO.getBusinessId())));
        scrapped.setFlowId(outputParamDTO.getProcessRootId());
        scrapped.setAuditStatus(outputParamDTO.getAuditStatus());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamDTO.getAuditStatus())) {
            this.purchaseMouldScrappedService.confirm(scrapped);
            return;
        }
        if (AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamDTO.getAuditStatus())) {
            scrapped.setPurchaseRemark(inputParamDTO.getAuditOpinion());
            this.purchaseMouldScrappedService.refuse(scrapped);
            return;
        }
        this.purchaseMouldScrappedService.updateById((Object)scrapped);
    }
}

