/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.siteInspection.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.enumerate.i18n.I18nBaseEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.AssertI18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.siteInspection.entity.PurchaseInspectionHead;
import com.els.modules.siteInspection.entity.SaleInspectionHead;
import com.els.modules.siteInspection.enums.I18nSiteInspectEnum;
import com.els.modules.siteInspection.mapper.PurchaseInspectionHeadMapper;
import com.els.modules.siteInspection.mapper.SaleInspectionHeadMapper;
import com.els.modules.siteInspection.service.PurchaseInspectionHeadService;
import com.els.modules.siteInspection.vo.InspectionScoreResVo;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="siteInspectionAdapter")
public class SiteInspectionAdapter
implements AuditOptCallBackService {
    @Resource
    private PurchaseInspectionHeadMapper purHeadMapper;
    @Resource
    private SaleInspectionHeadMapper saleHeadMapper;
    @Autowired
    private PurchaseInspectionHeadService purService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    private void updateAudiStatus(String businessId, String auditStatus, String processRootId) {
        PurchaseInspectionHead head = (PurchaseInspectionHead)((Object)this.purHeadMapper.selectById((Serializable)((Object)businessId)));
        AssertI18nUtil.isTrue((head == null ? 1 : 0) != 0, (Enum)I18nBaseEnum.RECORD_IS_NULL);
        AssertI18nUtil.isTrue((!"1".equals(head.getPubishAudit()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.NOT_AUDI_FAIL);
        AssertI18nUtil.isTrue((!"4".equals(head.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nSiteInspectEnum.NOT_SCORE_STATUS_FAIL);
        head.setResultAuditStatus(auditStatus).setResultFlowId(processRootId);
        if (Objects.equals(AuditStatusEnum.AUDIT_FINISH.getValue(), auditStatus)) {
            String status = "2".equals(head.getInspectionConclusion()) ? "5" : "6";
            head.setDocumentsStatus(status);
        } else if (Objects.equals(AuditStatusEnum.AUDIT_REJECT.getValue(), auditStatus)) {
            head.setDocumentsStatus("3");
        }
        this.purHeadMapper.updateById((Object)head);
        if (StringUtils.isBlank((CharSequence)head.getRelationId())) {
            return;
        }
        SaleInspectionHead saleInspectionHead = (SaleInspectionHead)((Object)this.saleHeadMapper.selectById((Serializable)((Object)head.getRelationId())));
        if (saleInspectionHead == null) {
            return;
        }
        saleInspectionHead.setResultAuditStatus(auditStatus).setResultFlowId(processRootId);
        saleInspectionHead.setDocumentsStatus(head.getDocumentsStatus());
        this.saleHeadMapper.updateById((Object)saleInspectionHead);
    }

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId());
        this.sendMsg(inputParamVO, outputParamVO, "submitAudit");
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId());
        String operType = AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) ? "auditPass" : "submitAudit";
        this.sendMsg(inputParamVO, outputParamVO, operType);
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId());
        this.sendMsg(inputParamVO, outputParamVO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAudiStatus(inputParamVO.getBusinessId(), outputParamVO.getAuditStatus(), outputParamVO.getProcessRootId());
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"siteInspection", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamVO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"siteInspection", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String businessType = inputParamVO.getBusinessType();
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        InspectionScoreResVo resVo = this.purService.getById(headId);
        Result result = Result.ok((Object)((Object)resVo));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

