/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.service.impl;

import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.sample.entity.PurchaseSampleCheckHead;
import com.els.modules.sample.entity.PurchaseSampleCheckItem;
import com.els.modules.sample.entity.PurchaseSampleTrackingItem;
import com.els.modules.sample.enumerate.PurchaseSampleCheckHeadEnum;
import com.els.modules.sample.enumerate.SampleUseLinkEnum;
import com.els.modules.sample.mapper.PurchaseSampleCheckHeadMapper;
import com.els.modules.sample.mapper.PurchaseSampleCheckItemMapper;
import com.els.modules.sample.mapper.PurchaseSampleTrackingItemMapper;
import com.els.modules.sample.service.PurchaseSampleCheckHeadService;
import com.els.modules.sample.service.PurchaseSampleCheckItemService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PurchaseSampleCheckHeadServiceImpl
extends BaseServiceImpl<PurchaseSampleCheckHeadMapper, PurchaseSampleCheckHead>
implements PurchaseSampleCheckHeadService {
    @Resource
    private PurchaseSampleCheckHeadMapper purchaseSampleCheckHeadMapper;
    @Resource
    private PurchaseSampleCheckItemMapper purchaseSampleCheckItemMapper;
    @Resource
    private PurchaseSampleCheckItemService purchaseSampleCheckItemService;
    @Resource
    private PurchaseSampleTrackingItemMapper purchaseSampleTrackingItemMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseSampleCheckHead purchaseSampleCheckHead, List<PurchaseSampleCheckItem> purchaseSampleCheckItemList) {
        purchaseSampleCheckHead.setCheckNumber(this.invokeBaseRpcService.getNextCode("srmSampleCheckNumber", (Object)purchaseSampleCheckHead));
        purchaseSampleCheckHead.setCheckStatus(PurchaseSampleCheckHeadEnum.NEW.getValue());
        this.purchaseSampleCheckHeadMapper.insert((Object)purchaseSampleCheckHead);
        if (purchaseSampleCheckItemList != null) {
            this.insertData(purchaseSampleCheckHead, purchaseSampleCheckItemList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseSampleCheckHead purchaseSampleCheckHead, List<PurchaseSampleCheckItem> purchaseSampleCheckItemList, Integer type) {
        Date now = new Date();
        if (type != null && 2 == type) {
            purchaseSampleCheckHead.setCheckStartDate(now);
        }
        this.purchaseSampleCheckHeadMapper.updateById((Object)purchaseSampleCheckHead);
        this.purchaseSampleCheckItemMapper.deleteByMainId(purchaseSampleCheckHead.getId());
        if (purchaseSampleCheckItemList != null) {
            this.insertData(purchaseSampleCheckHead, purchaseSampleCheckItemList);
        }
        if (type != null && 2 == type) {
            PurchaseSampleTrackingItem trackingItem = new PurchaseSampleTrackingItem();
            trackingItem.setHeadId(purchaseSampleCheckHead.getSampleHeadId());
            trackingItem.setSampleNumber(purchaseSampleCheckHead.getCheckNumber());
            trackingItem.setSampleId(purchaseSampleCheckHead.getId());
            trackingItem.setPurchasePrincipal(purchaseSampleCheckHead.getPrincipal());
            trackingItem.setActualBeginTime(now);
            trackingItem.setStatus(PurchaseSampleCheckHeadEnum.TEST_ING.getValue());
            trackingItem.setCheckResult(purchaseSampleCheckHead.getCheckResult());
            trackingItem.setQualified(purchaseSampleCheckHead.getQualified());
            trackingItem.setSampleUseLink(SampleUseLinkEnum.CHEAK.getValue());
            this.purchaseSampleTrackingItemMapper.insert((Object)trackingItem);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void resultRecord(PurchaseSampleCheckHead purchaseSampleCheckHead, List<PurchaseSampleCheckItem> purchaseSampleCheckItemList, Integer type) {
        Date now = new Date();
        if (type != null && 2 == type && "0".equals(purchaseSampleCheckHead.getResultAudit())) {
            purchaseSampleCheckHead.setCheckEndDate(now);
        }
        this.purchaseSampleCheckHeadMapper.updateById((Object)purchaseSampleCheckHead);
        for (PurchaseSampleCheckItem entity : purchaseSampleCheckItemList) {
            this.purchaseSampleCheckItemMapper.updateById((Object)entity);
        }
        if (type != null && 2 == type) {
            PurchaseSampleTrackingItem trackingItem = new PurchaseSampleTrackingItem();
            trackingItem.setSampleId(purchaseSampleCheckHead.getId());
            trackingItem.setStatus(PurchaseSampleCheckHeadEnum.TEST_END.getValue());
            trackingItem.setCheckResult(purchaseSampleCheckHead.getCheckResult());
            trackingItem.setQualified(purchaseSampleCheckHead.getQualified());
            if ("0".equals(purchaseSampleCheckHead.getResultAudit())) {
                trackingItem.setActualEndTime(now);
                if (purchaseSampleCheckHead.getCheckStartDate() != null) {
                    trackingItem.setEstimatedTimePeriod((now.getTime() - purchaseSampleCheckHead.getCheckStartDate().getTime()) / 86400000L + "");
                }
            }
            this.purchaseSampleTrackingItemMapper.updateBySampleId(trackingItem);
        }
    }

    private void insertData(PurchaseSampleCheckHead purchaseSampleCheckHead, List<PurchaseSampleCheckItem> purchaseSampleCheckItemList) {
        for (PurchaseSampleCheckItem entity : purchaseSampleCheckItemList) {
            entity.setHeadId(purchaseSampleCheckHead.getId());
            entity.setCheckNumber(purchaseSampleCheckHead.getCheckNumber());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseSampleCheckHead);
        }
        if (!purchaseSampleCheckItemList.isEmpty()) {
            this.purchaseSampleCheckItemService.saveBatch(purchaseSampleCheckItemList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseSampleCheckItemMapper.deleteByMainId(id);
        this.purchaseSampleCheckHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseSampleCheckItemMapper.deleteByMainId(serializable.toString());
            this.purchaseSampleCheckHeadMapper.deleteById(serializable);
        }
    }
}

