/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ecn.adapter;

import com.alibaba.fastjson.JSONObject;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.ecn.entity.EcnBuyerList;
import com.els.modules.ecn.entity.EcnOrderDetail;
import com.els.modules.ecn.entity.EcnSupplierList;
import com.els.modules.ecn.entity.PurchaseEcn;
import com.els.modules.ecn.entity.SaleEcn;
import com.els.modules.ecn.entity.SaleEcnOrderDetail;
import com.els.modules.ecn.enumerate.EcnStatusEnum;
import com.els.modules.ecn.rpc.service.EcnInvokeAccountRpcService;
import com.els.modules.ecn.rpc.service.EcnInvokeSupplierRpcService;
import com.els.modules.ecn.service.EcnBuyerListService;
import com.els.modules.ecn.service.EcnOrderDetailService;
import com.els.modules.ecn.service.EcnSupplierListService;
import com.els.modules.ecn.service.PurchaseEcnService;
import com.els.modules.ecn.service.SaleEcnOrderDetailService;
import com.els.modules.ecn.service.SaleEcnService;
import com.els.modules.uflo.dto.AuditInputParamDTO;
import com.els.modules.uflo.dto.AuditOutputParamDTO;
import com.els.modules.uflo.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.CoreInvokeSupplierRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EcnAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchaseEcnService purchaseEcnService;
    @Autowired
    private EcnSupplierListService ecnSupplierListService;
    @Autowired
    private SaleEcnService saleEcnService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleEcnOrderDetailService saleEcnOrderDetailService;
    @Autowired
    private EcnBuyerListService ecnBuyerListService;
    @Autowired
    private EcnOrderDetailService ecnOrderDetailService;
    @Resource
    private EcnInvokeAccountRpcService ecnInvokeAccountRpcService;
    @Resource
    private EcnInvokeSupplierRpcService ecnInvokeSupplierRpcService;
    @Resource
    private CoreInvokeSupplierRpcService coreInvokeSupplierRpcService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        this.sendMsg(inputParamVO, outputParamVO, "submitAudit");
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            this.sendMsg(inputParamVO, outputParamVO, "auditPass");
        } else {
            this.sendMsg(inputParamVO, outputParamVO, "submitAudit");
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        this.sendMsg(inputParamVO, outputParamVO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
    }

    private void updateAuditStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseEcn purchaseEcn = (PurchaseEcn)((Object)this.purchaseEcnService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
        purchaseEcn.setAuditStatus(outputParamVO.getAuditStatus());
        purchaseEcn.setFlowId(outputParamVO.getProcessRootId());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            purchaseEcn.setEcnStatus(EcnStatusEnum.NORMAL.getValue());
            if ("1".equals(purchaseEcn.getAutoSend())) {
                List<EcnSupplierList> supplierLists = this.ecnSupplierListService.selectByMainId(purchaseEcn.getId());
                List attachments = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(purchaseEcn.getId());
                List<EcnBuyerList> buyerLists = this.ecnBuyerListService.selectByMainId(purchaseEcn.getId());
                List<EcnOrderDetail> orderDetails = this.ecnOrderDetailService.selectByMainId(purchaseEcn.getId());
                this.sendSupplier(purchaseEcn, supplierLists, attachments, orderDetails);
                purchaseEcn.setSendStatus("1");
                this.sendBuyer(purchaseEcn, buyerLists);
                purchaseEcn.setInformBuyer("1");
            }
        }
        this.purchaseEcnService.updateById((Object)purchaseEcn);
    }

    private void sendBuyer(PurchaseEcn purchaseEcn, List<EcnBuyerList> buyerLists) {
        if (buyerLists != null) {
            HashMap receiverMap = new HashMap();
            ArrayList<ElsSubAccountDTO> accounts = new ArrayList<ElsSubAccountDTO>();
            for (EcnBuyerList ecnBuyerList : buyerLists) {
                ElsSubAccountDTO account = this.ecnInvokeAccountRpcService.getAccount(ecnBuyerList.getElsAccount(), ecnBuyerList.getSubAccount());
                accounts.add(account);
            }
            receiverMap.put(purchaseEcn.getElsAccount(), accounts);
            MsgParamsVO paramsVO = new MsgParamsVO();
            paramsVO.setParams((Object)purchaseEcn);
            paramsVO.setReceiverMap(receiverMap);
            MqUtil.sendBusMsg((String)purchaseEcn.getElsAccount(), (String)"ecn", (String)"publish", (MsgParamsVO)paramsVO);
        }
    }

    private void sendSupplier(PurchaseEcn purchaseEcn, List<EcnSupplierList> supplierLists, List<PurchaseAttachmentDTO> attachments, List<EcnOrderDetail> orderDetails) {
        if (supplierLists != null && supplierLists.size() > 0) {
            SaleEcn ecn = new SaleEcn();
            BeanUtils.copyProperties((Object)((Object)purchaseEcn), (Object)((Object)ecn));
            ArrayList<String> recevieAccount = new ArrayList<String>();
            HashMap<String, List> receiverMap = new HashMap<String, List>();
            for (EcnSupplierList ecnSupplierList : supplierLists) {
                ecn.setId(null);
                ecn.setRelationId(purchaseEcn.getId());
                ecn.setElsAccount(ecnSupplierList.getToElsAccount());
                ecn.setToElsAccount(purchaseEcn.getElsAccount());
                ecn.setSupplierName(ecnSupplierList.getSupplierName());
                ecn.setViewStatus("0");
                this.saleEcnService.save((Object)ecn);
                AttachmentSendDTO sendDTO = new AttachmentSendDTO();
                sendDTO.setHeadId(purchaseEcn.getId());
                sendDTO.setElsAccount(purchaseEcn.getElsAccount());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(ecn.getId(), ecnSupplierList.getToElsAccount());
                this.invokeBaseRpcService.sendPurchaseFile(sendDTO, true);
                ArrayList<SaleEcnOrderDetail> saleEcnOrderDetails = null;
                if (orderDetails != null) {
                    saleEcnOrderDetails = new ArrayList<SaleEcnOrderDetail>();
                    for (EcnOrderDetail detail : orderDetails) {
                        if (!ecnSupplierList.getToElsAccount().equals(detail.getToElsAccount())) continue;
                        SaleEcnOrderDetail saleEcnOrderDetail = new SaleEcnOrderDetail();
                        BeanUtils.copyProperties((Object)((Object)detail), (Object)((Object)saleEcnOrderDetail));
                        saleEcnOrderDetail.setElsAccount(ecnSupplierList.getToElsAccount());
                        saleEcnOrderDetail.setToElsAccount(purchaseEcn.getElsAccount());
                        saleEcnOrderDetail.setId(null);
                        saleEcnOrderDetail.setBusAccount(purchaseEcn.getElsAccount());
                        saleEcnOrderDetail.setPurchaseName(purchaseEcn.getPurchaseName());
                        saleEcnOrderDetails.add(saleEcnOrderDetail);
                    }
                    this.saleEcnOrderDetailService.saveBatch(saleEcnOrderDetails);
                }
                recevieAccount.add(ecnSupplierList.getToElsAccount());
            }
            Map map = this.coreInvokeSupplierRpcService.getSupplierContacts(recevieAccount, "ecn", "publish");
            for (String string : map.keySet()) {
                if (map.get(string) == null) continue;
                List accountDTOs = (List)map.get(string);
                receiverMap.put(string, accountDTOs);
            }
            MsgParamsVO msgParamsVO = new MsgParamsVO();
            msgParamsVO.setParams((Object)purchaseEcn);
            msgParamsVO.setReceiverMap(receiverMap);
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)"ecn", (String)"publish", (MsgParamsVO)msgParamsVO);
        }
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus()) || AuditStatusEnum.AUDIT_REJECT.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"ecn", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"ecn", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.ecnInvokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        System.out.println("123");
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        System.out.println("456");
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        Map<String, String> paramMap = inputParamVO.getVariables() == null ? new HashMap() : inputParamVO.getVariables();
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams(paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

