/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.trial.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.trial.entity.PurchaseTrialProductionHead;
import com.els.modules.trial.entity.PurchaseTrialProductionItem;
import com.els.modules.trial.entity.SaleTrialProductionHead;
import com.els.modules.trial.enumerate.PurchaseTrialPrincipalEnum;
import com.els.modules.trial.enumerate.PurchaseTrialProductionHeadEnum;
import com.els.modules.trial.mapper.PurchaseTrialProductionHeadMapper;
import com.els.modules.trial.mapper.PurchaseTrialProductionItemMapper;
import com.els.modules.trial.service.PurchaseTrialProductionHeadService;
import com.els.modules.trial.service.PurchaseTrialProductionItemService;
import com.els.modules.trial.service.impl.SaleTrialProductionHeadServiceImpl;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseTrialProductionHeadServiceImpl
extends BaseServiceImpl<PurchaseTrialProductionHeadMapper, PurchaseTrialProductionHead>
implements PurchaseTrialProductionHeadService {
    @Resource
    private PurchaseTrialProductionHeadMapper purchaseTrialProductionHeadMapper;
    @Resource
    private PurchaseTrialProductionItemMapper purchaseTrialProductionItemMapper;
    @Resource
    private PurchaseTrialProductionItemService purchaseTrialProductionItemService;
    @Autowired
    private SaleTrialProductionHeadServiceImpl saleTrialProductionHeadService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseTrialProductionHead purchaseTrialProductionHead, List<PurchaseTrialProductionItem> purchaseTrialProductionItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        purchaseTrialProductionHead.setTrialNumber(this.invokeBaseRpcService.getNextCode("srmTrialProdNumber", (Object)purchaseTrialProductionHead));
        purchaseTrialProductionHead.setTrialStatus(PurchaseTrialProductionHeadEnum.NEW.getValue());
        this.purchaseTrialProductionHeadMapper.insert((Object)purchaseTrialProductionHead);
        if (purchaseTrialProductionItemList != null) {
            this.insertData(purchaseTrialProductionHead, purchaseTrialProductionItemList, purchaseAttachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseTrialProductionHead purchaseTrialProductionHead, List<PurchaseTrialProductionItem> purchaseTrialProductionItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, Integer type) {
        if (StringUtils.isBlank((CharSequence)purchaseTrialProductionHead.getId())) {
            purchaseTrialProductionHead.setTrialNumber(this.invokeBaseRpcService.getNextCode("srmTrialProdNumber", (Object)purchaseTrialProductionHead));
            purchaseTrialProductionHead.setTrialStatus(PurchaseTrialProductionHeadEnum.NEW.getValue());
            this.purchaseTrialProductionHeadMapper.insert((Object)purchaseTrialProductionHead);
        } else {
            Date now = new Date();
            if (type != null && 2 == type) {
                purchaseTrialProductionHead.setTrialStartDate(now);
            }
            this.purchaseTrialProductionHeadMapper.updateById((Object)purchaseTrialProductionHead);
        }
        this.purchaseTrialProductionItemMapper.deleteByMainId(purchaseTrialProductionHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseTrialProductionHead.getId());
        if (purchaseTrialProductionItemList != null) {
            this.insertData(purchaseTrialProductionHead, purchaseTrialProductionItemList, purchaseAttachmentList);
        }
        if (type != null && 2 == type && PurchaseTrialPrincipalEnum.SALE.getValue().equals(purchaseTrialProductionHead.getTrialPrincipal())) {
            String headId = this.saleTrialProductionHeadService.addByPurchase(purchaseTrialProductionHead, purchaseTrialProductionItemList);
            HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
            JSONObject object = new JSONObject();
            object.put("id", (Object)headId);
            object.put("templateNumber", (Object)purchaseTrialProductionHead.getTemplateNumber());
            object.put("templateVersion", (Object)purchaseTrialProductionHead.getTemplateVersion());
            object.put("busAccount", (Object)purchaseTrialProductionHead.getElsAccount());
            receiveParamMap.put(purchaseTrialProductionHead.getToElsAccount(), object);
            super.sendMsg(TenantContext.getTenant(), purchaseTrialProductionHead.getToElsAccount(), (Object)purchaseTrialProductionHead, receiveParamMap, "trialProduction", "submitSupplier");
        }
    }

    @Override
    public void record(PurchaseTrialProductionHead purchaseTrialProductionHead, List<PurchaseTrialProductionItem> purchaseTrialProductionItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, Integer type) {
        Date now = new Date();
        if (type != null && 2 == type && "0".equals(purchaseTrialProductionHead.getResultAudit())) {
            purchaseTrialProductionHead.setTrialEndDate(now);
            purchaseTrialProductionHead.setTrialStatus(PurchaseTrialProductionHeadEnum.FINAL.getValue());
        }
        this.purchaseTrialProductionHeadMapper.updateById((Object)purchaseTrialProductionHead);
        if (purchaseTrialProductionItemList != null) {
            for (PurchaseTrialProductionItem entity : purchaseTrialProductionItemList) {
                this.purchaseTrialProductionItemMapper.updateById((Object)entity);
            }
        }
        if (!purchaseAttachmentList.isEmpty()) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseTrialProductionHead.getId());
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
        if (type != null && 2 == type && "0".equals(purchaseTrialProductionHead.getResultAudit())) {
            UpdateWrapper saleHeadQueryWrapper = new UpdateWrapper();
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialStatus, (Object)PurchaseTrialProductionHeadEnum.FINAL.getValue());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getSampleQuantity, (Object)purchaseTrialProductionHead.getSampleQuantity());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getQualifiedQuantity, (Object)purchaseTrialProductionHead.getQualifiedQuantity());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getDefectiveQuantity, (Object)purchaseTrialProductionHead.getDefectiveQuantity());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getQualifiedRate, (Object)purchaseTrialProductionHead.getQualifiedRate());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getQualified, (Object)purchaseTrialProductionHead.getQualified());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialResult, (Object)purchaseTrialProductionHead.getTrialResult());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getResultAudit, (Object)purchaseTrialProductionHead.getResultAudit());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialResultDesc, (Object)purchaseTrialProductionHead.getTrialResultDesc());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialResultNumber, (Object)purchaseTrialProductionHead.getTrialResultNumber());
            saleHeadQueryWrapper.lambda().set(SaleTrialProductionHead::getTrialEndDate, (Object)now);
            saleHeadQueryWrapper.lambda().eq(SaleTrialProductionHead::getRelationId, (Object)purchaseTrialProductionHead.getId());
            this.saleTrialProductionHeadService.update((Wrapper)saleHeadQueryWrapper);
        }
    }

    private void insertData(PurchaseTrialProductionHead purchaseTrialProductionHead, List<PurchaseTrialProductionItem> purchaseTrialProductionItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (purchaseTrialProductionItemList != null && !purchaseTrialProductionItemList.isEmpty()) {
            for (PurchaseTrialProductionItem entity : purchaseTrialProductionItemList) {
                entity.setHeadId(purchaseTrialProductionHead.getId());
                entity.setId(null);
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseTrialProductionHead);
            }
            this.purchaseTrialProductionItemService.saveBatch(purchaseTrialProductionItemList, 2000);
        }
        if (purchaseAttachmentList != null && !purchaseAttachmentList.isEmpty()) {
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseTrialProductionItemMapper.deleteByMainId(id);
        this.purchaseTrialProductionHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseTrialProductionItemMapper.deleteByMainId(serializable.toString());
            this.purchaseTrialProductionHeadMapper.deleteById(serializable);
        }
    }
}

