/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ecn.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.ecn.entity.EcnSupplierList;
import com.els.modules.ecn.entity.SaleEcn;
import com.els.modules.ecn.entity.SaleEcnOrderDetail;
import com.els.modules.ecn.mapper.SaleEcnMapper;
import com.els.modules.ecn.rpc.service.EcnInvokeBaseRpcService;
import com.els.modules.ecn.service.EcnSupplierListService;
import com.els.modules.ecn.service.SaleEcnOrderDetailService;
import com.els.modules.ecn.service.SaleEcnService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleEcnServiceImpl
extends BaseServiceImpl<SaleEcnMapper, SaleEcn>
implements SaleEcnService {
    @Autowired
    private EcnInvokeBaseRpcService ecnInvokeBaseRpcService;
    @Autowired
    private SaleEcnMapper saleEcnMapper;
    @Autowired
    private EcnSupplierListService ecnSupplierListService;
    @Autowired
    private SaleEcnOrderDetailService saleEcnOrderDetailService;

    @Override
    public void saveSaleEcn(SaleEcn saleEcn, List<SaleAttachmentDTO> attachments, List<SaleEcnOrderDetail> saleEcnOrderDetails) {
        ((SaleEcnMapper)this.baseMapper).insert((Object)saleEcn);
        if (attachments != null) {
            for (SaleAttachmentDTO saleAttachment : attachments) {
                saleAttachment.setHeadId(saleEcn.getId());
            }
            if (!attachments.isEmpty()) {
                this.ecnInvokeBaseRpcService.insertSaleBatchSomeColumn(attachments);
            }
        }
        if (saleEcnOrderDetails != null) {
            for (SaleEcnOrderDetail saleEcnOrderDetail : saleEcnOrderDetails) {
                saleEcnOrderDetail.setHeadId(saleEcn.getId());
            }
            if (!saleEcnOrderDetails.isEmpty()) {
                this.saleEcnOrderDetailService.saveBatch(saleEcnOrderDetails);
            }
        }
    }

    @Override
    public void updateSaleEcn(SaleEcn saleEcn) {
        ((SaleEcnMapper)this.baseMapper).updateById((Object)saleEcn);
    }

    @Override
    public void delSaleEcn(String id) {
        ((SaleEcnMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchSaleEcn(List<String> idList) {
        ((SaleEcnMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void delBatchByRelationId(String relationId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"relation_id", (Object)relationId);
        this.saleEcnMapper.delete((Wrapper)queryWrapper);
    }

    @Override
    public void view(String id) {
        SaleEcn ecn = (SaleEcn)((Object)this.getById((Serializable)((Object)id)));
        if (ecn != null) {
            ecn.setViewStatus("1");
            this.updateById((Object)ecn);
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"head_id", (Object)ecn.getRelationId());
            wrapper.eq((Object)"els_account", (Object)ecn.getToElsAccount());
            wrapper.eq((Object)"to_els_account", (Object)ecn.getElsAccount());
            List supplierLists = this.ecnSupplierListService.list((Wrapper)wrapper);
            if (!supplierLists.isEmpty()) {
                for (EcnSupplierList ecnSupplierList : supplierLists) {
                    ecnSupplierList.setViewStatus("1");
                }
                this.ecnSupplierListService.updateBatchById(supplierLists);
            }
        }
    }
}

