/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ecn.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.ecn.entity.EcnBuyerList;
import com.els.modules.ecn.entity.EcnOrderDetail;
import com.els.modules.ecn.entity.EcnSupplierList;
import com.els.modules.ecn.entity.PurchaseEcn;
import com.els.modules.ecn.entity.SaleEcn;
import com.els.modules.ecn.entity.SaleEcnOrderDetail;
import com.els.modules.ecn.enumerate.EcnStatusEnum;
import com.els.modules.ecn.mapper.EcnBuyerListMapper;
import com.els.modules.ecn.mapper.EcnOrderDetailMapper;
import com.els.modules.ecn.mapper.EcnSupplierListMapper;
import com.els.modules.ecn.mapper.PurchaseEcnMapper;
import com.els.modules.ecn.rpc.service.EcnInvokeAccountRpcService;
import com.els.modules.ecn.rpc.service.EcnInvokeBaseRpcService;
import com.els.modules.ecn.rpc.service.EcnInvokeMainDataRpcService;
import com.els.modules.ecn.service.PurchaseEcnService;
import com.els.modules.ecn.service.SaleEcnService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseEcnServiceImpl
extends BaseServiceImpl<PurchaseEcnMapper, PurchaseEcn>
implements PurchaseEcnService {
    @Resource
    private PurchaseEcnMapper purchaseEcnMapper;
    @Resource
    private EcnSupplierListMapper ecnSupplierListMapper;
    @Resource
    private EcnBuyerListMapper ecnBuyerListMapper;
    @Resource
    private EcnInvokeBaseRpcService ecnInvokeBaseRpcService;
    @Resource
    private EcnInvokeAccountRpcService ecnInvokeAccountRpcService;
    @Resource
    private EcnInvokeMainDataRpcService ecnInvokeMainDataRpcService;
    @Autowired
    private SaleEcnService saleEcnService;
    @Resource
    private EcnOrderDetailMapper ecnOrderDetailMapper;
    @Resource
    private InterfaceUtil interfaceUtil;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseEcn purchaseEcn, List<EcnSupplierList> ecnSupplierListList, List<EcnBuyerList> ecnBuyerListList, List<EcnOrderDetail> orderDetails) {
        purchaseEcn.setEcnNumber(this.ecnInvokeBaseRpcService.getNextCode("srmECNNumber", (Object)purchaseEcn));
        purchaseEcn.setChangeApplyTime(new Date());
        purchaseEcn.setPurchaseName(SysUtil.getLoginUser().getEnterpriseName());
        purchaseEcn.setEcnStatus(StringUtils.isNotEmpty((CharSequence)purchaseEcn.getEcnStatus()) ? purchaseEcn.getEcnStatus() : "0");
        if ("0".equals(purchaseEcn.getNeedApprove())) {
            purchaseEcn.setAuditStatus(StringUtils.isNotEmpty((CharSequence)purchaseEcn.getAuditStatus()) ? purchaseEcn.getAuditStatus() : "4");
        } else {
            purchaseEcn.setAuditStatus(StringUtils.isNotEmpty((CharSequence)purchaseEcn.getAuditStatus()) ? purchaseEcn.getAuditStatus() : "0");
        }
        this.purchaseEcnMapper.insert((Object)purchaseEcn);
        this.insertData(purchaseEcn, ecnSupplierListList, ecnBuyerListList, orderDetails);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseEcn purchaseEcn, List<EcnSupplierList> ecnSupplierListList, List<EcnBuyerList> ecnBuyerListList, List<EcnOrderDetail> orderDetails) {
        PurchaseOrganizationInfoDTO organizationInfo;
        if ("0".equals(purchaseEcn.getNeedApprove())) {
            purchaseEcn.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        ElsSubAccountDTO subAccount = null;
        if (purchaseEcn.getApplyPerson() != null && StringUtils.isNotBlank((CharSequence)purchaseEcn.getApplyPerson())) {
            subAccount = this.ecnInvokeAccountRpcService.getAccount(purchaseEcn.getElsAccount(), purchaseEcn.getApplyPerson().split("_")[0]);
        }
        if (subAccount != null && StringUtils.isNotBlank((CharSequence)subAccount.getOrgCode()) && (organizationInfo = this.ecnInvokeMainDataRpcService.selectById(subAccount.getOrgCode())) != null) {
            purchaseEcn.setApplyDepartment(organizationInfo.getOrgCode() + "_" + organizationInfo.getOrgDesc());
        }
        if (!ecnSupplierListList.isEmpty()) {
            purchaseEcn.setSupplierExist("1");
        }
        if (!ecnBuyerListList.isEmpty()) {
            purchaseEcn.setBuyerExist("1");
        }
        this.purchaseEcnMapper.updateById((Object)purchaseEcn);
        this.ecnSupplierListMapper.deleteByMainId(purchaseEcn.getId());
        this.ecnBuyerListMapper.deleteByMainId(purchaseEcn.getId());
        this.ecnOrderDetailMapper.deleteByMainId(purchaseEcn.getId());
        this.insertData(purchaseEcn, ecnSupplierListList, ecnBuyerListList, orderDetails);
    }

    private void insertData(PurchaseEcn purchaseEcn, List<EcnSupplierList> ecnSupplierListList, List<EcnBuyerList> ecnBuyerListList, List<EcnOrderDetail> orderDetails) {
        if (ecnSupplierListList != null) {
            for (EcnSupplierList ecnSupplierList : ecnSupplierListList) {
                ecnSupplierList.setHeadId(purchaseEcn.getId());
                SysUtil.setSysParam((BaseEntity)ecnSupplierList, (BaseEntity)purchaseEcn);
                ecnSupplierList.setViewStatus("0");
            }
            if (!ecnSupplierListList.isEmpty()) {
                this.ecnSupplierListMapper.insertBatchSomeColumn(ecnSupplierListList);
            }
        }
        if (ecnBuyerListList != null) {
            for (EcnBuyerList ecnBuyerList : ecnBuyerListList) {
                ecnBuyerList.setHeadId(purchaseEcn.getId());
                SysUtil.setSysParam((BaseEntity)ecnBuyerList, (BaseEntity)purchaseEcn);
            }
            if (!ecnBuyerListList.isEmpty()) {
                this.ecnBuyerListMapper.insertBatchSomeColumn(ecnBuyerListList);
            }
        }
        if (orderDetails != null) {
            for (EcnOrderDetail ecnOrderDetail : orderDetails) {
                ecnOrderDetail.setHeadId(purchaseEcn.getId());
                SysUtil.setSysParam((BaseEntity)ecnOrderDetail, (BaseEntity)purchaseEcn);
                ecnOrderDetail.setDeleted(CommonConstant.DEL_FLAG_0);
                ecnOrderDetail.setId(null);
            }
            if (!orderDetails.isEmpty()) {
                this.ecnOrderDetailMapper.insertBatchSomeColumn(orderDetails);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.ecnSupplierListMapper.deleteByMainId(id);
        this.ecnBuyerListMapper.deleteByMainId(id);
        this.purchaseEcnMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.ecnSupplierListMapper.deleteByMainId(serializable.toString());
            this.ecnBuyerListMapper.deleteByMainId(serializable.toString());
            this.purchaseEcnMapper.deleteById(serializable);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishSuppliers(PurchaseEcn purchaseEcn, List<EcnSupplierList> ecnSupplierListList, List<PurchaseAttachmentDTO> attachments, List<EcnOrderDetail> orderDetails) {
        purchaseEcn.setSendStatus("1");
        purchaseEcn.setEcnStatus(EcnStatusEnum.NORMAL.getValue());
        SaleEcn ecn = new SaleEcn();
        BeanUtils.copyProperties((Object)((Object)purchaseEcn), (Object)((Object)ecn));
        for (EcnSupplierList supplier : ecnSupplierListList) {
            ecn.setId(null);
            ecn.setRelationId(purchaseEcn.getId());
            ecn.setElsAccount(supplier.getToElsAccount());
            ecn.setToElsAccount(purchaseEcn.getElsAccount());
            ecn.setSupplierName(supplier.getSupplierName());
            ecn.setViewStatus("0");
            List<SaleAttachmentDTO> saleAttachments = null;
            if (attachments != null) {
                AttachmentSendDTO sendDTO = new AttachmentSendDTO();
                sendDTO.setHeadId(purchaseEcn.getId());
                sendDTO.setElsAccount(purchaseEcn.getElsAccount());
                HashMap map = new HashMap();
                map.put(ecn.getId(), ecn.getElsAccount());
                this.ecnInvokeBaseRpcService.sendPurchaseFile(sendDTO, true);
            }
            ArrayList<SaleEcnOrderDetail> saleEcnOrderDetails = null;
            if (orderDetails != null) {
                saleEcnOrderDetails = new ArrayList<SaleEcnOrderDetail>();
                for (EcnOrderDetail detail : orderDetails) {
                    if (!supplier.getToElsAccount().equals(detail.getToElsAccount())) continue;
                    SaleEcnOrderDetail saleEcnOrderDetail = new SaleEcnOrderDetail();
                    BeanUtils.copyProperties((Object)((Object)detail), (Object)((Object)saleEcnOrderDetail));
                    saleEcnOrderDetail.setElsAccount(supplier.getToElsAccount());
                    saleEcnOrderDetail.setToElsAccount(purchaseEcn.getElsAccount());
                    saleEcnOrderDetail.setId(null);
                    saleEcnOrderDetail.setBusAccount(purchaseEcn.getElsAccount());
                    saleEcnOrderDetail.setPurchaseName(purchaseEcn.getPurchaseName());
                    saleEcnOrderDetails.add(saleEcnOrderDetail);
                }
            }
            this.saleEcnService.saveSaleEcn(ecn, saleAttachments, saleEcnOrderDetails);
            String urlParam = "id=" + ecn.getId();
            if (StringUtils.isNotBlank((CharSequence)supplier.getSubAccount())) {
                super.sendMsg(TenantContext.getTenant(), supplier.getToElsAccount(), supplier.getSubAccount(), (Object)purchaseEcn, urlParam, "ecn", "publish");
                continue;
            }
            super.sendMsg(TenantContext.getTenant(), supplier.getToElsAccount(), (Object)purchaseEcn, urlParam, "ecn", "publish");
        }
        this.updateById((Object)purchaseEcn);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void publishBuyer(PurchaseEcn purchaseEcn, List<EcnBuyerList> buyerLists) {
        for (EcnBuyerList ecnBuyerList : buyerLists) {
            ElsSubAccountDTO account = this.ecnInvokeAccountRpcService.getAccount(ecnBuyerList.getElsAccount(), ecnBuyerList.getSubAccount());
            String urlParam = "id=" + ecnBuyerList.getId();
            super.sendMsg(TenantContext.getTenant(), account, urlParam, (Object)purchaseEcn, "ecn", "change");
        }
        purchaseEcn.setInformBuyer("1");
        this.updateById((Object)purchaseEcn);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void backout(String id) {
        PurchaseEcn ecn = (PurchaseEcn)((Object)this.getById((Serializable)((Object)id)));
        ecn.setSendStatus("0");
        ecn.setInformBuyer("0");
        this.updateById((Object)ecn);
        this.saleEcnService.delBatchByRelationId(id);
        List<EcnSupplierList> supplierLists = this.ecnSupplierListMapper.selectByMainId(id);
        if (!supplierLists.isEmpty()) {
            ArrayList<String> receiveAccount = new ArrayList<String>();
            for (EcnSupplierList ecnSupplierList : supplierLists) {
                receiveAccount.add(ecnSupplierList.getToElsAccount());
            }
            String urlParam = "id=" + ecn.getId();
            super.sendMsg(TenantContext.getTenant(), receiveAccount, (Object)ecn, urlParam, "ecn", "back");
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancellation(String id) {
        List<EcnSupplierList> supplierLists;
        PurchaseEcn ecn = (PurchaseEcn)((Object)this.getById((Serializable)((Object)id)));
        ecn.setEcnStatus(EcnStatusEnum.CANCELLATION.getValue());
        this.updateById((Object)ecn);
        if ("1".equals(ecn.getSendStatus()) && !(supplierLists = this.ecnSupplierListMapper.selectByMainId(id)).isEmpty()) {
            ArrayList<String> receiveAccount = new ArrayList<String>();
            for (EcnSupplierList ecnSupplierList : supplierLists) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.saleEcnService.lambdaUpdate().eq(SaleEcn::getRelationId, (Object)id)).eq(SaleEcn::getToElsAccount, (Object)ecn.getElsAccount())).eq(BaseEntity::getElsAccount, (Object)ecnSupplierList.getToElsAccount())).set(SaleEcn::getEcnStatus, (Object)EcnStatusEnum.CANCELLATION.getValue())).update((Object)new SaleEcn());
                receiveAccount.add(ecnSupplierList.getToElsAccount());
            }
            super.sendMsg(TenantContext.getTenant(), receiveAccount, (Object)ecn, "", "ecn", "invalid");
        }
        if ("1".equals(ecn.getInformBuyer())) {
            List<EcnBuyerList> buyerLists = this.ecnBuyerListMapper.selectByMainId(id);
            for (EcnBuyerList ecnBuyerList : buyerLists) {
                ElsSubAccountDTO account = this.ecnInvokeAccountRpcService.getAccount(ecnBuyerList.getElsAccount(), ecnBuyerList.getSubAccount());
                String urlParam = "id=" + ecnBuyerList.getId();
                super.sendMsg(TenantContext.getTenant(), account, urlParam, (Object)ecn, "ecn", "invalid");
            }
        }
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getECN", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List purchaseEcnList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseEcn purchaseEcn : purchaseEcnList) {
            String elsAccount = TenantContext.getTenant();
            this.interfaceUtil.callInterface(elsAccount, "pushECN", (Object)purchaseEcn);
        }
    }
}

