/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.massProduction.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.enumerate.i18n.I18nBaseEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.AssertI18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.massProduction.entity.PurchaseMassProdHead;
import com.els.modules.massProduction.entity.PurchaseMassProdPpapItem;
import com.els.modules.massProduction.entity.PurchaseMassProdSampleItem;
import com.els.modules.massProduction.entity.SaleMassProdHead;
import com.els.modules.massProduction.entity.SaleMassProdPpapItem;
import com.els.modules.massProduction.enums.I18nMassProdMsgEnum;
import com.els.modules.massProduction.enums.MassProdEnum;
import com.els.modules.massProduction.mapper.PurchaseMassProdHeadMapper;
import com.els.modules.massProduction.mapper.PurchaseMassProdPpapItemMapper;
import com.els.modules.massProduction.mapper.PurchaseMassProdSampleItemMapper;
import com.els.modules.massProduction.mapper.SaleMassProdHeadMapper;
import com.els.modules.massProduction.mapper.SaleMassProdPpapItemMapper;
import com.els.modules.massProduction.rpc.service.MassProductBaseRpcService;
import com.els.modules.massProduction.rpc.service.PurcMaterSourRpcService;
import com.els.modules.massProduction.service.PurchaseMassProdHeadService;
import com.els.modules.massProduction.vo.PurchaseMassProdConfirmVo;
import com.els.modules.material.api.dto.PurchaseMaterialSourceDTO;
import com.els.modules.material.api.enumerate.MaterialSourceStatusEnum;
import com.els.modules.material.api.enumerate.MaterialSourceTypeApiEnum;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseMassProdHeadServiceImpl
extends BaseServiceImpl<PurchaseMassProdHeadMapper, PurchaseMassProdHead>
implements PurchaseMassProdHeadService {
    @Resource
    private PurchaseMassProdHeadMapper purchaseMassProdHeadMapper;
    @Resource
    private PurchaseMassProdPpapItemMapper ppapItemMapper;
    @Resource
    private PurchaseMassProdSampleItemMapper purchaseMassProdSampleItemMapper;
    @Resource
    private SaleMassProdHeadMapper saleMassProdHeadMapper;
    @Resource
    private PurcMaterSourRpcService sourRpcService;
    @Resource
    private SaleMassProdPpapItemMapper saleMassProdPpapItemMapper;
    @Autowired
    private MassProductBaseRpcService baseRpcService;

    private void delMassProdItem(String headId) {
        this.ppapItemMapper.deleteByMainId(headId);
        this.purchaseMassProdSampleItemMapper.deleteByMainId(headId);
    }

    private void insertData(PurchaseMassProdHead purchaseMassProdHead, List<PurchaseMassProdPpapItem> purchaseMassMassProdPpapItemList, List<PurchaseMassProdSampleItem> purchaseMassProdSampleItemList) {
        if (!CollectionUtils.isEmpty(purchaseMassMassProdPpapItemList)) {
            for (PurchaseMassProdPpapItem purchaseMassProdPpapItem : purchaseMassMassProdPpapItemList) {
                purchaseMassProdPpapItem.setDocumentsSerialNumber(purchaseMassProdHead.getDocumentsSerialNumber());
                purchaseMassProdPpapItem.setRowNumber(this.baseRpcService.getNextCode("srmMassProdPpapNumber", (Object)purchaseMassProdPpapItem));
                purchaseMassProdPpapItem.setHeadId(purchaseMassProdHead.getId());
                purchaseMassProdPpapItem.setRelationId(purchaseMassProdHead.getRelationId());
                SysUtil.setSysParam((BaseEntity)purchaseMassProdPpapItem, (BaseEntity)purchaseMassProdHead);
            }
            this.ppapItemMapper.insertBatchSomeColumn(purchaseMassMassProdPpapItemList);
        }
        if (!CollectionUtils.isEmpty(purchaseMassProdSampleItemList)) {
            for (PurchaseMassProdSampleItem purchaseMassProdSampleItem : purchaseMassProdSampleItemList) {
                purchaseMassProdSampleItem.setDocumentsSerialNumber(purchaseMassProdHead.getDocumentsSerialNumber());
                purchaseMassProdSampleItem.setRowNumber(this.baseRpcService.getNextCode("srmMassProdSampleCheckNumber", (Object)purchaseMassProdSampleItem));
                purchaseMassProdSampleItem.setHeadId(purchaseMassProdHead.getId());
                purchaseMassProdSampleItem.setRelationId(purchaseMassProdHead.getRelationId());
                SysUtil.setSysParam((BaseEntity)purchaseMassProdSampleItem, (BaseEntity)purchaseMassProdHead);
            }
            this.purchaseMassProdSampleItemMapper.insertBatchSomeColumn(purchaseMassProdSampleItemList);
        }
    }

    private void publishPpapItem(String relationId, String headId, String supplierElsAccount, List<PurchaseMassProdPpapItem> purchaseMassMassProdPpapItemList) {
        ArrayList<SaleMassProdPpapItem> saleMassProdPpapItemList = new ArrayList<SaleMassProdPpapItem>();
        for (PurchaseMassProdPpapItem entity : purchaseMassMassProdPpapItemList) {
            SaleMassProdPpapItem saleMassProdPpapItem = new SaleMassProdPpapItem();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)saleMassProdPpapItem));
            saleMassProdPpapItem.setRelationId(relationId).setSourceId(entity.getId()).setHeadId(headId).setElsAccount(supplierElsAccount).setId(null);
            saleMassProdPpapItemList.add(saleMassProdPpapItem);
        }
        this.saleMassProdPpapItemMapper.insertBatchSomeColumn(saleMassProdPpapItemList);
    }

    private void pushToSource(PurchaseMassProdHead purchaseMassProdHead) {
        PurchaseMaterialSourceDTO purchaseMaterialSource = new PurchaseMaterialSourceDTO();
        Date now = new Date();
        List<TemplateHeadDTO> templateList = this.baseRpcService.getDefaultTemplateByType("materialSource");
        purchaseMaterialSource.setTemplateNumber(templateList.get(0).getTemplateNumber()).setTemplateName(templateList.get(0).getTemplateName()).setTemplateVersion(templateList.get(0).getTemplateVersion().toString()).setTemplateAccount(templateList.get(0).getElsAccount()).setBusAccount(purchaseMassProdHead.getElsAccount()).setSourceId(this.baseRpcService.getNextCode("materialSourceNumber", purchaseMaterialSource)).setMaterialSourceType(MaterialSourceTypeApiEnum.MASS_PRODUCT.value()).setSourceType(null).setMaterialNumber(purchaseMassProdHead.getMaterialCode()).setMaterialDesc(purchaseMassProdHead.getMaterialDesc()).setSaleMaterialNumber(purchaseMassProdHead.getSupplierErpCode()).setFactory(purchaseMassProdHead.getFactoryCode()).setFactoryName(purchaseMassProdHead.getFactoryName()).setToElsAccount(purchaseMassProdHead.getSupplierElsAccount()).setToElsDesc(purchaseMassProdHead.getSupplierName()).setMaterialCategory(purchaseMassProdHead.getMaterialType()).setPurchaseOrg(purchaseMassProdHead.getPurchaseOrgCode()).setPurchaseOrgName(purchaseMassProdHead.getPurchaseOrgName()).setCompany(purchaseMassProdHead.getCompanyCode()).setCompanyName(purchaseMassProdHead.getCompanyName()).setEffectiveDate(purchaseMassProdHead.getSourceValidBeginTime()).setExpiryDate(purchaseMassProdHead.getSourceValidEndTime()).setStatus(MaterialSourceStatusEnum.NORMAL.getValue()).setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue()).setElsAccount(purchaseMassProdHead.getElsAccount()).setCreateBy(purchaseMassProdHead.getCreateBy()).setUpdateBy(purchaseMassProdHead.getCreateBy()).setCreateTime(now).setUpdateTime(now);
        this.sourRpcService.savePurchaseMaterialSource(purchaseMaterialSource);
    }

    private void sendFile(String purchaseHeadId, String saleHeadId, String elsAccount, String toElsAccount) {
        AttachmentSendDTO attachmentSendVO = new AttachmentSendDTO();
        attachmentSendVO.setHeadId(purchaseHeadId);
        attachmentSendVO.setElsAccount(elsAccount);
        HashMap toSend = Maps.newHashMap();
        toSend.put(saleHeadId, toElsAccount);
        attachmentSendVO.setToSend((Map)toSend);
        this.baseRpcService.sendPurchaseFile(attachmentSendVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveMain(PurchaseMassProdHead purchaseMassProdHead, List<PurchaseMassProdPpapItem> purchaseMassMassProdPpapItemList, List<PurchaseMassProdSampleItem> purchaseMassProdSampleItemList) {
        purchaseMassProdHead.setDocumentsSerialNumber(this.baseRpcService.getNextCode("srmMassProdDocNumber", (Object)purchaseMassProdHead));
        purchaseMassProdHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_NEW.value());
        this.purchaseMassProdHeadMapper.insert((Object)purchaseMassProdHead);
        this.insertData(purchaseMassProdHead, purchaseMassMassProdPpapItemList, purchaseMassProdSampleItemList);
    }

    private void validStartTimeAndEndTime(Date startTime, Date endTime) {
        boolean bool = startTime != null && endTime != null && startTime.getTime() > endTime.getTime();
        AssertI18nUtil.isTrue((boolean)bool, (Enum)I18nMassProdMsgEnum.STARTTIME_GT_ENDTIME);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseMassProdHead prodHead, List<PurchaseMassProdPpapItem> purchaseMassMassProdPpapItemList, List<PurchaseMassProdSampleItem> purchaseMassProdSampleItemList) {
        this.validStartTimeAndEndTime(prodHead.getSourceValidBeginTime(), prodHead.getSourceValidEndTime());
        PurchaseMassProdHead oldRecord = (PurchaseMassProdHead)((Object)((PurchaseMassProdHeadMapper)this.baseMapper).selectById((Serializable)((Object)prodHead.getId())));
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_RECORD_NOT_EXIST);
        AssertI18nUtil.isTrue((!MassProdEnum.HEAD_DOC_STATUS_NEW.value().equals(oldRecord.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_DOC_STATUS_NO_NEW);
        prodHead.setDocumentsStatus(oldRecord.getDocumentsStatus());
        this.purchaseMassProdHeadMapper.updateById((Object)prodHead);
        this.delMassProdItem(prodHead.getId());
        this.insertData(prodHead, purchaseMassMassProdPpapItemList, purchaseMassProdSampleItemList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void newSubmit(PurchaseMassProdHead prodHead, List<PurchaseMassProdPpapItem> purchaseMassMassProdPpapItemList, List<PurchaseMassProdSampleItem> purchaseMassProdSampleItemList) {
        this.validStartTimeAndEndTime(prodHead.getSourceValidBeginTime(), prodHead.getSourceValidEndTime());
        prodHead.setDocumentsSerialNumber(this.baseRpcService.getNextCode("srmMassProdDocNumber", (Object)prodHead));
        prodHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_WAIT_CONFIRM.value());
        String relationId = null;
        if ("1".equals(prodHead.getSupplierPpapFile())) {
            AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)prodHead.getSupplierElsAccount()), (Enum)I18nMassProdMsgEnum.MASS_PROD_NEED_SALE);
            AssertI18nUtil.isTrue((boolean)CollectionUtils.isEmpty(purchaseMassMassProdPpapItemList), (Enum)I18nMassProdMsgEnum.MASS_PROD_NEED_PPAP);
            prodHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_WAIT_UPLOAD_FILE.value()).setId(IdWorker.getIdStr());
            SaleMassProdHead saleMassProdHead = new SaleMassProdHead();
            BeanUtils.copyProperties((Object)((Object)prodHead), (Object)((Object)saleMassProdHead));
            saleMassProdHead.setRelationId(prodHead.getId()).setBusAccount(TenantContext.getTenant()).setUploadPpap("0").setElsAccount(prodHead.getSupplierElsAccount()).setId(null);
            this.saleMassProdHeadMapper.insert((Object)saleMassProdHead);
            relationId = saleMassProdHead.getId();
            prodHead.setRelationId(relationId);
            this.sendMsg(TenantContext.getTenant(), prodHead.getSupplierElsAccount(), (Object)prodHead, "", "massProdHead", "publish");
        }
        if (!"1".equals(prodHead.getSupplierPpapFile()) && !"1".equals(prodHead.getPubishAudit())) {
            prodHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_HAS_CONFIRM.value());
        }
        ((PurchaseMassProdHeadMapper)this.baseMapper).insert((Object)prodHead);
        this.insertData(prodHead, purchaseMassMassProdPpapItemList, purchaseMassProdSampleItemList);
        if (Objects.equals("1", prodHead.getSupplierPpapFile())) {
            this.publishPpapItem(prodHead.getId(), relationId, prodHead.getSupplierElsAccount(), purchaseMassMassProdPpapItemList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSubmit(PurchaseMassProdHead prodHead, List<PurchaseMassProdPpapItem> purchaseMassMassProdPpapItemList, List<PurchaseMassProdSampleItem> purchaseMassProdSampleItemList) {
        this.validStartTimeAndEndTime(prodHead.getSourceValidBeginTime(), prodHead.getSourceValidEndTime());
        PurchaseMassProdHead oldRecord = (PurchaseMassProdHead)((Object)((PurchaseMassProdHeadMapper)this.baseMapper).selectById((Serializable)((Object)prodHead.getId())));
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_RECORD_NOT_EXIST);
        AssertI18nUtil.isTrue((!MassProdEnum.HEAD_DOC_STATUS_NEW.value().equals(oldRecord.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_DOC_STATUS_NO_NEW);
        prodHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_WAIT_CONFIRM.value());
        String relationId = null;
        if ("1".equals(prodHead.getSupplierPpapFile())) {
            AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)prodHead.getSupplierElsAccount()), (Enum)I18nMassProdMsgEnum.MASS_PROD_NEED_SALE);
            AssertI18nUtil.isTrue((boolean)CollectionUtils.isEmpty(purchaseMassMassProdPpapItemList), (Enum)I18nMassProdMsgEnum.MASS_PROD_NEED_PPAP);
            prodHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_WAIT_UPLOAD_FILE.value());
            SaleMassProdHead saleMassProdHead = new SaleMassProdHead();
            BeanUtils.copyProperties((Object)((Object)prodHead), (Object)((Object)saleMassProdHead));
            saleMassProdHead.setRelationId(prodHead.getId()).setBusAccount(oldRecord.getElsAccount()).setUploadPpap("0").setElsAccount(prodHead.getSupplierElsAccount()).setId(null);
            this.saleMassProdHeadMapper.insert((Object)saleMassProdHead);
            relationId = saleMassProdHead.getId();
            prodHead.setRelationId(relationId);
            this.sendMsg(TenantContext.getTenant(), prodHead.getSupplierElsAccount(), (Object)prodHead, "", "massProdHead", "publish");
        }
        if (!"1".equals(prodHead.getSupplierPpapFile()) && !"1".equals(prodHead.getPubishAudit())) {
            prodHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_HAS_CONFIRM.value());
        }
        ((PurchaseMassProdHeadMapper)this.baseMapper).updateById((Object)prodHead);
        this.delMassProdItem(prodHead.getId());
        this.insertData(prodHead, purchaseMassMassProdPpapItemList, purchaseMassProdSampleItemList);
        if (Objects.equals("1", prodHead.getSupplierPpapFile())) {
            this.publishPpapItem(prodHead.getId(), relationId, prodHead.getSupplierElsAccount(), purchaseMassMassProdPpapItemList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delMain(String id) {
        PurchaseMassProdHead oldRecord = (PurchaseMassProdHead)((Object)((PurchaseMassProdHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_RECORD_NOT_EXIST);
        boolean bool = MassProdEnum.HEAD_DOC_STATUS_NEW.value().equals(oldRecord.getDocumentsStatus()) || MassProdEnum.HEAD_DOC_STATUS_WAIT_CONFIRM.value().equals(oldRecord.getDocumentsStatus()) && AuditStatusEnum.AUDIT_NEW.getValue().equals(oldRecord.getResultAuditStatus());
        AssertI18nUtil.isTrue((!bool ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_DOC_STATUS_NO_NEW);
        this.delMassProdItem(id);
        this.purchaseMassProdHeadMapper.deleteById((Serializable)((Object)id));
        this.saleMassProdHeadMapper.deleteById((Serializable)((Object)oldRecord.getRelationId()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            PurchaseMassProdHead oldRecord = (PurchaseMassProdHead)((Object)((PurchaseMassProdHeadMapper)this.baseMapper).selectById(serializable));
            AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_RECORD_NOT_EXIST);
            boolean bool = MassProdEnum.HEAD_DOC_STATUS_NEW.value().equals(oldRecord.getDocumentsStatus()) || MassProdEnum.HEAD_DOC_STATUS_WAIT_CONFIRM.value().equals(oldRecord.getDocumentsStatus()) && AuditStatusEnum.AUDIT_NEW.getValue().equals(oldRecord.getResultAuditStatus());
            AssertI18nUtil.isTrue((!bool ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_DOC_STATUS_NO_NEW);
            this.delMassProdItem(serializable.toString());
            this.purchaseMassProdHeadMapper.deleteById(serializable);
            this.saleMassProdHeadMapper.deleteById((Serializable)((Object)oldRecord.getRelationId()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateWaitConfirm(PurchaseMassProdConfirmVo purchaseMassProdConfirmVo) {
        PurchaseMassProdHead oldRecord = (PurchaseMassProdHead)((Object)((PurchaseMassProdHeadMapper)this.baseMapper).selectById((Serializable)((Object)purchaseMassProdConfirmVo.getId())));
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_RECORD_NOT_EXIST);
        AssertI18nUtil.isTrue((!MassProdEnum.HEAD_DOC_STATUS_WAIT_CONFIRM.value().equals(oldRecord.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_DOC_STATUS_NO_WAIT_CONFIRM);
        AssertI18nUtil.isTrue((StringUtils.isNotBlank((CharSequence)oldRecord.getResultAuditStatus()) && !AuditStatusEnum.AUDIT_REJECT.getValue().equals(oldRecord.getResultAuditStatus()) ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_AUDI_STATUS_NOT_NULL);
        this.purchaseMassProdSampleItemMapper.deleteByMainId(oldRecord.getId());
        this.insertData(oldRecord, null, purchaseMassProdConfirmVo.getPurchaseMassProdSampleItemList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void confirm(PurchaseMassProdConfirmVo purchaseMassProdConfirmVo) {
        PurchaseMassProdHead oldRecord = (PurchaseMassProdHead)((Object)((PurchaseMassProdHeadMapper)this.baseMapper).selectById((Serializable)((Object)purchaseMassProdConfirmVo.getId())));
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_RECORD_NOT_EXIST);
        AssertI18nUtil.isTrue((!MassProdEnum.HEAD_DOC_STATUS_WAIT_CONFIRM.value().equals(oldRecord.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_DOC_STATUS_NO_WAIT_CONFIRM);
        AssertI18nUtil.isTrue((StringUtils.isNotBlank((CharSequence)oldRecord.getResultAuditStatus()) && !AuditStatusEnum.AUDIT_REJECT.getValue().equals(oldRecord.getResultAuditStatus()) ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_AUDI_STATUS_NOT_NULL);
        if (!Objects.equals(oldRecord.getPubishAudit(), "1")) {
            oldRecord.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_HAS_CONFIRM.value());
        } else {
            oldRecord.setResultAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        }
        SaleMassProdHead saleMassProdHead = new SaleMassProdHead();
        saleMassProdHead.setDocumentsStatus(oldRecord.getDocumentsStatus()).setId(oldRecord.getRelationId());
        ((PurchaseMassProdHeadMapper)this.baseMapper).updateById((Object)oldRecord);
        this.saleMassProdHeadMapper.updateById((Object)saleMassProdHead);
        if (Objects.equals("1", oldRecord.getPushToSource())) {
            this.pushToSource(oldRecord);
        }
        this.purchaseMassProdSampleItemMapper.deleteByMainId(oldRecord.getId());
        this.insertData(oldRecord, null, purchaseMassProdConfirmVo.getPurchaseMassProdSampleItemList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sendBackToSale(String id) {
        AssertI18nUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)id), (Enum)I18nBaseEnum.RECORD_ID_IS_NULL);
        PurchaseMassProdHead oldRecord = (PurchaseMassProdHead)((Object)((PurchaseMassProdHeadMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AssertI18nUtil.isTrue((oldRecord == null ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_RECORD_NOT_EXIST);
        AssertI18nUtil.isTrue((!"1".equals(oldRecord.getSupplierPpapFile()) ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_NOT_SEND_TO_SALE);
        AssertI18nUtil.isTrue((!MassProdEnum.HEAD_DOC_STATUS_WAIT_CONFIRM.value().equals(oldRecord.getDocumentsStatus()) ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_DOC_STATUS_NO_WAIT_CONFIRM);
        AssertI18nUtil.isTrue((StringUtils.isNotBlank((CharSequence)oldRecord.getResultAuditStatus()) && !AuditStatusEnum.AUDIT_REJECT.getValue().equals(oldRecord.getResultAuditStatus()) ? 1 : 0) != 0, (Enum)I18nMassProdMsgEnum.MASS_PROD_HAS_COMMIT_APPROVE);
        oldRecord.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_WAIT_UPLOAD_FILE.value());
        ((PurchaseMassProdHeadMapper)this.baseMapper).updateById((Object)oldRecord);
        SaleMassProdHead saleMassProdHead = new SaleMassProdHead();
        saleMassProdHead.setDocumentsStatus(MassProdEnum.HEAD_DOC_STATUS_WAIT_UPLOAD_FILE.value()).setUploadPpap("0").setId(oldRecord.getRelationId());
        this.saleMassProdHeadMapper.updateById((Object)saleMassProdHead);
    }
}

