/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ecn.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.ecn.entity.EcnBuyerList;
import com.els.modules.ecn.entity.EcnOrderDetail;
import com.els.modules.ecn.entity.EcnSupplierList;
import com.els.modules.ecn.entity.PurchaseEcn;
import com.els.modules.ecn.rpc.service.EcnInvokeBaseRpcService;
import com.els.modules.ecn.service.EcnBuyerListService;
import com.els.modules.ecn.service.EcnOrderDetailService;
import com.els.modules.ecn.service.EcnSupplierListService;
import com.els.modules.ecn.service.PurchaseEcnService;
import com.els.modules.ecn.vo.PurchaseEcnVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/ecn/purchaseEcn"})
@Api(tags={"\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u4e66"})
public class PurchaseEcnController
extends BaseController<PurchaseEcn, PurchaseEcnService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseEcnController.class);
    @Autowired
    private PurchaseEcnService purchaseEcnService;
    @Autowired
    private EcnSupplierListService ecnSupplierListService;
    @Autowired
    private EcnBuyerListService ecnBuyerListService;
    @Autowired
    private EcnInvokeBaseRpcService ecnInvokeBaseRpcService;
    @Autowired
    private EcnOrderDetailService ecnOrderDetailService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="ecn")
    @RequiresPermissions(value={"ecn#purchaseEcnHead:list"})
    public Result<?> queryPageList(PurchaseEcn purchaseEcn, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseEcn), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseEcnService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(busModule="\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u4e66", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"ecn#purchaseEcnHead:add"})
    public Result<?> add(@RequestBody PurchaseEcnVO purchaseEcnPage) {
        PurchaseEcn purchaseEcn = new PurchaseEcn();
        BeanUtils.copyProperties((Object)((Object)purchaseEcnPage), (Object)((Object)purchaseEcn));
        PurchaseEcn resultPurchaseEcn = this.purchaseEcnService.saveMain(purchaseEcn, purchaseEcnPage.getEcnSupplierListList(), purchaseEcnPage.getEcnBuyerListList(), purchaseEcnPage.getOrderDetails());
        return Result.ok((Object)((Object)resultPurchaseEcn));
    }

    @SrmValidated
    @ApiOperation(value="\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u4e66-\u590d\u5236", notes="\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u4e66-\u590d\u5236")
    @GetMapping(value={"/copyById"})
    @RequiresPermissions(value={"ecn#purchaseEcnHead:copy"})
    public Result<?> copyById(@RequestParam(name="id") String id) {
        this.purchaseEcnService.copyById(id);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(busModule="\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u4e66", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"ecn#purchaseEcnHead:edit"})
    public Result<?> edit(@RequestBody PurchaseEcnVO purchaseEcnPage) {
        PurchaseEcn purchaseEcn = new PurchaseEcn();
        BeanUtils.copyProperties((Object)((Object)purchaseEcnPage), (Object)((Object)purchaseEcn));
        this.purchaseEcnService.updateMain(purchaseEcn, purchaseEcnPage.getEcnSupplierListList(), purchaseEcnPage.getEcnBuyerListList(), purchaseEcnPage.getOrderDetails());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u4e66", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"ecn#purchaseEcnHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseEcnService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u4e66", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"ecn#purchaseEcnHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchaseEcnService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"ecn#purchaseEcnHead:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseEcn purchaseEcn = (PurchaseEcn)((Object)this.purchaseEcnService.getById((Serializable)((Object)id)));
        PurchaseEcnVO purchaseEcnVO = new PurchaseEcnVO();
        BeanUtils.copyProperties((Object)((Object)purchaseEcn), (Object)((Object)purchaseEcnVO));
        List<EcnSupplierList> ecnSupplierListList = this.ecnSupplierListService.selectByMainId(id);
        purchaseEcnVO.setEcnSupplierListList(ecnSupplierListList);
        List<EcnBuyerList> ecnBuyerListList = this.ecnBuyerListService.selectByMainId(id);
        purchaseEcnVO.setEcnBuyerListList(ecnBuyerListList);
        List<PurchaseAttachmentDTO> attachments = this.ecnInvokeBaseRpcService.purcahseSelectByMainId(id);
        purchaseEcnVO.setAttachments(attachments);
        List<EcnOrderDetail> orderDetails = this.ecnOrderDetailService.selectByMainId(id);
        purchaseEcnVO.setOrderDetails(orderDetails);
        return Result.ok((Object)((Object)purchaseEcnVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u4e66id\u67e5\u8be2\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u4f9b\u5e94\u5546\u5217\u8868", notes="\u901a\u8fc7\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u4e66id\u67e5\u8be2\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u4f9b\u5e94\u5546\u5217\u8868")
    @GetMapping(value={"/queryEcnSupplierListByMainId"})
    @RequiresPermissions(value={"ecn#purchaseEcnHead:list"})
    public Result<?> queryEcnSupplierListListByMainId(@RequestParam(name="id") String id) {
        List<EcnSupplierList> ecnSupplierListList = this.ecnSupplierListService.selectByMainId(id);
        return Result.ok(ecnSupplierListList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u4e66id\u67e5\u8be2\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u91c7\u8d2d\u5458\u5217\u8868", notes="\u901a\u8fc7\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u4e66id\u67e5\u8be2\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u91c7\u8d2d\u5458\u5217\u8868")
    @GetMapping(value={"/queryEcnBuyerListByMainId"})
    @RequiresPermissions(value={"ecn#purchaseEcnHead:list"})
    public Result<?> queryEcnBuyerListListByMainId(@RequestParam(name="id") String id) {
        List<EcnBuyerList> ecnBuyerListList = this.ecnBuyerListService.selectByMainId(id);
        return Result.ok(ecnBuyerListList);
    }

    @GetMapping(value={"/exportXls"})
    @RequiresPermissions(value={"ecn#purchaseEcnHead:exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, PurchaseEcn purchaseEcn) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseEcn), (Map)request.getParameterMap());
        LoginUser sysUser = SysUtil.getLoginUser();
        ArrayList<PurchaseEcnVO> pageList = new ArrayList<PurchaseEcnVO>();
        List purchaseEcnList = this.purchaseEcnService.list((Wrapper)queryWrapper);
        for (PurchaseEcn temp : purchaseEcnList) {
            PurchaseEcnVO vo = new PurchaseEcnVO();
            BeanUtils.copyProperties((Object)((Object)temp), (Object)((Object)vo));
            List<EcnSupplierList> ecnSupplierListList = this.ecnSupplierListService.selectByMainId(temp.getId());
            vo.setEcnSupplierListList(ecnSupplierListList);
            List<EcnBuyerList> ecnBuyerListList = this.ecnBuyerListService.selectByMainId(temp.getId());
            vo.setEcnBuyerListList(ecnBuyerListList);
            pageList.add(vo);
        }
        return null;
    }

    @SrmValidated
    @AutoLog(busModule="\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u4e66", value="\u53d1\u9001\u4f9b\u5e94\u5546")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u9001\u4f9b\u5e94\u5546")
    @PostMapping(value={"/publishSuppliers"})
    @RequiresPermissions(value={"ecn#purchaseEcnHead:publishSuppliers"})
    public Result<?> publishSuppliers(@RequestBody PurchaseEcnVO purchaseEcnPage) {
        PurchaseEcn purchaseEcn = new PurchaseEcn();
        BeanUtils.copyProperties((Object)((Object)purchaseEcnPage), (Object)((Object)purchaseEcn));
        if (purchaseEcnPage.getEcnSupplierListList() == null) {
            purchaseEcnPage.setEcnSupplierListList(this.ecnSupplierListService.selectByMainId(purchaseEcn.getId()));
        }
        if (purchaseEcnPage.getAttachments() == null) {
            purchaseEcnPage.setAttachments(this.ecnInvokeBaseRpcService.purcahseSelectByMainId(purchaseEcn.getId()));
        }
        if (purchaseEcnPage.getOrderDetails() == null) {
            purchaseEcnPage.setOrderDetails(this.ecnOrderDetailService.selectByMainId(purchaseEcn.getId()));
        }
        this.purchaseEcnService.publishSuppliers(purchaseEcn, purchaseEcnPage.getEcnSupplierListList(), purchaseEcnPage.getAttachments(), purchaseEcnPage.getOrderDetails());
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(busModule="\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u4e66", value="\u63d0\u9192\u91c7\u8d2d\u5458")
    @ApiOperation(value="\u53d1\u5e03", notes="\u63d0\u9192\u91c7\u8d2d\u5458")
    @PostMapping(value={"/publishBuyer"})
    @RequiresPermissions(value={"ecn#purchaseEcnHead:publishBuyer"})
    public Result<?> publishBuyer(@RequestBody PurchaseEcnVO purchaseEcnPage) {
        PurchaseEcn purchaseEcn = new PurchaseEcn();
        BeanUtils.copyProperties((Object)((Object)purchaseEcnPage), (Object)((Object)purchaseEcn));
        if (purchaseEcnPage.getEcnBuyerListList() == null) {
            purchaseEcnPage.setEcnBuyerListList(this.ecnBuyerListService.selectByMainId(purchaseEcn.getId()));
        }
        this.purchaseEcnService.publishBuyer(purchaseEcn, purchaseEcnPage.getEcnBuyerListList());
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(busModule="\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u4e66", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"ecn#purchaseEcnHead:publish"})
    public Result<?> publish(@RequestBody PurchaseEcnVO purchaseEcnPage) {
        PurchaseEcn purchaseEcn = new PurchaseEcn();
        BeanUtils.copyProperties((Object)((Object)purchaseEcnPage), (Object)((Object)purchaseEcn));
        purchaseEcnPage.setEcnBuyerListList(this.ecnBuyerListService.selectByMainId(purchaseEcn.getId()));
        if (purchaseEcnPage.getEcnBuyerListList() != null) {
            this.purchaseEcnService.publishBuyer(purchaseEcn, purchaseEcnPage.getEcnBuyerListList());
        }
        purchaseEcnPage.setEcnSupplierListList(this.ecnSupplierListService.selectByMainId(purchaseEcn.getId()));
        purchaseEcnPage.setAttachments(this.ecnInvokeBaseRpcService.purcahseSelectByMainId(purchaseEcn.getId()));
        purchaseEcnPage.setOrderDetails(this.ecnOrderDetailService.selectByMainId(purchaseEcn.getId()));
        if (purchaseEcnPage.getEcnSupplierListList() != null) {
            this.purchaseEcnService.publishSuppliers(purchaseEcn, purchaseEcnPage.getEcnSupplierListList(), purchaseEcnPage.getAttachments(), purchaseEcnPage.getOrderDetails());
        }
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(busModule="\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u4e66", value="\u64a4\u9500")
    @ApiOperation(value="\u64a4\u9500", notes="\u64a4\u9500")
    @GetMapping(value={"/backout"})
    @RequiresPermissions(value={"ecn#purchaseEcnHead:backout"})
    public Result<?> backout(@RequestParam(name="id") String id) {
        this.purchaseEcnService.backout(id);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(busModule="\u5de5\u7a0b\u53d8\u66f4\u901a\u77e5\u4e66", value="\u4f5c\u5e9f")
    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @GetMapping(value={"/cancellation"})
    @RequiresPermissions(value={"ecn#purchaseEcnHead:cancellation"})
    public Result<?> cancellation(@RequestParam(name="id") String id) {
        this.purchaseEcnService.cancellation(id);
        return this.commonSuccessResult(7);
    }

    @ApiOperation(value="\u83b7\u53d6ERP\u6570\u636e", notes="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"ecn#purchaseEcnHead:getDataByErp"})
    public Result<?> getDataByErp() {
        this.purchaseEcnService.getDataByErp();
        return Result.ok();
    }

    @ApiOperation(value="SRM\u63a8\u9001\u5230ERP", notes="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"ecn#purchaseEcnHead:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.purchaseEcnService.pushDataToErp(ids);
        return Result.ok();
    }
}

