/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.caigouwang.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.modules.caigouwang.entity.CaigouBusinessList;
import com.els.modules.caigouwang.mapper.CaigouBusinessListMapper;
import com.els.modules.caigouwang.service.CaigouBusinessListService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class CaigouBusinessListServiceImpl
extends BaseServiceImpl<CaigouBusinessListMapper, CaigouBusinessList>
implements CaigouBusinessListService {
    Map<String, String> config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
    private String address = this.config.get("service.caigouwang");
    private static final String BUSINESS_LIST_URL = "business/web/notice/business-list";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd+hh:mm:ss");
    private static SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    @Autowired
    private CaigouBusinessListMapper caigouBusinessListMapper;

    @Override
    public void saveCaigouBusinessList(CaigouBusinessList caigouBusinessList) {
        ((CaigouBusinessListMapper)this.baseMapper).insert((Object)caigouBusinessList);
    }

    @Override
    public void updateCaigouBusinessList(CaigouBusinessList caigouBusinessList) {
        ((CaigouBusinessListMapper)this.baseMapper).updateById((Object)caigouBusinessList);
    }

    @Override
    public void delCaigouBusinessList(String id) {
        ((CaigouBusinessListMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchCaigouBusinessList(List<String> idList) {
        ((CaigouBusinessListMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Result<?> handleData(CaigouBusinessList caigouBusinessList, Integer pageNo, Integer pageSize) {
        String url = this.address + BUSINESS_LIST_URL + "?current=" + pageNo + "&size=" + pageSize;
        JSONObject object = (JSONObject)SysUtil.copyProperties((Object)((Object)caigouBusinessList), JSONObject.class);
        if (StringUtils.isNotBlank((CharSequence)caigouBusinessList.getTitle())) {
            object.put("name", (Object)caigouBusinessList.getTitle());
        }
        for (String key : object.keySet()) {
            if (!StringUtils.isNotBlank((CharSequence)object.getString(key))) continue;
            url = url + "&" + key + "=" + object.getString(key);
        }
        String response = HttpRequest.get((String)url).execute().body();
        JSONObject result = JSONObject.parseObject((String)response);
        try {
            this.syncGetData();
        }
        catch (Exception e) {
            logger.error("\u91c7\u8d2d\u7f51-\u5546\u673a\u5217\u8868-\u5f02\u6b65\u8bf7\u6c42\u6570\u636e\u5931\u8d25\uff1a", (Throwable)e);
        }
        return result.getBoolean("success") != false ? Result.ok((Object)result.getJSONObject("data")) : Result.error((String)result.getString("message"));
    }

    @Async
    public void syncGetData() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"create_time"});
        wrapper.orderByDesc((Object)"create_time");
        wrapper.last(" limit 1");
        List list = this.list((Wrapper)wrapper);
        String startDate = null;
        String endDate = null;
        if (!list.isEmpty()) {
            startDate = sdf.format(((CaigouBusinessList)((Object)list.get(0))).getCreateTime());
            endDate = sdf.format(new Date());
        }
        String url = null;
        url = startDate == null ? this.address + BUSINESS_LIST_URL + "?size=100" : this.address + BUSINESS_LIST_URL + "?startDate=" + startDate + "&endDate=" + endDate + "&size=100";
        String response = HttpRequest.get((String)url).execute().body();
        JSONObject result = JSONObject.parseObject((String)response);
        if (result.getBoolean("success").booleanValue()) {
            ArrayList replenishList = new ArrayList();
            JSONObject data = result.getJSONObject("data");
            Integer total = data.getInteger("total");
            Integer size = data.getInteger("size");
            Integer current = data.getInteger("current");
            Integer pages = data.getInteger("pages");
            if (total != null && total > 0) {
                ArrayList lists = SysUtil.copyProperties((List)data.getJSONArray("records"), CaigouBusinessList.class);
                replenishList.addAll(lists);
            }
            for (int i = current.intValue(); i < pages; ++i) {
                Integer n = current;
                Integer n2 = current = Integer.valueOf(current + 1);
                url = startDate == null ? this.address + BUSINESS_LIST_URL + "?size=100&current=" + current : this.address + BUSINESS_LIST_URL + "?startDate=" + startDate + "&endDate=" + endDate + "&size=100&current=" + current;
                response = HttpRequest.get((String)url).execute().body();
                result = JSONObject.parseObject((String)response);
                if (!result.getBoolean("success").booleanValue()) continue;
                data = result.getJSONObject("data");
                ArrayList lists = SysUtil.copyProperties((List)data.getJSONArray("records"), CaigouBusinessList.class);
                replenishList.addAll(lists);
            }
            if (replenishList.size() > 0 && !list.isEmpty()) {
                this.caigouBusinessListMapper.deleteByTime(sdf2.format(((CaigouBusinessList)((Object)list.get(0))).getCreateTime()), sdf2.format(new Date()));
            }
            this.saveBatch(replenishList);
        }
    }
}

