/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.siteInspection.job.utils;

import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.job.api.dto.QuartzJobDTO;
import com.els.modules.siteInspection.entity.ElsInspectionPlanHead;
import com.els.modules.siteInspection.rpc.InspectionPlanInvokeJobRpcService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElsInspectionPlanJobUtil {
    private static final Logger log = LoggerFactory.getLogger(ElsInspectionPlanJobUtil.class);
    private static InspectionPlanInvokeJobRpcService inspectionPlanInvokeJobRpcService = (InspectionPlanInvokeJobRpcService)SpringContextUtils.getBean(InspectionPlanInvokeJobRpcService.class);
    public static final String PLAN_START_JOB = "srmInspectionPlanBeginJobServiceImpl";

    public static void createJob(ElsInspectionPlanHead head, Date time) {
        String elsAccount = TenantContext.getTenant();
        String cron = DateUtils.formatDate((Date)time, (String)"ss mm HH dd MM ? yyyy");
        QuartzJobDTO job = new QuartzJobDTO();
        job.setCronExpression(cron);
        job.setJobClassName("com.els.modules.quartz.job.BusinessJob");
        job.setStatus(CommonConstant.STATUS_NORMAL);
        job.setJobNameKey("srmInspectionPlanBeginJobServiceImpl_" + head.getPlanNumber() + "_" + elsAccount);
        JSONObject paramObj = new JSONObject();
        paramObj.put("id", (Object)head.getId());
        paramObj.put("jobKey", (Object)job.getJobNameKey());
        paramObj.put("tenantId", (Object)elsAccount);
        paramObj.put("jobImplName", (Object)PLAN_START_JOB);
        job.setParameter(paramObj.toJSONString());
        job.setElsAccount(elsAccount);
        try {
            inspectionPlanInvokeJobRpcService.createJob(job);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public static void deleteJob(String jobKey) {
        List<QuartzJobDTO> jobList = inspectionPlanInvokeJobRpcService.findJobList(jobKey);
        if (!jobList.isEmpty()) {
            inspectionPlanInvokeJobRpcService.deleteJob(jobList.get(0));
        }
    }
}

