/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.adapter;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.service.BaseRpcService;
import com.els.modules.extend.api.dto.ApprovalPendToFanWeiVo;
import com.els.modules.extend.api.service.OaThirdSevice;
import com.els.modules.quality.entity.PurchaseQualityCheckHead;
import com.els.modules.quality.entity.PurchaseQualityCheckItem;
import com.els.modules.quality.service.PurchaseQualityCheckHeadService;
import com.els.modules.quality.service.PurchaseQualityCheckItemService;
import com.els.modules.quality.vo.PurchaseQualityCheckHeadVO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class PurchaseQualityCheckAdapter
implements AuditOptCallBackService {
    @Autowired
    private PurchaseQualityCheckHeadService purchaseQualityCheckHeadService;
    @Autowired
    private PurchaseQualityCheckItemService purchaseQualityCheckItemService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    @Lazy(value=true)
    private OaThirdSevice oaThirdSevice;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String param = StringUtils.isEmpty((CharSequence)inputParamVO.getParams()) ? "{}" : inputParamVO.getParams();
        PurchaseQualityCheckHeadVO headVO = (PurchaseQualityCheckHeadVO)((Object)JSONObject.parseObject((String)param, PurchaseQualityCheckHeadVO.class));
        PurchaseQualityCheckHead head = new PurchaseQualityCheckHead();
        BeanUtil.copyProperties((Object)((Object)headVO), (Object)((Object)head), (String[])new String[0]);
        head.setCheckStatus("1");
        this.purchaseQualityCheckHeadService.updateMain(head, headVO.getPurchaseQualityCheckItemList());
        this.updateAuditStatus(inputParamVO, outputParamVO);
        String operataion = "submitAudit";
        if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
            operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
        }
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"qualityCheck", (String)operataion, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamVO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"qualityCheck", (String)operataion, (MsgParamsVO)msgParamsVO);
                String tenant = TenantContext.getTenant();
                List elsSubAccountDTOS = (List)msgParamsVO.getReceiverMap().get(tenant);
                JSONObject jsonObjectMsgParams = (JSONObject)msgParamsVO.getReceiveParamMap().get(tenant);
                String link = null;
                String taskId = jsonObjectMsgParams.getString("taskId");
                String businessType = jsonObjectMsgParams.getString("businessType");
                String businessId = jsonObjectMsgParams.getString("businessId");
                String processInstanceId = jsonObjectMsgParams.getString("processInstanceId");
                String linkParamApp = "taskId=" + taskId + "&businessType=" + businessType + "&businessId=" + businessId + "&processInstanceId=" + processInstanceId;
                String linkParam = "taskId=" + taskId + "&businessType=" + businessType + "&businessId=" + businessId + "&processInstanceId=" + processInstanceId + "&open=true";
                BaseRpcService baseRpcService = (BaseRpcService)SpringContextUtils.getBean(BaseRpcService.class);
                List todoListLink = baseRpcService.queryDictItemsByCode("todo_list_link", account);
                Map<String, String> todoListLinkMap = todoListLink.stream().collect(Collectors.toMap(DictDTO::getText, DictDTO::getValue));
                link = todoListLinkMap.get(WorkFlowType.BPMN.getValue());
                if (!CollectionUtil.isNotEmpty((Collection)elsSubAccountDTOS)) continue;
                for (int i = 0; i < elsSubAccountDTOS.size(); ++i) {
                    ElsSubAccountDTO elsSubAccountDTO = (ElsSubAccountDTO)elsSubAccountDTOS.get(i);
                    String AuthUrl = this.getAuthUrl(link + "?" + linkParam, elsSubAccountDTO);
                    String Appurl = this.getAppAuthUrl(link + "&" + linkParamApp, elsSubAccountDTO);
                    ApprovalPendToFanWeiVo approvalPendToFanWeiVo = new ApprovalPendToFanWeiVo();
                    approvalPendToFanWeiVo.setPcurl(AuthUrl);
                    approvalPendToFanWeiVo.setAppurl(Appurl);
                    approvalPendToFanWeiVo.setRequestname(inputParamVO.getAuditSubject());
                    approvalPendToFanWeiVo.setViewtype("0");
                    long timeMillis = System.currentTimeMillis();
                    approvalPendToFanWeiVo.setReceivets(String.valueOf(timeMillis));
                    approvalPendToFanWeiVo.setReceiver(((ElsSubAccountDTO)elsSubAccountDTOS.get(i)).getId());
                    approvalPendToFanWeiVo.setFlowid(String.valueOf(inputParamVO.getRootProcessInstanceId()));
                    approvalPendToFanWeiVo.setIsremark("0");
                    Date date = new Date();
                    date.getTime();
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String date2 = dateFormat.format(date);
                    approvalPendToFanWeiVo.setCreatedatetime(date2);
                    approvalPendToFanWeiVo.setReceivedatetime(date2);
                    approvalPendToFanWeiVo.setWorkflowname("submitAudit");
                    this.oaThirdSevice.putApprovalPendToFanWei(approvalPendToFanWeiVo);
                }
            }
        }
    }

    private String getAppAuthUrl(String redirectUri, ElsSubAccountDTO account) {
        Map config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
        StringBuilder url = new StringBuilder((String)config.get("service.address"));
        url.append("/mobile?type=redirect&pagePath=").append(URLUtil.encodeAll((String)redirectUri));
        return url.toString();
    }

    private String getAuthUrl(String redirectUri, ElsSubAccountDTO account) {
        Map config = ((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig();
        StringBuilder url = new StringBuilder((String)config.get("service.address"));
        url.append("/user/login?redirect=").append(URLUtil.encodeAll((String)redirectUri)).append("&token=").append(JwtUtil.getOutToken((String)(account.getElsAccount() + "_" + account.getSubAccount()), (String)account.getPassword()));
        return url.toString();
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            this.sendMsg(inputParamVO, outputParamVO, "auditPass");
        } else {
            this.sendMsg(inputParamVO, outputParamVO, "submitAudit");
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
        this.sendMsg(inputParamVO, outputParamVO, "auditReject");
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateAuditStatus(inputParamVO, outputParamVO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAuditStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        ReentrantLock lock = new ReentrantLock();
        try {
            lock.lock();
            PurchaseQualityCheckHead updateHead = new PurchaseQualityCheckHead();
            updateHead.setId(inputParamVO.getBusinessId());
            updateHead.setFlowId(outputParamVO.getProcessRootId());
            updateHead.setAuditStatus(outputParamVO.getAuditStatus());
            this.purchaseQualityCheckHeadService.updateById((Object)updateHead);
            if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
                PurchaseQualityCheckHead head = (PurchaseQualityCheckHead)((Object)this.purchaseQualityCheckHeadService.getById((Serializable)((Object)inputParamVO.getBusinessId())));
                List<PurchaseQualityCheckItem> checkItemList = this.purchaseQualityCheckItemService.selectByMainId(inputParamVO.getBusinessId());
                this.purchaseQualityCheckHeadService.publish(head, checkItemList);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void sendMsg(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String optType) {
        String elsAccount = TenantContext.getTenant();
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)elsAccount, (String)"qualityCheck", (String)optType, (MsgParamsVO)msgParamsVO);
        } else {
            List accountList = outputParamVO.getNextAuditUserList();
            for (String account : accountList) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                MqUtil.sendBusMsg((String)elsAccount, (String)"qualityCheck", (String)optType, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String businessType = inputParamVO.getBusinessType();
        String flowId = outputParamVO.getProcessRootId();
        String headId = inputParamVO.getBusinessId();
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        String outAuditRejectUrl = SysUtil.getOutAuditRejectUrl((ElsSubAccountDTO)subAccount, (String)flowId, (String)businessType, (String)headId);
        PurchaseQualityCheckHead head = (PurchaseQualityCheckHead)((Object)this.purchaseQualityCheckHeadService.getById((Serializable)((Object)headId)));
        List<PurchaseQualityCheckItem> checkItemList = this.purchaseQualityCheckItemService.selectByMainId(headId);
        PurchaseQualityCheckHeadVO headVO = new PurchaseQualityCheckHeadVO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
        headVO.setPurchaseQualityCheckItemList(checkItemList);
        Result result = Result.ok((Object)((Object)headVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean(DictAspect.class);
        dictAspect.parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("userName", subAccount.getRealname());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

