/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.sample.entity.PurchaseSampleCheckHead;
import com.els.modules.sample.entity.PurchaseSampleCheckItem;
import com.els.modules.sample.entity.PurchaseSampleItem;
import com.els.modules.sample.entity.PurchaseSampleTrackingItem;
import com.els.modules.sample.enumerate.PurchaseSampleCheckHeadEnum;
import com.els.modules.sample.enumerate.PurchaseSampleCheckProjectSyncEnum;
import com.els.modules.sample.enumerate.PurchaseSampleItemCheckStatusEnum;
import com.els.modules.sample.enumerate.SampleUseLinkEnum;
import com.els.modules.sample.mapper.PurchaseSampleCheckHeadMapper;
import com.els.modules.sample.mapper.PurchaseSampleCheckItemMapper;
import com.els.modules.sample.mapper.PurchaseSampleTrackingItemMapper;
import com.els.modules.sample.service.PurchaseSampleCheckHeadService;
import com.els.modules.sample.service.PurchaseSampleCheckItemService;
import com.els.modules.sample.service.PurchaseSampleItemService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseSampleCheckHeadServiceImpl
extends BaseServiceImpl<PurchaseSampleCheckHeadMapper, PurchaseSampleCheckHead>
implements PurchaseSampleCheckHeadService {
    @Resource
    private PurchaseSampleCheckHeadMapper purchaseSampleCheckHeadMapper;
    @Resource
    private PurchaseSampleCheckItemMapper purchaseSampleCheckItemMapper;
    @Resource
    private PurchaseSampleCheckItemService purchaseSampleCheckItemService;
    @Resource
    private PurchaseSampleTrackingItemMapper purchaseSampleTrackingItemMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseSampleItemService purchaseSampleItemService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseSampleCheckHead purchaseSampleCheckHead, List<PurchaseSampleCheckItem> purchaseSampleCheckItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        purchaseSampleCheckHead.setCheckNumber(this.invokeBaseRpcService.getNextCode("srmSampleCheckNumber", (Object)purchaseSampleCheckHead));
        purchaseSampleCheckHead.setCheckStatus(PurchaseSampleCheckHeadEnum.NEW.getValue());
        if ("1".equals(purchaseSampleCheckHead.getResultAudit())) {
            purchaseSampleCheckHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseSampleCheckHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.purchaseSampleCheckHeadMapper.insert((Object)purchaseSampleCheckHead);
        this.insertData(purchaseSampleCheckHead, purchaseSampleCheckItemList, purchaseAttachmentList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseSampleCheckHead purchaseSampleCheckHead, List<PurchaseSampleCheckItem> purchaseSampleCheckItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, Integer type) {
        Date now = new Date();
        if (type != null && 2 == type) {
            purchaseSampleCheckHead.setCheckStartDate(now);
        }
        if ("1".equals(purchaseSampleCheckHead.getResultAudit())) {
            purchaseSampleCheckHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchaseSampleCheckHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.purchaseSampleCheckHeadMapper.updateById((Object)purchaseSampleCheckHead);
        this.purchaseSampleCheckItemMapper.deleteByMainId(purchaseSampleCheckHead.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseSampleCheckHead.getId());
        this.insertData(purchaseSampleCheckHead, purchaseSampleCheckItemList, purchaseAttachmentList);
        if (type != null && 2 == type) {
            PurchaseSampleTrackingItem trackingItem = new PurchaseSampleTrackingItem();
            trackingItem.setHeadId(purchaseSampleCheckHead.getSampleHeadId());
            trackingItem.setSampleNumber(purchaseSampleCheckHead.getCheckNumber());
            trackingItem.setSampleId(purchaseSampleCheckHead.getId());
            trackingItem.setPurchasePrincipal(purchaseSampleCheckHead.getPrincipal());
            trackingItem.setActualBeginTime(now);
            trackingItem.setStatus(PurchaseSampleCheckHeadEnum.TEST_ING.getValue());
            trackingItem.setCheckResult(purchaseSampleCheckHead.getCheckResult());
            trackingItem.setQualified(purchaseSampleCheckHead.getQualified());
            trackingItem.setSampleUseLink(SampleUseLinkEnum.CHEAK.getValue());
            this.purchaseSampleTrackingItemMapper.insert((Object)trackingItem);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void resultRecord(PurchaseSampleCheckHead purchaseSampleCheckHead, List<PurchaseSampleCheckItem> purchaseSampleCheckItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList, Integer type) {
        Date now = new Date();
        PurchaseSampleItem sampleItem = (PurchaseSampleItem)((Object)this.purchaseSampleItemService.getById((Serializable)((Object)purchaseSampleCheckHead.getSampleItemId())));
        BigDecimal differenceValue = sampleItem.getRepertoryQuantity().subtract(sampleItem.getCheckedQuantity());
        Assert.isTrue((differenceValue.compareTo(purchaseSampleCheckHead.getSampleQuantity()) >= 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_VNUVcjIIWRIBRVNUVcjTVWRWAPnVWRefqGLWWWW_4eadcf3b", (String)"\u6837\u54c1\u7533\u8bf7\u884c\u7684\u5df2\u68c0\u6570\u91cf\u5df2\u8d85\u8fc7\u6837\u54c1\u7533\u8bf7\u884c\u7684\u9700\u6c42\u6570\u91cf\uff0c\u5f53\u524d\u91c7\u6837\u6570\u91cf\u6700\u5927\u53ef\u8bbe\u4e3a${0}", (String[])new String[]{Integer.valueOf(differenceValue.intValue()).toString()}));
        if (type != null && 2 == type && "0".equals(purchaseSampleCheckHead.getResultAudit())) {
            purchaseSampleCheckHead.setCheckEndDate(now);
        }
        if ("0".equals(purchaseSampleCheckHead.getResultAudit())) {
            purchaseSampleCheckHead.setResultSync(PurchaseSampleCheckProjectSyncEnum.SYNC.getValue());
        }
        purchaseSampleCheckHead.setResultSync(PurchaseSampleCheckProjectSyncEnum.SYNC.getValue());
        this.purchaseSampleCheckHeadMapper.updateById((Object)purchaseSampleCheckHead);
        for (PurchaseSampleCheckItem entity : purchaseSampleCheckItemList) {
            this.purchaseSampleCheckItemMapper.updateById((Object)entity);
        }
        if (!purchaseAttachmentList.isEmpty()) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseSampleCheckHead.getId());
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
        if (type != null && 2 == type) {
            PurchaseSampleTrackingItem trackingItem = new PurchaseSampleTrackingItem();
            trackingItem.setSampleId(purchaseSampleCheckHead.getId());
            trackingItem.setStatus(PurchaseSampleCheckHeadEnum.TEST_END.getValue());
            trackingItem.setCheckResult(purchaseSampleCheckHead.getCheckResult());
            trackingItem.setQualified(purchaseSampleCheckHead.getQualified());
            if ("0".equals(purchaseSampleCheckHead.getResultAudit())) {
                trackingItem.setActualEndTime(now);
                if (purchaseSampleCheckHead.getCheckStartDate() != null) {
                    trackingItem.setEstimatedTimePeriod((now.getTime() - purchaseSampleCheckHead.getCheckStartDate().getTime()) / 86400000L + "");
                }
                BigDecimal newCheckedQuantity = sampleItem.getCheckedQuantity().add(purchaseSampleCheckHead.getSampleQuantity());
                UpdateWrapper sampleItemQueryWrapper = new UpdateWrapper();
                sampleItemQueryWrapper.lambda().eq(BaseEntity::getId, (Object)purchaseSampleCheckHead.getSampleItemId());
                sampleItemQueryWrapper.lambda().set(PurchaseSampleItem::getCheckedQuantity, (Object)newCheckedQuantity);
                sampleItemQueryWrapper.lambda().set(PurchaseSampleItem::getAvailableQuantity, (Object)sampleItem.getRepertoryQuantity().subtract(newCheckedQuantity));
                this.purchaseSampleItemService.update((Wrapper)sampleItemQueryWrapper);
            }
            this.purchaseSampleTrackingItemMapper.updateBySampleId(trackingItem);
        }
    }

    private void insertData(PurchaseSampleCheckHead purchaseSampleCheckHead, List<PurchaseSampleCheckItem> purchaseSampleCheckItemList, List<PurchaseAttachmentDTO> purchaseAttachmentList) {
        if (purchaseSampleCheckItemList != null && !purchaseSampleCheckItemList.isEmpty()) {
            for (PurchaseSampleCheckItem entity : purchaseSampleCheckItemList) {
                entity.setHeadId(purchaseSampleCheckHead.getId());
                entity.setCheckNumber(purchaseSampleCheckHead.getCheckNumber());
                entity.setId(null);
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseSampleCheckHead);
            }
            this.purchaseSampleCheckItemService.saveBatch(purchaseSampleCheckItemList);
        }
        if (purchaseAttachmentList != null && !purchaseAttachmentList.isEmpty()) {
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachmentList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseSampleCheckItemMapper.deleteByMainId(id);
        this.purchaseSampleCheckHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseSampleCheckItemMapper.deleteByMainId(serializable.toString());
            this.purchaseSampleCheckHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public IPage<PurchaseSampleCheckHead> getSalePage(Page<PurchaseSampleCheckHead> page, PurchaseSampleCheckHead purchaseSampleCheckHead) {
        QueryWrapper wrapper = new QueryWrapper();
        if (purchaseSampleCheckHead != null && StringUtils.isNotBlank((CharSequence)purchaseSampleCheckHead.getKeyWord())) {
            wrapper.like((Object)"sample_number", (Object)purchaseSampleCheckHead.getKeyWord());
        }
        LoginUser loginUser = SysUtil.getLoginUser();
        wrapper.eq((Object)"to_els_account", (Object)loginUser.getElsAccount());
        wrapper.eq((Object)"is_deleted", (Object)PurchaseSampleCheckProjectSyncEnum.NO_SYNC.getValue());
        wrapper.eq((Object)"is_result_sync", (Object)PurchaseSampleCheckProjectSyncEnum.SYNC.getValue());
        wrapper.eq((Object)"check_status", (Object)PurchaseSampleItemCheckStatusEnum.TEST_END.getValue());
        wrapper.orderByDesc((Object)"create_time");
        return this.purchaseSampleCheckHeadMapper.getListselectTenantTemplate(page, (QueryWrapper<PurchaseSampleCheckHead>)wrapper);
    }

    @Override
    public void copy(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PurchaseSampleCheckHead purchaseSampleCheckHead = (PurchaseSampleCheckHead)((Object)this.purchaseSampleCheckHeadMapper.selectById((Serializable)((Object)id)));
            LoginUser loginUser = SysUtil.getLoginUser();
            if (purchaseSampleCheckHead != null) {
                purchaseSampleCheckHead.setCheckNumber(this.invokeBaseRpcService.getNextCode("srmSampleCheckNumber", (Object)purchaseSampleCheckHead));
                purchaseSampleCheckHead.setCheckStatus(PurchaseSampleCheckHeadEnum.NEW.getValue());
                if ("1".equals(purchaseSampleCheckHead.getResultAudit())) {
                    purchaseSampleCheckHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
                } else {
                    purchaseSampleCheckHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                }
                purchaseSampleCheckHead.setId(null);
                purchaseSampleCheckHead.setUpdateTime(new Date());
                purchaseSampleCheckHead.setCreateTime(new Date());
                purchaseSampleCheckHead.setCreateBy(loginUser.getSubAccount());
                purchaseSampleCheckHead.setUpdateBy(loginUser.getSubAccount());
                this.purchaseSampleCheckHeadMapper.insert((Object)purchaseSampleCheckHead);
                List<PurchaseSampleCheckItem> items = this.purchaseSampleCheckItemMapper.selectByMainId(id);
                if (items != null && !items.isEmpty()) {
                    for (PurchaseSampleCheckItem entity : items) {
                        entity.setUpdateTime(new Date());
                        entity.setCreateTime(new Date());
                        entity.setCreateBy(loginUser.getRealname());
                        entity.setUpdateBy(loginUser.getRealname());
                        entity.setHeadId(purchaseSampleCheckHead.getId());
                        entity.setCheckNumber(purchaseSampleCheckHead.getCheckNumber());
                        entity.setId(null);
                        SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseSampleCheckHead);
                    }
                    this.purchaseSampleCheckItemService.saveBatch(items);
                }
            }
        }
    }
}

