/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.calendar.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.modules.calendar.entity.PurchaseFactoryCalendarHead;
import com.els.modules.calendar.entity.PurchaseFactoryCalendarItem;
import com.els.modules.calendar.mapper.PurchaseFactoryCalendarHeadMapper;
import com.els.modules.calendar.mapper.PurchaseFactoryCalendarItemMapper;
import com.els.modules.calendar.service.PurchaseFactoryCalendarHeadService;
import com.els.modules.calendar.vo.PurchaseFactoryCalendarHeadVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class PurchaseFactoryCalendarHeadServiceImpl
extends ServiceImpl<PurchaseFactoryCalendarHeadMapper, PurchaseFactoryCalendarHead>
implements PurchaseFactoryCalendarHeadService {
    @Resource
    private PurchaseFactoryCalendarHeadMapper purchaseFactoryCalendarHeadMapper;
    @Resource
    private PurchaseFactoryCalendarItemMapper purchaseFactoryCalendarItemMapper;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseFactoryCalendarHead purchaseFactoryCalendarHead, List<PurchaseFactoryCalendarItem> purchaseFactoryCalendarItemList) {
        this.purchaseFactoryCalendarHeadMapper.insert((Object)purchaseFactoryCalendarHead);
        this.insertData(purchaseFactoryCalendarHead, purchaseFactoryCalendarItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseFactoryCalendarHead purchaseFactoryCalendarHead, List<PurchaseFactoryCalendarItem> purchaseFactoryCalendarItemList) {
        this.purchaseFactoryCalendarHeadMapper.updateById((Object)purchaseFactoryCalendarHead);
        this.purchaseFactoryCalendarItemMapper.deleteByMainId(purchaseFactoryCalendarHead.getId());
        this.insertData(purchaseFactoryCalendarHead, purchaseFactoryCalendarItemList);
    }

    private void insertData(PurchaseFactoryCalendarHead purchaseFactoryCalendarHead, List<PurchaseFactoryCalendarItem> purchaseFactoryCalendarItemList) {
        if (CollectionUtils.isNotEmpty(purchaseFactoryCalendarItemList)) {
            for (PurchaseFactoryCalendarItem entity : purchaseFactoryCalendarItemList) {
                entity.setHeadId(purchaseFactoryCalendarHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseFactoryCalendarHead);
            }
            this.purchaseFactoryCalendarItemMapper.insertBatchSomeColumn(purchaseFactoryCalendarItemList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseFactoryCalendarItemMapper.deleteByMainId(id);
        this.purchaseFactoryCalendarHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseFactoryCalendarItemMapper.deleteByMainId(serializable.toString());
            this.purchaseFactoryCalendarHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public List<PurchaseFactoryCalendarHeadVO> getCalendar(String elsAccount, String factory) {
        List<PurchaseFactoryCalendarHeadVO> list = this.purchaseFactoryCalendarHeadMapper.selectCalendarList(elsAccount, factory);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (PurchaseFactoryCalendarHeadVO vo : list) {
            List<PurchaseFactoryCalendarItem> itemList = vo.getPurchaseFactoryCalendarItemList();
            List<String> dayOffList = itemList.stream().map(item -> sdf.format(item.getDayOff())).collect(Collectors.toList());
            vo.setDayOffList(dayOffList);
        }
        return list;
    }

    @Override
    public String loadHeadId(String elsAccount, String factory) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(PurchaseFactoryCalendarHead::getFactory, (Object)factory)).eq(BaseEntity::getElsAccount, (Object)elsAccount)).last(" limit 1");
        PurchaseFactoryCalendarHead purchaseFactoryCalendarHead = (PurchaseFactoryCalendarHead)((Object)((PurchaseFactoryCalendarHeadMapper)this.baseMapper).selectOne((Wrapper)wrapper));
        if (null == purchaseFactoryCalendarHead) {
            return null;
        }
        return purchaseFactoryCalendarHead.getId();
    }
}

