/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.mould.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.mould.entity.PurchaseMouldData;
import com.els.modules.mould.entity.PurchaseMouldScrapped;
import com.els.modules.mould.entity.SaleMouldData;
import com.els.modules.mould.entity.SaleMouldScrapped;
import com.els.modules.mould.enumerate.ScrappedStatusEnum;
import com.els.modules.mould.enumerate.TargetStatusEnum;
import com.els.modules.mould.mapper.PurchaseMouldScrappedMapper;
import com.els.modules.mould.mapper.SaleMouldScrappedMapper;
import com.els.modules.mould.service.PurchaseMouldDataService;
import com.els.modules.mould.service.SaleMouldDataService;
import com.els.modules.mould.service.SaleMouldScrappedService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleMouldScrappedServiceImpl
extends BaseServiceImpl<SaleMouldScrappedMapper, SaleMouldScrapped>
implements SaleMouldScrappedService {
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleMouldDataService saleMouldDataService;
    @Autowired
    private PurchaseMouldDataService purchaseMouldDataService;
    @Resource
    private PurchaseMouldScrappedMapper purchaseMouldScrappedMapper;

    @Override
    @SrmTransaction
    public void add(SaleMouldScrapped scrapped) {
        scrapped.setId(null);
        scrapped.setRelationId(null);
        scrapped.setElsAccount(TenantContext.getTenant());
        scrapped.setApplyUser(this.getLoginSubAndName());
        scrapped.setScrappedStatus(ScrappedStatusEnum.NEW.getValue());
        String scrappedNumber = this.invokeBaseRpcService.getNextCode("mouldScrapped", (Object)scrapped, scrapped.getBusAccount());
        scrapped.setScrappedNumber(scrappedNumber);
        ((SaleMouldScrappedMapper)this.baseMapper).insert((Object)scrapped);
        SaleMouldData mouldData = new SaleMouldData();
        mouldData.setId(scrapped.getMouldDataId());
        mouldData.setTargetStatus(TargetStatusEnum.SCRAPPED.getValue());
        this.saleMouldDataService.updateById((Object)mouldData);
    }

    @Override
    public void edit(SaleMouldScrapped scrapped) {
        scrapped.setScrappedStatus(ScrappedStatusEnum.NEW.getValue());
        ((SaleMouldScrappedMapper)this.baseMapper).updateById((Object)scrapped);
    }

    @Override
    @SrmTransaction
    public void send(SaleMouldScrapped scrapped) {
        Date now = new Date();
        scrapped.setRelationId(IdWorker.getIdStr());
        scrapped.setSendTime(now);
        scrapped.setApplyScrappedTime(now);
        scrapped.setScrappedStatus(ScrappedStatusEnum.SEND.getValue());
        ((SaleMouldScrappedMapper)this.baseMapper).updateById((Object)scrapped);
        PurchaseMouldScrapped purchaseScrapped = new PurchaseMouldScrapped();
        BeanUtils.copyProperties((Object)((Object)scrapped), (Object)((Object)purchaseScrapped));
        purchaseScrapped.setId(scrapped.getRelationId());
        purchaseScrapped.setRelationId(scrapped.getId());
        purchaseScrapped.setElsAccount(scrapped.getToElsAccount());
        purchaseScrapped.setToElsAccount(scrapped.getElsAccount());
        this.purchaseMouldScrappedMapper.insert((Object)purchaseScrapped);
        this.purchaseMouldDataService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(PurchaseMouldData::getRelationId, (Object)scrapped.getMouldDataId())).set(PurchaseMouldData::getTargetStatus, (Object)TargetStatusEnum.SCRAPPED.getValue()));
    }

    @Override
    @SrmTransaction
    public void delete(String id) {
        SaleMouldScrapped dbScrapped = (SaleMouldScrapped)((Object)((SaleMouldScrappedMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        Assert.isTrue((boolean)ScrappedStatusEnum.NEW.getValue().equals(dbScrapped.getScrappedStatus()), (String)I18nUtil.translate((String)"i18n_title_onlyDocumentsNewStatusDeleted", (String)"\u53ea\u6709\u65b0\u5efa\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u5220\u9664"));
        ((SaleMouldScrappedMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.saleMouldDataService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(BaseEntity::getId, (Object)dbScrapped.getMouldDataId())).set(SaleMouldData::getTargetStatus, null));
    }
}

