/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.spcn.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.ecn.rpc.service.EcnInvokeBaseRpcService;
import com.els.modules.spcn.entity.SaleSpcn;
import com.els.modules.spcn.service.SaleSpcnService;
import com.els.modules.spcn.vo.SaleSpcnVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"SPCN"})
@RestController
@RequestMapping(value={"/spcn/saleSpcn"})
public class SaleSpcnController
extends BaseController<SaleSpcn, SaleSpcnService> {
    @Autowired
    private SaleSpcnService saleSpcnService;
    @Autowired
    private EcnInvokeBaseRpcService ecnInvokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"spcn#saleSpcn:list"})
    public Result<?> queryPageList(SaleSpcn saleSpcn, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleSpcn), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleSpcnService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="SPCN-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"spcn#saleSpcn:add"})
    public Result<?> add(@RequestBody SaleSpcn saleSpcn) {
        this.saleSpcnService.saveSaleSpcn(saleSpcn);
        return Result.ok((Object)((Object)saleSpcn));
    }

    @SrmValidated
    @AutoLog(value="SPCN-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"spcn#saleSpcn:edit"})
    public Result<?> edit(@RequestBody SaleSpcn saleSpcn) {
        this.saleSpcnService.updateSaleSpcn(saleSpcn);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="SPCN-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"spcn#saleSpcn:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.saleSpcnService.delSaleSpcn(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="SPCN-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"spcn#saleSpcn:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.saleSpcnService.delBatchSaleSpcn(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"spcn#saleSpcn:query"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleSpcn saleSpcn = (SaleSpcn)((Object)this.saleSpcnService.getById((Serializable)((Object)id)));
        SaleSpcnVO spcnVO = new SaleSpcnVO();
        BeanUtils.copyProperties((Object)((Object)saleSpcn), (Object)((Object)spcnVO));
        List<SaleAttachmentDTO> attachments = this.ecnInvokeBaseRpcService.saleSelectByMainId(id);
        spcnVO.setAttachments(attachments);
        return Result.ok((Object)((Object)spcnVO));
    }

    @SrmValidated
    @AutoLog(value="SPCN-\u53d1\u9001")
    @ApiOperation(value="\u53d1\u9001", notes="\u53d1\u9001")
    @PostMapping(value={"/send"})
    @RequiresPermissions(value={"spcn#saleSpcn:send"})
    public Result<?> send(@RequestBody SaleSpcnVO spcnVO) {
        SaleSpcn spcn = new SaleSpcn();
        BeanUtils.copyProperties((Object)((Object)spcnVO), (Object)((Object)spcn));
        this.saleSpcnService.send(spcn, spcnVO.getAttachments());
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="SPCN-\u64a4\u56de")
    @ApiOperation(value="\u64a4\u56de", notes="\u64a4\u56de")
    @GetMapping(value={"/backout"})
    @RequiresPermissions(value={"spcn#saleSpcn:backout"})
    public Result<?> backout(@RequestParam(name="id") String id) {
        return this.saleSpcnService.backout(id);
    }

    @SrmValidated
    @AutoLog(value="SPCN-\u4f5c\u5e9f")
    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @GetMapping(value={"/cancellation"})
    @RequiresPermissions(value={"spcn#saleSpcn:cancellation"})
    public Result<?> cancellation(@RequestParam(name="id") String id) {
        return this.saleSpcnService.cancellation(id);
    }
}

