/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.modules.sample.api.dto.PurchaseSampleHeadDTO;
import com.els.modules.sample.api.dto.PurchaseSampleItemDTO;
import com.els.modules.sample.api.service.PurchaseSampleItemSelfService;
import com.els.modules.sample.entity.PurchaseSampleHead;
import com.els.modules.sample.entity.PurchaseSampleItem;
import com.els.modules.sample.enumerate.PurchaseSampleStatusItemEnum;
import com.els.modules.sample.mapper.PurchaseSampleHeadMapper;
import com.els.modules.sample.mapper.PurchaseSampleItemMapper;
import com.els.modules.sample.service.PurchaseSampleItemService;
import com.els.modules.sample.vo.PurchaseSampleInfoVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PurchaseSampleItemServiceImpl
extends BaseServiceImpl<PurchaseSampleItemMapper, PurchaseSampleItem>
implements PurchaseSampleItemService {
    @Resource
    private PurchaseSampleItemMapper purchaseSampleItemMapper;
    @Resource
    private PurchaseSampleHeadMapper purchaseSampleHeadMapper;
    @Resource
    private PurchaseSampleItemSelfService purchaseSampleItemSelfService;

    @Override
    public List<PurchaseSampleItem> selectByMainId(String mainId) {
        return this.purchaseSampleItemMapper.selectByMainId(mainId);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public String transformRequest(List<PurchaseSampleItemDTO> itemList) {
        Assert.isNotEmpty(itemList, (String)I18nUtil.translate((String)"i18n_alert_empty_notSelectItem", (String)"\u9009\u62e9\u7684\u884c\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseSampleHead purchaseSampleHead = (PurchaseSampleHead)((Object)this.purchaseSampleHeadMapper.selectById((Serializable)((Object)itemList.get(0).getHeadId())));
        PurchaseSampleHeadDTO purchaseSampleHeadDTO = new PurchaseSampleHeadDTO();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleHead), (Object)purchaseSampleHeadDTO);
        Boolean isSuccess = this.purchaseSampleItemSelfService.transformRequest(purchaseSampleHeadDTO, itemList);
        if (isSuccess.booleanValue()) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(PurchaseSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.DEMAND_TRANSFERRED.getValue())).in(BaseEntity::getId, (Collection)itemList.parallelStream().map(BaseDTO::getId).collect(Collectors.toList()))).update((Object)new PurchaseSampleItem());
        } else {
            Assert.isNotEmpty(itemList, (String)I18nUtil.translate((String)"i18n_alert_sTVuIH_40021368", (String)"\u8f6c\u9700\u6c42\u6c60\u5f02\u5e38"));
        }
        return itemList.get(0).getSampleNumber();
    }

    @Override
    public IPage<PurchaseSampleInfoVO> financeQuerySample(Page<PurchaseSampleInfoVO> page, PurchaseSampleInfoVO purchaseSampleInfoVO) {
        return this.purchaseSampleItemMapper.financeQuerySample(page, purchaseSampleInfoVO);
    }
}

