/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.BaseDTO;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderPermissionConfigDTO;
import com.els.modules.sample.api.dto.PurchaseSampleHeadDTO;
import com.els.modules.sample.api.dto.PurchaseSampleItemDTO;
import com.els.modules.sample.api.dto.PurchaseSampleTransformRequestDTO;
import com.els.modules.sample.api.service.PurchaseSampleItemSelfService;
import com.els.modules.sample.entity.PurchaseSampleHead;
import com.els.modules.sample.entity.PurchaseSampleItem;
import com.els.modules.sample.enumerate.PurchaseSampleStatusItemEnum;
import com.els.modules.sample.mapper.PurchaseSampleHeadMapper;
import com.els.modules.sample.mapper.PurchaseSampleItemMapper;
import com.els.modules.sample.rpc.service.SampleInvokeMainDataRpcService;
import com.els.modules.sample.rpc.service.SampleInvokeOrderRpcService;
import com.els.modules.sample.service.PurchaseSampleItemService;
import com.els.modules.sample.vo.PurchaseSampleInfoVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class PurchaseSampleItemServiceImpl
extends BaseServiceImpl<PurchaseSampleItemMapper, PurchaseSampleItem>
implements PurchaseSampleItemService {
    @Resource
    private PurchaseSampleItemMapper purchaseSampleItemMapper;
    @Resource
    private PurchaseSampleHeadMapper purchaseSampleHeadMapper;
    @Resource
    private PurchaseSampleItemSelfService purchaseSampleItemSelfService;
    @Resource
    private SampleInvokeMainDataRpcService mainDataRpcService;
    private static final int CHECK_FAIL_CODE = 555;

    @Override
    public List<PurchaseSampleItem> selectByMainId(String mainId) {
        return this.purchaseSampleItemMapper.selectByMainId(mainId);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> transformRequest(PurchaseSampleTransformRequestDTO transformRequestDTO) {
        List itemList = transformRequestDTO.getList();
        Assert.isNotEmpty((Collection)itemList, (String)I18nUtil.translate((String)"i18n_alert_empty_notSelectItem", (String)"\u9009\u62e9\u7684\u884c\u4e0d\u80fd\u4e3a\u7a7a"));
        if ("0".equals(transformRequestDTO.getIsOld()) && !this.setParamAndCheck(itemList).booleanValue()) {
            Result result = new Result();
            result.setCode(Integer.valueOf(555));
            result.setSuccess(false);
            result.setMessage(I18nUtil.translate((String)"i18n_alert_sTVujVNcVHnRVRlS_89f8bb94", (String)"\u8f6c\u9700\u6c42\u6c60\u7684\u6837\u54c1\u884c\u4fe1\u606f\u91c7\u8d2d\u7ec4\u7ec7\u5fc5\u586b\uff01"));
            return result;
        }
        PurchaseSampleHead purchaseSampleHead = (PurchaseSampleHead)((Object)this.purchaseSampleHeadMapper.selectById((Serializable)((Object)((PurchaseSampleItemDTO)itemList.get(0)).getHeadId())));
        PurchaseSampleHeadDTO purchaseSampleHeadDTO = new PurchaseSampleHeadDTO();
        BeanUtils.copyProperties((Object)((Object)purchaseSampleHead), (Object)purchaseSampleHeadDTO);
        Boolean isSuccess = this.purchaseSampleItemSelfService.transformRequest(purchaseSampleHeadDTO, itemList);
        if (isSuccess.booleanValue()) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(PurchaseSampleItem::getItemStatus, (Object)PurchaseSampleStatusItemEnum.DEMAND_TRANSFERRED.getValue())).in(BaseEntity::getId, (Collection)itemList.parallelStream().map(BaseDTO::getId).collect(Collectors.toList()))).update((Object)new PurchaseSampleItem());
        } else {
            Assert.isNotEmpty((Collection)itemList, (String)I18nUtil.translate((String)"i18n_alert_sTVuIH_40021368", (String)"\u8f6c\u9700\u6c42\u6c60\u5f02\u5e38"));
        }
        return Result.ok((String)("\u8f6c\u9700\u6c42\u6c60\u6210\u529f,\u5355\u53f7\u4e3a:" + ((PurchaseSampleItemDTO)itemList.get(0)).getSampleNumber()));
    }

    private Boolean setParamAndCheck(List<PurchaseSampleItemDTO> itemList) {
        Boolean isSuccess = true;
        Map<String, PurchaseOrderPermissionConfigDTO> orderPermissionConfigMap = this.getOrderPermissionConfigMap(itemList);
        for (PurchaseSampleItemDTO item : itemList) {
            if (StringUtils.isBlank((CharSequence)item.getPurchaseOrg()) && Objects.nonNull(orderPermissionConfigMap.get(item.getCateCode() + "_" + item.getFactory()))) {
                item.setPurchaseOrg(orderPermissionConfigMap.get(item.getCateCode() + "_" + item.getFactory()).getPurchaseOrg());
            }
            PurchaseMaterialHeadDTO materialHeadDTO = this.mainDataRpcService.getMaterialHeadByNumber(item.getMaterialNumber());
            if (StringUtils.isBlank((CharSequence)item.getPurchaseGroup())) {
                item.setPurchaseGroup(materialHeadDTO.getPurchaseGroup());
            }
            if (StringUtils.isBlank((CharSequence)item.getPurchaseOrg())) {
                item.setPurchaseOrg(materialHeadDTO.getPurchaseOrg());
            }
            if (!StringUtils.isBlank((CharSequence)item.getPurchaseOrg())) continue;
            isSuccess = false;
            break;
        }
        return isSuccess;
    }

    private Map<String, PurchaseOrderPermissionConfigDTO> getOrderPermissionConfigMap(List<PurchaseSampleItemDTO> itemList) {
        ArrayList<String> cateCodeAndFactoryKeys = new ArrayList<String>();
        for (PurchaseSampleItemDTO item : itemList) {
            if (cateCodeAndFactoryKeys.contains(item.getCateCode() + "_" + item.getFactory())) continue;
            cateCodeAndFactoryKeys.add(item.getCateCode() + "_" + item.getFactory());
            cateCodeAndFactoryKeys.add("_" + item.getFactory());
        }
        SampleInvokeOrderRpcService orderRpcService = (SampleInvokeOrderRpcService)SpringContextUtils.getBean(SampleInvokeOrderRpcService.class);
        List<PurchaseOrderPermissionConfigDTO> purchaseOrderPermissionConfigDTOList = orderRpcService.getOrderPermissionConfigList(cateCodeAndFactoryKeys);
        HashMap<String, PurchaseOrderPermissionConfigDTO> orderPermissionConfigByCodeCategoryMap = new HashMap<String, PurchaseOrderPermissionConfigDTO>();
        for (PurchaseOrderPermissionConfigDTO purchaseOrderPermissionConfigDTO : purchaseOrderPermissionConfigDTOList) {
            orderPermissionConfigByCodeCategoryMap.put(purchaseOrderPermissionConfigDTO.getCateCode() + "_" + purchaseOrderPermissionConfigDTO.getPurchaseFactory(), purchaseOrderPermissionConfigDTO);
        }
        return orderPermissionConfigByCodeCategoryMap;
    }

    @Override
    public IPage<PurchaseSampleInfoVO> financeQuerySample(Page<PurchaseSampleInfoVO> page, PurchaseSampleInfoVO purchaseSampleInfoVO) {
        return this.purchaseSampleItemMapper.financeQuerySample(page, purchaseSampleInfoVO);
    }
}

