/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quality.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.quality.entity.PurchaseRetificationReviewTeam;
import com.els.modules.quality.entity.PurchaseSupplierRectificationReportHead;
import com.els.modules.quality.entity.PurchaseSupplierRectificationReportItem;
import com.els.modules.quality.excel.SupplierRectificationReportHeadExportServiceImpl;
import com.els.modules.quality.service.PurchaseRetificationReviewTeamService;
import com.els.modules.quality.service.PurchaseSupplierRectificationReportHeadService;
import com.els.modules.quality.service.PurchaseSupplierRectificationReportItemService;
import com.els.modules.quality.vo.PurchaseSupplierRectificationReportHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/quality/purchaseSupplierRectificationReportHead"})
@Api(tags={"\u4f9b\u5e94\u5546\u6574\u6539\u5934"})
@BusinessModule(module="supplierRetification")
public class PurchaseSupplierRectificationReportHeadController
extends BaseController<PurchaseSupplierRectificationReportHead, PurchaseSupplierRectificationReportHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseSupplierRectificationReportHeadController.class);
    @Autowired
    private PurchaseSupplierRectificationReportHeadService purchaseSupplierRectificationReportHeadService;
    @Autowired
    private PurchaseSupplierRectificationReportItemService purchaseSupplierRectificationReportItemService;
    @Autowired
    private PurchaseRetificationReviewTeamService purchaseRetificationReviewTeamService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @AutoLog(value="\u91c7\u8d2d\u4f9b\u5e94\u5546\u6574\u6539-\u5206\u9875\u5217\u8868\u67e5\u8be2", logType=1)
    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="supplierRetification")
    @RequiresPermissions(value={"supplierRetification#purchaseSupplierRectification:list"})
    public Result<?> queryPageList(PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseSupplierRectificationReportHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseSupplierRectificationReportHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u4f9b\u5e94\u5546\u6574\u6539-\u6dfb\u52a0", logType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"supplierRetification#purchaseSupplierRectification:add"})
    public Result<?> add(@RequestBody PurchaseSupplierRectificationReportHeadVO purchaseSupplierRectificationReportHeadPage) {
        PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead = new PurchaseSupplierRectificationReportHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSupplierRectificationReportHeadPage), (Object)((Object)purchaseSupplierRectificationReportHead));
        this.purchaseSupplierRectificationReportHeadService.saveMain(purchaseSupplierRectificationReportHead, purchaseSupplierRectificationReportHeadPage.getPurchaseSupplierRectificationReportItemList(), purchaseSupplierRectificationReportHeadPage.getPurchaseRetificationReviewTeamList(), purchaseSupplierRectificationReportHeadPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseSupplierRectificationReportHead));
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u4f9b\u5e94\u5546\u6574\u6539-\u7f16\u8f91", logType=2)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"supplierRetification#purchaseSupplierRectification:edit"})
    public Result<?> edit(@RequestBody PurchaseSupplierRectificationReportHeadVO purchaseSupplierRectificationReportHeadPage) {
        PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead = new PurchaseSupplierRectificationReportHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSupplierRectificationReportHeadPage), (Object)((Object)purchaseSupplierRectificationReportHead));
        this.purchaseSupplierRectificationReportHeadService.updateMain(purchaseSupplierRectificationReportHead, purchaseSupplierRectificationReportHeadPage.getPurchaseSupplierRectificationReportItemList(), purchaseSupplierRectificationReportHeadPage.getPurchaseRetificationReviewTeamList(), purchaseSupplierRectificationReportHeadPage.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u4f9b\u5e94\u5546\u6574\u6539-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"supplierRetification#purchaseSupplierRectification:delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchaseSupplierRectificationReportHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u4f9b\u5e94\u5546\u6574\u6539-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"supplierRetification#purchaseSupplierRectification:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchaseSupplierRectificationReportHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u4f9b\u5e94\u5546\u6574\u6539-\u53d1\u5e03")
    @SrmValidated
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"supplierRetification#purchaseSupplierRectification:publish"})
    public Result<?> publish(@RequestBody PurchaseSupplierRectificationReportHeadVO purchaseSupplierRectificationReportHeadVO) {
        Assert.hasText((String)purchaseSupplierRectificationReportHeadVO.getTemplateNumber(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempNum", (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)purchaseSupplierRectificationReportHeadVO.getTemplateVersion(), (String)I18nUtil.translate((String)"i18n_alert_empty_notTempVersion", (String)"\u6a21\u677f\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
        PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead = new PurchaseSupplierRectificationReportHead();
        BeanUtils.copyProperties((Object)((Object)purchaseSupplierRectificationReportHeadVO), (Object)((Object)purchaseSupplierRectificationReportHead));
        this.purchaseSupplierRectificationReportHeadService.publish(purchaseSupplierRectificationReportHead, purchaseSupplierRectificationReportHeadVO.getPurchaseSupplierRectificationReportItemList(), purchaseSupplierRectificationReportHeadVO.getPurchaseRetificationReviewTeamList(), purchaseSupplierRectificationReportHeadVO.getPurchaseAttachmentList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u4f9b\u5e94\u5546\u6574\u6539-\u63a5\u53d7\u8bc4\u5ba1\u5c0f\u7ec4")
    @SrmValidated
    @ApiOperation(value="\u63a5\u53d7\u8bc4\u5ba1\u5c0f\u7ec4", notes="\u63a5\u53d7\u8bc4\u5ba1\u5c0f\u7ec4")
    @PostMapping(value={"/acceptRectification"})
    @RequiresPermissions(value={"supplierRetification#purchaseSupplierRectification:accept"})
    public Result<?> acceptRectification(@RequestBody PurchaseRetificationReviewTeam purchaseRetificationReviewTeam) {
        this.purchaseSupplierRectificationReportHeadService.acceptRectification(purchaseRetificationReviewTeam);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u4f9b\u5e94\u5546\u6574\u6539-\u62d2\u7edd\u8bc4\u5ba1\u5c0f\u7ec4")
    @SrmValidated
    @ApiOperation(value="\u62d2\u7edd\u8bc4\u5ba1\u5c0f\u7ec4", notes="\u62d2\u7edd\u8bc4\u5ba1\u5c0f\u7ec4")
    @PostMapping(value={"/rejectRectification"})
    @RequiresPermissions(value={"supplierRetification#purchaseSupplierRectification:reject"})
    public Result<?> rejectRectification(@RequestBody PurchaseRetificationReviewTeam purchaseRetificationReviewTeam) {
        this.purchaseSupplierRectificationReportHeadService.rejectRectification(purchaseRetificationReviewTeam);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u4f9b\u5e94\u5546\u6574\u6539-\u91cd\u65b0\u6574\u6539")
    @SrmValidated
    @ApiOperation(value="\u91cd\u65b0\u6574\u6539", notes="\u91cd\u65b0\u6574\u6539")
    @PostMapping(value={"/againRectification"})
    @RequiresPermissions(value={"supplierRetification#purchaseSupplierRectification:againRectification"})
    public Result<?> againRectification(@RequestBody PurchaseSupplierRectificationReportHead supplierRectificationReportHead) {
        this.purchaseSupplierRectificationReportHeadService.againRectification(supplierRectificationReportHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u4f9b\u5e94\u5546\u6574\u6539-\u6574\u6539\u5b8c\u6210")
    @SrmValidated
    @ApiOperation(value="\u6574\u6539\u5b8c\u6210", notes="\u6574\u6539\u5b8c\u6210")
    @PostMapping(value={"/finishRectification"})
    @RequiresPermissions(value={"supplierRetification#purchaseSupplierRectification:finishRectification"})
    public Result<?> finishRectification(@RequestBody PurchaseSupplierRectificationReportHead supplierRectificationReportHead) {
        this.purchaseSupplierRectificationReportHeadService.finishRectification(supplierRectificationReportHead);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u4f9b\u5e94\u5546\u6574\u6539-\u901a\u8fc7id\u4f5c\u5e9f")
    @ApiOperation(value="\u901a\u8fc7id\u4f5c\u5e9f", notes="\u901a\u8fc7id\u4f5c\u5e9f")
    @GetMapping(value={"/cancel"})
    @RequiresPermissions(value={"supplierRetification#purchaseSupplierRectification:cancel"})
    public Result<?> cancel(@RequestParam(name="id", required=true) String id) {
        this.purchaseSupplierRectificationReportHeadService.cancel(id);
        return Result.ok();
    }

    @AutoLog(value="\u4f9b\u5e94\u5546\u6574\u6539\u5934-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"supplierRetification#purchaseSupplierRectification:query"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead = (PurchaseSupplierRectificationReportHead)((Object)this.purchaseSupplierRectificationReportHeadService.getById((Serializable)((Object)id)));
        PurchaseSupplierRectificationReportHeadVO purchaseSupplierRectificationReportHeadVO = new PurchaseSupplierRectificationReportHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseSupplierRectificationReportHead), (Object)((Object)purchaseSupplierRectificationReportHeadVO));
        List<PurchaseSupplierRectificationReportItem> purchaseSupplierRectificationReportItemList = this.purchaseSupplierRectificationReportItemService.selectByMainId(id);
        purchaseSupplierRectificationReportHeadVO.setPurchaseSupplierRectificationReportItemList(purchaseSupplierRectificationReportItemList);
        List<PurchaseRetificationReviewTeam> purchaseRetificationReviewTeamList = this.purchaseRetificationReviewTeamService.selectByMainId(id);
        purchaseSupplierRectificationReportHeadVO.setPurchaseRetificationReviewTeamList(purchaseRetificationReviewTeamList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseSupplierRectificationReportHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return Result.ok((Object)((Object)purchaseSupplierRectificationReportHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u6574\u6539\u5934id\u67e5\u8be2\u4f9b\u5e94\u5546\u6574\u6539\u884c", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u6574\u6539\u5934id\u67e5\u8be2\u4f9b\u5e94\u5546\u6574\u6539\u884c")
    @GetMapping(value={"/queryPurchaseSupplierRectificationReportItemByMainId"})
    @RequiresPermissions(value={"supplierRetification#purchaseSupplierRectification:list"})
    public Result<?> queryPurchaseSupplierRectificationReportItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseSupplierRectificationReportItem> purchaseSupplierRectificationReportItemList = this.purchaseSupplierRectificationReportItemService.selectByMainId(id);
        return Result.ok(purchaseSupplierRectificationReportItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u6574\u6539\u5934id\u67e5\u8be2\u4f9b\u5e94\u5546\u6574\u8bc4\u5ba1\u5c0f\u7ec4", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u6574\u6539\u5934id\u67e5\u8be2\u4f9b\u5e94\u5546\u6574\u8bc4\u5ba1\u5c0f\u7ec4")
    @GetMapping(value={"/queryPurchaseRetificationReviewTeamByMainId"})
    @RequiresPermissions(value={"supplierRetification#purchaseSupplierRectification:list"})
    public Result<?> queryPurchaseRetificationReviewTeamListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseRetificationReviewTeam> purchaseRetificationReviewTeamList = this.purchaseRetificationReviewTeamService.selectByMainId(id);
        return Result.ok(purchaseRetificationReviewTeamList);
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u6574\u6539\u5934id\u67e5\u8be2\u91c7\u8d2d\u9644\u4ef6", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u6574\u6539\u5934id\u67e5\u8be2\u91c7\u8d2d\u9644\u4ef6")
    @GetMapping(value={"/queryPurchaseAttachmentByMainId"})
    @RequiresPermissions(value={"supplierRetification#purchaseSupplierRectification:list"})
    public Result<?> queryPurchaseAttachmentListByMainId(@RequestParam(name="id", required=true) String id) {
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        return Result.ok((Object)purchaseAttachmentList);
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"supplierRetification#purchaseSupplierRectification:export"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, SupplierRectificationReportHeadExportServiceImpl.class);
    }

    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"supplierRetification#purchaseSupplierRectification:list"})
    public Result<?> queryTabsCount(PurchaseSupplierRectificationReportHead purchaseSupplierRectificationReportHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseSupplierRectificationReportHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"rectification_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"rectification_status");
        List list = ((PurchaseSupplierRectificationReportHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseSupplierRectificationReportHead::getRectificationStatus, PurchaseSupplierRectificationReportHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "rectificationStatus", null, all));
        List srmStatusDictList = this.invokeBaseRpcService.queryDictItemsByCode("srmRectificationStatus", TenantContext.getTenant());
        for (DictDTO status : srmStatusDictList) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "rectificationStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @SrmValidated
    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @PostMapping(value={"/copy/{id}"})
    @RequiresPermissions(value={"contractAcceptance#PurchaseContractAcceptance:copy"})
    public Result<?> copy(@PathVariable String id) {
        this.purchaseSupplierRectificationReportHeadService.copy(id);
        return Result.ok();
    }
}

