/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.eightReportPoc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.eightReportPoc.entity.PurchaseEightDisciplinesZero;
import com.els.modules.eightReportPoc.entity.SaleEightDisciplinesZero;
import com.els.modules.eightReportPoc.enumerate.EightReportStatusEnum;
import com.els.modules.eightReportPoc.mapper.PurchaseEightDisciplinesZeroPocMapper;
import com.els.modules.eightReportPoc.mapper.SaleEightDisciplinesZeroPocMapper;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EightDisciplineAuditOptCallBackPocServiceImpl
implements AuditOptCallBackService {
    @Autowired
    private PurchaseEightDisciplinesZeroPocMapper purchaseEightDisciplinesZeroPocMapper;
    @Autowired
    private SaleEightDisciplinesZeroPocMapper saleEightDisciplinesZeroPocMapper;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseEightDisciplinesZero dbPurchaseEightDisciplinesZero = (PurchaseEightDisciplinesZero)((Object)this.purchaseEightDisciplinesZeroPocMapper.selectById((Serializable)((Object)inputParamVO.getBusinessId())));
        PurchaseEightDisciplinesZero head = new PurchaseEightDisciplinesZero();
        head.setId(inputParamVO.getBusinessId());
        head.setAuditStatus(outputParamVO.getAuditStatus());
        head.setFlowId(outputParamVO.getProcessRootId());
        SaleEightDisciplinesZero saleEightDisciplinesZero = new SaleEightDisciplinesZero();
        saleEightDisciplinesZero.setId(dbPurchaseEightDisciplinesZero.getRelationId());
        saleEightDisciplinesZero.setAuditStatus(outputParamVO.getAuditStatus());
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            head.setEightDisciplinesStatus(EightReportStatusEnum.D9.getValue());
            saleEightDisciplinesZero.setEightDisciplinesStatus(EightReportStatusEnum.D9.getValue());
        }
        this.purchaseEightDisciplinesZeroPocMapper.updateById((Object)head);
        this.saleEightDisciplinesZeroPocMapper.updateById((Object)saleEightDisciplinesZero);
    }

    public void startCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateStatus(inputParamDTO, outputParamDTO);
        for (String account : outputParamDTO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, account);
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamDTO.getBpmnType())) {
                operataion = outputParamDTO.getBpmnType() + "_" + "submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamDTO.getAuditStatus())) {
            this.updateStatus(inputParamDTO, outputParamDTO);
        } else {
            for (String account : outputParamDTO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, account);
                String operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamDTO.getBpmnType())) {
                    operataion = outputParamDTO.getBpmnType() + "_" + "submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateStatus(inputParamDTO, outputParamDTO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamDTO, outputParamDTO, outputParamDTO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamDTO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamDTO, AuditOutputParamDTO outputParamDTO) {
        this.updateStatus(inputParamDTO, outputParamDTO);
    }

    public JSONObject getDataById(String id) {
        PurchaseEightDisciplinesZero head = (PurchaseEightDisciplinesZero)((Object)this.purchaseEightDisciplinesZeroPocMapper.selectById((Serializable)((Object)id)));
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
            JSONObject jsonObject = (JSONObject)result.getResult();
            return jsonObject;
        }
        return null;
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

