/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.calendar.controller;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.DateUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.calendar.entity.ElsCalendarConfig;
import com.els.modules.calendar.entity.ElsCalendarHead;
import com.els.modules.calendar.entity.ElsCalendarItem;
import com.els.modules.calendar.service.ElsCalendarConfigService;
import com.els.modules.calendar.service.ElsCalendarHeadService;
import com.els.modules.calendar.service.ElsCalendarItemService;
import com.els.modules.calendar.vo.CalendarSaveVO;
import com.els.modules.calendar.vo.ElsCalendarHeadVO;
import com.els.modules.calendar.vo.ElsSettingCalendarVO;
import com.els.modules.calendar.vo.SingleSettingConfigVO;
import com.els.modules.eightReport.rpc.service.InvokeMainDataRpcService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/calendar/purchaseFactoryCalendar"})
@Api(tags={"\u5de5\u5382\u65e5\u5386"})
public class ElsCalendarController
extends BaseController<ElsCalendarHead, ElsCalendarHeadService> {
    private static final Logger log = LoggerFactory.getLogger(ElsCalendarController.class);
    @Autowired
    private ElsCalendarHeadService purchaseFactoryCalendarHeadService;
    @Autowired
    private ElsCalendarItemService purchaseFactoryCalendarItemService;
    @Autowired
    private InvokeMainDataRpcService invokeMainDataRpcService;
    @Autowired
    private ElsCalendarConfigService calendarConfigService;

    @AutoLog(value="\u5de5\u5382\u65e5\u5386-\u5206\u9875\u5217\u8868\u67e5\u8be2", logType=2)
    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"factoryCalendar#purchasefactoryCalendar:list"})
    public Result<?> queryPageList(ElsCalendarItem purchaseFactoryCalendarItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) throws ParseException {
        if (StringUtils.isBlank((CharSequence)purchaseFactoryCalendarItem.getElsAccount()) || StringUtils.isBlank((CharSequence)purchaseFactoryCalendarItem.getCreateBy())) {
            return Result.ok((Object)new Page());
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseFactoryCalendarItem), (Map)req.getParameterMap());
        LocalDateTime now = LocalDateTimeUtil.now();
        LocalDate localDate = now.toLocalDate().plusDays(1L);
        queryWrapper.ge((Object)"day_off", (Object)LocalDateTimeUtil.format((LocalDate)localDate, (DateTimeFormatter)DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        queryWrapper.eq((Object)"day_type", (Object)"visit");
        queryWrapper.orderByAsc((Object)"day_off");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        Page pageList = this.purchaseFactoryCalendarItemService.selectWithoutElsAccountPageList((IPage)page, (Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)pageList.getRecords())) {
            List<String> holidays = this.purchaseFactoryCalendarItemService.selectWithoutElsAccountHolidayList(purchaseFactoryCalendarItem.getElsAccount(), purchaseFactoryCalendarItem.getCreateBy(), LocalDateTimeUtil.format((LocalDate)localDate, (DateTimeFormatter)DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            ArrayList<ElsCalendarItem> newList = new ArrayList<ElsCalendarItem>();
            LocalDate afterThreeMonth = localDate.plusMonths(3L).plusDays(1L);
            LocalDate localDate1 = localDate;
            while (localDate1.isBefore(afterThreeMonth)) {
                ElsCalendarItem item = new ElsCalendarItem();
                String dateStr = LocalDateTimeUtil.format((LocalDate)localDate1, (DateTimeFormatter)DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                if (!holidays.contains(dateStr)) {
                    Date dayOff = DateUtils.parseDate((String)dateStr, (String)"yyyy-MM-dd");
                    item.setDayOff(dayOff);
                    newList.add(item);
                }
                localDate1 = localDate1.plusDays(1L);
            }
            pageList = new Page(1L, (long)newList.size(), 1L);
            pageList.setRecords(newList);
        }
        return Result.ok(pageList);
    }

    @AutoLog(value="\u5de5\u5382\u65e5\u5386-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"factoryCalendar#purchasefactoryCalendar:add"})
    public Result<?> add(@RequestBody ElsCalendarHeadVO purchaseFactoryCalendarHeadPage) {
        ElsCalendarHead purchaseFactoryCalendarHead = new ElsCalendarHead();
        BeanUtils.copyProperties((Object)((Object)purchaseFactoryCalendarHeadPage), (Object)((Object)purchaseFactoryCalendarHead));
        this.purchaseFactoryCalendarHeadService.saveMain(purchaseFactoryCalendarHead, purchaseFactoryCalendarHeadPage.getPurchaseFactoryCalendarItemList());
        return Result.ok((Object)((Object)purchaseFactoryCalendarHead));
    }

    @AutoLog(value="\u5de5\u5382\u65e5\u5386-\u83b7\u53d6\u5de5\u5382\u65e5\u5386")
    @ApiOperation(value="\u83b7\u53d6\u5de5\u5382\u65e5\u5386", notes="\u83b7\u53d6\u5de5\u5382\u65e5\u5386")
    @GetMapping(value={"/getCalendar"})
    @RequiresPermissions(value={"factoryCalendar#purchasefactoryCalendar:query"})
    public Result<?> getCalendar() {
        List<ElsCalendarHeadVO> list = this.purchaseFactoryCalendarHeadService.getCalendar();
        list.sort(Comparator.comparing(BaseEntity::getId).reversed());
        return Result.ok(list);
    }

    @AutoLog(value="\u5de5\u5382\u65e5\u5386-\u8bbe\u5b9a\u65e5\u5386")
    @ApiOperation(value="\u8bbe\u5b9a\u65e5\u5386", notes="\u8bbe\u5b9a\u65e5\u5386")
    @PostMapping(value={"/settingCalendar"})
    @SrmValidated
    @RequiresPermissions(value={"factoryCalendar#purchasefactoryCalendar:addCalendar"})
    public Result<?> settingCalendar(@RequestBody ElsSettingCalendarVO vo) {
        if (StringUtils.isBlank((CharSequence)vo.getCurrentDate())) {
            return Result.ok();
        }
        this.purchaseFactoryCalendarHeadService.settingCalendar(vo);
        return Result.ok();
    }

    @AutoLog(value="\u5de5\u5382\u65e5\u5386-\u6dfb\u52a0\u65e5\u5386")
    @ApiOperation(value="\u6dfb\u52a0\u65e5\u5386", notes="\u6dfb\u52a0\u65e5\u5386")
    @PostMapping(value={"/addCalendar"})
    @SrmValidated
    @RequiresPermissions(value={"factoryCalendar#purchasefactoryCalendar:addCalendar"})
    public Result<?> addCalendar(@RequestBody CalendarSaveVO calendarSaveVO) {
        this.purchaseFactoryCalendarHeadService.addCalendar(calendarSaveVO);
        return Result.ok();
    }

    @AutoLog(value="\u5de5\u5382\u65e5\u5386-\u83b7\u53d6\u7ec4\u7ec7\u67b6\u6784\u5de5\u5382", logType=2)
    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u67b6\u6784\u5de5\u5382", notes="\u83b7\u53d6\u7ec4\u7ec7\u67b6\u6784\u5de5\u5382")
    @GetMapping(value={"/getFactory"})
    @RequiresPermissions(value={"factoryCalendar#purchasefactoryCalendar:getFactory"})
    public Result<?> getFactory(@RequestParam(name="elsAccount") String elsAccount) {
        List<PurchaseOrganizationInfoDTO> factoryList = this.invokeMainDataRpcService.getOrgByOrgCode(elsAccount, "factory");
        return Result.ok(factoryList);
    }

    @AutoLog(value="\u5de5\u5382\u65e5\u5386-\u7f16\u8f91", logType=2)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"factoryCalendar#purchasefactoryCalendar:edit"})
    public Result<?> edit(@RequestBody ElsCalendarHeadVO purchaseFactoryCalendarHeadPage) {
        ElsCalendarHead purchaseFactoryCalendarHead = new ElsCalendarHead();
        BeanUtils.copyProperties((Object)((Object)purchaseFactoryCalendarHeadPage), (Object)((Object)purchaseFactoryCalendarHead));
        this.purchaseFactoryCalendarHeadService.updateMain(purchaseFactoryCalendarHead, purchaseFactoryCalendarHeadPage.getPurchaseFactoryCalendarItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5de5\u5382\u65e5\u5386-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"factoryCalendar#purchasefactoryCalendar:delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchaseFactoryCalendarHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u5de5\u5382\u65e5\u5386-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"factoryCalendar#purchasefactoryCalendar:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchaseFactoryCalendarHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u5de5\u5382\u65e5\u5386-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"factoryCalendar#purchasefactoryCalendar:query"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        ElsCalendarHead purchaseFactoryCalendarHead = (ElsCalendarHead)((Object)this.purchaseFactoryCalendarHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        ElsCalendarHeadVO purchaseFactoryCalendarHeadVO = new ElsCalendarHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseFactoryCalendarHead), (Object)((Object)purchaseFactoryCalendarHeadVO));
        List<ElsCalendarItem> purchaseFactoryCalendarItemList = this.purchaseFactoryCalendarItemService.selectByMainId(id);
        purchaseFactoryCalendarHeadVO.setPurchaseFactoryCalendarItemList(purchaseFactoryCalendarItemList);
        return Result.ok((Object)((Object)purchaseFactoryCalendarHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u5de5\u5382\u65e5\u5386\u5934\u8868id\u67e5\u8be2\u5de5\u5382\u65e5\u5386\u884c\u8868", notes="\u901a\u8fc7\u5de5\u5382\u65e5\u5386\u5934\u8868id\u67e5\u8be2\u5de5\u5382\u65e5\u5386\u884c\u8868")
    @GetMapping(value={"/queryPurchaseFactoryCalendarItemByMainId"})
    @RequiresPermissions(value={"factoryCalendar#purchasefactoryCalendar:query"})
    public Result<?> queryPurchaseFactoryCalendarItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<ElsCalendarItem> purchaseFactoryCalendarItemList = this.purchaseFactoryCalendarItemService.selectByMainId(id);
        return Result.ok(purchaseFactoryCalendarItemList);
    }

    @AutoLog(value="\u83b7\u53d6\u5355\u65e5\u914d\u7f6e\u4fe1\u606f")
    @ApiOperation(value="\u83b7\u53d6\u5355\u65e5\u914d\u7f6e\u4fe1\u606f", notes="\u83b7\u53d6\u5355\u65e5\u914d\u7f6e\u4fe1\u606f")
    @GetMapping(value={"/getSettingConfig"})
    public Result<?> getSettingConfig(String currentDate) {
        SingleSettingConfigVO configVO = this.purchaseFactoryCalendarHeadService.getSettingConfig(currentDate);
        return Result.ok((Object)configVO);
    }

    @AutoLog(value="\u83b7\u53d6\u6279\u91cf\u914d\u7f6e\u4fe1\u606f")
    @ApiOperation(value="\u83b7\u53d6\u6279\u91cf\u914d\u7f6e\u4fe1\u606f", notes="\u83b7\u53d6\u6279\u91cf\u914d\u7f6e\u4fe1\u606f")
    @GetMapping(value={"/getCalendarConfig"})
    public Result<?> getCalendarConfig(String configType) {
        ElsCalendarConfig config = this.calendarConfigService.getCalendarConfig(configType);
        return Result.ok((Object)((Object)config));
    }
}

