/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.calendar.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.calendar.entity.ElsCalendarHead;
import com.els.modules.calendar.entity.ElsCalendarItem;
import com.els.modules.calendar.mapper.ElsCalendarHeadMapper;
import com.els.modules.calendar.mapper.ElsCalendarItemMapper;
import com.els.modules.calendar.service.ElsCalendarConfigService;
import com.els.modules.calendar.service.ElsCalendarHeadService;
import com.els.modules.calendar.vo.CalendarSaveVO;
import com.els.modules.calendar.vo.ElsCalendarHeadVO;
import com.els.modules.calendar.vo.ElsSettingCalendarVO;
import com.els.modules.calendar.vo.SingleSettingConfigVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsCalendarHeadServiceImpl
extends ServiceImpl<ElsCalendarHeadMapper, ElsCalendarHead>
implements ElsCalendarHeadService {
    @Resource
    private ElsCalendarHeadMapper purchaseFactoryCalendarHeadMapper;
    @Resource
    private ElsCalendarItemMapper purchaseFactoryCalendarItemMapper;
    @Autowired
    private ElsCalendarConfigService calendarConfigService;

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(ElsCalendarHead purchaseFactoryCalendarHead, List<ElsCalendarItem> purchaseFactoryCalendarItemList) {
        this.purchaseFactoryCalendarHeadMapper.insert(purchaseFactoryCalendarHead);
        this.insertData(purchaseFactoryCalendarHead, purchaseFactoryCalendarItemList);
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(ElsCalendarHead purchaseFactoryCalendarHead, List<ElsCalendarItem> purchaseFactoryCalendarItemList) {
        this.purchaseFactoryCalendarHeadMapper.updateById(purchaseFactoryCalendarHead);
        this.purchaseFactoryCalendarItemMapper.deleteByMainId(purchaseFactoryCalendarHead.getId(), null);
        this.insertData(purchaseFactoryCalendarHead, purchaseFactoryCalendarItemList);
    }

    private void insertData(ElsCalendarHead purchaseFactoryCalendarHead, List<ElsCalendarItem> purchaseFactoryCalendarItemList) {
        if (CollectionUtils.isNotEmpty(purchaseFactoryCalendarItemList)) {
            for (ElsCalendarItem entity : purchaseFactoryCalendarItemList) {
                entity.setHeadId(purchaseFactoryCalendarHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseFactoryCalendarHead);
            }
            this.purchaseFactoryCalendarItemMapper.insertBatchSomeColumn(purchaseFactoryCalendarItemList);
        }
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchaseFactoryCalendarItemMapper.deleteByMainId(id, null);
        this.purchaseFactoryCalendarHeadMapper.deleteById((Serializable)((Object)id));
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchaseFactoryCalendarItemMapper.deleteByMainId(serializable.toString(), null);
            this.purchaseFactoryCalendarHeadMapper.deleteById(serializable);
        }
    }

    public List<ElsCalendarHeadVO> getCalendar() {
        LoginUser loginUser = SysUtil.getLoginUser();
        List<ElsCalendarHeadVO> list = this.purchaseFactoryCalendarHeadMapper.selectCalendarList(TenantContext.getTenant(), loginUser.getSubAccount());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (ElsCalendarHeadVO vo : list) {
            List itemList = vo.getPurchaseFactoryCalendarItemList();
            List holidayList = itemList.stream().filter(item -> "holiday".equals(item.getDayType())).map(item -> sdf.format(item.getDayOff())).collect(Collectors.toList());
            vo.setHolidayList(holidayList);
            List visitList = itemList.stream().filter(item -> "visit".equals(item.getDayType())).map(item -> sdf.format(item.getDayOff())).collect(Collectors.toList());
            vo.setVisitList(visitList);
        }
        return list;
    }

    public String loadHeadId(String elsAccount, String factory) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ElsCalendarHead::getFactory, (Object)factory)).eq(BaseEntity::getElsAccount, (Object)elsAccount)).last(" limit 1");
        ElsCalendarHead purchaseFactoryCalendarHead = (ElsCalendarHead)((ElsCalendarHeadMapper)this.baseMapper).selectOne((Wrapper)wrapper);
        if (null == purchaseFactoryCalendarHead) {
            return null;
        }
        return purchaseFactoryCalendarHead.getId();
    }

    public void settingCalendar(ElsSettingCalendarVO vo) {
        ElsCalendarItem item;
        LoginUser loginUser = SysUtil.getLoginUser();
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getCreateBy, (Object)loginUser.getSubAccount())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        ElsCalendarHead head = (ElsCalendarHead)((ElsCalendarHeadMapper)this.baseMapper).selectOne((Wrapper)wrapper);
        if (head == null) {
            head = new ElsCalendarHead();
            head.setId(IdWorker.getIdStr());
            ((ElsCalendarHeadMapper)this.baseMapper).insert(head);
        }
        if ((item = this.purchaseFactoryCalendarItemMapper.getByDayType(TenantContext.getTenant(), "holiday", loginUser.getSubAccount(), vo.getCurrentDate())) == null && "1".equals(vo.getHoliday())) {
            item = new ElsCalendarItem();
            item.setElsAccount(loginUser.getElsAccount());
            item.setHeadId(head.getId());
            item.setDayOff((Date)DateUtil.parse((CharSequence)vo.getCurrentDate(), (String)"yyyy-MM-dd"));
            item.setDayType("holiday");
            this.purchaseFactoryCalendarItemMapper.insert(item);
        }
        if (item != null && "0".equals(vo.getHoliday())) {
            this.purchaseFactoryCalendarItemMapper.deleteById((Serializable)((Object)item.getId()));
        }
        if ((item = this.purchaseFactoryCalendarItemMapper.getByDayType(TenantContext.getTenant(), "visit", loginUser.getSubAccount(), vo.getCurrentDate())) == null && "1".equals(vo.getVisit())) {
            item = new ElsCalendarItem();
            item.setElsAccount(loginUser.getElsAccount());
            item.setHeadId(head.getId());
            item.setDayOff((Date)DateUtil.parse((CharSequence)vo.getCurrentDate(), (String)"yyyy-MM-dd"));
            item.setDayType("visit");
            item.setTimes(vo.getTimes());
            this.purchaseFactoryCalendarItemMapper.insert(item);
        }
        if (item != null) {
            if ("0".equals(vo.getVisit())) {
                this.purchaseFactoryCalendarItemMapper.deleteById((Serializable)((Object)item.getId()));
            } else {
                item.setTimes(vo.getTimes());
                this.purchaseFactoryCalendarItemMapper.updateById(item);
            }
        }
    }

    public void addCalendar(CalendarSaveVO calendarSaveVO) {
        this.calendarConfigService.saveCalendarConfig(calendarSaveVO.getConfig());
        LoginUser loginUser = SysUtil.getLoginUser();
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(BaseEntity::getCreateBy, (Object)loginUser.getSubAccount())).eq(BaseEntity::getElsAccount, (Object)TenantContext.getTenant());
        ElsCalendarHead head = (ElsCalendarHead)((ElsCalendarHeadMapper)this.baseMapper).selectOne((Wrapper)wrapper);
        if (head == null) {
            head = new ElsCalendarHead();
            head.setId(IdWorker.getIdStr());
            ((ElsCalendarHeadMapper)this.baseMapper).insert(head);
        }
        this.purchaseFactoryCalendarItemMapper.deleteByMainId(head.getId(), calendarSaveVO.getConfig().getConfigType());
        if (!CollectionUtils.isEmpty((Collection)calendarSaveVO.getItems())) {
            for (ElsCalendarItem item : calendarSaveVO.getItems()) {
                item.setElsAccount(TenantContext.getTenant());
                item.setHeadId(head.getId());
                SysUtil.setSysParam((BaseEntity)item, (BaseEntity)head);
            }
            this.purchaseFactoryCalendarItemMapper.insertBatchSomeColumn(calendarSaveVO.getItems());
        }
    }

    @SrmTransaction
    public SingleSettingConfigVO getSettingConfig(String currentDate) {
        SingleSettingConfigVO configVO = new SingleSettingConfigVO();
        LoginUser loginUser = SysUtil.getLoginUser();
        ElsCalendarItem item = this.purchaseFactoryCalendarItemMapper.getByDayType(TenantContext.getTenant(), "holiday", loginUser.getSubAccount(), currentDate);
        configVO.setHoliday(item == null ? "0" : "1");
        item = this.purchaseFactoryCalendarItemMapper.getByDayType(TenantContext.getTenant(), "visit", loginUser.getSubAccount(), currentDate);
        configVO.setVisit(item == null ? "0" : "1");
        configVO.setTimes(item == null ? null : item.getTimes());
        return configVO;
    }
}

