/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.sample.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.sample.entity.SaleSampleCheckHead;
import com.els.modules.sample.service.SaleSampleCheckHeadService;
import com.els.modules.sample.service.SaleSampleCheckItemService;
import com.els.modules.sample.vo.PurchaseSampleCheckHeadRecordVO;
import com.els.modules.sample.vo.SaleSampleCheckHeadVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sample/saleSampleCheckHead"})
@Api(tags={"\u4f9b\u5e94\u5546\u6837\u54c1\u68c0\u6d4b\u5934"})
public class SaleSampleCheckHeadController
extends BaseController<SaleSampleCheckHead, SaleSampleCheckHeadService> {
    private static final Logger log = LoggerFactory.getLogger(SaleSampleCheckHeadController.class);
    @Autowired
    private SaleSampleCheckHeadService saleSampleCheckHeadService;
    @Autowired
    private SaleSampleCheckItemService saleSampleCheckItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"sample#saleSampleCheckHead:list"})
    public Result<?> queryPageList(SaleSampleCheckHead saleSampleCheckHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)saleSampleCheckHead, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleSampleCheckHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"sample#saleSampleCheckHead:query"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SaleSampleCheckHead saleSampleCheckHead = (SaleSampleCheckHead)this.saleSampleCheckHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant()));
        SaleSampleCheckHeadVO saleSampleCheckHeadVO = new SaleSampleCheckHeadVO();
        BeanUtils.copyProperties((Object)saleSampleCheckHead, (Object)((Object)saleSampleCheckHeadVO));
        List saleSampleCheckItemList = this.saleSampleCheckItemService.selectByMainId(id);
        saleSampleCheckHeadVO.setPurchaseSampleCheckItemList(saleSampleCheckItemList);
        List attachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        saleSampleCheckHeadVO.setSaleAttachmentList(attachmentList);
        PurchaseSampleCheckHeadRecordVO recordVO = new PurchaseSampleCheckHeadRecordVO();
        recordVO.setSampleQuantity(saleSampleCheckHeadVO.getSampleQuantity());
        recordVO.setQualifiedQuantity(saleSampleCheckHeadVO.getQualifiedQuantity());
        recordVO.setDefectiveQuantity(saleSampleCheckHeadVO.getDefectiveQuantity());
        recordVO.setQualifiedRate(saleSampleCheckHeadVO.getQualifiedRate());
        recordVO.setQualified(saleSampleCheckHeadVO.getQualified());
        recordVO.setCheckResult(saleSampleCheckHeadVO.getCheckResult());
        recordVO.setResultAudit(saleSampleCheckHeadVO.getResultAudit());
        saleSampleCheckHeadVO.setPurchaseSampleRecord(recordVO);
        saleSampleCheckHeadVO.setBusAccount(saleSampleCheckHeadVO.getElsAccount());
        return Result.ok((Object)((Object)saleSampleCheckHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u4f9b\u5e94\u5546\u6837\u54c1\u68c0\u6d4b\u5934id\u67e5\u8be2\u4f9b\u5e94\u5546\u6837\u54c1\u68c0\u6d4b\u884c", notes="\u901a\u8fc7\u4f9b\u5e94\u5546\u6837\u54c1\u68c0\u6d4b\u5934id\u67e5\u8be2\u4f9b\u5e94\u5546\u6837\u54c1\u68c0\u6d4b\u884c")
    @GetMapping(value={"/querySaleSampleCheckItemByMainId"})
    @RequiresPermissions(value={"sample#saleSampleCheckHead:list"})
    public Result<?> querySaleSampleCheckItemListByMainId(@RequestParam(name="id") String id) {
        List saleSampleCheckItemList = this.saleSampleCheckItemService.selectByMainId(id);
        return Result.ok((Object)saleSampleCheckItemList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"sample#saleSampleCheckHead:list"})
    public Result<?> queryTabsCount(SaleSampleCheckHead purchaseSampleCheckHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)purchaseSampleCheckHead, (Map)req.getParameterMap());
        queryWrapper.select((Object[])new String[]{"check_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"check_status");
        List list = ((SaleSampleCheckHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SaleSampleCheckHead::getCheckStatus, SaleSampleCheckHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "checkStatus", null, all));
        List srmContractStatus = this.invokeBaseRpcService.queryDictItemsByCode("sampleCheckStatus", TenantContext.getTenant());
        String[] statuses = new String[]{"1", "2", "3"};
        List<String> statusList = Arrays.asList(statuses);
        for (DictDTO status : srmContractStatus) {
            if (!statusList.contains(status.getValue())) continue;
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "checkStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

